<?php
/**
 * Plugin Name:  WooCommerce Advanced Shipping Packages
 * Plugin URI:   https://woo.com/products/woocommerce-advanced-shipping-packages/
 * Description:  Split your order into multiple shipping packages when you need it to, with the products you want to.
 * Version:      1.2.1
 * Author:       Jeroen Sormani
 * Author URI:   https://jeroensormani.com/
 * Text Domain:  advanced-shipping-packages-for-woocommerce
 *
 * WC requires at least: 6.0
 * WC tested up to: 8.6
 * Woo: 1922995:7e5f76d76a24335e1b21d633ffd2b28d
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


/**
 * Class Advanced_Shipping_Packages_for_WooCommerce.
 *
 * Main plugin class handles everything like initializing the other parts.
 *
 * @class       Advanced_Shipping_Packages_for_WooCommerce
 * @version     1.0.0
 * @author      Jeroen Sormani
 */
class Advanced_Shipping_Packages_for_WooCommerce {


	/**
	 * Version.
	 *
	 * @since 1.0.0
	 * @var string $version Plugin version number.
	 */
	public $version = '1.2.1';


	/**
	 * File.
	 *
	 * @since 1.0.0
	 * @var string $file Plugin __FILE__ path.
	 */
	public $file = __FILE__;


	/**
	 * Instance of Advanced_Shipping_Packages_for_WooCommerce.
	 *
	 * @since 1.0.0
	 * @access private
	 * @var object $instance The instance of ASPWC.
	 */
	private static $instance;

	/**
	 * @var ASPWC_Admin
	 */
	public $admin;

	/**
	 * @var ASPWC_Post_Type
	 */
	public $post_type;

	/**
	 * @var ASPWC_AJAX
	 */
	public $ajax;

	/**
	 * @var ASPWC_Match_Conditions
	 */
	public $matcher;


	/**
	 * Constructor.
	 *
	 * @since 1.0.0
	 */
	public function __construct() {}


	/**
	 * Instance.
	 *
	 * An global instance of the class. Used to retrieve the instance
	 * to use on other files/plugins/themes.
	 *
	 * @since 1.0.0
	 *
	 * @return object Instance of the class.
	 */
	public static function instance() {

		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}

		return self::$instance;

	}


	/**
	 * Init.
	 *
	 * Initialize plugin parts.
	 *
	 * @since 1.0.0
	 */
	public function init() {
		if ( ! $this->woocommerce_active() ) return;

		// Load textdomain
		$this->load_textdomain();

		require_once plugin_dir_path( __FILE__ ) . '/libraries/wp-conditions/functions.php';

		/**
		 * Admin class
		 */
		require_once plugin_dir_path( __FILE__ ) . 'includes/admin/class-aspwc-admin.php';
		$this->admin = new ASPWC_Admin();

		/**
		 * Post type
		 */
		require_once plugin_dir_path( __FILE__ ) . 'includes/class-aspwc-post-type.php';
		$this->post_type = new ASPWC_Post_Type();

		if ( defined( 'DOING_AJAX' ) && DOING_AJAX ) {
			/**
			 * AJAX class
			 */
			require_once plugin_dir_path( __FILE__ ) . 'includes/class-aspwc-ajax.php';
			$this->ajax = new ASPWC_AJAX();
		}

		/**
		 * Matching functions
		 */
		require_once plugin_dir_path( __FILE__ ) . 'includes/class-aspwc-match-conditions.php';
		$this->matcher = new ASPWC_Match_Conditions();

		require_once plugin_dir_path( __FILE__ ) . 'includes/aspwc-core-functions.php';

		// Declare HPOS compatibility
		add_action( 'before_woocommerce_init', function () {
			if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
				\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
			}
		} );
	}


	/**
	 * Textdomain.
	 *
	 * Load the textdomain based on WP language.
	 *
	 * @since 1.0.0
	 */
	public function load_textdomain() {

		$locale = apply_filters( 'plugin_locale', get_locale(), 'advanced-shipping-packages-for-woocommerce' );

		// Load textdomain
		load_textdomain( 'advanced-shipping-packages-for-woocommerce', WP_LANG_DIR . '/advanced-shipping-packages-for-woocommerce/advanced-shipping-packages-for-woocommerce-' . $locale . '.mo' );
		load_plugin_textdomain( 'advanced-shipping-packages-for-woocommerce', false, basename( dirname( __FILE__ ) ) . '/languages' );

	}


	/**
	 * Is WooCommerce active.
	 *
	 * @since NEWVERSION
	 *
	 * @return bool True when WooCommerce is active.
	 */
	private function woocommerce_active() {
		// Load plugin.php if it's not already loaded.
		if ( ! function_exists( 'is_plugin_active' ) ) {
			require_once ABSPATH . 'wp-admin/includes/plugin.php';
		}

		if ( \is_plugin_active( 'woocommerce/woocommerce.php' ) ) {
			return true;
		}

		return false;
	}
}


if ( ! function_exists( 'advanced_shipping_packages_for_woocommerce' ) ) {
	/**
	 * The main function responsible for returning the Advanced_Shipping_Packages_for_WooCommerce object.
	 *
	 * Use this function like you would a global variable, except without needing to declare the global.
	 *
	 * Example: <?php advanced_shipping_packages_for_woocommerce()->method_name(); ?>
	 *
	 * @since 1.0.0
	 *
	 * @return object advanced_shipping_packages_for_woocommerce class object.
	 */
	function advanced_shipping_packages_for_woocommerce() {

		return Advanced_Shipping_Packages_for_WooCommerce::instance();

	}
}

advanced_shipping_packages_for_woocommerce()->init();
if ( ! defined( 'ABSPATH' ) )
	exit; // Exit if accessed directly

if ( ! class_exists( 'Code8_Admin_Notices' ) ) {

	class Code8_Admin_Notices {

		private static $_instance;
		private $admin_notices;
		private $slug;
		const TYPES = 'error,warning,info,success';

		private function __construct($slug) {
			$this->admin_notices = new stdClass();
			$this->slug = $slug;
			foreach ( explode( ',', self::TYPES ) as $type ) {
				$this->admin_notices->{$type} = array();
			}
			add_action( 'admin_init', array( &$this, 'action_admin_init' ) );
			add_action( 'admin_notices', array( &$this, 'action_admin_notices' ) );
			add_action( 'admin_enqueue_scripts', array( &$this, 'action_admin_enqueue_scripts' ) );
			add_action($this->slug.'_notify_event',  array( &$this, 'run_notify' ));
			add_action('wp',  array( &$this, 'notify_activation'));
		}

		public static function get_instance($slug) {
			if ( ! ( self::$_instance instanceof self ) ) {
				self::$_instance = new self($slug);
			}
			return self::$_instance;
		}

		public function action_admin_init() {
			$dismiss_option = filter_input( INPUT_GET, $this->slug.'_dismiss', FILTER_SANITIZE_STRING );
			if ( is_string( $dismiss_option ) ) {
				update_option( $this->slug."_dismissed_$dismiss_option", true );
				wp_die();
			}
		}

		public function action_admin_enqueue_scripts() {
			wp_enqueue_script( 'jquery' );
		}

		public  function notify_activation() {

            if ( !wp_next_scheduled( $this->slug.'_notify_event' ) ) {

                wp_schedule_event(time(), 'hourly', $this->slug.'_notify_event');
            }
        }
        public function run_notify() {

	        if ( ! get_option( $this->slug."_enable_notify" ) ) {

		        update_option( $this->slug."_enable_notify", 'false' );

	        }else {

		        update_option( $this->slug."_enable_notify", 'true' );

            }

        }

		public function action_admin_notices() {
			if ( ! get_option( $this->slug."_enable_notify" )  ||   get_option( $this->slug."_enable_notify" ) === 'false' ) {
			    return;
			}
			foreach ( explode( ',', self::TYPES ) as $type ) {
				foreach ( $this->admin_notices->{$type} as $admin_notice ) {

					$dismiss_url = add_query_arg( array(
						$this->slug.'_dismiss' => $admin_notice->dismiss_option
					), admin_url() );

					if ( ! get_option( $this->slug."_dismissed_{$admin_notice->dismiss_option}" ) ) {
						?><div
						class="notice <?php echo $this->slug;?>-notice notice-<?php echo $type;

						if ( $admin_notice->dismiss_option ) {
							echo ' is-dismissible" data-dismiss-url="' . esc_url( $dismiss_url );
						} ?>">

						<?php echo $admin_notice->message; ?>

						</div>
						<script>
                            /**
                             * Admin code for dismissing notifications.
                             *
                             */
                            (function( $ ) {
                                'use strict';
                                $( function() {
                                    $( '.<?php echo $this->slug;?>-notice' ).on( 'click', '.notice-dismiss', function( event, el ) {
                                        var $notice = $(this).parent('.notice.is-dismissible');
                                        var dismiss_url = $notice.attr('data-dismiss-url');
                                        if ( dismiss_url ) {
                                            $.get( dismiss_url );
                                        }
                                    });
                                } );
                            })( jQuery );
						</script><?php
					}
				}
			}
		}

		public function error( $message, $dismiss_option = false ) {
			$this->notice( 'error', $message, $dismiss_option );
		}

		public function warning( $message, $dismiss_option = false ) {
			$this->notice( 'warning', $message, $dismiss_option );
		}

		public function success( $message, $dismiss_option = false ) {
			$this->notice( 'success', $message, $dismiss_option );
		}

		public function info( $message, $dismiss_option = false ) {
			$this->notice( 'info', $message, $dismiss_option );
		}

		private function notice( $type, $message, $dismiss_option ) {
			$notice = new stdClass();
			$notice->message = $message;
			$notice->dismiss_option = $dismiss_option;

			$this->admin_notices->{$type}[] = $notice;
		}

		public static function error_handler( $errno, $errstr, $errfile, $errline, $errcontext ) {
			if ( ! ( error_reporting() & $errno ) ) {
				// This error code is not included in error_reporting
				return;
			}

			$message = "errstr: $errstr, errfile: $errfile, errline: $errline, PHP: " . PHP_VERSION . " OS: " . PHP_OS;

			$self = self::get_instance();

			switch ($errno) {
				case E_USER_ERROR:
					$self->error( $message );
					break;

				case E_USER_WARNING:
					$self->warning( $message );
					break;

				case E_USER_NOTICE:
				default:
					$self->notice( $message );
					break;
			}

			// write to wp-content/debug.log if logging enabled
			error_log( $message );

			// Don't execute PHP internal error handler
			return true;
		}
	}
}


$notice = Code8_Admin_Notices::get_instance('advanced-shipping-packages-for-woo-error-dl-ir');
$notice->error( '<h2>تذکر مهم</h2>' .'<p>افزونه WooCommerce Advanced Shipping Packages توسط سایت لرن دی ال learndl.ir تهیه و بومی سازی شده است،اگر شما این افزونه را از سایتی غیر از سایت لرن دی ال تهیه کرده باشید،به صورت غیرقانونی به دست شما رسیده و باید به سایت لرن دی ال مراجعه کنید و گزارش دهید.</p>', true  );