/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-11-19 09:46:16 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `won_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  `priority` tinyint(3) unsigned NOT NULL DEFAULT 10,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id` (`claim_id`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `claim_id_status_priority_scheduled_date_gmt` (`claim_id`,`status`,`priority`,`scheduled_date_gmt`),
  KEY `status_last_attempt_gmt` (`status`,`last_attempt_gmt`),
  KEY `status_claim_id` (`status`,`claim_id`)
) ENGINE=MyISAM AUTO_INCREMENT=747 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `won_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=25471 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `won_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `won_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=2193 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `won_arcontactus` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `icon` varchar(50) DEFAULT NULL,
  `color` varchar(10) DEFAULT NULL,
  `type` tinyint(3) unsigned DEFAULT 0,
  `display` tinyint(3) unsigned DEFAULT 1,
  `link` varchar(255) DEFAULT NULL,
  `target` tinyint(3) unsigned DEFAULT 0,
  `integration` varchar(50) DEFAULT NULL,
  `js` text DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `subtitle` varchar(255) DEFAULT NULL,
  `content` text DEFAULT NULL,
  `params` text DEFAULT NULL,
  `status` tinyint(3) unsigned DEFAULT 1,
  `registered_only` tinyint(3) unsigned DEFAULT 0,
  `position` int(10) unsigned DEFAULT 0,
  `language` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `position` (`position`),
  KEY `language` (`language`)
) ENGINE=MyISAM AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE `won_arcontactus_callback` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_user` int(10) unsigned DEFAULT NULL,
  `phone` varchar(50) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `referer` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `status` tinyint(3) unsigned DEFAULT NULL,
  `type` tinyint(3) unsigned DEFAULT 0,
  `comment` text DEFAULT NULL,
  `message` text DEFAULT NULL,
  `params` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_user` (`id_user`),
  KEY `phone` (`phone`),
  KEY `type` (`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE `won_arcontactus_lang` (
  `lang` varchar(10) NOT NULL,
  `id_item` int(10) unsigned NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `subtitle` varchar(255) DEFAULT NULL,
  `content` mediumtext DEFAULT NULL,
  PRIMARY KEY (`lang`,`id_item`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE `won_arcontactus_prompt` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `message` text NOT NULL,
  `status` int(11) unsigned NOT NULL,
  `position` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE `won_arcontactus_prompt_lang` (
  `lang` varchar(10) NOT NULL,
  `id_item` int(10) unsigned NOT NULL,
  `message` mediumtext DEFAULT NULL,
  PRIMARY KEY (`lang`,`id_item`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE `won_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=43 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `won_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`),
  KEY `woo_idx_comment_date_type` (`comment_date_gmt`,`comment_type`,`comment_approved`,`comment_post_ID`)
) ENGINE=MyISAM AUTO_INCREMENT=49 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `won_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE `won_e_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `won_e_notes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `route_url` text DEFAULT NULL COMMENT 'Clean url where the note was created.',
  `route_title` varchar(255) DEFAULT NULL,
  `route_post_id` bigint(20) unsigned DEFAULT NULL COMMENT 'The post id of the route that the note was created on.',
  `post_id` bigint(20) unsigned DEFAULT NULL,
  `element_id` varchar(60) DEFAULT NULL COMMENT 'The Elementor element ID the note is attached to.',
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `author_id` bigint(20) unsigned DEFAULT NULL,
  `author_display_name` varchar(250) DEFAULT NULL COMMENT 'Save the author name when the author was deleted.',
  `status` varchar(20) NOT NULL DEFAULT 'publish',
  `position` text DEFAULT NULL COMMENT 'A JSON string that represents the position of the note inside the element in percentages. e.g. {x:10, y:15}',
  `content` longtext DEFAULT NULL,
  `is_resolved` tinyint(1) NOT NULL DEFAULT 0,
  `is_public` tinyint(1) NOT NULL DEFAULT 1,
  `last_activity_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `route_url_index` (`route_url`(191)),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `parent_id_index` (`parent_id`),
  KEY `author_id_index` (`author_id`),
  KEY `status_index` (`status`),
  KEY `is_resolved_index` (`is_resolved`),
  KEY `is_public_index` (`is_public`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `last_activity_at_index` (`last_activity_at`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `won_e_notes_users_relations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) NOT NULL COMMENT 'The relation type between user and note (e.g mention, watch, read).',
  `note_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`),
  KEY `note_id_index` (`note_id`),
  KEY `user_id_index` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `won_e_submissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) DEFAULT NULL,
  `hash_id` varchar(60) NOT NULL,
  `main_meta_id` bigint(20) unsigned NOT NULL COMMENT 'Id of main field. to represent the main meta field',
  `post_id` bigint(20) unsigned NOT NULL,
  `referer` varchar(500) NOT NULL,
  `referer_title` varchar(300) DEFAULT NULL,
  `element_id` varchar(20) NOT NULL,
  `form_name` varchar(60) NOT NULL,
  `campaign_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip` varchar(46) NOT NULL,
  `user_agent` text NOT NULL,
  `actions_count` int(11) DEFAULT 0,
  `actions_succeeded_count` int(11) DEFAULT 0,
  `status` varchar(20) NOT NULL,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `meta` text DEFAULT NULL,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash_id_unique_index` (`hash_id`),
  KEY `main_meta_id_index` (`main_meta_id`),
  KEY `hash_id_index` (`hash_id`),
  KEY `type_index` (`type`),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `campaign_id_index` (`campaign_id`),
  KEY `user_id_index` (`user_id`),
  KEY `user_ip_index` (`user_ip`),
  KEY `status_index` (`status`),
  KEY `is_read_index` (`is_read`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `referer_index` (`referer`(191)),
  KEY `referer_title_index` (`referer_title`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `won_e_submissions_actions_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL,
  `action_name` varchar(60) NOT NULL,
  `action_label` varchar(60) DEFAULT NULL,
  `status` varchar(20) NOT NULL,
  `log` text DEFAULT NULL,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `action_name_index` (`action_name`),
  KEY `status_index` (`status`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `won_e_submissions_values` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `key` varchar(60) DEFAULT NULL,
  `value` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `key_index` (`key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `won_gf_draft_submissions` (
  `uuid` char(32) NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `form_id` mediumint(10) unsigned NOT NULL,
  `date_created` datetime NOT NULL,
  `ip` varchar(45) NOT NULL,
  `source_url` longtext NOT NULL,
  `submission` longtext NOT NULL,
  PRIMARY KEY (`uuid`),
  KEY `form_id` (`form_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `won_gf_entry` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` mediumint(10) unsigned NOT NULL,
  `post_id` bigint(10) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL,
  `date_updated` datetime DEFAULT NULL,
  `is_starred` tinyint(10) NOT NULL DEFAULT 0,
  `is_read` tinyint(10) NOT NULL DEFAULT 0,
  `ip` varchar(45) NOT NULL,
  `source_url` varchar(200) NOT NULL DEFAULT '',
  `user_agent` varchar(250) NOT NULL DEFAULT '',
  `currency` varchar(5) DEFAULT NULL,
  `payment_status` varchar(15) DEFAULT NULL,
  `payment_date` datetime DEFAULT NULL,
  `payment_amount` decimal(19,2) DEFAULT NULL,
  `payment_method` varchar(30) DEFAULT NULL,
  `transaction_id` varchar(50) DEFAULT NULL,
  `is_fulfilled` tinyint(10) DEFAULT NULL,
  `created_by` bigint(10) unsigned DEFAULT NULL,
  `transaction_type` tinyint(10) DEFAULT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'active',
  PRIMARY KEY (`id`),
  KEY `form_id` (`form_id`),
  KEY `form_id_status` (`form_id`,`status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `won_gf_entry_meta` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` mediumint(10) unsigned NOT NULL DEFAULT 0,
  `entry_id` bigint(10) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  `item_index` varchar(60) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key` (`meta_key`(191)),
  KEY `entry_id` (`entry_id`),
  KEY `meta_value` (`meta_value`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `won_gf_entry_notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `entry_id` int(10) unsigned NOT NULL,
  `user_name` varchar(250) DEFAULT NULL,
  `user_id` bigint(10) DEFAULT NULL,
  `date_created` datetime NOT NULL,
  `value` longtext DEFAULT NULL,
  `note_type` varchar(50) DEFAULT NULL,
  `sub_type` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `entry_id` (`entry_id`),
  KEY `entry_user_key` (`entry_id`,`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `won_gf_form` (
  `id` mediumint(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(150) NOT NULL,
  `date_created` datetime NOT NULL,
  `date_updated` datetime DEFAULT NULL,
  `is_active` tinyint(10) NOT NULL DEFAULT 1,
  `is_trash` tinyint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `won_gf_form_meta` (
  `form_id` mediumint(10) unsigned NOT NULL,
  `display_meta` longtext DEFAULT NULL,
  `entries_grid_meta` longtext DEFAULT NULL,
  `confirmations` longtext DEFAULT NULL,
  `notifications` longtext DEFAULT NULL,
  PRIMARY KEY (`form_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `won_gf_form_revisions` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` mediumint(10) unsigned NOT NULL,
  `display_meta` longtext DEFAULT NULL,
  `date_created` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `date_created` (`date_created`),
  KEY `form_id` (`form_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `won_gf_form_view` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` mediumint(10) unsigned NOT NULL,
  `date_created` datetime NOT NULL,
  `ip` char(15) DEFAULT NULL,
  `count` mediumint(10) unsigned NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `date_created` (`date_created`),
  KEY `form_id` (`form_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `won_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `won_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=65004 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `won_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=23787 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `won_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=4232 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `won_revslider_css` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext DEFAULT NULL,
  `hover` longtext DEFAULT NULL,
  `advanced` longtext DEFAULT NULL,
  `params` longtext NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `handle_index` (`handle`(64))
) ENGINE=MyISAM AUTO_INCREMENT=110 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `won_revslider_css_bkp` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext DEFAULT NULL,
  `hover` longtext DEFAULT NULL,
  `advanced` longtext DEFAULT NULL,
  `params` longtext NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `handle_index` (`handle`(64))
) ENGINE=MyISAM AUTO_INCREMENT=48 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `won_revslider_layer_animations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `won_revslider_layer_animations_bkp` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `won_revslider_navigations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `type` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `won_revslider_navigations_bkp` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `type` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `won_revslider_sliders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext DEFAULT NULL,
  `params` longtext NOT NULL,
  `settings` text DEFAULT NULL,
  `type` varchar(191) NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `won_revslider_sliders_bkp` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext DEFAULT NULL,
  `params` longtext NOT NULL,
  `settings` text DEFAULT NULL,
  `type` varchar(191) NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `won_revslider_slides` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `slider_id` int(11) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=MyISAM AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `won_revslider_slides_bkp` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `slider_id` int(11) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `won_revslider_static_slides` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `slider_id` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `won_revslider_static_slides_bkp` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `slider_id` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `won_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `won_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=1521 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `won_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=502 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `won_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=1521 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `won_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=1500 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `won_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=60 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `won_wc_admin_note_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL,
  `query` longtext NOT NULL,
  `status` varchar(255) NOT NULL,
  `actioned_text` varchar(255) NOT NULL,
  `nonce_action` varchar(255) DEFAULT NULL,
  `nonce_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=MyISAM AUTO_INCREMENT=6055 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `won_wc_admin_notes` (
  `note_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  `locale` varchar(20) NOT NULL,
  `title` longtext NOT NULL,
  `content` longtext NOT NULL,
  `content_data` longtext DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `source` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT 0,
  `layout` varchar(20) NOT NULL DEFAULT '',
  `image` varchar(200) DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `icon` varchar(200) NOT NULL DEFAULT 'info',
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`note_id`)
) ENGINE=MyISAM AUTO_INCREMENT=70 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `won_wc_category_lookup` (
  `category_tree_id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `won_wc_customer_lookup` (
  `customer_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `username` varchar(60) NOT NULL DEFAULT '',
  `first_name` varchar(255) NOT NULL,
  `last_name` varchar(255) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) NOT NULL DEFAULT '',
  `postcode` varchar(20) NOT NULL DEFAULT '',
  `city` varchar(100) NOT NULL DEFAULT '',
  `state` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=MyISAM AUTO_INCREMENT=46 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `won_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `won_wc_order_addresses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned NOT NULL,
  `address_type` varchar(20) DEFAULT NULL,
  `first_name` text DEFAULT NULL,
  `last_name` text DEFAULT NULL,
  `company` text DEFAULT NULL,
  `address_1` text DEFAULT NULL,
  `address_2` text DEFAULT NULL,
  `city` text DEFAULT NULL,
  `state` text DEFAULT NULL,
  `postcode` text DEFAULT NULL,
  `country` text DEFAULT NULL,
  `email` varchar(320) DEFAULT NULL,
  `phone` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_type_order_id` (`address_type`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `email` (`email`(191)),
  KEY `phone` (`phone`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `won_wc_order_coupon_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `coupon_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `won_wc_order_operational_data` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `created_via` varchar(100) DEFAULT NULL,
  `woocommerce_version` varchar(20) DEFAULT NULL,
  `prices_include_tax` tinyint(1) DEFAULT NULL,
  `coupon_usages_are_counted` tinyint(1) DEFAULT NULL,
  `download_permission_granted` tinyint(1) DEFAULT NULL,
  `cart_hash` varchar(100) DEFAULT NULL,
  `new_order_email_sent` tinyint(1) DEFAULT NULL,
  `order_key` varchar(100) DEFAULT NULL,
  `order_stock_reduced` tinyint(1) DEFAULT NULL,
  `date_paid_gmt` datetime DEFAULT NULL,
  `date_completed_gmt` datetime DEFAULT NULL,
  `shipping_tax_amount` decimal(26,8) DEFAULT NULL,
  `shipping_total_amount` decimal(26,8) DEFAULT NULL,
  `discount_tax_amount` decimal(26,8) DEFAULT NULL,
  `discount_total_amount` decimal(26,8) DEFAULT NULL,
  `recorded_sales` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id` (`order_id`),
  KEY `order_key` (`order_key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `won_wc_order_product_lookup` (
  `order_item_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `variation_id` bigint(20) unsigned NOT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int(11) NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT 0,
  `product_gross_revenue` double NOT NULL DEFAULT 0,
  `coupon_amount` double NOT NULL DEFAULT 0,
  `tax_amount` double NOT NULL DEFAULT 0,
  `shipping_amount` double NOT NULL DEFAULT 0,
  `shipping_tax_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_item_id`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_product_date` (`customer_id`,`product_id`,`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `won_wc_order_stats` (
  `order_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int(11) NOT NULL DEFAULT 0,
  `total_sales` double NOT NULL DEFAULT 0,
  `tax_total` double NOT NULL DEFAULT 0,
  `shipping_total` double NOT NULL DEFAULT 0,
  `net_total` double NOT NULL DEFAULT 0,
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(20) NOT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `won_wc_order_tax_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT 0,
  `order_tax` double NOT NULL DEFAULT 0,
  `total_tax` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `won_wc_orders` (
  `id` bigint(20) unsigned NOT NULL,
  `status` varchar(20) DEFAULT NULL,
  `currency` varchar(10) DEFAULT NULL,
  `type` varchar(20) DEFAULT NULL,
  `tax_amount` decimal(26,8) DEFAULT NULL,
  `total_amount` decimal(26,8) DEFAULT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `billing_email` varchar(320) DEFAULT NULL,
  `date_created_gmt` datetime DEFAULT NULL,
  `date_updated_gmt` datetime DEFAULT NULL,
  `parent_order_id` bigint(20) unsigned DEFAULT NULL,
  `payment_method` varchar(100) DEFAULT NULL,
  `payment_method_title` text DEFAULT NULL,
  `transaction_id` varchar(100) DEFAULT NULL,
  `ip_address` varchar(100) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `customer_note` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `date_created` (`date_created_gmt`),
  KEY `customer_id_billing_email` (`customer_id`,`billing_email`(171)),
  KEY `billing_email` (`billing_email`(191)),
  KEY `type_status_date` (`type`,`status`,`date_created_gmt`),
  KEY `parent_order_id` (`parent_order_id`),
  KEY `date_updated` (`date_updated_gmt`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `won_wc_orders_meta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key_value` (`meta_key`(100),`meta_value`(82)),
  KEY `order_id_meta_key_meta_value` (`order_id`,`meta_key`(100),`meta_value`(82))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `won_wc_product_attributes_lookup` (
  `product_id` bigint(20) NOT NULL,
  `product_or_parent_id` bigint(20) NOT NULL,
  `taxonomy` varchar(32) NOT NULL,
  `term_id` bigint(20) NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `won_wc_product_download_directories` (
  `url_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `won_wc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) DEFAULT '',
  `virtual` tinyint(1) DEFAULT 0,
  `downloadable` tinyint(1) DEFAULT 0,
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT 0,
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT 0,
  `average_rating` decimal(3,2) DEFAULT 0.00,
  `total_sales` bigint(20) DEFAULT 0,
  `tax_status` varchar(100) DEFAULT 'taxable',
  `tax_class` varchar(100) DEFAULT '',
  `global_unique_id` varchar(100) DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`),
  KEY `sku` (`sku`(50))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `won_wc_rate_limits` (
  `rate_limit_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) NOT NULL,
  `rate_limit_expiry` bigint(20) unsigned NOT NULL,
  `rate_limit_remaining` smallint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `won_wc_reserved_stock` (
  `order_id` bigint(20) NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT 0,
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `won_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `won_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) NOT NULL,
  `name` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text NOT NULL,
  `secret` text NOT NULL,
  `topic` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT 0,
  `pending_delivery` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `won_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) DEFAULT NULL,
  `permissions` varchar(10) NOT NULL,
  `consumer_key` char(64) NOT NULL,
  `consumer_secret` char(43) NOT NULL,
  `nonces` longtext DEFAULT NULL,
  `truncated_key` char(7) NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `won_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) NOT NULL,
  `attribute_label` varchar(200) DEFAULT NULL,
  `attribute_type` varchar(20) NOT NULL,
  `attribute_orderby` varchar(20) NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `won_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `order_key` varchar(200) NOT NULL,
  `user_email` varchar(200) NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `won_woocommerce_exported_csv_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `export_id` varchar(32) NOT NULL DEFAULT '',
  `content_length` int(10) unsigned NOT NULL DEFAULT 0,
  `content` longtext NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `export_id` (`export_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `won_woocommerce_ir` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `text1` text CHARACTER SET utf8mb3 COLLATE utf8mb3_persian_ci NOT NULL,
  `text2` text CHARACTER SET utf8mb3 COLLATE utf8mb3_persian_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE `won_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) NOT NULL,
  `message` longtext NOT NULL,
  `context` longtext DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `won_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM AUTO_INCREMENT=461 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `won_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text NOT NULL,
  `order_item_type` varchar(200) NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=MyISAM AUTO_INCREMENT=52 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `won_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `won_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) NOT NULL,
  `token` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `type` varchar(200) NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `won_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) NOT NULL,
  `session_value` longtext NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`),
  KEY `session_expiry` (`session_expiry`)
) ENGINE=MyISAM AUTO_INCREMENT=798 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `won_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20)),
  KEY `zone_id` (`zone_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `won_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`instance_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `won_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `won_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `won_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) NOT NULL DEFAULT '',
  `tax_rate` varchar(8) NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT 0,
  `tax_rate_shipping` int(1) NOT NULL DEFAULT 1,
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `won_woodmart_wishlist_products` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` varchar(255) NOT NULL,
  `wishlist_id` int(11) DEFAULT NULL,
  `date_added` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`ID`),
  KEY `product_id` (`product_id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE `won_woodmart_wishlists` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM AUTO_INCREMENT=60 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: won_actionscheduler_actions */
INSERT INTO `won_actionscheduler_actions` VALUES("474", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-08-12 19:37:07", "2024-08-12 23:07:07", "[2299,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1723491427;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1723491427;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("475", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-08-12 19:37:07", "2024-08-12 23:07:07", "[411,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1723491427;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1723491427;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("473", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-08-12 19:36:57", "2024-08-12 23:06:57", "[2301,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1723491417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1723491417;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("472", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-08-12 19:36:57", "2024-08-12 23:06:57", "[2303,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1723491417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1723491417;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("470", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-08-12 19:36:56", "2024-08-12 23:06:56", "[2379,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1723491416;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1723491416;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("471", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-08-12 19:36:56", "2024-08-12 23:06:56", "[2305,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1723491416;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1723491416;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("275", "action_scheduler/migration_hook", "failed", "2024-01-12 16:44:38", "2024-01-12 20:14:38", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1705077878;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1705077878;}", "1", "1", "2024-01-12 16:45:15", "2024-01-12 20:15:15", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("469", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-08-12 19:36:56", "2024-08-12 23:06:56", "[2381,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1723491416;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1723491416;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("468", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-08-12 19:36:56", "2024-08-12 23:06:56", "[2383,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1723491416;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1723491416;}", "4", "1", "2025-11-08 15:10:57", "2025-11-08 18:40:57", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("466", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-08-12 19:36:56", "2024-08-12 23:06:56", "[2388,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1723491416;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1723491416;}", "4", "1", "2025-11-08 15:10:57", "2025-11-08 18:40:57", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("467", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-08-12 19:36:56", "2024-08-12 23:06:56", "[2385,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1723491416;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1723491416;}", "4", "1", "2025-11-08 15:10:57", "2025-11-08 18:40:57", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("465", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-08-12 19:36:56", "2024-08-12 23:06:56", "[2567,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1723491416;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1723491416;}", "4", "1", "2025-11-08 15:10:57", "2025-11-08 18:40:57", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("464", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-08-12 19:36:56", "2024-08-12 23:06:56", "[2574,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1723491416;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1723491416;}", "4", "1", "2025-11-08 15:10:57", "2025-11-08 18:40:57", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("462", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-08-12 19:36:56", "2024-08-12 23:06:56", "[2579,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1723491416;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1723491416;}", "4", "1", "2025-11-08 15:10:57", "2025-11-08 18:40:57", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("463", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-08-12 19:36:56", "2024-08-12 23:06:56", "[2576,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1723491416;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1723491416;}", "4", "1", "2025-11-08 15:10:57", "2025-11-08 18:40:57", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("461", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-08-12 19:36:56", "2024-08-12 23:06:56", "[2582,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1723491416;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1723491416;}", "4", "1", "2025-11-08 15:10:57", "2025-11-08 18:40:57", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("459", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-08-12 19:36:56", "2024-08-12 23:06:56", "[2592,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1723491416;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1723491416;}", "4", "1", "2025-11-08 15:10:57", "2025-11-08 18:40:57", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("460", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-08-12 19:36:56", "2024-08-12 23:06:56", "[2584,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1723491416;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1723491416;}", "4", "1", "2025-11-08 15:10:57", "2025-11-08 18:40:57", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("458", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-08-12 19:36:56", "2024-08-12 23:06:56", "[2597,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1723491416;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1723491416;}", "4", "1", "2025-11-08 15:10:57", "2025-11-08 18:40:57", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("457", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-08-12 19:36:56", "2024-08-12 23:06:56", "[2599,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1723491416;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1723491416;}", "4", "1", "2025-11-08 15:10:57", "2025-11-08 18:40:57", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("455", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-08-12 19:36:56", "2024-08-12 23:06:56", "[2603,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1723491416;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1723491416;}", "4", "1", "2025-11-08 15:10:57", "2025-11-08 18:40:57", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("456", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-08-12 19:36:56", "2024-08-12 23:06:56", "[2601,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1723491416;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1723491416;}", "4", "1", "2025-11-08 15:10:57", "2025-11-08 18:40:57", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("454", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-08-12 19:36:56", "2024-08-12 23:06:56", "[2605,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1723491416;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1723491416;}", "4", "1", "2025-11-08 15:10:57", "2025-11-08 18:40:57", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("453", "wc_schedule_update_product_default_cat", "complete", "2024-08-12 17:17:26", "2024-08-12 20:47:26", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1723483046;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1723483046;}", "6", "1", "2025-11-08 15:10:57", "2025-11-08 18:40:57", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("451", "wc_schedule_update_product_default_cat", "complete", "2024-08-12 17:17:12", "2024-08-12 20:47:12", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1723483032;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1723483032;}", "6", "1", "2025-11-08 15:10:57", "2025-11-08 18:40:57", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("452", "wc_schedule_update_product_default_cat", "complete", "2024-08-12 17:17:16", "2024-08-12 20:47:16", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1723483036;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1723483036;}", "6", "1", "2025-11-08 15:10:57", "2025-11-08 18:40:57", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("450", "woocommerce_cleanup_draft_orders", "complete", "2024-08-13 15:38:47", "2024-08-13 19:08:47", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1723563527;s:18:\"\0*\0first_timestamp\";i:1668072076;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1723563527;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("449", "woocommerce_marketplace_fetch_promotions", "complete", "2024-08-13 03:38:47", "2024-08-13 07:08:47", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1723520327;s:18:\"\0*\0first_timestamp\";i:1713404666;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1723520327;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("671", "woocommerce_refresh_order_count_cache", "complete", "2025-11-09 03:13:30", "2025-11-09 06:43:30", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762658010;s:18:\"\0*\0first_timestamp\";i:1762658010;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762658010;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2025-11-09 04:34:12", "2025-11-09 08:04:12", "25418", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("668", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-11-09 00:00:00", "2025-11-09 03:30:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762646400;s:18:\"\0*\0first_timestamp\";i:1762646400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762646400;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-11-09 01:08:22", "2025-11-09 04:38:22", "25409", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("662", "woocommerce_scheduled_sales", "complete", "2025-11-08 21:00:00", "2025-11-09 00:30:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762635600;s:18:\"\0*\0first_timestamp\";i:1762635600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762635600;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-11-08 21:11:21", "2025-11-09 00:41:21", "25407", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("663", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-08 16:13:30", "2025-11-08 19:43:30", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762618410;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762618410;}", "9", "1", "2025-11-08 16:13:54", "2025-11-08 19:43:54", "25152", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("664", "woocommerce_cleanup_personal_data", "complete", "2025-11-08 15:13:40", "2025-11-08 18:43:40", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762614820;s:18:\"\0*\0first_timestamp\";i:1762614820;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762614820;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-11-08 15:14:15", "2025-11-08 18:44:15", "25105", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("665", "woocommerce_cleanup_logs", "complete", "2025-11-09 00:00:00", "2025-11-09 03:30:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762646400;s:18:\"\0*\0first_timestamp\";i:1762646400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762646400;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-11-09 01:08:22", "2025-11-09 04:38:22", "25409", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("601", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614658;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614658;}", "5", "1", "2025-11-08 15:11:02", "2025-11-08 18:41:02", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("599", "wc_customer_order_export_cleanup_exports", "complete", "2025-11-09 15:10:58", "2025-11-09 18:40:58", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762701058;s:18:\"\0*\0first_timestamp\";i:1731431264;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762701058;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-11-14 06:32:37", "2025-11-14 10:02:37", "25468", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("600", "wc_customer_order_export_validate_automations", "complete", "2025-11-09 15:10:58", "2025-11-09 18:40:58", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762701058;s:18:\"\0*\0first_timestamp\";i:1731431264;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762701058;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-11-14 06:32:37", "2025-11-14 10:02:37", "25468", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("598", "woocommerce_cleanup_draft_orders", "complete", "2025-11-09 15:10:58", "2025-11-09 18:40:58", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762701058;s:18:\"\0*\0first_timestamp\";i:1668072076;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762701058;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-11-14 06:32:37", "2025-11-14 10:02:37", "25468", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("596", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614658;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614658;}", "5", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("677", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2025-11-08 17:29:33", "2025-11-08 20:59:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762622973;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762622973;}", "5", "1", "2025-11-08 17:29:38", "2025-11-08 20:59:38", "25222", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("678", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-08 19:14:14", "2025-11-08 22:44:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762629254;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762629254;}", "9", "1", "2025-11-08 19:14:15", "2025-11-08 22:44:15", "25325", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("676", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-08 18:13:59", "2025-11-08 21:43:59", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762625639;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762625639;}", "9", "1", "2025-11-08 18:14:14", "2025-11-08 21:44:14", "25267", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("674", "woocommerce_cleanup_personal_data", "complete", "2025-11-09 15:14:15", "2025-11-09 18:44:15", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762701255;s:18:\"\0*\0first_timestamp\";i:1762614820;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762701255;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-11-14 06:32:38", "2025-11-14 10:02:38", "25468", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("675", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-08 17:13:54", "2025-11-08 20:43:54", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762622034;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762622034;}", "9", "1", "2025-11-08 17:13:59", "2025-11-08 20:43:59", "25204", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("673", "wc_admin_daily_wrapper", "complete", "2025-11-09 15:13:30", "2025-11-09 18:43:30", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762701210;s:18:\"\0*\0first_timestamp\";i:1762614810;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762701210;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-11-14 06:32:37", "2025-11-14 10:02:37", "25468", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("672", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-11-09 15:13:30", "2025-11-09 18:43:30", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762701210;s:18:\"\0*\0first_timestamp\";i:1762614809;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762701210;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-11-14 06:32:38", "2025-11-14 10:02:38", "25469", NULL, "20");
INSERT INTO `won_actionscheduler_actions` VALUES("669", "wc_admin_daily_wrapper", "complete", "2025-11-08 15:13:30", "2025-11-08 18:43:30", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762614810;s:18:\"\0*\0first_timestamp\";i:1762614810;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762614810;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-11-08 15:13:30", "2025-11-08 18:43:30", "25103", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("670", "generate_category_lookup_table_wrapper", "complete", "2025-11-08 15:13:40", "2025-11-08 18:43:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614820;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614820;}", "9", "1", "2025-11-08 15:14:15", "2025-11-08 18:44:15", "25105", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("666", "woocommerce_cleanup_sessions", "complete", "2025-11-09 03:00:00", "2025-11-09 06:30:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762657200;s:18:\"\0*\0first_timestamp\";i:1762657200;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762657200;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-11-09 04:34:12", "2025-11-09 08:04:12", "25418", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("667", "woocommerce_geoip_updater", "complete", "2025-11-09 03:00:00", "2025-11-09 06:30:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762657200;s:18:\"\0*\0first_timestamp\";i:1762657200;s:13:\"\0*\0recurrence\";i:1296000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762657200;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:1296000;}", "9", "1", "2025-11-09 04:34:12", "2025-11-09 08:04:12", "25418", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("661", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-11-08 15:13:29", "2025-11-08 18:43:29", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762614809;s:18:\"\0*\0first_timestamp\";i:1762614809;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762614809;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-11-08 15:13:30", "2025-11-08 18:43:30", "25102", NULL, "20");
INSERT INTO `won_actionscheduler_actions` VALUES("476", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-08-12 19:37:07", "2024-08-12 23:07:07", "[407,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1723491427;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1723491427;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("477", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-08-12 19:37:07", "2024-08-12 23:07:07", "[406,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1723491427;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1723491427;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("478", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-08-12 19:37:07", "2024-08-12 23:07:07", "[54,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1723491427;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1723491427;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("479", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-08-12 19:37:07", "2024-08-12 23:07:07", "[404,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1723491427;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1723491427;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("480", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-08-12 19:37:07", "2024-08-12 23:07:07", "[403,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1723491427;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1723491427;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("481", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-08-12 19:37:07", "2024-08-12 23:07:07", "[402,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1723491427;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1723491427;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("482", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-08-12 19:37:07", "2024-08-12 23:07:07", "[401,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1723491427;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1723491427;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("483", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-08-12 19:37:07", "2024-08-12 23:07:07", "[48,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1723491427;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1723491427;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("484", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-08-12 19:37:07", "2024-08-12 23:07:07", "[400,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1723491427;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1723491427;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("485", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-08-12 19:37:07", "2024-08-12 23:07:07", "[399,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1723491427;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1723491427;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("486", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-08-12 19:37:07", "2024-08-12 23:07:07", "[398,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1723491427;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1723491427;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("487", "wc_schedule_update_product_default_cat", "complete", "2024-08-13 06:34:22", "2024-08-13 10:04:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1723530862;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1723530862;}", "6", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("488", "wc_schedule_update_product_default_cat", "complete", "2024-08-13 06:34:22", "2024-08-13 10:04:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1723530862;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1723530862;}", "6", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("489", "wc_schedule_update_product_default_cat", "complete", "2024-08-13 06:34:22", "2024-08-13 10:04:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1723530862;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1723530862;}", "6", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("490", "wc_schedule_update_product_default_cat", "complete", "2024-08-13 06:34:22", "2024-08-13 10:04:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1723530862;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1723530862;}", "6", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("491", "wc_schedule_update_product_default_cat", "complete", "2024-08-13 06:34:22", "2024-08-13 10:04:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1723530862;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1723530862;}", "6", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("492", "wc_schedule_update_product_default_cat", "complete", "2024-08-13 06:34:22", "2024-08-13 10:04:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1723530862;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1723530862;}", "6", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("493", "image-optimization/database/migration", "complete", "2024-11-12 15:30:35", "2024-11-12 15:30:35", "{\"name\":\"fix_optimized_size_keys\"}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "7", "1", "2025-11-08 15:10:57", "2025-11-08 18:40:57", "0", NULL, "0");
INSERT INTO `won_actionscheduler_actions` VALUES("494", "wc_schedule_update_product_default_cat", "complete", "2024-11-12 16:35:25", "2024-11-12 20:05:25", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731429325;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731429325;}", "6", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("495", "wc_schedule_update_product_default_cat", "complete", "2024-11-12 16:35:25", "2024-11-12 20:05:25", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731429325;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731429325;}", "6", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("496", "wc_schedule_update_product_default_cat", "complete", "2024-11-12 16:35:25", "2024-11-12 20:05:25", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731429325;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731429325;}", "6", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("497", "wc_schedule_update_product_default_cat", "complete", "2024-11-12 16:35:25", "2024-11-12 20:05:25", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731429325;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731429325;}", "6", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("498", "woocommerce_run_update_callback", "complete", "2024-11-12 16:49:28", "2024-11-12 20:19:28", "{\"update_callback\":\"wc_update_860_remove_recommended_marketing_plugins_transient\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731430168;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731430168;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("499", "woocommerce_run_update_callback", "complete", "2024-11-12 16:49:29", "2024-11-12 20:19:29", "{\"update_callback\":\"wc_update_870_prevent_listing_of_transient_files_directory\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731430169;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731430169;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("500", "woocommerce_run_update_callback", "complete", "2024-11-12 16:49:30", "2024-11-12 20:19:30", "{\"update_callback\":\"wc_update_890_update_connect_to_woocommerce_note\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731430170;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731430170;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("501", "woocommerce_run_update_callback", "complete", "2024-11-12 16:49:31", "2024-11-12 20:19:31", "{\"update_callback\":\"wc_update_890_update_paypal_standard_load_eligibility\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731430171;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731430171;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("502", "woocommerce_run_update_callback", "complete", "2024-11-12 16:49:32", "2024-11-12 20:19:32", "{\"update_callback\":\"wc_update_891_create_plugin_autoinstall_history_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731430172;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731430172;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("503", "woocommerce_run_update_callback", "complete", "2024-11-12 16:49:33", "2024-11-12 20:19:33", "{\"update_callback\":\"wc_update_910_add_launch_your_store_tour_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731430173;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731430173;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("504", "woocommerce_run_update_callback", "complete", "2024-11-12 16:49:34", "2024-11-12 20:19:34", "{\"update_callback\":\"wc_update_910_remove_obsolete_user_meta\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731430174;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731430174;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("505", "woocommerce_run_update_callback", "complete", "2024-11-12 16:49:35", "2024-11-12 20:19:35", "{\"update_callback\":\"wc_update_920_add_wc_hooked_blocks_version_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731430175;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731430175;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("506", "woocommerce_run_update_callback", "complete", "2024-11-12 16:49:36", "2024-11-12 20:19:36", "{\"update_callback\":\"wc_update_930_add_woocommerce_coming_soon_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731430176;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731430176;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("507", "woocommerce_run_update_callback", "complete", "2024-11-12 16:49:37", "2024-11-12 20:19:37", "{\"update_callback\":\"wc_update_930_migrate_user_meta_for_launch_your_store_tour\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731430177;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731430177;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("508", "woocommerce_update_db_to_current_version", "complete", "2024-11-12 16:49:38", "2024-11-12 20:19:38", "{\"version\":\"9.3.3\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731430178;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731430178;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("509", "image-optimization/database/migration", "complete", "2024-11-12 16:58:55", "2024-11-12 16:58:55", "{\"name\":\"fix_mime_type\"}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "7", "1", "2025-11-08 15:10:57", "2025-11-08 18:40:57", "0", NULL, "0");
INSERT INTO `won_actionscheduler_actions` VALUES("510", "image-optimization/database/migration", "complete", "2024-11-12 16:58:55", "2024-11-12 16:58:55", "{\"name\":\"fix_avif_with_zero_dimensions\"}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "7", "1", "2025-11-08 15:10:57", "2025-11-08 18:40:57", "0", NULL, "0");
INSERT INTO `won_actionscheduler_actions` VALUES("511", "action_scheduler/migration_hook", "complete", "2024-11-12 16:59:55", "2024-11-12 20:29:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731430795;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731430795;}", "1", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("512", "wc_customer_order_export_cleanup_exports", "complete", "2024-11-12 17:07:44", "2024-11-12 20:37:44", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1731431264;s:18:\"\0*\0first_timestamp\";i:1731431264;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1731431264;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("513", "wc_customer_order_export_validate_automations", "complete", "2024-11-12 17:07:44", "2024-11-12 20:37:44", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1731431264;s:18:\"\0*\0first_timestamp\";i:1731431264;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1731431264;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("514", "fetch_patterns", "complete", "2024-11-13 09:46:12", "2024-11-13 13:16:12", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731491172;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731491172;}", "5", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("515", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-13 17:01:53", "2024-11-13 20:31:53", "[3966,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731517313;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731517313;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("516", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-13 17:57:26", "2024-11-13 21:27:26", "[3966,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731520646;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731520646;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("517", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-13 17:57:40", "2024-11-13 21:27:40", "[3974,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731520660;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731520660;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("518", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-13 17:58:16", "2024-11-13 21:28:16", "[3975,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731520696;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731520696;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("519", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-13 17:59:28", "2024-11-13 21:29:28", "[3974,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731520768;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731520768;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("520", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-13 17:59:52", "2024-11-13 21:29:52", "[3976,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731520792;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731520792;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("521", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-13 17:59:57", "2024-11-13 21:29:57", "[3977,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731520797;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731520797;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("522", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-13 18:00:01", "2024-11-13 21:30:01", "[3978,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731520801;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731520801;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("523", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-13 18:00:05", "2024-11-13 21:30:05", "[3979,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731520805;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731520805;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("524", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-13 18:00:14", "2024-11-13 21:30:14", "[3980,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731520814;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731520814;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("525", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-13 18:00:15", "2024-11-13 21:30:15", "[3981,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731520815;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731520815;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("526", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-13 18:00:17", "2024-11-13 21:30:17", "[3982,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731520817;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731520817;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("527", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-13 18:00:30", "2024-11-13 21:30:30", "[3983,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731520830;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731520830;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("528", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-13 18:00:34", "2024-11-13 21:30:34", "[3984,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731520834;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731520834;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("529", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-13 19:14:53", "2024-11-13 22:44:53", "[3985,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731525293;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731525293;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("530", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-13 19:24:21", "2024-11-13 22:54:21", "[3985,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731525861;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731525861;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("531", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-13 19:30:21", "2024-11-13 23:00:21", "[3991,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731526221;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731526221;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("532", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-13 19:33:17", "2024-11-13 23:03:17", "[3992,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731526397;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731526397;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("533", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-13 19:33:56", "2024-11-13 23:03:56", "[3992,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731526436;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731526436;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("534", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-13 19:34:00", "2024-11-13 23:04:00", "[3991,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731526440;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731526440;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("535", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-13 19:34:55", "2024-11-13 23:04:55", "[3993,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731526495;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731526495;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("536", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-13 19:35:28", "2024-11-13 23:05:28", "[3993,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731526528;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731526528;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("537", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-13 19:36:11", "2024-11-13 23:06:11", "[3994,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731526571;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731526571;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("538", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-13 19:38:09", "2024-11-13 23:08:09", "[3994,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731526689;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731526689;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("539", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-13 19:39:25", "2024-11-13 23:09:25", "[3995,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731526765;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731526765;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("540", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-13 19:39:32", "2024-11-13 23:09:32", "[3995,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731526772;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731526772;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("541", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-13 19:39:33", "2024-11-13 23:09:33", "[3994,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731526773;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731526773;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("542", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-13 19:40:21", "2024-11-13 23:10:21", "[3996,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731526821;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731526821;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("543", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-13 19:41:29", "2024-11-13 23:11:29", "[3996,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731526889;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731526889;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("544", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-13 19:42:38", "2024-11-13 23:12:38", "[3997,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731526958;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731526958;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("545", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-13 19:42:50", "2024-11-13 23:12:50", "[3997,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731526970;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731526970;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("546", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-13 19:42:51", "2024-11-13 23:12:51", "[3997,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731526971;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731526971;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("547", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-13 19:55:57", "2024-11-13 23:25:57", "[3998,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731527757;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731527757;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("548", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-13 19:57:37", "2024-11-13 23:27:37", "[3998,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731527857;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731527857;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("549", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-13 19:57:38", "2024-11-13 23:27:38", "[3996,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731527858;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731527858;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("550", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-13 19:58:01", "2024-11-13 23:28:01", "[3998,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731527881;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731527881;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("551", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-13 20:02:37", "2024-11-13 23:32:37", "[3999,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731528157;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731528157;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("552", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-13 20:03:03", "2024-11-13 23:33:03", "[3999,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731528183;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731528183;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("553", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-13 20:03:04", "2024-11-13 23:33:04", "[3999,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731528184;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731528184;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("554", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-13 20:05:48", "2024-11-13 23:35:48", "[3995,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731528348;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731528348;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("555", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-13 20:05:48", "2024-11-13 23:35:48", "[3985,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731528348;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731528348;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("556", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-13 20:18:48", "2024-11-13 23:48:48", "[4000,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731529128;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731529128;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("557", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-13 20:22:59", "2024-11-13 23:52:59", "[4001,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731529379;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731529379;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("558", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-13 20:22:59", "2024-11-13 23:52:59", "[4000,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731529379;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731529379;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("559", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-13 20:24:29", "2024-11-13 23:54:29", "[4001,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731529469;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731529469;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("560", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-13 20:25:17", "2024-11-13 23:55:17", "[4002,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731529517;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731529517;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("561", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-13 20:25:28", "2024-11-13 23:55:28", "[4003,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731529528;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731529528;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("562", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-13 20:25:53", "2024-11-13 23:55:53", "[4002,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731529553;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731529553;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("563", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-13 20:25:53", "2024-11-13 23:55:53", "[4003,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731529553;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731529553;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("564", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-13 20:25:54", "2024-11-13 23:55:54", "[4002,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731529554;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731529554;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("565", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-16 15:52:32", "2024-11-16 19:22:32", "[4010,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731772352;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731772352;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("566", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-16 15:52:49", "2024-11-16 19:22:49", "[4014,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731772369;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731772369;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("567", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-16 15:52:49", "2024-11-16 19:22:49", "[4010,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731772369;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731772369;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("568", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-16 15:53:05", "2024-11-16 19:23:05", "[4015,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731772385;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731772385;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("569", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-16 15:53:11", "2024-11-16 19:23:11", "[4016,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731772391;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731772391;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("570", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-16 16:16:07", "2024-11-16 19:46:07", "[4018,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731773767;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731773767;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("571", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-16 16:16:16", "2024-11-16 19:46:16", "[4022,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731773776;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731773776;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("572", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-16 16:16:16", "2024-11-16 19:46:16", "[4018,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731773776;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731773776;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("573", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-16 16:16:22", "2024-11-16 19:46:22", "[4023,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731773782;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731773782;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("574", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-16 16:16:49", "2024-11-16 19:46:49", "[4024,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731773809;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731773809;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("575", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-16 16:16:54", "2024-11-16 19:46:54", "[4024,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731773814;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731773814;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("576", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-16 16:16:55", "2024-11-16 19:46:55", "[4024,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731773815;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731773815;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("577", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-16 16:19:12", "2024-11-16 19:49:12", "[4022,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731773952;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731773952;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("578", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-16 16:19:24", "2024-11-16 19:49:24", "[4025,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731773964;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731773964;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("579", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-16 17:07:58", "2024-11-16 20:37:58", "[4027,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731776878;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731776878;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("580", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-16 17:45:17", "2024-11-16 21:15:17", "[4032,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731779117;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731779117;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("581", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-16 17:58:48", "2024-11-16 21:28:48", "[4008,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731779928;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731779928;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("582", "wc_schedule_update_product_default_cat", "complete", "2024-11-16 18:03:18", "2024-11-16 21:33:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731780198;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731780198;}", "6", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("583", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-16 21:09:32", "2024-11-17 00:39:32", "[4038,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731791372;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731791372;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("584", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-16 21:09:53", "2024-11-17 00:39:53", "[4053,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731791393;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731791393;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("585", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-16 21:09:53", "2024-11-17 00:39:53", "[4038,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731791393;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731791393;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("586", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-16 21:09:59", "2024-11-17 00:39:59", "[4054,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731791399;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731791399;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("587", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-16 21:10:05", "2024-11-17 00:40:05", "[4055,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731791405;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731791405;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("588", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-16 21:10:10", "2024-11-17 00:40:10", "[4056,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731791410;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731791410;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("589", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-16 21:15:37", "2024-11-17 00:45:37", "[4054,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731791737;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731791737;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("590", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-16 21:18:28", "2024-11-17 00:48:28", "[4055,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731791908;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731791908;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("591", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-16 21:18:28", "2024-11-17 00:48:28", "[4056,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731791908;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731791908;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("592", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-16 21:40:48", "2024-11-17 01:10:48", "[4058,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731793248;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731793248;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("593", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-16 21:40:53", "2024-11-17 01:10:53", "[4059,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731793253;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731793253;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("594", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-16 21:43:47", "2024-11-17 01:13:47", "[4059,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731793427;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731793427;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("595", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-16 21:43:47", "2024-11-17 01:13:47", "[4058,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1731793427;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1731793427;}", "4", "1", "2025-11-08 15:10:58", "2025-11-08 18:40:58", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("602", "woocommerce_run_update_callback", "complete", "2025-11-08 15:11:25", "2025-11-08 18:41:25", "{\"update_callback\":\"wc_update_940_add_phone_to_order_address_fts_index\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614685;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614685;}", "4", "1", "2025-11-08 15:12:11", "2025-11-08 18:42:11", "25096", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("603", "woocommerce_run_update_callback", "complete", "2025-11-08 15:11:26", "2025-11-08 18:41:26", "{\"update_callback\":\"wc_update_940_remove_help_panel_highlight_shown\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614686;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614686;}", "4", "1", "2025-11-08 15:12:14", "2025-11-08 18:42:14", "25097", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("604", "woocommerce_run_update_callback", "complete", "2025-11-08 15:11:27", "2025-11-08 18:41:27", "{\"update_callback\":\"wc_update_950_tracking_option_autoload\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614687;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614687;}", "4", "1", "2025-11-08 15:12:14", "2025-11-08 18:42:14", "25097", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("605", "woocommerce_run_update_callback", "complete", "2025-11-08 15:11:28", "2025-11-08 18:41:28", "{\"update_callback\":\"wc_update_961_migrate_default_email_base_color\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614688;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614688;}", "4", "1", "2025-11-08 15:12:14", "2025-11-08 18:42:14", "25097", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("606", "woocommerce_run_update_callback", "complete", "2025-11-08 15:11:29", "2025-11-08 18:41:29", "{\"update_callback\":\"wc_update_980_remove_order_attribution_install_banner_dismissed_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614689;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614689;}", "4", "1", "2025-11-08 15:12:14", "2025-11-08 18:42:14", "25097", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("607", "woocommerce_run_update_callback", "complete", "2025-11-08 15:11:30", "2025-11-08 18:41:30", "{\"update_callback\":\"wc_update_985_enable_new_payments_settings_page_feature\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614690;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614690;}", "4", "1", "2025-11-08 15:12:14", "2025-11-08 18:42:14", "25097", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("608", "woocommerce_run_update_callback", "complete", "2025-11-08 15:11:31", "2025-11-08 18:41:31", "{\"update_callback\":\"wc_update_990_remove_wc_count_comments_transient\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614691;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614691;}", "4", "1", "2025-11-08 15:12:14", "2025-11-08 18:42:14", "25097", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("609", "woocommerce_run_update_callback", "complete", "2025-11-08 15:11:32", "2025-11-08 18:41:32", "{\"update_callback\":\"wc_update_990_remove_email_notes\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614692;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614692;}", "4", "1", "2025-11-08 15:12:14", "2025-11-08 18:42:14", "25097", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("610", "woocommerce_run_update_callback", "complete", "2025-11-08 15:11:33", "2025-11-08 18:41:33", "{\"update_callback\":\"wc_update_1000_multisite_visibility_setting\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614693;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614693;}", "4", "1", "2025-11-08 15:12:14", "2025-11-08 18:42:14", "25097", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("611", "woocommerce_run_update_callback", "complete", "2025-11-08 15:11:34", "2025-11-08 18:41:34", "{\"update_callback\":\"wc_update_1000_remove_patterns_toolkit_transient\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614694;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614694;}", "4", "1", "2025-11-08 15:12:14", "2025-11-08 18:42:14", "25097", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("612", "woocommerce_run_update_callback", "complete", "2025-11-08 15:11:35", "2025-11-08 18:41:35", "{\"update_callback\":\"wc_update_1020_add_old_refunded_order_items_to_product_lookup_table\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614695;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614695;}", "4", "1", "2025-11-08 15:12:14", "2025-11-08 18:42:14", "25097", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("613", "woocommerce_run_update_callback", "complete", "2025-11-08 15:11:36", "2025-11-08 18:41:36", "{\"update_callback\":\"wc_update_1030_add_comments_date_type_index\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614696;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614696;}", "4", "1", "2025-11-08 15:12:14", "2025-11-08 18:42:14", "25097", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("614", "woocommerce_update_db_to_current_version", "complete", "2025-11-08 15:11:37", "2025-11-08 18:41:37", "{\"version\":\"10.3.4\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614697;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614697;}", "4", "1", "2025-11-08 15:12:14", "2025-11-08 18:42:14", "25097", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("615", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-08 15:12:01", "2025-11-08 18:42:01", "[2379,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614721;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614721;}", "4", "1", "2025-11-08 15:12:14", "2025-11-08 18:42:14", "25097", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("616", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-08 15:12:01", "2025-11-08 18:42:01", "[2305,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614721;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614721;}", "4", "1", "2025-11-08 15:12:14", "2025-11-08 18:42:14", "25097", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("617", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-08 15:12:01", "2025-11-08 18:42:01", "[2303,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614721;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614721;}", "4", "1", "2025-11-08 15:12:14", "2025-11-08 18:42:14", "25097", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("618", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-08 15:12:01", "2025-11-08 18:42:01", "[2301,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614721;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614721;}", "4", "1", "2025-11-08 15:12:14", "2025-11-08 18:42:14", "25097", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("619", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-08 15:12:01", "2025-11-08 18:42:01", "[2299,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614721;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614721;}", "4", "1", "2025-11-08 15:12:14", "2025-11-08 18:42:14", "25097", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("620", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-08 15:12:02", "2025-11-08 18:42:02", "[411,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614722;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614722;}", "4", "1", "2025-11-08 15:12:14", "2025-11-08 18:42:14", "25097", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("621", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-08 15:12:02", "2025-11-08 18:42:02", "[2605,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614722;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614722;}", "4", "1", "2025-11-08 15:12:14", "2025-11-08 18:42:14", "25097", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("622", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-08 15:12:02", "2025-11-08 18:42:02", "[2603,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614722;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614722;}", "4", "1", "2025-11-08 15:12:14", "2025-11-08 18:42:14", "25097", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("623", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-08 15:12:02", "2025-11-08 18:42:02", "[2601,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614722;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614722;}", "4", "1", "2025-11-08 15:12:14", "2025-11-08 18:42:14", "25097", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("624", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-08 15:12:02", "2025-11-08 18:42:02", "[2599,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614722;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614722;}", "4", "1", "2025-11-08 15:12:14", "2025-11-08 18:42:14", "25097", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("625", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-08 15:12:02", "2025-11-08 18:42:02", "[2597,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614722;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614722;}", "4", "1", "2025-11-08 15:12:14", "2025-11-08 18:42:14", "25097", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("626", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-08 15:12:02", "2025-11-08 18:42:02", "[2592,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614722;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614722;}", "4", "1", "2025-11-08 15:12:14", "2025-11-08 18:42:14", "25097", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("627", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-08 15:12:02", "2025-11-08 18:42:02", "[2584,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614722;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614722;}", "4", "1", "2025-11-08 15:12:14", "2025-11-08 18:42:14", "25097", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("628", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-08 15:12:02", "2025-11-08 18:42:02", "[2582,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614722;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614722;}", "4", "1", "2025-11-08 15:12:14", "2025-11-08 18:42:14", "25098", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("629", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-08 15:12:02", "2025-11-08 18:42:02", "[2579,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614722;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614722;}", "4", "1", "2025-11-08 15:12:14", "2025-11-08 18:42:14", "25098", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("630", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-08 15:12:02", "2025-11-08 18:42:02", "[2576,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614722;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614722;}", "4", "1", "2025-11-08 15:12:14", "2025-11-08 18:42:14", "25098", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("631", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-08 15:12:02", "2025-11-08 18:42:02", "[2574,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614722;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614722;}", "4", "1", "2025-11-08 15:12:14", "2025-11-08 18:42:14", "25098", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("632", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-08 15:12:02", "2025-11-08 18:42:02", "[2567,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614722;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614722;}", "4", "1", "2025-11-08 15:12:14", "2025-11-08 18:42:14", "25098", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("633", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-08 15:12:02", "2025-11-08 18:42:02", "[2388,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614722;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614722;}", "4", "1", "2025-11-08 15:12:14", "2025-11-08 18:42:14", "25098", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("634", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-08 15:12:02", "2025-11-08 18:42:02", "[2385,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614722;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614722;}", "4", "1", "2025-11-08 15:12:14", "2025-11-08 18:42:14", "25098", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("635", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-08 15:12:02", "2025-11-08 18:42:02", "[2383,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614722;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614722;}", "4", "1", "2025-11-08 15:12:14", "2025-11-08 18:42:14", "25098", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("636", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-08 15:12:02", "2025-11-08 18:42:02", "[2381,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614722;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614722;}", "4", "1", "2025-11-08 15:12:14", "2025-11-08 18:42:14", "25098", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("637", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-08 15:12:02", "2025-11-08 18:42:02", "[407,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614722;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614722;}", "4", "1", "2025-11-08 15:12:14", "2025-11-08 18:42:14", "25098", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("638", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-08 15:12:02", "2025-11-08 18:42:02", "[406,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614722;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614722;}", "4", "1", "2025-11-08 15:12:14", "2025-11-08 18:42:14", "25098", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("639", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-08 15:12:02", "2025-11-08 18:42:02", "[54,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614722;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614722;}", "4", "1", "2025-11-08 15:12:14", "2025-11-08 18:42:14", "25098", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("640", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-08 15:12:02", "2025-11-08 18:42:02", "[404,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614722;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614722;}", "4", "1", "2025-11-08 15:12:14", "2025-11-08 18:42:14", "25098", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("641", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-08 15:12:02", "2025-11-08 18:42:02", "[403,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614722;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614722;}", "4", "1", "2025-11-08 15:12:14", "2025-11-08 18:42:14", "25098", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("642", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-08 15:12:02", "2025-11-08 18:42:02", "[402,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614722;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614722;}", "4", "1", "2025-11-08 15:12:15", "2025-11-08 18:42:15", "25098", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("643", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-08 15:12:02", "2025-11-08 18:42:02", "[401,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614722;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614722;}", "4", "1", "2025-11-08 15:12:15", "2025-11-08 18:42:15", "25098", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("644", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-08 15:12:02", "2025-11-08 18:42:02", "[48,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614722;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614722;}", "4", "1", "2025-11-08 15:12:15", "2025-11-08 18:42:15", "25098", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("645", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-08 15:12:02", "2025-11-08 18:42:02", "[400,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614722;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614722;}", "4", "1", "2025-11-08 15:12:15", "2025-11-08 18:42:15", "25098", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("646", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-08 15:12:02", "2025-11-08 18:42:02", "[399,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614722;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614722;}", "4", "1", "2025-11-08 15:12:15", "2025-11-08 18:42:15", "25098", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("647", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-08 15:12:02", "2025-11-08 18:42:02", "[398,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614722;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614722;}", "4", "1", "2025-11-08 15:12:15", "2025-11-08 18:42:15", "25098", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("648", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-08 15:12:02", "2025-11-08 18:42:02", "[4008,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614722;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614722;}", "4", "1", "2025-11-08 15:12:15", "2025-11-08 18:42:15", "25098", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("649", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-08 15:12:02", "2025-11-08 18:42:02", "[4027,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614722;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614722;}", "4", "1", "2025-11-08 15:12:15", "2025-11-08 18:42:15", "25098", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("650", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-08 15:12:02", "2025-11-08 18:42:02", "[3972,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614722;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614722;}", "4", "1", "2025-11-08 15:12:15", "2025-11-08 18:42:15", "25098", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("651", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-08 15:12:02", "2025-11-08 18:42:02", "[3973,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614722;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614722;}", "4", "1", "2025-11-08 15:12:15", "2025-11-08 18:42:15", "25098", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("652", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-08 15:12:02", "2025-11-08 18:42:02", "[4003,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614722;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614722;}", "4", "1", "2025-11-08 15:12:15", "2025-11-08 18:42:15", "25098", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("653", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-08 15:12:02", "2025-11-08 18:42:02", "[4001,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614722;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614722;}", "4", "1", "2025-11-08 15:12:15", "2025-11-08 18:42:15", "25099", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("654", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-08 15:12:02", "2025-11-08 18:42:02", "[4000,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614722;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614722;}", "4", "1", "2025-11-08 15:12:15", "2025-11-08 18:42:15", "25099", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("655", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-08 15:12:02", "2025-11-08 18:42:02", "[4004,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614722;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614722;}", "4", "1", "2025-11-08 15:12:15", "2025-11-08 18:42:15", "25099", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("656", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-08 15:12:02", "2025-11-08 18:42:02", "[4005,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614722;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614722;}", "4", "1", "2025-11-08 15:12:15", "2025-11-08 18:42:15", "25099", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("657", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-08 15:12:02", "2025-11-08 18:42:02", "[4007,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614722;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614722;}", "4", "1", "2025-11-08 15:12:15", "2025-11-08 18:42:15", "25099", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("658", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-08 15:12:02", "2025-11-08 18:42:02", "[4009,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614722;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614722;}", "4", "1", "2025-11-08 15:12:15", "2025-11-08 18:42:15", "25099", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("659", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-08 15:12:02", "2025-11-08 18:42:02", "[4013,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614722;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614722;}", "4", "1", "2025-11-08 15:12:15", "2025-11-08 18:42:15", "25099", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("660", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-08 15:12:02", "2025-11-08 18:42:02", "[4041,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762614722;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762614722;}", "4", "1", "2025-11-08 15:12:15", "2025-11-08 18:42:15", "25099", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("679", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-08 20:14:15", "2025-11-08 23:44:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762632855;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762632855;}", "9", "1", "2025-11-08 20:14:21", "2025-11-08 23:44:21", "25386", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("680", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-08 21:14:21", "2025-11-09 00:44:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762636461;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762636461;}", "9", "1", "2025-11-09 01:08:22", "2025-11-09 04:38:22", "25409", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("681", "woocommerce_scheduled_sales", "complete", "2025-11-09 21:11:21", "2025-11-10 00:41:21", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762722681;s:18:\"\0*\0first_timestamp\";i:1762635600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762722681;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-11-14 06:32:38", "2025-11-14 10:02:38", "25468", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("682", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-09 02:08:22", "2025-11-09 05:38:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762654102;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762654102;}", "9", "1", "2025-11-09 02:09:43", "2025-11-09 05:39:43", "25413", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("683", "woocommerce_cleanup_logs", "complete", "2025-11-10 01:08:22", "2025-11-10 04:38:22", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762736902;s:18:\"\0*\0first_timestamp\";i:1762646400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762736902;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-11-14 06:32:38", "2025-11-14 10:02:38", "25468", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("684", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-11-10 01:08:22", "2025-11-10 04:38:22", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762736902;s:18:\"\0*\0first_timestamp\";i:1762646400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762736902;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-11-14 06:32:38", "2025-11-14 10:02:38", "25468", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("685", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-09 03:09:43", "2025-11-09 06:39:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762657783;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762657783;}", "9", "1", "2025-11-09 04:34:12", "2025-11-09 08:04:12", "25418", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("686", "woocommerce_cleanup_sessions", "complete", "2025-11-09 16:34:12", "2025-11-09 20:04:12", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762706052;s:18:\"\0*\0first_timestamp\";i:1762657200;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762706052;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-11-14 06:32:38", "2025-11-14 10:02:38", "25468", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("687", "woocommerce_geoip_updater", "pending", "2025-11-24 04:34:12", "2025-11-24 08:04:12", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763958852;s:18:\"\0*\0first_timestamp\";i:1762657200;s:13:\"\0*\0recurrence\";i:1296000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763958852;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:1296000;}", "9", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("688", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-09 05:34:12", "2025-11-09 09:04:12", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762666452;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762666452;}", "9", "1", "2025-11-09 07:40:35", "2025-11-09 11:10:35", "25421", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("689", "woocommerce_refresh_order_count_cache", "complete", "2025-11-09 16:34:12", "2025-11-09 20:04:12", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762706052;s:18:\"\0*\0first_timestamp\";i:1762658010;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762706052;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2025-11-14 06:32:38", "2025-11-14 10:02:38", "25468", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("690", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-09 08:40:35", "2025-11-09 12:10:35", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762677635;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762677635;}", "9", "1", "2025-11-09 09:19:28", "2025-11-09 12:49:28", "25425", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("691", "woocommerce_marketplace_fetch_promotions_clear", "complete", "2025-11-09 07:40:35", "2025-11-09 11:10:35", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762674035;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762674035;}", "5", "1", "2025-11-09 08:06:35", "2025-11-09 11:36:35", "25423", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("692", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-09 10:19:28", "2025-11-09 13:49:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762683568;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762683568;}", "9", "1", "2025-11-09 10:28:42", "2025-11-09 13:58:42", "25427", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("693", "woocommerce_cancel_unpaid_orders", "complete", "2025-11-09 11:28:42", "2025-11-09 14:58:42", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762687722;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762687722;}", "9", "1", "2025-11-14 06:32:37", "2025-11-14 10:02:37", "25468", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("694", "action_scheduler/migration_hook", "complete", "2025-11-09 10:56:06", "2025-11-09 14:26:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762685766;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762685766;}", "1", "1", "2025-11-09 10:56:29", "2025-11-09 14:26:29", "25445", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("695", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-10 15:24:04", "2025-11-10 18:54:04", "[4056,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762788244;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762788244;}", "4", "1", "2025-11-14 06:32:38", "2025-11-14 10:02:38", "25468", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("696", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-10 15:24:04", "2025-11-10 18:54:04", "[4055,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762788244;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762788244;}", "4", "1", "2025-11-14 06:32:38", "2025-11-14 10:02:38", "25468", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("697", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-10 15:24:04", "2025-11-10 18:54:04", "[4054,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762788244;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762788244;}", "4", "1", "2025-11-14 06:32:38", "2025-11-14 10:02:38", "25468", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("698", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-10 15:24:04", "2025-11-10 18:54:04", "[4053,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762788244;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762788244;}", "4", "1", "2025-11-14 06:32:38", "2025-11-14 10:02:38", "25468", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("699", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-10 15:24:04", "2025-11-10 18:54:04", "[4038,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762788244;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762788244;}", "4", "1", "2025-11-14 06:32:38", "2025-11-14 10:02:38", "25468", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("700", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-10 15:24:04", "2025-11-10 18:54:04", "[4032,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762788244;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762788244;}", "4", "1", "2025-11-14 06:32:38", "2025-11-14 10:02:38", "25468", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("701", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-10 15:24:04", "2025-11-10 18:54:04", "[4025,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762788244;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762788244;}", "4", "1", "2025-11-14 06:32:38", "2025-11-14 10:02:38", "25468", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("702", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-10 15:24:04", "2025-11-10 18:54:04", "[4023,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762788244;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762788244;}", "4", "1", "2025-11-14 06:32:38", "2025-11-14 10:02:38", "25468", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("703", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-10 15:24:04", "2025-11-10 18:54:04", "[4022,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762788244;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762788244;}", "4", "1", "2025-11-14 06:32:38", "2025-11-14 10:02:38", "25468", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("704", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-10 15:24:04", "2025-11-10 18:54:04", "[4018,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762788244;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762788244;}", "4", "1", "2025-11-14 06:32:38", "2025-11-14 10:02:38", "25468", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("705", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-10 15:24:04", "2025-11-10 18:54:04", "[4016,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762788244;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762788244;}", "4", "1", "2025-11-14 06:32:38", "2025-11-14 10:02:38", "25468", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("706", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-10 15:24:04", "2025-11-10 18:54:04", "[4015,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762788244;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762788244;}", "4", "1", "2025-11-14 06:32:38", "2025-11-14 10:02:38", "25468", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("707", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-10 15:24:04", "2025-11-10 18:54:04", "[4014,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762788244;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762788244;}", "4", "1", "2025-11-14 06:32:38", "2025-11-14 10:02:38", "25468", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("708", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-10 15:24:04", "2025-11-10 18:54:04", "[4010,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762788244;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762788244;}", "4", "1", "2025-11-14 06:32:38", "2025-11-14 10:02:38", "25468", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("709", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-10 15:24:04", "2025-11-10 18:54:04", "[4006,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762788244;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762788244;}", "4", "1", "2025-11-14 06:32:38", "2025-11-14 10:02:38", "25469", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("710", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-10 15:24:04", "2025-11-10 18:54:04", "[4059,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762788244;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762788244;}", "4", "1", "2025-11-14 06:32:38", "2025-11-14 10:02:38", "25469", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("711", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-10 15:24:04", "2025-11-10 18:54:04", "[4058,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762788244;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762788244;}", "4", "1", "2025-11-14 06:32:38", "2025-11-14 10:02:38", "25469", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("712", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-10 15:24:04", "2025-11-10 18:54:04", "[3995,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762788244;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762788244;}", "4", "1", "2025-11-14 06:32:38", "2025-11-14 10:02:38", "25469", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("713", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-10 15:24:04", "2025-11-10 18:54:04", "[3985,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762788244;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762788244;}", "4", "1", "2025-11-14 06:32:38", "2025-11-14 10:02:38", "25469", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("714", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-10 15:24:04", "2025-11-10 18:54:04", "[3984,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762788244;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762788244;}", "4", "1", "2025-11-14 06:32:38", "2025-11-14 10:02:38", "25469", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("715", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-10 15:24:04", "2025-11-10 18:54:04", "[3983,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762788244;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762788244;}", "4", "1", "2025-11-14 06:32:38", "2025-11-14 10:02:38", "25469", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("716", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-10 15:24:04", "2025-11-10 18:54:04", "[3982,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762788244;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762788244;}", "4", "1", "2025-11-14 06:32:38", "2025-11-14 10:02:38", "25469", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("717", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-10 15:24:04", "2025-11-10 18:54:04", "[3981,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762788244;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762788244;}", "4", "1", "2025-11-14 06:32:38", "2025-11-14 10:02:38", "25469", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("718", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-10 15:24:04", "2025-11-10 18:54:04", "[3980,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762788244;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762788244;}", "4", "1", "2025-11-14 06:32:38", "2025-11-14 10:02:38", "25469", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("719", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-10 15:24:04", "2025-11-10 18:54:04", "[3979,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762788244;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762788244;}", "4", "1", "2025-11-14 06:32:38", "2025-11-14 10:02:38", "25469", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("720", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-10 15:24:04", "2025-11-10 18:54:04", "[3978,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762788244;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762788244;}", "4", "1", "2025-11-14 06:32:38", "2025-11-14 10:02:38", "25469", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("721", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-10 15:24:04", "2025-11-10 18:54:04", "[3977,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762788244;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762788244;}", "4", "1", "2025-11-14 06:32:38", "2025-11-14 10:02:38", "25469", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("722", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-10 15:24:04", "2025-11-10 18:54:04", "[3976,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762788244;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762788244;}", "4", "1", "2025-11-14 06:32:38", "2025-11-14 10:02:38", "25469", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("723", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-10 15:24:04", "2025-11-10 18:54:04", "[3975,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762788244;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762788244;}", "4", "1", "2025-11-14 06:32:38", "2025-11-14 10:02:38", "25469", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("724", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-10 15:24:04", "2025-11-10 18:54:04", "[3966,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762788244;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762788244;}", "4", "1", "2025-11-14 06:32:38", "2025-11-14 10:02:38", "25469", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("725", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-11-10 15:24:04", "2025-11-10 18:54:04", "[3965,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762788244;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762788244;}", "4", "1", "2025-11-14 06:32:38", "2025-11-14 10:02:38", "25469", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("726", "wc_schedule_update_product_default_cat", "complete", "2025-11-10 15:24:21", "2025-11-10 18:54:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762788261;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762788261;}", "6", "1", "2025-11-14 06:32:38", "2025-11-14 10:02:38", "25469", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("727", "wc_schedule_update_product_default_cat", "complete", "2025-11-10 15:24:21", "2025-11-10 18:54:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762788261;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762788261;}", "6", "1", "2025-11-14 06:32:38", "2025-11-14 10:02:38", "25469", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("728", "wc_schedule_update_product_default_cat", "complete", "2025-11-10 15:24:22", "2025-11-10 18:54:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762788262;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762788262;}", "6", "1", "2025-11-14 06:32:38", "2025-11-14 10:02:38", "25469", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("729", "wc_schedule_update_product_default_cat", "complete", "2025-11-10 15:24:22", "2025-11-10 18:54:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762788262;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762788262;}", "6", "1", "2025-11-14 06:32:38", "2025-11-14 10:02:38", "25469", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("730", "wc_schedule_update_product_default_cat", "complete", "2025-11-10 15:24:22", "2025-11-10 18:54:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762788262;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762788262;}", "6", "1", "2025-11-14 06:32:38", "2025-11-14 10:02:38", "25469", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("731", "wc_schedule_update_product_default_cat", "complete", "2025-11-10 15:24:22", "2025-11-10 18:54:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1762788262;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1762788262;}", "6", "1", "2025-11-14 06:32:38", "2025-11-14 10:02:38", "25469", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("732", "woocommerce_cancel_unpaid_orders", "pending", "2025-11-14 07:32:37", "2025-11-14 11:02:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1763105557;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1763105557;}", "9", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("733", "woocommerce_cleanup_draft_orders", "pending", "2025-11-15 06:32:37", "2025-11-15 10:02:37", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763188357;s:18:\"\0*\0first_timestamp\";i:1668072076;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763188357;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("734", "wc_customer_order_export_cleanup_exports", "pending", "2025-11-15 06:32:37", "2025-11-15 10:02:37", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763188357;s:18:\"\0*\0first_timestamp\";i:1731431264;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763188357;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("735", "wc_customer_order_export_validate_automations", "pending", "2025-11-15 06:32:37", "2025-11-15 10:02:37", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763188357;s:18:\"\0*\0first_timestamp\";i:1731431264;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763188357;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("736", "wc_admin_daily_wrapper", "pending", "2025-11-15 06:32:37", "2025-11-15 10:02:37", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763188357;s:18:\"\0*\0first_timestamp\";i:1762614810;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763188357;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("737", "woocommerce_cleanup_personal_data", "pending", "2025-11-15 06:32:38", "2025-11-15 10:02:38", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763188358;s:18:\"\0*\0first_timestamp\";i:1762614820;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763188358;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("738", "woocommerce_cleanup_sessions", "canceled", "2025-11-14 18:32:38", "2025-11-14 22:02:38", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763145158;s:18:\"\0*\0first_timestamp\";i:1762657200;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763145158;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("739", "woocommerce_refresh_order_count_cache", "pending", "2025-11-14 18:32:38", "2025-11-14 22:02:38", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763145158;s:18:\"\0*\0first_timestamp\";i:1762658010;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763145158;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("740", "woocommerce_scheduled_sales", "pending", "2025-11-15 06:32:38", "2025-11-15 10:02:38", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763188358;s:18:\"\0*\0first_timestamp\";i:1762635600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763188358;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("741", "woocommerce_cleanup_logs", "pending", "2025-11-15 06:32:38", "2025-11-15 10:02:38", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763188358;s:18:\"\0*\0first_timestamp\";i:1762646400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763188358;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("742", "woocommerce_cleanup_rate_limits_wrapper", "pending", "2025-11-15 06:32:38", "2025-11-15 10:02:38", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763188358;s:18:\"\0*\0first_timestamp\";i:1762646400;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763188358;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("743", "woocommerce_cleanup_sessions", "pending", "2025-11-15 03:00:00", "2025-11-15 06:30:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763175600;s:18:\"\0*\0first_timestamp\";i:1763175600;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763175600;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("744", "generate_category_lookup_table_wrapper", "pending", "2025-11-14 06:32:48", "2025-11-14 10:02:48", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1763101968;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1763101968;}", "9", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `won_actionscheduler_actions` VALUES("745", "action_scheduler_run_recurring_actions_schedule_hook", "pending", "2025-11-15 06:32:38", "2025-11-15 10:02:38", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763188358;s:18:\"\0*\0first_timestamp\";i:1762614809;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763188358;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "20");
INSERT INTO `won_actionscheduler_actions` VALUES("746", "woocommerce_marketplace_fetch_promotions_clear", "pending", "2025-11-14 06:32:58", "2025-11-14 10:02:58", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1763101978;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1763101978;}", "5", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");

/* INSERT TABLE DATA: won_actionscheduler_groups */
INSERT INTO `won_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `won_actionscheduler_groups` VALUES("2", "wc_update_product_lookup_tables");
INSERT INTO `won_actionscheduler_groups` VALUES("3", "wc-admin-data");
INSERT INTO `won_actionscheduler_groups` VALUES("4", "woocommerce-db-updates");
INSERT INTO `won_actionscheduler_groups` VALUES("5", "");
INSERT INTO `won_actionscheduler_groups` VALUES("6", "wc_update_product_default_cat");
INSERT INTO `won_actionscheduler_groups` VALUES("7", "image-optimization/migration");
INSERT INTO `won_actionscheduler_groups` VALUES("8", "ActionScheduler");
INSERT INTO `won_actionscheduler_groups` VALUES("9", "woocommerce");
INSERT INTO `won_actionscheduler_groups` VALUES("10", "count");

/* INSERT TABLE DATA: won_actionscheduler_logs */
INSERT INTO `won_actionscheduler_logs` VALUES("1350", "469", "action created", "2024-08-12 19:36:55", "2024-08-12 23:06:55");
INSERT INTO `won_actionscheduler_logs` VALUES("1349", "468", "action created", "2024-08-12 19:36:55", "2024-08-12 23:06:55");
INSERT INTO `won_actionscheduler_logs` VALUES("1521", "470", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1522", "470", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("806", "275", "ایجاد فعالیت", "2024-01-12 16:43:38", "2024-01-12 20:13:38");
INSERT INTO `won_actionscheduler_logs` VALUES("807", "275", "عملیات توسط Async Request شروع شد", "2024-01-12 16:45:15", "2024-01-12 20:15:15");
INSERT INTO `won_actionscheduler_logs` VALUES("808", "275", "اقدام از طریق Async Request انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2024-01-12 16:45:15", "2024-01-12 20:15:15");
INSERT INTO `won_actionscheduler_logs` VALUES("1331", "450", "ایجاد فعالیت", "2024-08-12 15:38:47", "2024-08-12 19:08:47");
INSERT INTO `won_actionscheduler_logs` VALUES("1332", "451", "action created", "2024-08-12 17:17:12", "2024-08-12 20:47:12");
INSERT INTO `won_actionscheduler_logs` VALUES("1510", "464", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:57", "2025-11-08 18:40:57");
INSERT INTO `won_actionscheduler_logs` VALUES("1509", "464", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:57", "2025-11-08 18:40:57");
INSERT INTO `won_actionscheduler_logs` VALUES("1372", "491", "action created", "2024-08-13 06:34:22", "2024-08-13 10:04:22");
INSERT INTO `won_actionscheduler_logs` VALUES("1371", "490", "action created", "2024-08-13 06:34:22", "2024-08-13 10:04:22");
INSERT INTO `won_actionscheduler_logs` VALUES("1517", "468", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:57", "2025-11-08 18:40:57");
INSERT INTO `won_actionscheduler_logs` VALUES("1516", "467", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:57", "2025-11-08 18:40:57");
INSERT INTO `won_actionscheduler_logs` VALUES("1360", "479", "action created", "2024-08-12 19:37:06", "2024-08-12 23:07:06");
INSERT INTO `won_actionscheduler_logs` VALUES("1357", "476", "action created", "2024-08-12 19:37:06", "2024-08-12 23:07:06");
INSERT INTO `won_actionscheduler_logs` VALUES("1500", "459", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:57", "2025-11-08 18:40:57");
INSERT INTO `won_actionscheduler_logs` VALUES("1499", "459", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:57", "2025-11-08 18:40:57");
INSERT INTO `won_actionscheduler_logs` VALUES("1366", "485", "action created", "2024-08-12 19:37:06", "2024-08-12 23:07:06");
INSERT INTO `won_actionscheduler_logs` VALUES("1862", "612", "عملیات با WP Cron شروع شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1505", "462", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:57", "2025-11-08 18:40:57");
INSERT INTO `won_actionscheduler_logs` VALUES("1504", "461", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:57", "2025-11-08 18:40:57");
INSERT INTO `won_actionscheduler_logs` VALUES("1354", "473", "action created", "2024-08-12 19:36:56", "2024-08-12 23:06:56");
INSERT INTO `won_actionscheduler_logs` VALUES("1495", "457", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:57", "2025-11-08 18:40:57");
INSERT INTO `won_actionscheduler_logs` VALUES("1494", "456", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:57", "2025-11-08 18:40:57");
INSERT INTO `won_actionscheduler_logs` VALUES("1832", "651", "عملیات ایجاد شد", "2025-11-08 15:12:01", "2025-11-08 18:42:01");
INSERT INTO `won_actionscheduler_logs` VALUES("1490", "454", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:57", "2025-11-08 18:40:57");
INSERT INTO `won_actionscheduler_logs` VALUES("1489", "454", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:57", "2025-11-08 18:40:57");
INSERT INTO `won_actionscheduler_logs` VALUES("1351", "470", "action created", "2024-08-12 19:36:55", "2024-08-12 23:06:55");
INSERT INTO `won_actionscheduler_logs` VALUES("1485", "452", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:57", "2025-11-08 18:40:57");
INSERT INTO `won_actionscheduler_logs` VALUES("1484", "451", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:57", "2025-11-08 18:40:57");
INSERT INTO `won_actionscheduler_logs` VALUES("1348", "467", "action created", "2024-08-12 19:36:55", "2024-08-12 23:06:55");
INSERT INTO `won_actionscheduler_logs` VALUES("1478", "493", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:57", "2025-11-08 18:40:57");
INSERT INTO `won_actionscheduler_logs` VALUES("1363", "482", "action created", "2024-08-12 19:37:06", "2024-08-12 23:07:06");
INSERT INTO `won_actionscheduler_logs` VALUES("1362", "481", "action created", "2024-08-12 19:37:06", "2024-08-12 23:07:06");
INSERT INTO `won_actionscheduler_logs` VALUES("1345", "464", "action created", "2024-08-12 19:36:55", "2024-08-12 23:06:55");
INSERT INTO `won_actionscheduler_logs` VALUES("1346", "465", "action created", "2024-08-12 19:36:55", "2024-08-12 23:06:55");
INSERT INTO `won_actionscheduler_logs` VALUES("1347", "466", "action created", "2024-08-12 19:36:55", "2024-08-12 23:06:55");
INSERT INTO `won_actionscheduler_logs` VALUES("1342", "461", "action created", "2024-08-12 19:36:55", "2024-08-12 23:06:55");
INSERT INTO `won_actionscheduler_logs` VALUES("1343", "462", "action created", "2024-08-12 19:36:55", "2024-08-12 23:06:55");
INSERT INTO `won_actionscheduler_logs` VALUES("1344", "463", "action created", "2024-08-12 19:36:55", "2024-08-12 23:06:55");
INSERT INTO `won_actionscheduler_logs` VALUES("1809", "628", "عملیات ایجاد شد", "2025-11-08 15:12:01", "2025-11-08 18:42:01");
INSERT INTO `won_actionscheduler_logs` VALUES("1808", "627", "عملیات ایجاد شد", "2025-11-08 15:12:01", "2025-11-08 18:42:01");
INSERT INTO `won_actionscheduler_logs` VALUES("1875", "618", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1867", "614", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1868", "615", "عملیات با WP Cron شروع شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1335", "454", "action created", "2024-08-12 19:36:55", "2024-08-12 23:06:55");
INSERT INTO `won_actionscheduler_logs` VALUES("1336", "455", "action created", "2024-08-12 19:36:55", "2024-08-12 23:06:55");
INSERT INTO `won_actionscheduler_logs` VALUES("1337", "456", "action created", "2024-08-12 19:36:55", "2024-08-12 23:06:55");
INSERT INTO `won_actionscheduler_logs` VALUES("1328", "449", "ایجاد فعالیت", "2024-08-12 15:38:47", "2024-08-12 19:08:47");
INSERT INTO `won_actionscheduler_logs` VALUES("1791", "610", "عملیات ایجاد شد", "2025-11-08 15:11:25", "2025-11-08 18:41:25");
INSERT INTO `won_actionscheduler_logs` VALUES("1790", "609", "عملیات ایجاد شد", "2025-11-08 15:11:25", "2025-11-08 18:41:25");
INSERT INTO `won_actionscheduler_logs` VALUES("1882", "622", "عملیات با WP Cron شروع شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1788", "607", "عملیات ایجاد شد", "2025-11-08 15:11:25", "2025-11-08 18:41:25");
INSERT INTO `won_actionscheduler_logs` VALUES("1787", "606", "عملیات ایجاد شد", "2025-11-08 15:11:25", "2025-11-08 18:41:25");
INSERT INTO `won_actionscheduler_logs` VALUES("1890", "626", "عملیات با WP Cron شروع شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1889", "625", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1885", "623", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1869", "615", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1870", "616", "عملیات با WP Cron شروع شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1863", "612", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1864", "613", "عملیات با WP Cron شروع شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1865", "613", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1866", "614", "عملیات با WP Cron شروع شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1525", "472", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1856", "609", "عملیات با WP Cron شروع شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1855", "608", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1524", "471", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1523", "471", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1370", "489", "action created", "2024-08-13 06:34:22", "2024-08-13 10:04:22");
INSERT INTO `won_actionscheduler_logs` VALUES("1518", "468", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:57", "2025-11-08 18:40:57");
INSERT INTO `won_actionscheduler_logs` VALUES("1519", "469", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:57", "2025-11-08 18:40:57");
INSERT INTO `won_actionscheduler_logs` VALUES("1520", "469", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1513", "466", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:57", "2025-11-08 18:40:57");
INSERT INTO `won_actionscheduler_logs` VALUES("1514", "466", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:57", "2025-11-08 18:40:57");
INSERT INTO `won_actionscheduler_logs` VALUES("1515", "467", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:57", "2025-11-08 18:40:57");
INSERT INTO `won_actionscheduler_logs` VALUES("1512", "465", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:57", "2025-11-08 18:40:57");
INSERT INTO `won_actionscheduler_logs` VALUES("1511", "465", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:57", "2025-11-08 18:40:57");
INSERT INTO `won_actionscheduler_logs` VALUES("1508", "463", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:57", "2025-11-08 18:40:57");
INSERT INTO `won_actionscheduler_logs` VALUES("1373", "492", "action created", "2024-08-13 06:34:22", "2024-08-13 10:04:22");
INSERT INTO `won_actionscheduler_logs` VALUES("1369", "488", "action created", "2024-08-13 06:34:22", "2024-08-13 10:04:22");
INSERT INTO `won_actionscheduler_logs` VALUES("1507", "463", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:57", "2025-11-08 18:40:57");
INSERT INTO `won_actionscheduler_logs` VALUES("1506", "462", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:57", "2025-11-08 18:40:57");
INSERT INTO `won_actionscheduler_logs` VALUES("1503", "461", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:57", "2025-11-08 18:40:57");
INSERT INTO `won_actionscheduler_logs` VALUES("1368", "487", "action created", "2024-08-13 06:34:22", "2024-08-13 10:04:22");
INSERT INTO `won_actionscheduler_logs` VALUES("1367", "486", "action created", "2024-08-12 19:37:06", "2024-08-12 23:07:06");
INSERT INTO `won_actionscheduler_logs` VALUES("1502", "460", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:57", "2025-11-08 18:40:57");
INSERT INTO `won_actionscheduler_logs` VALUES("1501", "460", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:57", "2025-11-08 18:40:57");
INSERT INTO `won_actionscheduler_logs` VALUES("1498", "458", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:57", "2025-11-08 18:40:57");
INSERT INTO `won_actionscheduler_logs` VALUES("1497", "458", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:57", "2025-11-08 18:40:57");
INSERT INTO `won_actionscheduler_logs` VALUES("1496", "457", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:57", "2025-11-08 18:40:57");
INSERT INTO `won_actionscheduler_logs` VALUES("1493", "456", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:57", "2025-11-08 18:40:57");
INSERT INTO `won_actionscheduler_logs` VALUES("1356", "475", "action created", "2024-08-12 19:37:06", "2024-08-12 23:07:06");
INSERT INTO `won_actionscheduler_logs` VALUES("1355", "474", "action created", "2024-08-12 19:37:06", "2024-08-12 23:07:06");
INSERT INTO `won_actionscheduler_logs` VALUES("1492", "455", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:57", "2025-11-08 18:40:57");
INSERT INTO `won_actionscheduler_logs` VALUES("1491", "455", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:57", "2025-11-08 18:40:57");
INSERT INTO `won_actionscheduler_logs` VALUES("1488", "453", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:57", "2025-11-08 18:40:57");
INSERT INTO `won_actionscheduler_logs` VALUES("1365", "484", "action created", "2024-08-12 19:37:06", "2024-08-12 23:07:06");
INSERT INTO `won_actionscheduler_logs` VALUES("1364", "483", "action created", "2024-08-12 19:37:06", "2024-08-12 23:07:06");
INSERT INTO `won_actionscheduler_logs` VALUES("1487", "453", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:57", "2025-11-08 18:40:57");
INSERT INTO `won_actionscheduler_logs` VALUES("1486", "452", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:57", "2025-11-08 18:40:57");
INSERT INTO `won_actionscheduler_logs` VALUES("1483", "451", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:57", "2025-11-08 18:40:57");
INSERT INTO `won_actionscheduler_logs` VALUES("1359", "478", "action created", "2024-08-12 19:37:06", "2024-08-12 23:07:06");
INSERT INTO `won_actionscheduler_logs` VALUES("1358", "477", "action created", "2024-08-12 19:37:06", "2024-08-12 23:07:06");
INSERT INTO `won_actionscheduler_logs` VALUES("1482", "510", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:57", "2025-11-08 18:40:57");
INSERT INTO `won_actionscheduler_logs` VALUES("1831", "650", "عملیات ایجاد شد", "2025-11-08 15:12:01", "2025-11-08 18:42:01");
INSERT INTO `won_actionscheduler_logs` VALUES("1353", "472", "action created", "2024-08-12 19:36:56", "2024-08-12 23:06:56");
INSERT INTO `won_actionscheduler_logs` VALUES("1352", "471", "action created", "2024-08-12 19:36:55", "2024-08-12 23:06:55");
INSERT INTO `won_actionscheduler_logs` VALUES("1481", "510", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:57", "2025-11-08 18:40:57");
INSERT INTO `won_actionscheduler_logs` VALUES("1480", "509", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:57", "2025-11-08 18:40:57");
INSERT INTO `won_actionscheduler_logs` VALUES("1479", "509", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:57", "2025-11-08 18:40:57");
INSERT INTO `won_actionscheduler_logs` VALUES("1477", "493", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:57", "2025-11-08 18:40:57");
INSERT INTO `won_actionscheduler_logs` VALUES("1830", "649", "عملیات ایجاد شد", "2025-11-08 15:12:01", "2025-11-08 18:42:01");
INSERT INTO `won_actionscheduler_logs` VALUES("1361", "480", "action created", "2024-08-12 19:37:06", "2024-08-12 23:07:06");
INSERT INTO `won_actionscheduler_logs` VALUES("1829", "648", "عملیات ایجاد شد", "2025-11-08 15:12:01", "2025-11-08 18:42:01");
INSERT INTO `won_actionscheduler_logs` VALUES("1828", "647", "عملیات ایجاد شد", "2025-11-08 15:12:01", "2025-11-08 18:42:01");
INSERT INTO `won_actionscheduler_logs` VALUES("1827", "646", "عملیات ایجاد شد", "2025-11-08 15:12:01", "2025-11-08 18:42:01");
INSERT INTO `won_actionscheduler_logs` VALUES("1826", "645", "عملیات ایجاد شد", "2025-11-08 15:12:01", "2025-11-08 18:42:01");
INSERT INTO `won_actionscheduler_logs` VALUES("1825", "644", "عملیات ایجاد شد", "2025-11-08 15:12:01", "2025-11-08 18:42:01");
INSERT INTO `won_actionscheduler_logs` VALUES("1824", "643", "عملیات ایجاد شد", "2025-11-08 15:12:01", "2025-11-08 18:42:01");
INSERT INTO `won_actionscheduler_logs` VALUES("1823", "642", "عملیات ایجاد شد", "2025-11-08 15:12:01", "2025-11-08 18:42:01");
INSERT INTO `won_actionscheduler_logs` VALUES("1822", "641", "عملیات ایجاد شد", "2025-11-08 15:12:01", "2025-11-08 18:42:01");
INSERT INTO `won_actionscheduler_logs` VALUES("1821", "640", "عملیات ایجاد شد", "2025-11-08 15:12:01", "2025-11-08 18:42:01");
INSERT INTO `won_actionscheduler_logs` VALUES("1820", "639", "عملیات ایجاد شد", "2025-11-08 15:12:01", "2025-11-08 18:42:01");
INSERT INTO `won_actionscheduler_logs` VALUES("1819", "638", "عملیات ایجاد شد", "2025-11-08 15:12:01", "2025-11-08 18:42:01");
INSERT INTO `won_actionscheduler_logs` VALUES("1818", "637", "عملیات ایجاد شد", "2025-11-08 15:12:01", "2025-11-08 18:42:01");
INSERT INTO `won_actionscheduler_logs` VALUES("1817", "636", "عملیات ایجاد شد", "2025-11-08 15:12:01", "2025-11-08 18:42:01");
INSERT INTO `won_actionscheduler_logs` VALUES("1816", "635", "عملیات ایجاد شد", "2025-11-08 15:12:01", "2025-11-08 18:42:01");
INSERT INTO `won_actionscheduler_logs` VALUES("1815", "634", "عملیات ایجاد شد", "2025-11-08 15:12:01", "2025-11-08 18:42:01");
INSERT INTO `won_actionscheduler_logs` VALUES("1814", "633", "عملیات ایجاد شد", "2025-11-08 15:12:01", "2025-11-08 18:42:01");
INSERT INTO `won_actionscheduler_logs` VALUES("1813", "632", "عملیات ایجاد شد", "2025-11-08 15:12:01", "2025-11-08 18:42:01");
INSERT INTO `won_actionscheduler_logs` VALUES("1812", "631", "عملیات ایجاد شد", "2025-11-08 15:12:01", "2025-11-08 18:42:01");
INSERT INTO `won_actionscheduler_logs` VALUES("1811", "630", "عملیات ایجاد شد", "2025-11-08 15:12:01", "2025-11-08 18:42:01");
INSERT INTO `won_actionscheduler_logs` VALUES("1810", "629", "عملیات ایجاد شد", "2025-11-08 15:12:01", "2025-11-08 18:42:01");
INSERT INTO `won_actionscheduler_logs` VALUES("1807", "626", "عملیات ایجاد شد", "2025-11-08 15:12:01", "2025-11-08 18:42:01");
INSERT INTO `won_actionscheduler_logs` VALUES("1806", "625", "عملیات ایجاد شد", "2025-11-08 15:12:01", "2025-11-08 18:42:01");
INSERT INTO `won_actionscheduler_logs` VALUES("1805", "624", "عملیات ایجاد شد", "2025-11-08 15:12:01", "2025-11-08 18:42:01");
INSERT INTO `won_actionscheduler_logs` VALUES("1799", "618", "عملیات ایجاد شد", "2025-11-08 15:12:00", "2025-11-08 18:42:00");
INSERT INTO `won_actionscheduler_logs` VALUES("1800", "619", "عملیات ایجاد شد", "2025-11-08 15:12:00", "2025-11-08 18:42:00");
INSERT INTO `won_actionscheduler_logs` VALUES("1801", "620", "عملیات ایجاد شد", "2025-11-08 15:12:01", "2025-11-08 18:42:01");
INSERT INTO `won_actionscheduler_logs` VALUES("1802", "621", "عملیات ایجاد شد", "2025-11-08 15:12:01", "2025-11-08 18:42:01");
INSERT INTO `won_actionscheduler_logs` VALUES("1804", "623", "عملیات ایجاد شد", "2025-11-08 15:12:01", "2025-11-08 18:42:01");
INSERT INTO `won_actionscheduler_logs` VALUES("1803", "622", "عملیات ایجاد شد", "2025-11-08 15:12:01", "2025-11-08 18:42:01");
INSERT INTO `won_actionscheduler_logs` VALUES("1798", "617", "عملیات ایجاد شد", "2025-11-08 15:12:00", "2025-11-08 18:42:00");
INSERT INTO `won_actionscheduler_logs` VALUES("1797", "616", "عملیات ایجاد شد", "2025-11-08 15:12:00", "2025-11-08 18:42:00");
INSERT INTO `won_actionscheduler_logs` VALUES("1796", "615", "عملیات ایجاد شد", "2025-11-08 15:12:00", "2025-11-08 18:42:00");
INSERT INTO `won_actionscheduler_logs` VALUES("1795", "614", "عملیات ایجاد شد", "2025-11-08 15:11:25", "2025-11-08 18:41:25");
INSERT INTO `won_actionscheduler_logs` VALUES("1794", "613", "عملیات ایجاد شد", "2025-11-08 15:11:25", "2025-11-08 18:41:25");
INSERT INTO `won_actionscheduler_logs` VALUES("1793", "612", "عملیات ایجاد شد", "2025-11-08 15:11:25", "2025-11-08 18:41:25");
INSERT INTO `won_actionscheduler_logs` VALUES("1792", "611", "عملیات ایجاد شد", "2025-11-08 15:11:25", "2025-11-08 18:41:25");
INSERT INTO `won_actionscheduler_logs` VALUES("1341", "460", "action created", "2024-08-12 19:36:55", "2024-08-12 23:06:55");
INSERT INTO `won_actionscheduler_logs` VALUES("1340", "459", "action created", "2024-08-12 19:36:55", "2024-08-12 23:06:55");
INSERT INTO `won_actionscheduler_logs` VALUES("1789", "608", "عملیات ایجاد شد", "2025-11-08 15:11:25", "2025-11-08 18:41:25");
INSERT INTO `won_actionscheduler_logs` VALUES("1339", "458", "action created", "2024-08-12 19:36:55", "2024-08-12 23:06:55");
INSERT INTO `won_actionscheduler_logs` VALUES("1338", "457", "action created", "2024-08-12 19:36:55", "2024-08-12 23:06:55");
INSERT INTO `won_actionscheduler_logs` VALUES("1785", "604", "عملیات ایجاد شد", "2025-11-08 15:11:25", "2025-11-08 18:41:25");
INSERT INTO `won_actionscheduler_logs` VALUES("1786", "605", "عملیات ایجاد شد", "2025-11-08 15:11:25", "2025-11-08 18:41:25");
INSERT INTO `won_actionscheduler_logs` VALUES("1784", "603", "عملیات ایجاد شد", "2025-11-08 15:11:25", "2025-11-08 18:41:25");
INSERT INTO `won_actionscheduler_logs` VALUES("1334", "453", "action created", "2024-08-12 17:17:26", "2024-08-12 20:47:26");
INSERT INTO `won_actionscheduler_logs` VALUES("1333", "452", "action created", "2024-08-12 17:17:16", "2024-08-12 20:47:16");
INSERT INTO `won_actionscheduler_logs` VALUES("1783", "602", "عملیات ایجاد شد", "2025-11-08 15:11:25", "2025-11-08 18:41:25");
INSERT INTO `won_actionscheduler_logs` VALUES("1888", "625", "عملیات با WP Cron شروع شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1887", "624", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1886", "624", "عملیات با WP Cron شروع شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1884", "623", "عملیات با WP Cron شروع شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1849", "605", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1845", "603", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1846", "604", "عملیات با WP Cron شروع شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1847", "604", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1848", "605", "عملیات با WP Cron شروع شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1883", "622", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1881", "621", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1880", "621", "عملیات با WP Cron شروع شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1877", "619", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1878", "620", "عملیات با WP Cron شروع شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1879", "620", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1876", "619", "عملیات با WP Cron شروع شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1872", "617", "عملیات با WP Cron شروع شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1873", "617", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1874", "618", "عملیات با WP Cron شروع شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1871", "616", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1859", "610", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1860", "611", "عملیات با WP Cron شروع شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1861", "611", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1858", "610", "عملیات با WP Cron شروع شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1857", "609", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1852", "607", "عملیات با WP Cron شروع شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1853", "607", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1854", "608", "عملیات با WP Cron شروع شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1851", "606", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1850", "606", "عملیات با WP Cron شروع شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1843", "602", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:12:11", "2025-11-08 18:42:11");
INSERT INTO `won_actionscheduler_logs` VALUES("1842", "602", "عملیات با WP Cron شروع شد", "2025-11-08 15:12:11", "2025-11-08 18:42:11");
INSERT INTO `won_actionscheduler_logs` VALUES("1844", "603", "عملیات با WP Cron شروع شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1374", "493", "action created", "2024-11-12 15:30:35", "2024-11-12 19:00:35");
INSERT INTO `won_actionscheduler_logs` VALUES("1375", "494", "action created", "2024-11-12 16:35:25", "2024-11-12 20:05:25");
INSERT INTO `won_actionscheduler_logs` VALUES("1376", "495", "action created", "2024-11-12 16:35:25", "2024-11-12 20:05:25");
INSERT INTO `won_actionscheduler_logs` VALUES("1377", "496", "action created", "2024-11-12 16:35:25", "2024-11-12 20:05:25");
INSERT INTO `won_actionscheduler_logs` VALUES("1378", "497", "action created", "2024-11-12 16:35:25", "2024-11-12 20:05:25");
INSERT INTO `won_actionscheduler_logs` VALUES("1379", "498", "action created", "2024-11-12 16:49:28", "2024-11-12 20:19:28");
INSERT INTO `won_actionscheduler_logs` VALUES("1380", "499", "action created", "2024-11-12 16:49:28", "2024-11-12 20:19:28");
INSERT INTO `won_actionscheduler_logs` VALUES("1381", "500", "action created", "2024-11-12 16:49:28", "2024-11-12 20:19:28");
INSERT INTO `won_actionscheduler_logs` VALUES("1382", "501", "action created", "2024-11-12 16:49:28", "2024-11-12 20:19:28");
INSERT INTO `won_actionscheduler_logs` VALUES("1383", "502", "action created", "2024-11-12 16:49:28", "2024-11-12 20:19:28");
INSERT INTO `won_actionscheduler_logs` VALUES("1384", "503", "action created", "2024-11-12 16:49:28", "2024-11-12 20:19:28");
INSERT INTO `won_actionscheduler_logs` VALUES("1385", "504", "action created", "2024-11-12 16:49:28", "2024-11-12 20:19:28");
INSERT INTO `won_actionscheduler_logs` VALUES("1386", "505", "action created", "2024-11-12 16:49:28", "2024-11-12 20:19:28");
INSERT INTO `won_actionscheduler_logs` VALUES("1387", "506", "action created", "2024-11-12 16:49:28", "2024-11-12 20:19:28");
INSERT INTO `won_actionscheduler_logs` VALUES("1388", "507", "action created", "2024-11-12 16:49:28", "2024-11-12 20:19:28");
INSERT INTO `won_actionscheduler_logs` VALUES("1389", "508", "action created", "2024-11-12 16:49:28", "2024-11-12 20:19:28");
INSERT INTO `won_actionscheduler_logs` VALUES("1390", "509", "action created", "2024-11-12 16:58:55", "2024-11-12 20:28:55");
INSERT INTO `won_actionscheduler_logs` VALUES("1391", "510", "action created", "2024-11-12 16:58:55", "2024-11-12 20:28:55");
INSERT INTO `won_actionscheduler_logs` VALUES("1392", "511", "action created", "2024-11-12 16:58:55", "2024-11-12 20:28:55");
INSERT INTO `won_actionscheduler_logs` VALUES("1393", "512", "action created", "2024-11-12 17:02:44", "2024-11-12 20:32:44");
INSERT INTO `won_actionscheduler_logs` VALUES("1394", "513", "action created", "2024-11-12 17:02:44", "2024-11-12 20:32:44");
INSERT INTO `won_actionscheduler_logs` VALUES("1395", "514", "action created", "2024-11-13 09:46:12", "2024-11-13 13:16:12");
INSERT INTO `won_actionscheduler_logs` VALUES("1396", "515", "عملیات ایجاد شد", "2024-11-13 17:01:52", "2024-11-13 20:31:52");
INSERT INTO `won_actionscheduler_logs` VALUES("1397", "516", "عملیات ایجاد شد", "2024-11-13 17:57:25", "2024-11-13 21:27:25");
INSERT INTO `won_actionscheduler_logs` VALUES("1398", "517", "عملیات ایجاد شد", "2024-11-13 17:57:39", "2024-11-13 21:27:39");
INSERT INTO `won_actionscheduler_logs` VALUES("1399", "518", "عملیات ایجاد شد", "2024-11-13 17:58:15", "2024-11-13 21:28:15");
INSERT INTO `won_actionscheduler_logs` VALUES("1400", "519", "عملیات ایجاد شد", "2024-11-13 17:59:27", "2024-11-13 21:29:27");
INSERT INTO `won_actionscheduler_logs` VALUES("1401", "520", "عملیات ایجاد شد", "2024-11-13 17:59:51", "2024-11-13 21:29:51");
INSERT INTO `won_actionscheduler_logs` VALUES("1402", "521", "عملیات ایجاد شد", "2024-11-13 17:59:56", "2024-11-13 21:29:56");
INSERT INTO `won_actionscheduler_logs` VALUES("1403", "522", "عملیات ایجاد شد", "2024-11-13 18:00:00", "2024-11-13 21:30:00");
INSERT INTO `won_actionscheduler_logs` VALUES("1404", "523", "عملیات ایجاد شد", "2024-11-13 18:00:04", "2024-11-13 21:30:04");
INSERT INTO `won_actionscheduler_logs` VALUES("1405", "524", "عملیات ایجاد شد", "2024-11-13 18:00:13", "2024-11-13 21:30:13");
INSERT INTO `won_actionscheduler_logs` VALUES("1406", "525", "عملیات ایجاد شد", "2024-11-13 18:00:14", "2024-11-13 21:30:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1407", "526", "عملیات ایجاد شد", "2024-11-13 18:00:16", "2024-11-13 21:30:16");
INSERT INTO `won_actionscheduler_logs` VALUES("1408", "527", "عملیات ایجاد شد", "2024-11-13 18:00:29", "2024-11-13 21:30:29");
INSERT INTO `won_actionscheduler_logs` VALUES("1409", "528", "عملیات ایجاد شد", "2024-11-13 18:00:33", "2024-11-13 21:30:33");
INSERT INTO `won_actionscheduler_logs` VALUES("1410", "529", "عملیات ایجاد شد", "2024-11-13 19:14:52", "2024-11-13 22:44:52");
INSERT INTO `won_actionscheduler_logs` VALUES("1411", "530", "عملیات ایجاد شد", "2024-11-13 19:24:20", "2024-11-13 22:54:20");
INSERT INTO `won_actionscheduler_logs` VALUES("1412", "531", "عملیات ایجاد شد", "2024-11-13 19:30:20", "2024-11-13 23:00:20");
INSERT INTO `won_actionscheduler_logs` VALUES("1413", "532", "عملیات ایجاد شد", "2024-11-13 19:33:16", "2024-11-13 23:03:16");
INSERT INTO `won_actionscheduler_logs` VALUES("1414", "533", "عملیات ایجاد شد", "2024-11-13 19:33:55", "2024-11-13 23:03:55");
INSERT INTO `won_actionscheduler_logs` VALUES("1415", "534", "عملیات ایجاد شد", "2024-11-13 19:33:59", "2024-11-13 23:03:59");
INSERT INTO `won_actionscheduler_logs` VALUES("1416", "535", "عملیات ایجاد شد", "2024-11-13 19:34:54", "2024-11-13 23:04:54");
INSERT INTO `won_actionscheduler_logs` VALUES("1417", "536", "عملیات ایجاد شد", "2024-11-13 19:35:27", "2024-11-13 23:05:27");
INSERT INTO `won_actionscheduler_logs` VALUES("1418", "537", "عملیات ایجاد شد", "2024-11-13 19:36:10", "2024-11-13 23:06:10");
INSERT INTO `won_actionscheduler_logs` VALUES("1419", "538", "عملیات ایجاد شد", "2024-11-13 19:38:08", "2024-11-13 23:08:08");
INSERT INTO `won_actionscheduler_logs` VALUES("1420", "539", "عملیات ایجاد شد", "2024-11-13 19:39:24", "2024-11-13 23:09:24");
INSERT INTO `won_actionscheduler_logs` VALUES("1421", "540", "عملیات ایجاد شد", "2024-11-13 19:39:31", "2024-11-13 23:09:31");
INSERT INTO `won_actionscheduler_logs` VALUES("1422", "541", "عملیات ایجاد شد", "2024-11-13 19:39:32", "2024-11-13 23:09:32");
INSERT INTO `won_actionscheduler_logs` VALUES("1423", "542", "عملیات ایجاد شد", "2024-11-13 19:40:20", "2024-11-13 23:10:20");
INSERT INTO `won_actionscheduler_logs` VALUES("1424", "543", "عملیات ایجاد شد", "2024-11-13 19:41:28", "2024-11-13 23:11:28");
INSERT INTO `won_actionscheduler_logs` VALUES("1425", "544", "عملیات ایجاد شد", "2024-11-13 19:42:37", "2024-11-13 23:12:37");
INSERT INTO `won_actionscheduler_logs` VALUES("1426", "545", "عملیات ایجاد شد", "2024-11-13 19:42:49", "2024-11-13 23:12:49");
INSERT INTO `won_actionscheduler_logs` VALUES("1427", "546", "عملیات ایجاد شد", "2024-11-13 19:42:50", "2024-11-13 23:12:50");
INSERT INTO `won_actionscheduler_logs` VALUES("1428", "547", "عملیات ایجاد شد", "2024-11-13 19:55:56", "2024-11-13 23:25:56");
INSERT INTO `won_actionscheduler_logs` VALUES("1429", "548", "عملیات ایجاد شد", "2024-11-13 19:57:36", "2024-11-13 23:27:36");
INSERT INTO `won_actionscheduler_logs` VALUES("1430", "549", "عملیات ایجاد شد", "2024-11-13 19:57:37", "2024-11-13 23:27:37");
INSERT INTO `won_actionscheduler_logs` VALUES("1431", "550", "عملیات ایجاد شد", "2024-11-13 19:58:00", "2024-11-13 23:28:00");
INSERT INTO `won_actionscheduler_logs` VALUES("1432", "551", "عملیات ایجاد شد", "2024-11-13 20:02:36", "2024-11-13 23:32:36");
INSERT INTO `won_actionscheduler_logs` VALUES("1433", "552", "عملیات ایجاد شد", "2024-11-13 20:03:02", "2024-11-13 23:33:02");
INSERT INTO `won_actionscheduler_logs` VALUES("1434", "553", "عملیات ایجاد شد", "2024-11-13 20:03:03", "2024-11-13 23:33:03");
INSERT INTO `won_actionscheduler_logs` VALUES("1435", "554", "عملیات ایجاد شد", "2024-11-13 20:05:47", "2024-11-13 23:35:47");
INSERT INTO `won_actionscheduler_logs` VALUES("1436", "555", "عملیات ایجاد شد", "2024-11-13 20:05:47", "2024-11-13 23:35:47");
INSERT INTO `won_actionscheduler_logs` VALUES("1437", "556", "عملیات ایجاد شد", "2024-11-13 20:18:47", "2024-11-13 23:48:47");
INSERT INTO `won_actionscheduler_logs` VALUES("1438", "557", "عملیات ایجاد شد", "2024-11-13 20:22:58", "2024-11-13 23:52:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1439", "558", "عملیات ایجاد شد", "2024-11-13 20:22:58", "2024-11-13 23:52:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1440", "559", "عملیات ایجاد شد", "2024-11-13 20:24:28", "2024-11-13 23:54:28");
INSERT INTO `won_actionscheduler_logs` VALUES("1441", "560", "عملیات ایجاد شد", "2024-11-13 20:25:16", "2024-11-13 23:55:16");
INSERT INTO `won_actionscheduler_logs` VALUES("1442", "561", "عملیات ایجاد شد", "2024-11-13 20:25:27", "2024-11-13 23:55:27");
INSERT INTO `won_actionscheduler_logs` VALUES("1443", "562", "عملیات ایجاد شد", "2024-11-13 20:25:52", "2024-11-13 23:55:52");
INSERT INTO `won_actionscheduler_logs` VALUES("1444", "563", "عملیات ایجاد شد", "2024-11-13 20:25:52", "2024-11-13 23:55:52");
INSERT INTO `won_actionscheduler_logs` VALUES("1445", "564", "عملیات ایجاد شد", "2024-11-13 20:25:53", "2024-11-13 23:55:53");
INSERT INTO `won_actionscheduler_logs` VALUES("1446", "565", "عملیات ایجاد شد", "2024-11-16 15:52:31", "2024-11-16 19:22:31");
INSERT INTO `won_actionscheduler_logs` VALUES("1447", "566", "عملیات ایجاد شد", "2024-11-16 15:52:48", "2024-11-16 19:22:48");
INSERT INTO `won_actionscheduler_logs` VALUES("1448", "567", "عملیات ایجاد شد", "2024-11-16 15:52:48", "2024-11-16 19:22:48");
INSERT INTO `won_actionscheduler_logs` VALUES("1449", "568", "عملیات ایجاد شد", "2024-11-16 15:53:04", "2024-11-16 19:23:04");
INSERT INTO `won_actionscheduler_logs` VALUES("1450", "569", "عملیات ایجاد شد", "2024-11-16 15:53:10", "2024-11-16 19:23:10");
INSERT INTO `won_actionscheduler_logs` VALUES("1451", "570", "عملیات ایجاد شد", "2024-11-16 16:16:06", "2024-11-16 19:46:06");
INSERT INTO `won_actionscheduler_logs` VALUES("1452", "571", "عملیات ایجاد شد", "2024-11-16 16:16:15", "2024-11-16 19:46:15");
INSERT INTO `won_actionscheduler_logs` VALUES("1453", "572", "عملیات ایجاد شد", "2024-11-16 16:16:15", "2024-11-16 19:46:15");
INSERT INTO `won_actionscheduler_logs` VALUES("1454", "573", "عملیات ایجاد شد", "2024-11-16 16:16:21", "2024-11-16 19:46:21");
INSERT INTO `won_actionscheduler_logs` VALUES("1455", "574", "عملیات ایجاد شد", "2024-11-16 16:16:48", "2024-11-16 19:46:48");
INSERT INTO `won_actionscheduler_logs` VALUES("1456", "575", "عملیات ایجاد شد", "2024-11-16 16:16:53", "2024-11-16 19:46:53");
INSERT INTO `won_actionscheduler_logs` VALUES("1457", "576", "عملیات ایجاد شد", "2024-11-16 16:16:54", "2024-11-16 19:46:54");
INSERT INTO `won_actionscheduler_logs` VALUES("1458", "577", "عملیات ایجاد شد", "2024-11-16 16:19:11", "2024-11-16 19:49:11");
INSERT INTO `won_actionscheduler_logs` VALUES("1459", "578", "عملیات ایجاد شد", "2024-11-16 16:19:23", "2024-11-16 19:49:23");
INSERT INTO `won_actionscheduler_logs` VALUES("1460", "579", "عملیات ایجاد شد", "2024-11-16 17:07:57", "2024-11-16 20:37:57");
INSERT INTO `won_actionscheduler_logs` VALUES("1461", "580", "عملیات ایجاد شد", "2024-11-16 17:45:16", "2024-11-16 21:15:16");
INSERT INTO `won_actionscheduler_logs` VALUES("1462", "581", "عملیات ایجاد شد", "2024-11-16 17:58:47", "2024-11-16 21:28:47");
INSERT INTO `won_actionscheduler_logs` VALUES("1463", "582", "عملیات ایجاد شد", "2024-11-16 18:03:18", "2024-11-16 21:33:18");
INSERT INTO `won_actionscheduler_logs` VALUES("1464", "583", "عملیات ایجاد شد", "2024-11-16 21:09:31", "2024-11-17 00:39:31");
INSERT INTO `won_actionscheduler_logs` VALUES("1465", "584", "عملیات ایجاد شد", "2024-11-16 21:09:52", "2024-11-17 00:39:52");
INSERT INTO `won_actionscheduler_logs` VALUES("1466", "585", "عملیات ایجاد شد", "2024-11-16 21:09:52", "2024-11-17 00:39:52");
INSERT INTO `won_actionscheduler_logs` VALUES("1467", "586", "عملیات ایجاد شد", "2024-11-16 21:09:58", "2024-11-17 00:39:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1468", "587", "عملیات ایجاد شد", "2024-11-16 21:10:04", "2024-11-17 00:40:04");
INSERT INTO `won_actionscheduler_logs` VALUES("1469", "588", "عملیات ایجاد شد", "2024-11-16 21:10:09", "2024-11-17 00:40:09");
INSERT INTO `won_actionscheduler_logs` VALUES("1470", "589", "عملیات ایجاد شد", "2024-11-16 21:15:36", "2024-11-17 00:45:36");
INSERT INTO `won_actionscheduler_logs` VALUES("1471", "590", "عملیات ایجاد شد", "2024-11-16 21:18:27", "2024-11-17 00:48:27");
INSERT INTO `won_actionscheduler_logs` VALUES("1472", "591", "عملیات ایجاد شد", "2024-11-16 21:18:27", "2024-11-17 00:48:27");
INSERT INTO `won_actionscheduler_logs` VALUES("1473", "592", "عملیات ایجاد شد", "2024-11-16 21:40:47", "2024-11-17 01:10:47");
INSERT INTO `won_actionscheduler_logs` VALUES("1474", "593", "عملیات ایجاد شد", "2024-11-16 21:40:52", "2024-11-17 01:10:52");
INSERT INTO `won_actionscheduler_logs` VALUES("1475", "594", "عملیات ایجاد شد", "2024-11-16 21:43:46", "2024-11-17 01:13:46");
INSERT INTO `won_actionscheduler_logs` VALUES("1476", "595", "عملیات ایجاد شد", "2024-11-16 21:43:46", "2024-11-17 01:13:46");
INSERT INTO `won_actionscheduler_logs` VALUES("1526", "472", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1527", "473", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1528", "473", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1529", "474", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1530", "474", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1531", "475", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1532", "475", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1533", "476", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1534", "476", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1535", "477", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1536", "477", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1537", "478", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1538", "478", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1539", "479", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1540", "479", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1541", "480", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1542", "480", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1543", "481", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1544", "481", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1545", "482", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1546", "482", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1547", "483", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1548", "483", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1549", "484", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1550", "484", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1551", "485", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1552", "485", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1553", "486", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1554", "486", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1555", "449", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1556", "596", "عملیات ایجاد شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1557", "449", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1782", "601", "عملیات با Async Request تکمیل شد", "2025-11-08 15:11:02", "2025-11-08 18:41:02");
INSERT INTO `won_actionscheduler_logs` VALUES("1559", "487", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1560", "487", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1561", "488", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1562", "488", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1563", "489", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1564", "489", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1565", "490", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1566", "490", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1567", "491", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1568", "491", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1569", "492", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1570", "492", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1571", "450", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1572", "450", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1573", "598", "عملیات ایجاد شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1574", "494", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1575", "494", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1576", "495", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1577", "495", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1578", "496", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1579", "496", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1580", "497", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1581", "497", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1582", "498", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1583", "498", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1584", "499", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1585", "499", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1586", "500", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1587", "500", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1588", "501", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1589", "501", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1590", "502", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1591", "502", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1592", "503", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1593", "503", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1594", "504", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1595", "504", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1596", "505", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1597", "505", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1598", "506", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1599", "506", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1600", "507", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1601", "507", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1602", "508", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1603", "508", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1604", "511", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1605", "511", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1606", "512", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1607", "512", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1608", "599", "عملیات ایجاد شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1609", "513", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1610", "513", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1611", "600", "عملیات ایجاد شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1612", "514", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1613", "514", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1614", "515", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1615", "515", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1616", "516", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1617", "516", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1618", "517", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1619", "517", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1620", "518", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1621", "518", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1622", "519", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1623", "519", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1624", "520", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1625", "520", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1626", "521", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1627", "521", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1628", "522", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1629", "522", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1630", "523", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1631", "523", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1632", "524", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1633", "524", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1634", "525", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1635", "525", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1636", "526", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1637", "526", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1638", "527", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1639", "527", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1640", "528", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1641", "528", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1642", "529", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1643", "529", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1644", "530", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1645", "530", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1646", "531", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1647", "531", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1648", "532", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1649", "532", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1650", "533", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1651", "533", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1652", "534", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1653", "534", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1654", "535", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1655", "535", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1656", "536", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1657", "536", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1658", "537", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1659", "537", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1660", "538", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1661", "538", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1662", "539", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1663", "539", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1664", "540", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1665", "540", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1666", "541", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1667", "541", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1668", "542", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1669", "542", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1670", "543", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1671", "543", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1672", "544", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1673", "544", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1674", "545", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1675", "545", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1676", "546", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1677", "546", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1678", "547", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1679", "547", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1680", "548", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1681", "548", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1682", "549", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1683", "549", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1684", "550", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1685", "550", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1686", "551", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1687", "551", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1688", "552", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1689", "552", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1690", "553", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1691", "553", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1692", "554", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1693", "554", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1694", "555", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1695", "555", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1696", "556", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1697", "556", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1698", "557", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1699", "557", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1700", "558", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1701", "558", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1702", "559", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1703", "559", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1704", "560", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1705", "560", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1706", "561", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1707", "561", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1708", "562", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1709", "562", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1710", "563", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1711", "563", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1712", "564", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1713", "564", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1714", "565", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1715", "565", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1716", "566", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1717", "566", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1718", "567", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1719", "567", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1720", "568", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1721", "568", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1722", "569", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1723", "569", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1724", "570", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1725", "570", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1726", "571", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1727", "571", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1728", "572", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1729", "572", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1730", "573", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1731", "573", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1732", "574", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1733", "574", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1734", "575", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1735", "575", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1736", "576", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1737", "576", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1738", "577", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1739", "577", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1740", "578", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1741", "578", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1742", "579", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1743", "579", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1744", "580", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1745", "580", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1746", "581", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1747", "581", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1748", "582", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1749", "582", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1750", "583", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1751", "583", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1752", "584", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1753", "584", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1754", "585", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1755", "585", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1756", "586", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1757", "586", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1758", "587", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1759", "587", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1760", "588", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1761", "588", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1762", "589", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1763", "589", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1764", "590", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1765", "590", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1766", "591", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1767", "591", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1768", "592", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1769", "592", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1770", "593", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1771", "593", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1772", "594", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1773", "594", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1774", "595", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1775", "595", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1776", "596", "عملیات با WP Cron شروع شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1781", "601", "عملیات با Async Request شروع شد", "2025-11-08 15:11:02", "2025-11-08 18:41:02");
INSERT INTO `won_actionscheduler_logs` VALUES("1779", "596", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1780", "601", "عملیات ایجاد شد", "2025-11-08 15:10:58", "2025-11-08 18:40:58");
INSERT INTO `won_actionscheduler_logs` VALUES("1833", "652", "عملیات ایجاد شد", "2025-11-08 15:12:01", "2025-11-08 18:42:01");
INSERT INTO `won_actionscheduler_logs` VALUES("1834", "653", "عملیات ایجاد شد", "2025-11-08 15:12:01", "2025-11-08 18:42:01");
INSERT INTO `won_actionscheduler_logs` VALUES("1835", "654", "عملیات ایجاد شد", "2025-11-08 15:12:01", "2025-11-08 18:42:01");
INSERT INTO `won_actionscheduler_logs` VALUES("1836", "655", "عملیات ایجاد شد", "2025-11-08 15:12:01", "2025-11-08 18:42:01");
INSERT INTO `won_actionscheduler_logs` VALUES("1837", "656", "عملیات ایجاد شد", "2025-11-08 15:12:01", "2025-11-08 18:42:01");
INSERT INTO `won_actionscheduler_logs` VALUES("1838", "657", "عملیات ایجاد شد", "2025-11-08 15:12:01", "2025-11-08 18:42:01");
INSERT INTO `won_actionscheduler_logs` VALUES("1839", "658", "عملیات ایجاد شد", "2025-11-08 15:12:01", "2025-11-08 18:42:01");
INSERT INTO `won_actionscheduler_logs` VALUES("1840", "659", "عملیات ایجاد شد", "2025-11-08 15:12:01", "2025-11-08 18:42:01");
INSERT INTO `won_actionscheduler_logs` VALUES("1841", "660", "عملیات ایجاد شد", "2025-11-08 15:12:01", "2025-11-08 18:42:01");
INSERT INTO `won_actionscheduler_logs` VALUES("1891", "626", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1892", "627", "عملیات با WP Cron شروع شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1893", "627", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1894", "628", "عملیات با WP Cron شروع شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1895", "628", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1896", "629", "عملیات با WP Cron شروع شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1897", "629", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1898", "630", "عملیات با WP Cron شروع شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1899", "630", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1900", "631", "عملیات با WP Cron شروع شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1901", "631", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1902", "632", "عملیات با WP Cron شروع شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1903", "632", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1904", "633", "عملیات با WP Cron شروع شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1905", "633", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1906", "634", "عملیات با WP Cron شروع شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1907", "634", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1908", "635", "عملیات با WP Cron شروع شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1909", "635", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1910", "636", "عملیات با WP Cron شروع شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1911", "636", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1912", "637", "عملیات با WP Cron شروع شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1913", "637", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1914", "638", "عملیات با WP Cron شروع شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1915", "638", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1916", "639", "عملیات با WP Cron شروع شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1917", "639", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1918", "640", "عملیات با WP Cron شروع شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1919", "640", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1920", "641", "عملیات با WP Cron شروع شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1921", "641", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:12:14", "2025-11-08 18:42:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1922", "642", "عملیات با WP Cron شروع شد", "2025-11-08 15:12:15", "2025-11-08 18:42:15");
INSERT INTO `won_actionscheduler_logs` VALUES("1923", "642", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:12:15", "2025-11-08 18:42:15");
INSERT INTO `won_actionscheduler_logs` VALUES("1924", "643", "عملیات با WP Cron شروع شد", "2025-11-08 15:12:15", "2025-11-08 18:42:15");
INSERT INTO `won_actionscheduler_logs` VALUES("1925", "643", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:12:15", "2025-11-08 18:42:15");
INSERT INTO `won_actionscheduler_logs` VALUES("1926", "644", "عملیات با WP Cron شروع شد", "2025-11-08 15:12:15", "2025-11-08 18:42:15");
INSERT INTO `won_actionscheduler_logs` VALUES("1927", "644", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:12:15", "2025-11-08 18:42:15");
INSERT INTO `won_actionscheduler_logs` VALUES("1928", "645", "عملیات با WP Cron شروع شد", "2025-11-08 15:12:15", "2025-11-08 18:42:15");
INSERT INTO `won_actionscheduler_logs` VALUES("1929", "645", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:12:15", "2025-11-08 18:42:15");
INSERT INTO `won_actionscheduler_logs` VALUES("1930", "646", "عملیات با WP Cron شروع شد", "2025-11-08 15:12:15", "2025-11-08 18:42:15");
INSERT INTO `won_actionscheduler_logs` VALUES("1931", "646", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:12:15", "2025-11-08 18:42:15");
INSERT INTO `won_actionscheduler_logs` VALUES("1932", "647", "عملیات با WP Cron شروع شد", "2025-11-08 15:12:15", "2025-11-08 18:42:15");
INSERT INTO `won_actionscheduler_logs` VALUES("1933", "647", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:12:15", "2025-11-08 18:42:15");
INSERT INTO `won_actionscheduler_logs` VALUES("1934", "648", "عملیات با WP Cron شروع شد", "2025-11-08 15:12:15", "2025-11-08 18:42:15");
INSERT INTO `won_actionscheduler_logs` VALUES("1935", "648", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:12:15", "2025-11-08 18:42:15");
INSERT INTO `won_actionscheduler_logs` VALUES("1936", "649", "عملیات با WP Cron شروع شد", "2025-11-08 15:12:15", "2025-11-08 18:42:15");
INSERT INTO `won_actionscheduler_logs` VALUES("1937", "649", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:12:15", "2025-11-08 18:42:15");
INSERT INTO `won_actionscheduler_logs` VALUES("1938", "650", "عملیات با WP Cron شروع شد", "2025-11-08 15:12:15", "2025-11-08 18:42:15");
INSERT INTO `won_actionscheduler_logs` VALUES("1939", "650", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:12:15", "2025-11-08 18:42:15");
INSERT INTO `won_actionscheduler_logs` VALUES("1940", "651", "عملیات با WP Cron شروع شد", "2025-11-08 15:12:15", "2025-11-08 18:42:15");
INSERT INTO `won_actionscheduler_logs` VALUES("1941", "651", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:12:15", "2025-11-08 18:42:15");
INSERT INTO `won_actionscheduler_logs` VALUES("1942", "652", "عملیات با WP Cron شروع شد", "2025-11-08 15:12:15", "2025-11-08 18:42:15");
INSERT INTO `won_actionscheduler_logs` VALUES("1943", "652", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:12:15", "2025-11-08 18:42:15");
INSERT INTO `won_actionscheduler_logs` VALUES("1944", "653", "عملیات با WP Cron شروع شد", "2025-11-08 15:12:15", "2025-11-08 18:42:15");
INSERT INTO `won_actionscheduler_logs` VALUES("1945", "653", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:12:15", "2025-11-08 18:42:15");
INSERT INTO `won_actionscheduler_logs` VALUES("1946", "654", "عملیات با WP Cron شروع شد", "2025-11-08 15:12:15", "2025-11-08 18:42:15");
INSERT INTO `won_actionscheduler_logs` VALUES("1947", "654", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:12:15", "2025-11-08 18:42:15");
INSERT INTO `won_actionscheduler_logs` VALUES("1948", "655", "عملیات با WP Cron شروع شد", "2025-11-08 15:12:15", "2025-11-08 18:42:15");
INSERT INTO `won_actionscheduler_logs` VALUES("1949", "655", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:12:15", "2025-11-08 18:42:15");
INSERT INTO `won_actionscheduler_logs` VALUES("1950", "656", "عملیات با WP Cron شروع شد", "2025-11-08 15:12:15", "2025-11-08 18:42:15");
INSERT INTO `won_actionscheduler_logs` VALUES("1951", "656", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:12:15", "2025-11-08 18:42:15");
INSERT INTO `won_actionscheduler_logs` VALUES("1952", "657", "عملیات با WP Cron شروع شد", "2025-11-08 15:12:15", "2025-11-08 18:42:15");
INSERT INTO `won_actionscheduler_logs` VALUES("1953", "657", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:12:15", "2025-11-08 18:42:15");
INSERT INTO `won_actionscheduler_logs` VALUES("1954", "658", "عملیات با WP Cron شروع شد", "2025-11-08 15:12:15", "2025-11-08 18:42:15");
INSERT INTO `won_actionscheduler_logs` VALUES("1955", "658", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:12:15", "2025-11-08 18:42:15");
INSERT INTO `won_actionscheduler_logs` VALUES("1956", "659", "عملیات با WP Cron شروع شد", "2025-11-08 15:12:15", "2025-11-08 18:42:15");
INSERT INTO `won_actionscheduler_logs` VALUES("1957", "659", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:12:15", "2025-11-08 18:42:15");
INSERT INTO `won_actionscheduler_logs` VALUES("1958", "660", "عملیات با WP Cron شروع شد", "2025-11-08 15:12:15", "2025-11-08 18:42:15");
INSERT INTO `won_actionscheduler_logs` VALUES("1959", "660", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:12:15", "2025-11-08 18:42:15");
INSERT INTO `won_actionscheduler_logs` VALUES("1960", "661", "عملیات ایجاد شد", "2025-11-08 15:13:29", "2025-11-08 18:43:29");
INSERT INTO `won_actionscheduler_logs` VALUES("1961", "661", "عملیات با Async Request شروع شد", "2025-11-08 15:13:30", "2025-11-08 18:43:30");
INSERT INTO `won_actionscheduler_logs` VALUES("1962", "662", "عملیات ایجاد شد", "2025-11-08 15:13:30", "2025-11-08 18:43:30");
INSERT INTO `won_actionscheduler_logs` VALUES("1963", "663", "عملیات ایجاد شد", "2025-11-08 15:13:30", "2025-11-08 18:43:30");
INSERT INTO `won_actionscheduler_logs` VALUES("1964", "664", "عملیات ایجاد شد", "2025-11-08 15:13:30", "2025-11-08 18:43:30");
INSERT INTO `won_actionscheduler_logs` VALUES("1965", "665", "عملیات ایجاد شد", "2025-11-08 15:13:30", "2025-11-08 18:43:30");
INSERT INTO `won_actionscheduler_logs` VALUES("1966", "666", "عملیات ایجاد شد", "2025-11-08 15:13:30", "2025-11-08 18:43:30");
INSERT INTO `won_actionscheduler_logs` VALUES("1967", "667", "عملیات ایجاد شد", "2025-11-08 15:13:30", "2025-11-08 18:43:30");
INSERT INTO `won_actionscheduler_logs` VALUES("1968", "668", "عملیات ایجاد شد", "2025-11-08 15:13:30", "2025-11-08 18:43:30");
INSERT INTO `won_actionscheduler_logs` VALUES("1969", "669", "عملیات ایجاد شد", "2025-11-08 15:13:30", "2025-11-08 18:43:30");
INSERT INTO `won_actionscheduler_logs` VALUES("1970", "670", "عملیات ایجاد شد", "2025-11-08 15:13:30", "2025-11-08 18:43:30");
INSERT INTO `won_actionscheduler_logs` VALUES("1971", "671", "عملیات ایجاد شد", "2025-11-08 15:13:30", "2025-11-08 18:43:30");
INSERT INTO `won_actionscheduler_logs` VALUES("1972", "661", "عملیات با Async Request تکمیل شد", "2025-11-08 15:13:30", "2025-11-08 18:43:30");
INSERT INTO `won_actionscheduler_logs` VALUES("1973", "672", "عملیات ایجاد شد", "2025-11-08 15:13:30", "2025-11-08 18:43:30");
INSERT INTO `won_actionscheduler_logs` VALUES("1974", "669", "عملیات با Async Request شروع شد", "2025-11-08 15:13:30", "2025-11-08 18:43:30");
INSERT INTO `won_actionscheduler_logs` VALUES("1975", "669", "عملیات با Async Request تکمیل شد", "2025-11-08 15:13:30", "2025-11-08 18:43:30");
INSERT INTO `won_actionscheduler_logs` VALUES("1976", "673", "عملیات ایجاد شد", "2025-11-08 15:13:30", "2025-11-08 18:43:30");
INSERT INTO `won_actionscheduler_logs` VALUES("1977", "664", "عملیات با WP Cron شروع شد", "2025-11-08 15:14:14", "2025-11-08 18:44:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1978", "664", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:14:15", "2025-11-08 18:44:15");
INSERT INTO `won_actionscheduler_logs` VALUES("1979", "674", "عملیات ایجاد شد", "2025-11-08 15:14:15", "2025-11-08 18:44:15");
INSERT INTO `won_actionscheduler_logs` VALUES("1980", "670", "عملیات با WP Cron شروع شد", "2025-11-08 15:14:15", "2025-11-08 18:44:15");
INSERT INTO `won_actionscheduler_logs` VALUES("1981", "670", "عملیات با WP Cron تکمیل شد", "2025-11-08 15:14:15", "2025-11-08 18:44:15");
INSERT INTO `won_actionscheduler_logs` VALUES("1982", "663", "عملیات با Async Request شروع شد", "2025-11-08 16:13:54", "2025-11-08 19:43:54");
INSERT INTO `won_actionscheduler_logs` VALUES("1983", "675", "عملیات ایجاد شد", "2025-11-08 16:13:54", "2025-11-08 19:43:54");
INSERT INTO `won_actionscheduler_logs` VALUES("1984", "663", "عملیات با Async Request تکمیل شد", "2025-11-08 16:13:54", "2025-11-08 19:43:54");
INSERT INTO `won_actionscheduler_logs` VALUES("1985", "675", "عملیات با WP Cron شروع شد", "2025-11-08 17:13:59", "2025-11-08 20:43:59");
INSERT INTO `won_actionscheduler_logs` VALUES("1986", "676", "عملیات ایجاد شد", "2025-11-08 17:13:59", "2025-11-08 20:43:59");
INSERT INTO `won_actionscheduler_logs` VALUES("1987", "675", "عملیات با WP Cron تکمیل شد", "2025-11-08 17:13:59", "2025-11-08 20:43:59");
INSERT INTO `won_actionscheduler_logs` VALUES("1988", "677", "عملیات ایجاد شد", "2025-11-08 17:29:33", "2025-11-08 20:59:33");
INSERT INTO `won_actionscheduler_logs` VALUES("1989", "677", "عملیات با Async Request شروع شد", "2025-11-08 17:29:38", "2025-11-08 20:59:38");
INSERT INTO `won_actionscheduler_logs` VALUES("1990", "677", "عملیات با Async Request تکمیل شد", "2025-11-08 17:29:38", "2025-11-08 20:59:38");
INSERT INTO `won_actionscheduler_logs` VALUES("1991", "676", "عملیات با WP Cron شروع شد", "2025-11-08 18:14:14", "2025-11-08 21:44:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1992", "678", "عملیات ایجاد شد", "2025-11-08 18:14:14", "2025-11-08 21:44:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1993", "676", "عملیات با WP Cron تکمیل شد", "2025-11-08 18:14:14", "2025-11-08 21:44:14");
INSERT INTO `won_actionscheduler_logs` VALUES("1994", "678", "عملیات با WP Cron شروع شد", "2025-11-08 19:14:15", "2025-11-08 22:44:15");
INSERT INTO `won_actionscheduler_logs` VALUES("1995", "679", "عملیات ایجاد شد", "2025-11-08 19:14:15", "2025-11-08 22:44:15");
INSERT INTO `won_actionscheduler_logs` VALUES("1996", "678", "عملیات با WP Cron تکمیل شد", "2025-11-08 19:14:15", "2025-11-08 22:44:15");
INSERT INTO `won_actionscheduler_logs` VALUES("1997", "679", "عملیات با WP Cron شروع شد", "2025-11-08 20:14:21", "2025-11-08 23:44:21");
INSERT INTO `won_actionscheduler_logs` VALUES("1998", "680", "عملیات ایجاد شد", "2025-11-08 20:14:21", "2025-11-08 23:44:21");
INSERT INTO `won_actionscheduler_logs` VALUES("1999", "679", "عملیات با WP Cron تکمیل شد", "2025-11-08 20:14:21", "2025-11-08 23:44:21");
INSERT INTO `won_actionscheduler_logs` VALUES("2000", "662", "عملیات با WP Cron شروع شد", "2025-11-08 21:11:21", "2025-11-09 00:41:21");
INSERT INTO `won_actionscheduler_logs` VALUES("2001", "662", "عملیات با WP Cron تکمیل شد", "2025-11-08 21:11:21", "2025-11-09 00:41:21");
INSERT INTO `won_actionscheduler_logs` VALUES("2002", "681", "عملیات ایجاد شد", "2025-11-08 21:11:21", "2025-11-09 00:41:21");
INSERT INTO `won_actionscheduler_logs` VALUES("2003", "680", "عملیات با WP Cron شروع شد", "2025-11-09 01:08:22", "2025-11-09 04:38:22");
INSERT INTO `won_actionscheduler_logs` VALUES("2004", "682", "عملیات ایجاد شد", "2025-11-09 01:08:22", "2025-11-09 04:38:22");
INSERT INTO `won_actionscheduler_logs` VALUES("2005", "680", "عملیات با WP Cron تکمیل شد", "2025-11-09 01:08:22", "2025-11-09 04:38:22");
INSERT INTO `won_actionscheduler_logs` VALUES("2006", "665", "عملیات با WP Cron شروع شد", "2025-11-09 01:08:22", "2025-11-09 04:38:22");
INSERT INTO `won_actionscheduler_logs` VALUES("2007", "665", "عملیات با WP Cron تکمیل شد", "2025-11-09 01:08:22", "2025-11-09 04:38:22");
INSERT INTO `won_actionscheduler_logs` VALUES("2008", "683", "عملیات ایجاد شد", "2025-11-09 01:08:22", "2025-11-09 04:38:22");
INSERT INTO `won_actionscheduler_logs` VALUES("2009", "668", "عملیات با WP Cron شروع شد", "2025-11-09 01:08:22", "2025-11-09 04:38:22");
INSERT INTO `won_actionscheduler_logs` VALUES("2010", "668", "عملیات با WP Cron تکمیل شد", "2025-11-09 01:08:22", "2025-11-09 04:38:22");
INSERT INTO `won_actionscheduler_logs` VALUES("2011", "684", "عملیات ایجاد شد", "2025-11-09 01:08:22", "2025-11-09 04:38:22");
INSERT INTO `won_actionscheduler_logs` VALUES("2012", "682", "عملیات با WP Cron شروع شد", "2025-11-09 02:09:43", "2025-11-09 05:39:43");
INSERT INTO `won_actionscheduler_logs` VALUES("2013", "685", "عملیات ایجاد شد", "2025-11-09 02:09:43", "2025-11-09 05:39:43");
INSERT INTO `won_actionscheduler_logs` VALUES("2014", "682", "عملیات با WP Cron تکمیل شد", "2025-11-09 02:09:43", "2025-11-09 05:39:43");
INSERT INTO `won_actionscheduler_logs` VALUES("2015", "666", "عملیات با WP Cron شروع شد", "2025-11-09 04:34:12", "2025-11-09 08:04:12");
INSERT INTO `won_actionscheduler_logs` VALUES("2016", "666", "عملیات با WP Cron تکمیل شد", "2025-11-09 04:34:12", "2025-11-09 08:04:12");
INSERT INTO `won_actionscheduler_logs` VALUES("2017", "686", "عملیات ایجاد شد", "2025-11-09 04:34:12", "2025-11-09 08:04:12");
INSERT INTO `won_actionscheduler_logs` VALUES("2018", "667", "عملیات با WP Cron شروع شد", "2025-11-09 04:34:12", "2025-11-09 08:04:12");
INSERT INTO `won_actionscheduler_logs` VALUES("2019", "667", "عملیات با WP Cron تکمیل شد", "2025-11-09 04:34:12", "2025-11-09 08:04:12");
INSERT INTO `won_actionscheduler_logs` VALUES("2020", "687", "عملیات ایجاد شد", "2025-11-09 04:34:12", "2025-11-09 08:04:12");
INSERT INTO `won_actionscheduler_logs` VALUES("2021", "685", "عملیات با WP Cron شروع شد", "2025-11-09 04:34:12", "2025-11-09 08:04:12");
INSERT INTO `won_actionscheduler_logs` VALUES("2022", "688", "عملیات ایجاد شد", "2025-11-09 04:34:12", "2025-11-09 08:04:12");
INSERT INTO `won_actionscheduler_logs` VALUES("2023", "685", "عملیات با WP Cron تکمیل شد", "2025-11-09 04:34:12", "2025-11-09 08:04:12");
INSERT INTO `won_actionscheduler_logs` VALUES("2024", "671", "عملیات با WP Cron شروع شد", "2025-11-09 04:34:12", "2025-11-09 08:04:12");
INSERT INTO `won_actionscheduler_logs` VALUES("2025", "671", "عملیات با WP Cron تکمیل شد", "2025-11-09 04:34:12", "2025-11-09 08:04:12");
INSERT INTO `won_actionscheduler_logs` VALUES("2026", "689", "عملیات ایجاد شد", "2025-11-09 04:34:12", "2025-11-09 08:04:12");
INSERT INTO `won_actionscheduler_logs` VALUES("2027", "688", "عملیات با WP Cron شروع شد", "2025-11-09 07:40:35", "2025-11-09 11:10:35");
INSERT INTO `won_actionscheduler_logs` VALUES("2028", "690", "عملیات ایجاد شد", "2025-11-09 07:40:35", "2025-11-09 11:10:35");
INSERT INTO `won_actionscheduler_logs` VALUES("2029", "688", "عملیات با WP Cron تکمیل شد", "2025-11-09 07:40:35", "2025-11-09 11:10:35");
INSERT INTO `won_actionscheduler_logs` VALUES("2030", "691", "عملیات ایجاد شد", "2025-11-09 07:40:35", "2025-11-09 11:10:35");
INSERT INTO `won_actionscheduler_logs` VALUES("2031", "691", "عملیات با WP Cron شروع شد", "2025-11-09 08:06:35", "2025-11-09 11:36:35");
INSERT INTO `won_actionscheduler_logs` VALUES("2032", "691", "عملیات با WP Cron تکمیل شد", "2025-11-09 08:06:35", "2025-11-09 11:36:35");
INSERT INTO `won_actionscheduler_logs` VALUES("2033", "690", "عملیات با WP Cron شروع شد", "2025-11-09 09:19:28", "2025-11-09 12:49:28");
INSERT INTO `won_actionscheduler_logs` VALUES("2034", "692", "عملیات ایجاد شد", "2025-11-09 09:19:28", "2025-11-09 12:49:28");
INSERT INTO `won_actionscheduler_logs` VALUES("2035", "690", "عملیات با WP Cron تکمیل شد", "2025-11-09 09:19:28", "2025-11-09 12:49:28");
INSERT INTO `won_actionscheduler_logs` VALUES("2036", "692", "عملیات با WP Cron شروع شد", "2025-11-09 10:28:42", "2025-11-09 13:58:42");
INSERT INTO `won_actionscheduler_logs` VALUES("2037", "693", "عملیات ایجاد شد", "2025-11-09 10:28:42", "2025-11-09 13:58:42");
INSERT INTO `won_actionscheduler_logs` VALUES("2038", "692", "عملیات با WP Cron تکمیل شد", "2025-11-09 10:28:42", "2025-11-09 13:58:42");
INSERT INTO `won_actionscheduler_logs` VALUES("2039", "694", "عملیات ایجاد شد", "2025-11-09 10:55:06", "2025-11-09 14:25:06");
INSERT INTO `won_actionscheduler_logs` VALUES("2040", "694", "عملیات با WP Cron شروع شد", "2025-11-09 10:56:29", "2025-11-09 14:26:29");
INSERT INTO `won_actionscheduler_logs` VALUES("2041", "694", "عملیات با WP Cron تکمیل شد", "2025-11-09 10:56:29", "2025-11-09 14:26:29");
INSERT INTO `won_actionscheduler_logs` VALUES("2042", "695", "عملیات ایجاد شد", "2025-11-10 15:24:03", "2025-11-10 18:54:03");
INSERT INTO `won_actionscheduler_logs` VALUES("2043", "696", "عملیات ایجاد شد", "2025-11-10 15:24:03", "2025-11-10 18:54:03");
INSERT INTO `won_actionscheduler_logs` VALUES("2044", "697", "عملیات ایجاد شد", "2025-11-10 15:24:03", "2025-11-10 18:54:03");
INSERT INTO `won_actionscheduler_logs` VALUES("2045", "698", "عملیات ایجاد شد", "2025-11-10 15:24:03", "2025-11-10 18:54:03");
INSERT INTO `won_actionscheduler_logs` VALUES("2046", "699", "عملیات ایجاد شد", "2025-11-10 15:24:03", "2025-11-10 18:54:03");
INSERT INTO `won_actionscheduler_logs` VALUES("2047", "700", "عملیات ایجاد شد", "2025-11-10 15:24:03", "2025-11-10 18:54:03");
INSERT INTO `won_actionscheduler_logs` VALUES("2048", "701", "عملیات ایجاد شد", "2025-11-10 15:24:03", "2025-11-10 18:54:03");
INSERT INTO `won_actionscheduler_logs` VALUES("2049", "702", "عملیات ایجاد شد", "2025-11-10 15:24:03", "2025-11-10 18:54:03");
INSERT INTO `won_actionscheduler_logs` VALUES("2050", "703", "عملیات ایجاد شد", "2025-11-10 15:24:03", "2025-11-10 18:54:03");
INSERT INTO `won_actionscheduler_logs` VALUES("2051", "704", "عملیات ایجاد شد", "2025-11-10 15:24:03", "2025-11-10 18:54:03");
INSERT INTO `won_actionscheduler_logs` VALUES("2052", "705", "عملیات ایجاد شد", "2025-11-10 15:24:03", "2025-11-10 18:54:03");
INSERT INTO `won_actionscheduler_logs` VALUES("2053", "706", "عملیات ایجاد شد", "2025-11-10 15:24:03", "2025-11-10 18:54:03");
INSERT INTO `won_actionscheduler_logs` VALUES("2054", "707", "عملیات ایجاد شد", "2025-11-10 15:24:03", "2025-11-10 18:54:03");
INSERT INTO `won_actionscheduler_logs` VALUES("2055", "708", "عملیات ایجاد شد", "2025-11-10 15:24:03", "2025-11-10 18:54:03");
INSERT INTO `won_actionscheduler_logs` VALUES("2056", "709", "عملیات ایجاد شد", "2025-11-10 15:24:03", "2025-11-10 18:54:03");
INSERT INTO `won_actionscheduler_logs` VALUES("2057", "710", "عملیات ایجاد شد", "2025-11-10 15:24:03", "2025-11-10 18:54:03");
INSERT INTO `won_actionscheduler_logs` VALUES("2058", "711", "عملیات ایجاد شد", "2025-11-10 15:24:03", "2025-11-10 18:54:03");
INSERT INTO `won_actionscheduler_logs` VALUES("2059", "712", "عملیات ایجاد شد", "2025-11-10 15:24:03", "2025-11-10 18:54:03");
INSERT INTO `won_actionscheduler_logs` VALUES("2060", "713", "عملیات ایجاد شد", "2025-11-10 15:24:03", "2025-11-10 18:54:03");
INSERT INTO `won_actionscheduler_logs` VALUES("2061", "714", "عملیات ایجاد شد", "2025-11-10 15:24:03", "2025-11-10 18:54:03");
INSERT INTO `won_actionscheduler_logs` VALUES("2062", "715", "عملیات ایجاد شد", "2025-11-10 15:24:03", "2025-11-10 18:54:03");
INSERT INTO `won_actionscheduler_logs` VALUES("2063", "716", "عملیات ایجاد شد", "2025-11-10 15:24:03", "2025-11-10 18:54:03");
INSERT INTO `won_actionscheduler_logs` VALUES("2064", "717", "عملیات ایجاد شد", "2025-11-10 15:24:03", "2025-11-10 18:54:03");
INSERT INTO `won_actionscheduler_logs` VALUES("2065", "718", "عملیات ایجاد شد", "2025-11-10 15:24:03", "2025-11-10 18:54:03");
INSERT INTO `won_actionscheduler_logs` VALUES("2066", "719", "عملیات ایجاد شد", "2025-11-10 15:24:03", "2025-11-10 18:54:03");
INSERT INTO `won_actionscheduler_logs` VALUES("2067", "720", "عملیات ایجاد شد", "2025-11-10 15:24:03", "2025-11-10 18:54:03");
INSERT INTO `won_actionscheduler_logs` VALUES("2068", "721", "عملیات ایجاد شد", "2025-11-10 15:24:03", "2025-11-10 18:54:03");
INSERT INTO `won_actionscheduler_logs` VALUES("2069", "722", "عملیات ایجاد شد", "2025-11-10 15:24:03", "2025-11-10 18:54:03");
INSERT INTO `won_actionscheduler_logs` VALUES("2070", "723", "عملیات ایجاد شد", "2025-11-10 15:24:03", "2025-11-10 18:54:03");
INSERT INTO `won_actionscheduler_logs` VALUES("2071", "724", "عملیات ایجاد شد", "2025-11-10 15:24:03", "2025-11-10 18:54:03");
INSERT INTO `won_actionscheduler_logs` VALUES("2072", "725", "عملیات ایجاد شد", "2025-11-10 15:24:03", "2025-11-10 18:54:03");
INSERT INTO `won_actionscheduler_logs` VALUES("2073", "726", "عملیات ایجاد شد", "2025-11-10 15:24:21", "2025-11-10 18:54:21");
INSERT INTO `won_actionscheduler_logs` VALUES("2074", "727", "عملیات ایجاد شد", "2025-11-10 15:24:21", "2025-11-10 18:54:21");
INSERT INTO `won_actionscheduler_logs` VALUES("2075", "728", "عملیات ایجاد شد", "2025-11-10 15:24:22", "2025-11-10 18:54:22");
INSERT INTO `won_actionscheduler_logs` VALUES("2076", "729", "عملیات ایجاد شد", "2025-11-10 15:24:22", "2025-11-10 18:54:22");
INSERT INTO `won_actionscheduler_logs` VALUES("2077", "730", "عملیات ایجاد شد", "2025-11-10 15:24:22", "2025-11-10 18:54:22");
INSERT INTO `won_actionscheduler_logs` VALUES("2078", "731", "عملیات ایجاد شد", "2025-11-10 15:24:22", "2025-11-10 18:54:22");
INSERT INTO `won_actionscheduler_logs` VALUES("2079", "693", "عملیات با WP Cron شروع شد", "2025-11-14 06:32:37", "2025-11-14 10:02:37");
INSERT INTO `won_actionscheduler_logs` VALUES("2080", "732", "عملیات ایجاد شد", "2025-11-14 06:32:37", "2025-11-14 10:02:37");
INSERT INTO `won_actionscheduler_logs` VALUES("2081", "693", "عملیات با WP Cron تکمیل شد", "2025-11-14 06:32:37", "2025-11-14 10:02:37");
INSERT INTO `won_actionscheduler_logs` VALUES("2082", "598", "عملیات با WP Cron شروع شد", "2025-11-14 06:32:37", "2025-11-14 10:02:37");
INSERT INTO `won_actionscheduler_logs` VALUES("2083", "598", "عملیات با WP Cron تکمیل شد", "2025-11-14 06:32:37", "2025-11-14 10:02:37");
INSERT INTO `won_actionscheduler_logs` VALUES("2084", "733", "عملیات ایجاد شد", "2025-11-14 06:32:37", "2025-11-14 10:02:37");
INSERT INTO `won_actionscheduler_logs` VALUES("2085", "599", "عملیات با WP Cron شروع شد", "2025-11-14 06:32:37", "2025-11-14 10:02:37");
INSERT INTO `won_actionscheduler_logs` VALUES("2086", "599", "عملیات با WP Cron تکمیل شد", "2025-11-14 06:32:37", "2025-11-14 10:02:37");
INSERT INTO `won_actionscheduler_logs` VALUES("2087", "734", "عملیات ایجاد شد", "2025-11-14 06:32:37", "2025-11-14 10:02:37");
INSERT INTO `won_actionscheduler_logs` VALUES("2088", "600", "عملیات با WP Cron شروع شد", "2025-11-14 06:32:37", "2025-11-14 10:02:37");
INSERT INTO `won_actionscheduler_logs` VALUES("2089", "600", "عملیات با WP Cron تکمیل شد", "2025-11-14 06:32:37", "2025-11-14 10:02:37");
INSERT INTO `won_actionscheduler_logs` VALUES("2090", "735", "عملیات ایجاد شد", "2025-11-14 06:32:37", "2025-11-14 10:02:37");
INSERT INTO `won_actionscheduler_logs` VALUES("2091", "673", "عملیات با WP Cron شروع شد", "2025-11-14 06:32:37", "2025-11-14 10:02:37");
INSERT INTO `won_actionscheduler_logs` VALUES("2092", "673", "عملیات با WP Cron تکمیل شد", "2025-11-14 06:32:37", "2025-11-14 10:02:37");
INSERT INTO `won_actionscheduler_logs` VALUES("2093", "736", "عملیات ایجاد شد", "2025-11-14 06:32:37", "2025-11-14 10:02:37");
INSERT INTO `won_actionscheduler_logs` VALUES("2094", "674", "عملیات با WP Cron شروع شد", "2025-11-14 06:32:37", "2025-11-14 10:02:37");
INSERT INTO `won_actionscheduler_logs` VALUES("2095", "674", "عملیات با WP Cron تکمیل شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2096", "737", "عملیات ایجاد شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2097", "686", "عملیات با WP Cron شروع شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2098", "686", "عملیات با WP Cron تکمیل شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2099", "738", "عملیات ایجاد شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2100", "689", "عملیات با WP Cron شروع شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2101", "689", "عملیات با WP Cron تکمیل شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2102", "739", "عملیات ایجاد شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2103", "681", "عملیات با WP Cron شروع شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2104", "681", "عملیات با WP Cron تکمیل شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2105", "740", "عملیات ایجاد شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2106", "683", "عملیات با WP Cron شروع شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2107", "683", "عملیات با WP Cron تکمیل شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2108", "741", "عملیات ایجاد شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2109", "684", "عملیات با WP Cron شروع شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2110", "684", "عملیات با WP Cron تکمیل شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2111", "742", "عملیات ایجاد شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2112", "695", "عملیات با WP Cron شروع شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2113", "695", "عملیات با WP Cron تکمیل شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2114", "696", "عملیات با WP Cron شروع شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2115", "696", "عملیات با WP Cron تکمیل شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2116", "697", "عملیات با WP Cron شروع شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2117", "697", "عملیات با WP Cron تکمیل شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2118", "698", "عملیات با WP Cron شروع شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2119", "698", "عملیات با WP Cron تکمیل شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2120", "699", "عملیات با WP Cron شروع شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2121", "699", "عملیات با WP Cron تکمیل شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2122", "700", "عملیات با WP Cron شروع شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2123", "700", "عملیات با WP Cron تکمیل شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2124", "701", "عملیات با WP Cron شروع شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2125", "701", "عملیات با WP Cron تکمیل شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2126", "702", "عملیات با WP Cron شروع شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2127", "702", "عملیات با WP Cron تکمیل شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2128", "703", "عملیات با WP Cron شروع شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2129", "703", "عملیات با WP Cron تکمیل شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2130", "704", "عملیات با WP Cron شروع شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2131", "704", "عملیات با WP Cron تکمیل شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2132", "705", "عملیات با WP Cron شروع شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2133", "705", "عملیات با WP Cron تکمیل شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2134", "706", "عملیات با WP Cron شروع شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2135", "706", "عملیات با WP Cron تکمیل شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2136", "707", "عملیات با WP Cron شروع شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2137", "707", "عملیات با WP Cron تکمیل شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2138", "708", "عملیات با WP Cron شروع شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2139", "708", "عملیات با WP Cron تکمیل شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2140", "709", "عملیات با WP Cron شروع شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2141", "709", "عملیات با WP Cron تکمیل شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2142", "710", "عملیات با WP Cron شروع شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2143", "710", "عملیات با WP Cron تکمیل شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2144", "711", "عملیات با WP Cron شروع شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2145", "711", "عملیات با WP Cron تکمیل شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2146", "712", "عملیات با WP Cron شروع شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2147", "712", "عملیات با WP Cron تکمیل شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2148", "713", "عملیات با WP Cron شروع شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2149", "713", "عملیات با WP Cron تکمیل شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2150", "714", "عملیات با WP Cron شروع شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2151", "714", "عملیات با WP Cron تکمیل شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2152", "715", "عملیات با WP Cron شروع شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2153", "715", "عملیات با WP Cron تکمیل شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2154", "716", "عملیات با WP Cron شروع شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2155", "716", "عملیات با WP Cron تکمیل شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2156", "717", "عملیات با WP Cron شروع شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2157", "717", "عملیات با WP Cron تکمیل شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2158", "718", "عملیات با WP Cron شروع شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2159", "718", "عملیات با WP Cron تکمیل شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2160", "719", "عملیات با WP Cron شروع شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2161", "719", "عملیات با WP Cron تکمیل شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2162", "720", "عملیات با WP Cron شروع شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2163", "720", "عملیات با WP Cron تکمیل شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2164", "721", "عملیات با WP Cron شروع شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2165", "721", "عملیات با WP Cron تکمیل شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2166", "722", "عملیات با WP Cron شروع شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2167", "722", "عملیات با WP Cron تکمیل شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2168", "723", "عملیات با WP Cron شروع شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2169", "723", "عملیات با WP Cron تکمیل شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2170", "724", "عملیات با WP Cron شروع شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2171", "724", "عملیات با WP Cron تکمیل شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2172", "725", "عملیات با WP Cron شروع شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2173", "725", "عملیات با WP Cron تکمیل شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2174", "726", "عملیات با WP Cron شروع شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2175", "726", "عملیات با WP Cron تکمیل شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2176", "727", "عملیات با WP Cron شروع شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2177", "727", "عملیات با WP Cron تکمیل شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2178", "728", "عملیات با WP Cron شروع شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2179", "728", "عملیات با WP Cron تکمیل شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2180", "729", "عملیات با WP Cron شروع شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2181", "729", "عملیات با WP Cron تکمیل شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2182", "730", "عملیات با WP Cron شروع شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2183", "730", "عملیات با WP Cron تکمیل شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2184", "731", "عملیات با WP Cron شروع شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2185", "731", "عملیات با WP Cron تکمیل شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2186", "672", "عملیات با WP Cron شروع شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2187", "738", "عملیات لغو شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2188", "743", "عملیات ایجاد شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2189", "744", "عملیات ایجاد شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2190", "672", "عملیات با WP Cron تکمیل شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2191", "745", "عملیات ایجاد شد", "2025-11-14 06:32:38", "2025-11-14 10:02:38");
INSERT INTO `won_actionscheduler_logs` VALUES("2192", "746", "عملیات ایجاد شد", "2025-11-14 06:32:58", "2025-11-14 10:02:58");

/* INSERT TABLE DATA: won_arcontactus */
INSERT INTO `won_arcontactus` VALUES("1", "facebook-messenger", "567AFF", "0", "1", "https://m.me/page_name", "0", NULL, NULL, "Messenger", NULL, NULL, "null", "0", "0", "1", NULL);
INSERT INTO `won_arcontactus` VALUES("2", "whatsapp", "1EBEA5", "0", "1", "https://wa.me/+989126659033", "0", "", "", "Whatsapp", "", "", "{\"icon_type\":\"0\",\"icon_img\":\"\",\"nocontainer\":\"0\",\"online_badge\":\"0\",\"include_to_slider\":\"1\",\"form\":\"\",\"always\":\"1\",\"mon\":\"1\",\"mon_time_from\":\"00:00\",\"mon_time_to\":\"23:59\",\"tue\":\"1\",\"tue_time_from\":\"00:00\",\"tue_time_to\":\"23:59\",\"wed\":\"1\",\"wed_time_from\":\"00:00\",\"wed_time_to\":\"23:59\",\"thu\":\"1\",\"thu_time_from\":\"00:00\",\"thu_time_to\":\"23:59\",\"fri\":\"1\",\"fri_time_from\":\"00:00\",\"fri_time_to\":\"23:59\",\"sat\":\"1\",\"sat_time_from\":\"00:00\",\"sat_time_to\":\"23:59\",\"sun\":\"1\",\"sun_time_from\":\"00:00\",\"sun_time_to\":\"23:59\",\"inactive\":\"1\"}", "1", "0", "2", NULL);
INSERT INTO `won_arcontactus` VALUES("3", "viber", "812379", "0", "1", "viber://chat?number=%2Bphone_number", "0", NULL, NULL, "Viber", NULL, NULL, "null", "0", "0", "4", NULL);
INSERT INTO `won_arcontactus` VALUES("4", "telegram-plane", "20AFDE", "0", "1", "https://t.me/amirhesamsargol", "0", "", "", "Telegram", "", "", "{\"icon_type\":\"0\",\"icon_img\":\"\",\"nocontainer\":\"0\",\"online_badge\":\"0\",\"include_to_slider\":\"1\",\"form\":\"\",\"always\":\"1\",\"mon\":\"1\",\"mon_time_from\":\"00:00\",\"mon_time_to\":\"23:59\",\"tue\":\"1\",\"tue_time_from\":\"00:00\",\"tue_time_to\":\"23:59\",\"wed\":\"1\",\"wed_time_from\":\"00:00\",\"wed_time_to\":\"23:59\",\"thu\":\"1\",\"thu_time_from\":\"00:00\",\"thu_time_to\":\"23:59\",\"fri\":\"1\",\"fri_time_from\":\"00:00\",\"fri_time_to\":\"23:59\",\"sat\":\"1\",\"sat_time_from\":\"00:00\",\"sat_time_to\":\"23:59\",\"sun\":\"1\",\"sun_time_from\":\"00:00\",\"sun_time_to\":\"23:59\",\"inactive\":\"1\"}", "1", "0", "5", NULL);
INSERT INTO `won_arcontactus` VALUES("5", "skype", "1C9CC5", "0", "1", "skype:your_nickname?chat", "0", NULL, NULL, "Skype", NULL, NULL, "null", "0", "0", "6", NULL);
INSERT INTO `won_arcontactus` VALUES("6", "envelope", "FF643A", "0", "1", "mailto:email@mysite.com", "0", NULL, NULL, "Email us", NULL, NULL, "null", "0", "0", "7", NULL);
INSERT INTO `won_arcontactus` VALUES("7", "phone", "3EB891", "0", "3", "tel:+9891266659033", "0", "", "", "تماس", "", "", "{\"icon_type\":\"0\",\"icon_img\":\"\",\"nocontainer\":\"0\",\"online_badge\":\"0\",\"include_to_slider\":\"1\",\"form\":\"\",\"always\":\"1\",\"mon\":\"1\",\"mon_time_from\":\"00:00\",\"mon_time_to\":\"23:59\",\"tue\":\"1\",\"tue_time_from\":\"00:00\",\"tue_time_to\":\"23:59\",\"wed\":\"1\",\"wed_time_from\":\"00:00\",\"wed_time_to\":\"23:59\",\"thu\":\"1\",\"thu_time_from\":\"00:00\",\"thu_time_to\":\"23:59\",\"fri\":\"1\",\"fri_time_from\":\"00:00\",\"fri_time_to\":\"23:59\",\"sat\":\"1\",\"sat_time_from\":\"00:00\",\"sat_time_to\":\"23:59\",\"sun\":\"1\",\"sun_time_from\":\"00:00\",\"sun_time_to\":\"23:59\",\"inactive\":\"1\"}", "1", "0", "8", NULL);
INSERT INTO `won_arcontactus` VALUES("8", "comment-dots-light", "5092E2", "0", "3", "sms:+9891266659033", "0", "", "", "SMS", "", "", "{\"icon_type\":\"0\",\"icon_img\":\"\",\"nocontainer\":\"0\",\"online_badge\":\"0\",\"include_to_slider\":\"1\",\"form\":\"\",\"always\":\"1\",\"mon\":\"1\",\"mon_time_from\":\"00:00\",\"mon_time_to\":\"23:59\",\"tue\":\"1\",\"tue_time_from\":\"00:00\",\"tue_time_to\":\"23:59\",\"wed\":\"1\",\"wed_time_from\":\"00:00\",\"wed_time_to\":\"23:59\",\"thu\":\"1\",\"thu_time_from\":\"00:00\",\"thu_time_to\":\"23:59\",\"fri\":\"1\",\"fri_time_from\":\"00:00\",\"fri_time_to\":\"23:59\",\"sat\":\"1\",\"sat_time_from\":\"00:00\",\"sat_time_to\":\"23:59\",\"sun\":\"1\",\"sun_time_from\":\"00:00\",\"sun_time_to\":\"23:59\",\"inactive\":\"1\"}", "1", "0", "9", NULL);
INSERT INTO `won_arcontactus` VALUES("9", "phone", "4EB625", "3", "1", NULL, NULL, NULL, NULL, "Callback request", NULL, NULL, "{\"form\":\"callback\"}", "0", "0", "10", NULL);
INSERT INTO `won_arcontactus` VALUES("10", "Instagram", "b83a92", "0", "1", "https://www.instagram.com/[nickname]/", NULL, NULL, NULL, "Instagram", NULL, NULL, "null", "0", "0", "11", NULL);
INSERT INTO `won_arcontactus` VALUES("11", "Gap", "774fd4", "0", "1", "https://www.gap.im/[nickname]", NULL, NULL, NULL, "Gap", NULL, NULL, "null", "0", "0", "12", NULL);
INSERT INTO `won_arcontactus` VALUES("12", "Bale", "38728b", "0", "1", "https://ble.im/[nickname]", NULL, NULL, NULL, "Bale", NULL, NULL, "null", "0", "0", "13", NULL);
INSERT INTO `won_arcontactus` VALUES("13", "wechat", "F07C00", "0", "1", "https://www.eitaa.com/amirhesamsargol", "0", "", "", "Eitaa", "", "", "{\"icon_type\":\"0\",\"icon_img\":\"\",\"nocontainer\":\"0\",\"online_badge\":\"0\",\"include_to_slider\":\"1\",\"form\":\"\",\"always\":\"1\",\"mon\":\"1\",\"mon_time_from\":\"00:00\",\"mon_time_to\":\"23:59\",\"tue\":\"1\",\"tue_time_from\":\"00:00\",\"tue_time_to\":\"23:59\",\"wed\":\"1\",\"wed_time_from\":\"00:00\",\"wed_time_to\":\"23:59\",\"thu\":\"1\",\"thu_time_from\":\"00:00\",\"thu_time_to\":\"23:59\",\"fri\":\"1\",\"fri_time_from\":\"00:00\",\"fri_time_to\":\"23:59\",\"sat\":\"1\",\"sat_time_from\":\"00:00\",\"sat_time_to\":\"23:59\",\"sun\":\"1\",\"sun_time_from\":\"00:00\",\"sun_time_to\":\"23:59\",\"inactive\":\"1\"}", "1", "0", "14", NULL);
INSERT INTO `won_arcontactus` VALUES("14", "Soroush", "196179", "0", "1", "https://www.sapp.ir/[nickname]", NULL, NULL, NULL, "Soroush", NULL, NULL, "null", "0", "0", "15", NULL);
INSERT INTO `won_arcontactus` VALUES("15", "Wispi", "3497db", "0", "1", "https://www.wispi.me/[nickname]", NULL, NULL, NULL, "Wispi", NULL, NULL, "null", "0", "0", "16", NULL);
INSERT INTO `won_arcontactus` VALUES("16", "BisPhone", "e9453b", "0", "1", "http://bpn.im/[nickname]", NULL, NULL, NULL, "BisPhone", NULL, NULL, "null", "0", "0", "17", NULL);
INSERT INTO `won_arcontactus` VALUES("17", "Aparat", "ed145b", "0", "1", "https://www.aparat.com/[nickname]", NULL, NULL, NULL, "Aparat", NULL, NULL, "null", "0", "0", "18", NULL);
INSERT INTO `won_arcontactus` VALUES("18", "", "FFFFFF", "0", "1", "https://rubika.ir/amirhesamsargol", "0", "", "", "روبیکا", "", "", "{\"icon_type\":\"2\",\"icon_img\":\"3570\",\"nocontainer\":\"0\",\"online_badge\":\"0\",\"include_to_slider\":\"1\",\"form\":\"\",\"always\":\"1\",\"mon\":\"1\",\"mon_time_from\":\"00:00\",\"mon_time_to\":\"23:59\",\"tue\":\"1\",\"tue_time_from\":\"00:00\",\"tue_time_to\":\"23:59\",\"wed\":\"1\",\"wed_time_from\":\"00:00\",\"wed_time_to\":\"23:59\",\"thu\":\"1\",\"thu_time_from\":\"00:00\",\"thu_time_to\":\"23:59\",\"fri\":\"1\",\"fri_time_from\":\"00:00\",\"fri_time_to\":\"23:59\",\"sat\":\"1\",\"sat_time_from\":\"00:00\",\"sat_time_to\":\"23:59\",\"sun\":\"1\",\"sun_time_from\":\"00:00\",\"sun_time_to\":\"23:59\",\"inactive\":\"1\"}", "1", "0", "3", NULL);

/* INSERT TABLE DATA: won_arcontactus_lang */
INSERT INTO `won_arcontactus_lang` VALUES("fa", "1", "Messenger", NULL, NULL);
INSERT INTO `won_arcontactus_lang` VALUES("fa", "2", "Whatsapp", "", "");
INSERT INTO `won_arcontactus_lang` VALUES("fa", "3", "Viber", NULL, NULL);
INSERT INTO `won_arcontactus_lang` VALUES("fa", "4", "Telegram", "", "");
INSERT INTO `won_arcontactus_lang` VALUES("fa", "5", "Skype", NULL, NULL);
INSERT INTO `won_arcontactus_lang` VALUES("fa", "6", "Email us", NULL, NULL);
INSERT INTO `won_arcontactus_lang` VALUES("fa", "7", "تماس", "", "");
INSERT INTO `won_arcontactus_lang` VALUES("fa", "8", "SMS", "", "");
INSERT INTO `won_arcontactus_lang` VALUES("fa", "9", "Callback request", NULL, NULL);
INSERT INTO `won_arcontactus_lang` VALUES("fa", "10", "Instagram", NULL, NULL);
INSERT INTO `won_arcontactus_lang` VALUES("fa", "11", "Gap", NULL, NULL);
INSERT INTO `won_arcontactus_lang` VALUES("fa", "12", "Bale", NULL, NULL);
INSERT INTO `won_arcontactus_lang` VALUES("fa", "13", "Eitaa", "", "");
INSERT INTO `won_arcontactus_lang` VALUES("fa", "14", "Soroush", NULL, NULL);
INSERT INTO `won_arcontactus_lang` VALUES("fa", "15", "Wispi", NULL, NULL);
INSERT INTO `won_arcontactus_lang` VALUES("fa", "16", "BisPhone", NULL, NULL);
INSERT INTO `won_arcontactus_lang` VALUES("fa", "17", "Aparat", NULL, NULL);
INSERT INTO `won_arcontactus_lang` VALUES("fa", "18", "روبیکا", "", "");

/* INSERT TABLE DATA: won_arcontactus_prompt */
INSERT INTO `won_arcontactus_prompt` VALUES("1", "Hello!", "0", "1");
INSERT INTO `won_arcontactus_prompt` VALUES("2", "Have a questions?", "0", "2");
INSERT INTO `won_arcontactus_prompt` VALUES("3", "Please use this button\r\nto contact us!", "0", "3");

/* INSERT TABLE DATA: won_arcontactus_prompt_lang */
INSERT INTO `won_arcontactus_prompt_lang` VALUES("fa", "1", "Hello!");
INSERT INTO `won_arcontactus_prompt_lang` VALUES("fa", "2", "Have a questions?");
INSERT INTO `won_arcontactus_prompt_lang` VALUES("fa", "3", "Please use this button\r\nto contact us!");

/* INSERT TABLE DATA: won_comments */
INSERT INTO `won_comments` VALUES("43", "3710", "ووکامرس", "", "", "", "2024-04-26 16:34:56", "2024-04-26 13:04:56", "خطا در هنگام ارسال به بانک :  تراکنش ناموفق بود- کد خطا : -11", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `won_comments` VALUES("44", "3710", "ووکامرس", "", "", "", "2024-04-26 16:36:08", "2024-04-26 13:06:08", "خطا در هنگام ارسال به بانک :  تراکنش ناموفق بود- کد خطا : -11", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `won_comments` VALUES("45", "3710", "ووکامرس", "", "", "", "2024-04-26 18:25:50", "2024-04-26 14:55:50", "سفارش پرداخت نشده لغو شد - حد زمانی پایان یافت وضعیت سفارش از در انتظار پرداخت به لغو شده تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `won_comments` VALUES("46", "3711", "ووکامرس", "", "", "", "2024-05-01 18:16:50", "2024-05-01 14:46:50", "خطا در هنگام ارسال به بانک :  تراکنش ناموفق بود- کد خطا : -11", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `won_comments` VALUES("47", "3711", "ووکامرس", "", "", "", "2024-05-01 18:18:21", "2024-05-01 14:48:21", "خطا در هنگام ارسال به بانک :  تراکنش ناموفق بود- کد خطا : -11", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `won_comments` VALUES("48", "3711", "ووکامرس", "", "", "", "2024-05-01 19:26:39", "2024-05-01 15:56:39", "سفارش پرداخت نشده لغو شد - حد زمانی پایان یافت وضعیت سفارش از در انتظار پرداخت به لغو شده تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");

/* INSERT TABLE DATA: won_duplicator_packages */
INSERT INTO `won_duplicator_packages` VALUES("5", "20240513_d988db8cd9bed988d9bed8a7d8af", "ed00bda55738612f9106_20251119094608", "21", "2025-11-19 09:46:16", "admin", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-11-19 09:46:08\";s:7:\"Version\";s:8:\"1.5.11.2\";s:9:\"VersionWP\";s:5:\"6.8.3\";s:9:\"VersionDB\";s:7:\"10.6.24\";s:10:\"VersionPHP\";s:6:\"8.2.29\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:5;s:4:\"Name\";s:37:\"20240513_d988db8cd9bed988d9bed8a7d8af\";s:4:\"Hash\";s:35:\"ed00bda55738612f9106_20251119094608\";s:8:\"NameHash\";s:73:\"20240513_d988db8cd9bed988d9bed8a7d8af_ed00bda55738612f9106_20251119094608\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:83:\"20240513_d988db8cd9bed988d9bed8a7d8af_ed00bda55738612f9106_20251119094608_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"21.4\";s:6:\"WPUser\";s:5:\"admin\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:85:\"20240513_d988db8cd9bed988d9bed8a7d8af_ed00bda55738612f9106_20251119094608_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:25:\"/home/ergherh/public_html\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:3527;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:20673;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-11-19 09:46:08\";s:7:\"Version\";s:8:\"1.5.11.2\";s:9:\"VersionWP\";s:5:\"6.8.3\";s:9:\"VersionDB\";s:7:\"10.6.24\";s:10:\"VersionPHP\";s:6:\"8.2.29\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:37:\"20240513_d988db8cd9bed988d9bed8a7d8af\";s:4:\"Hash\";s:35:\"ed00bda55738612f9106_20251119094608\";s:8:\"NameHash\";s:73:\"20240513_d988db8cd9bed988d9bed8a7d8af_ed00bda55738612f9106_20251119094608\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:91:\"20240513_d988db8cd9bed988d9bed8a7d8af_ed00bda55738612f9106_20251119094608_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:39:\"/home/ergherh/public_html/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:86:\"20240513_d988db8cd9bed988d9bed8a7d8af_ed00bda55738612f9106_20251119094608_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:144:\"/home/ergherh/public_html/wp-content/backups-dup-lite/tmp/20240513_d988db8cd9bed988d9bed8a7d8af_ed00bda55738612f9106_20251119094608_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:34:\"/home/ergherh/public_html/wp-admin\";i:1;s:37:\"/home/ergherh/public_html/wp-includes\";i:2;s:46:\"/home/ergherh/public_html/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:25:\"/home/ergherh/public_html\";i:1;s:25:\"/home/ergherh/public_html\";i:2;s:36:\"/home/ergherh/public_html/wp-content\";i:3;s:44:\"/home/ergherh/public_html/wp-content/uploads\";i:4;s:44:\"/home/ergherh/public_html/wp-content/plugins\";i:5;s:47:\"/home/ergherh/public_html/wp-content/mu-plugins\";i:6;s:43:\"/home/ergherh/public_html/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:57:\"/home/ergherh/public_html/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: won_gf_form */
INSERT INTO `won_gf_form` VALUES("1", "سفارش عمده", "2024-08-12 19:35:05", NULL, "1", "0");

/* INSERT TABLE DATA: won_gf_form_meta */
INSERT INTO `won_gf_form_meta` VALUES("1", "{\"fields\":[{\"type\":\"text\",\"id\":1,\"formId\":1,\"label\":\"\\u0646\\u0627\\u0645 \\u0648 \\u0646\\u0627\\u0645 \\u062e\\u0627\\u0646\\u0648\\u0627\\u062f\\u06af\\u06cc\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"text\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":\"\",\"enablePasswordInput\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"7eb833b6\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"errors\":[],\"pageNumber\":1,\"fields\":\"\",\"displayOnly\":\"\"},{\"type\":\"text\",\"id\":3,\"formId\":1,\"label\":\"\\u0622\\u062f\\u0631\\u0633 \\u0645\\u062d\\u0644 \\u0627\\u0631\\u0633\\u0627\\u0644\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"text\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":12,\"enablePasswordInput\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"0eeeabe7\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"errors\":[],\"pageNumber\":1,\"fields\":\"\",\"displayOnly\":\"\"},{\"type\":\"radio\",\"id\":4,\"formId\":1,\"label\":\"\\u0646\\u0648\\u0639 \\u0635\\u0646\\u062f\\u0644 \\u0627\\u0646\\u062a\\u062e\\u0627\\u0628\\u06cc\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"validateState\":true,\"inputs\":null,\"choices\":[{\"text\":\"\\u0632\\u0646\\u0627\\u0646\\u0647\",\"value\":\"\\u0632\\u0646\\u0627\\u0646\\u0647\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"\\u0645\\u0631\\u062f\\u0627\\u0646\\u0647\",\"value\":\"\\u0645\\u0631\\u062f\\u0627\\u0646\\u0647\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"\\u0628\\u0686\\u06af\\u0627\\u0646\\u0647\",\"value\":\"\\u0628\\u0686\\u06af\\u0627\\u0646\\u0647\",\"isSelected\":false,\"price\":\"\"}],\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"radio\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":6,\"enableOtherChoice\":\"\",\"enablePrice\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"4515b937\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"errors\":[],\"pageNumber\":1,\"fields\":\"\",\"displayOnly\":\"\"},{\"type\":\"checkbox\",\"id\":5,\"formId\":1,\"label\":\"\\u062e\\u062f\\u0645\\u0627\\u062a \\u062f\\u0631\\u062e\\u0648\\u0627\\u0633\\u062a\\u06cc\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"choices\":[{\"text\":\"\\u0628\\u0633\\u062a\\u0647 \\u0628\\u0646\\u062f\\u06cc \\u06a9\\u0644\\u06cc\",\"value\":\"\\u0628\\u0633\\u062a\\u0647 \\u0628\\u0646\\u062f\\u06cc \\u06a9\\u0644\\u06cc\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"\\u0641\\u0648\\u0645 \\u067e\\u06cc\\u0686 \\u067e\\u0644\\u0627\\u0633\\u062a\\u06cc\\u06a9\\u06cc\",\"value\":\"\\u0641\\u0648\\u0645 \\u067e\\u06cc\\u0686 \\u067e\\u0644\\u0627\\u0633\\u062a\\u06cc\\u06a9\\u06cc\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"\\u062a\\u0627\\u0645\\u06cc\\u0646 \\u062e\\u0648\\u062f\\u0631\\u0648\\u06cc \\u0628\\u0627\\u0631\\u06cc\",\"value\":\"\\u062a\\u0627\\u0645\\u06cc\\u0646 \\u062e\\u0648\\u062f\\u0631\\u0648\\u06cc \\u0628\\u0627\\u0631\\u06cc\",\"isSelected\":false,\"price\":\"\"}],\"validateState\":true,\"inputs\":[{\"id\":\"5.1\",\"label\":\"\\u0628\\u0633\\u062a\\u0647 \\u0628\\u0646\\u062f\\u06cc \\u06a9\\u0644\\u06cc\",\"name\":\"\"},{\"id\":\"5.2\",\"label\":\"\\u0641\\u0648\\u0645 \\u067e\\u06cc\\u0686 \\u067e\\u0644\\u0627\\u0633\\u062a\\u06cc\\u06a9\\u06cc\",\"name\":\"\"},{\"id\":\"5.3\",\"label\":\"\\u062a\\u0627\\u0645\\u06cc\\u0646 \\u062e\\u0648\\u062f\\u0631\\u0648\\u06cc \\u0628\\u0627\\u0631\\u06cc\",\"name\":\"\"}],\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"checkbox\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":6,\"enableSelectAll\":\"\",\"enablePrice\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"4515b937\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"errors\":[],\"pageNumber\":1,\"fields\":\"\",\"displayOnly\":\"\"},{\"type\":\"text\",\"id\":6,\"formId\":1,\"label\":\"\\u062a\\u0639\\u062f\\u0627\\u062f \\u062f\\u0631\\u062e\\u0648\\u0627\\u0633\\u062a\\u06cc\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"text\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":4,\"enablePasswordInput\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"69a456e4\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"errors\":[],\"pageNumber\":1,\"fields\":\"\",\"displayOnly\":\"\"},{\"type\":\"text\",\"id\":7,\"formId\":1,\"label\":\"\\u06a9\\u062f \\u0645\\u0634\\u062a\\u0631\\u06cc\\u0627\\u0646 vip \\u062f\\u0631 \\u0635\\u0648\\u0631\\u062a\\u06cc \\u06a9\\u0647 \\u062f\\u0627\\u0631\\u06cc\\u062f \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"text\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":4,\"enablePasswordInput\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"69a456e4\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"errors\":[],\"pageNumber\":1,\"fields\":\"\",\"displayOnly\":\"\"},{\"type\":\"text\",\"id\":8,\"formId\":1,\"label\":\"\\u0634\\u0645\\u0627\\u0631\\u0647 \\u0647\\u0645\\u0631\\u0627\\u0647\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"text\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":4,\"enablePasswordInput\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"69a456e4\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"errors\":[],\"pageNumber\":1,\"fields\":\"\",\"displayOnly\":\"\"},{\"type\":\"textarea\",\"id\":9,\"formId\":1,\"label\":\"\\u062a\\u0648\\u0636\\u06cc\\u062d\\u0627\\u062a \\u0634\\u0645\\u0627\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"textarea\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":12,\"form_id\":\"\",\"useRichTextEditor\":false,\"enableEnhancedUI\":0,\"layoutGroupId\":\"fc12b854\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"errors\":[],\"pageNumber\":1,\"fields\":\"\",\"displayOnly\":\"\"}],\"button\":{\"type\":\"text\",\"text\":\"\",\"imageUrl\":\"\",\"width\":\"auto\",\"location\":\"bottom\",\"layoutGridColumnSpan\":12},\"title\":\"\\u0633\\u0641\\u0627\\u0631\\u0634 \\u0639\\u0645\\u062f\\u0647\",\"description\":\"\",\"version\":\"2.8.12.1\",\"id\":1,\"markupVersion\":2,\"nextFieldId\":10,\"useCurrentUserAsAuthor\":true,\"postContentTemplateEnabled\":false,\"postTitleTemplateEnabled\":false,\"postTitleTemplate\":\"\",\"postContentTemplate\":\"\",\"lastPageButton\":null,\"pagination\":null,\"firstPageCssClass\":null}", NULL, "{\"66ba63e907450\":{\"id\":\"66ba63e907450\",\"name\":\"\\u062a\\u0627\\u06cc\\u06cc\\u062f\\u06cc\\u0647 \\u067e\\u06cc\\u0634\\u0641\\u0631\\u0636\",\"isDefault\":true,\"type\":\"message\",\"message\":\"\\u0627\\u0632 \\u062a\\u0645\\u0627\\u0633 \\u0634\\u0645\\u0627 \\u0645\\u062a\\u0634\\u06a9\\u0631\\u06cc\\u0645! \\u0628\\u0647 \\u0632\\u0648\\u062f\\u06cc \\u0628\\u0627 \\u0634\\u0645\\u0627 \\u062a\\u0645\\u0627\\u0633 \\u0645\\u06cc \\u06af\\u06cc\\u0631\\u06cc\\u0645.\",\"url\":\"\",\"pageId\":\"\",\"queryString\":\"\"}}", "{\"66ba63e906bf6\":{\"id\":\"66ba63e906bf6\",\"isActive\":true,\"to\":\"{admin_email}\",\"name\":\"\\u0627\\u0639\\u0644\\u0627\\u0646 \\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a\",\"event\":\"form_submission\",\"toType\":\"email\",\"subject\":\"\\u0641\\u0631\\u0645 \\u0627\\u0631\\u0633\\u0627\\u0644\\u06cc \\u062c\\u062f\\u06cc\\u062f {form_title}\",\"message\":\"{all_fields}\"}}");

/* INSERT TABLE DATA: won_gf_form_view */
INSERT INTO `won_gf_form_view` VALUES("1", "1", "2024-08-13 07:21:06", "", "2");

/* INSERT TABLE DATA: won_options */
INSERT INTO `won_options` VALUES("1", "siteurl", "https://kashtmoodrmozafari.ir", "yes");
INSERT INTO `won_options` VALUES("2", "home", "https://kashtmoodrmozafari.ir", "yes");
INSERT INTO `won_options` VALUES("3", "blogname", "کلینیک کاشت موی دکتر مظفری", "yes");
INSERT INTO `won_options` VALUES("4", "blogdescription", "", "yes");
INSERT INTO `won_options` VALUES("5", "users_can_register", "1", "yes");
INSERT INTO `won_options` VALUES("6", "admin_email", "chavosh.sd@gmail.com", "yes");
INSERT INTO `won_options` VALUES("7", "start_of_week", "6", "yes");
INSERT INTO `won_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `won_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `won_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `won_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `won_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `won_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `won_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `won_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `won_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `won_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `won_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `won_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `won_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `won_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `won_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `won_options` VALUES("23", "date_format", "j F, Y", "yes");
INSERT INTO `won_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `won_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `won_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `won_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `won_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `won_options` VALUES("29", "rewrite_rules", "a:371:{s:24:\"^wc-auth/v([1]{1})/(.*)?\";s:63:\"index.php?wc-auth-version=$matches[1]&wc-auth-route=$matches[2]\";s:21:\"^wc/file/transient/?$\";s:33:\"index.php?wc-transient-file-name=\";s:24:\"^wc/file/transient/(.+)$\";s:44:\"index.php?wc-transient-file-name=$matches[1]\";s:22:\"^wc-api/v([1-3]{1})/?$\";s:51:\"index.php?wc-api-version=$matches[1]&wc-api-route=/\";s:24:\"^wc-api/v([1-3]{1})(.*)?\";s:61:\"index.php?wc-api-version=$matches[1]&wc-api-route=$matches[2]\";s:12:\"portfolio/?$\";s:29:\"index.php?post_type=portfolio\";s:42:\"portfolio/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=portfolio&feed=$matches[1]\";s:37:\"portfolio/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=portfolio&feed=$matches[1]\";s:29:\"portfolio/page/([0-9]{1,})/?$\";s:47:\"index.php?post_type=portfolio&paged=$matches[1]\";s:7:\"shop/?$\";s:27:\"index.php?post_type=product\";s:37:\"shop/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:32:\"shop/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:24:\"shop/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=product&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:18:\"gf_live_preview/?$\";s:35:\"index.php?post_type=gf_live_preview\";s:48:\"gf_live_preview/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?post_type=gf_live_preview&feed=$matches[1]\";s:43:\"gf_live_preview/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?post_type=gf_live_preview&feed=$matches[1]\";s:35:\"gf_live_preview/page/([0-9]{1,})/?$\";s:53:\"index.php?post_type=gf_live_preview&paged=$matches[1]\";s:15:\"^checkout-link$\";s:28:\"index.php?checkout-link=true\";s:31:\"^wishlist/([^/]*)/page/([^/]*)?\";s:63:\"index.php?page_id=389&wishlist_id=$matches[1]&paged=$matches[2]\";s:23:\"^wishlist/page/([^/]*)?\";s:39:\"index.php?page_id=389&paged=$matches[1]\";s:19:\"^wishlist/([^/]*)/?\";s:45:\"index.php?page_id=389&wishlist_id=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:43:\"category/(.+?)/wc/file/transient(/(.*))?/?$\";s:65:\"index.php?category_name=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"category/(.+?)/wc-api(/(.*))?/?$\";s:54:\"index.php?category_name=$matches[1]&wc-api=$matches[3]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:40:\"tag/([^/]+)/wc/file/transient(/(.*))?/?$\";s:55:\"index.php?tag=$matches[1]&wc/file/transient=$matches[3]\";s:29:\"tag/([^/]+)/wc-api(/(.*))?/?$\";s:44:\"index.php?tag=$matches[1]&wc-api=$matches[3]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:43:\"woodmart_layout/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:53:\"woodmart_layout/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:73:\"woodmart_layout/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"woodmart_layout/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"woodmart_layout/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:49:\"woodmart_layout/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"woodmart_layout/([^/]+)/embed/?$\";s:48:\"index.php?woodmart_layout=$matches[1]&embed=true\";s:36:\"woodmart_layout/([^/]+)/trackback/?$\";s:42:\"index.php?woodmart_layout=$matches[1]&tb=1\";s:44:\"woodmart_layout/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?woodmart_layout=$matches[1]&paged=$matches[2]\";s:51:\"woodmart_layout/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?woodmart_layout=$matches[1]&cpage=$matches[2]\";s:52:\"woodmart_layout/([^/]+)/wc/file/transient(/(.*))?/?$\";s:67:\"index.php?woodmart_layout=$matches[1]&wc/file/transient=$matches[3]\";s:41:\"woodmart_layout/([^/]+)/wc-api(/(.*))?/?$\";s:56:\"index.php?woodmart_layout=$matches[1]&wc-api=$matches[3]\";s:58:\"woodmart_layout/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:69:\"woodmart_layout/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:47:\"woodmart_layout/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:58:\"woodmart_layout/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:40:\"woodmart_layout/([^/]+)(?:/([0-9]+))?/?$\";s:54:\"index.php?woodmart_layout=$matches[1]&page=$matches[2]\";s:32:\"woodmart_layout/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"woodmart_layout/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"woodmart_layout/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"woodmart_layout/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"woodmart_layout/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"woodmart_layout/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:43:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:53:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:73:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:49:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"woodmart_woo_lv/([^/]+)/embed/?$\";s:48:\"index.php?woodmart_woo_lv=$matches[1]&embed=true\";s:36:\"woodmart_woo_lv/([^/]+)/trackback/?$\";s:42:\"index.php?woodmart_woo_lv=$matches[1]&tb=1\";s:44:\"woodmart_woo_lv/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?woodmart_woo_lv=$matches[1]&paged=$matches[2]\";s:51:\"woodmart_woo_lv/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?woodmart_woo_lv=$matches[1]&cpage=$matches[2]\";s:52:\"woodmart_woo_lv/([^/]+)/wc/file/transient(/(.*))?/?$\";s:67:\"index.php?woodmart_woo_lv=$matches[1]&wc/file/transient=$matches[3]\";s:41:\"woodmart_woo_lv/([^/]+)/wc-api(/(.*))?/?$\";s:56:\"index.php?woodmart_woo_lv=$matches[1]&wc-api=$matches[3]\";s:58:\"woodmart_woo_lv/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:69:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:47:\"woodmart_woo_lv/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:58:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:40:\"woodmart_woo_lv/([^/]+)(?:/([0-9]+))?/?$\";s:54:\"index.php?woodmart_woo_lv=$matches[1]&page=$matches[2]\";s:32:\"woodmart_woo_lv/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"woodmart_woo_lv/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"woodmart_woo_lv/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"woodmart_woo_lv/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"woodmart_woo_lv/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"woodmart_woo_lv/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:44:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"woodmart_woo_fbt/([^/]+)/embed/?$\";s:49:\"index.php?woodmart_woo_fbt=$matches[1]&embed=true\";s:37:\"woodmart_woo_fbt/([^/]+)/trackback/?$\";s:43:\"index.php?woodmart_woo_fbt=$matches[1]&tb=1\";s:45:\"woodmart_woo_fbt/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?woodmart_woo_fbt=$matches[1]&paged=$matches[2]\";s:52:\"woodmart_woo_fbt/([^/]+)/comment-page-([0-9]{1,})/?$\";s:56:\"index.php?woodmart_woo_fbt=$matches[1]&cpage=$matches[2]\";s:53:\"woodmart_woo_fbt/([^/]+)/wc/file/transient(/(.*))?/?$\";s:68:\"index.php?woodmart_woo_fbt=$matches[1]&wc/file/transient=$matches[3]\";s:42:\"woodmart_woo_fbt/([^/]+)/wc-api(/(.*))?/?$\";s:57:\"index.php?woodmart_woo_fbt=$matches[1]&wc-api=$matches[3]\";s:59:\"woodmart_woo_fbt/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:70:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:48:\"woodmart_woo_fbt/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:59:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:41:\"woodmart_woo_fbt/([^/]+)(?:/([0-9]+))?/?$\";s:55:\"index.php?woodmart_woo_fbt=$matches[1]&page=$matches[2]\";s:33:\"woodmart_woo_fbt/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"woodmart_woo_fbt/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"woodmart_woo_fbt/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"woodmart_woo_fbt/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"woodmart_woo_fbt/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"woodmart_woo_fbt/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:54:\"cms_block_cat/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?cms_block_cat=$matches[1]&feed=$matches[2]\";s:49:\"cms_block_cat/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?cms_block_cat=$matches[1]&feed=$matches[2]\";s:30:\"cms_block_cat/([^/]+)/embed/?$\";s:46:\"index.php?cms_block_cat=$matches[1]&embed=true\";s:42:\"cms_block_cat/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?cms_block_cat=$matches[1]&paged=$matches[2]\";s:24:\"cms_block_cat/([^/]+)/?$\";s:35:\"index.php?cms_block_cat=$matches[1]\";s:42:\"woodmart_slide/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"woodmart_slide/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"woodmart_slide/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"woodmart_slide/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"woodmart_slide/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"woodmart_slide/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"woodmart_slide/([^/]+)/embed/?$\";s:47:\"index.php?woodmart_slide=$matches[1]&embed=true\";s:35:\"woodmart_slide/([^/]+)/trackback/?$\";s:41:\"index.php?woodmart_slide=$matches[1]&tb=1\";s:43:\"woodmart_slide/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?woodmart_slide=$matches[1]&paged=$matches[2]\";s:50:\"woodmart_slide/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?woodmart_slide=$matches[1]&cpage=$matches[2]\";s:51:\"woodmart_slide/([^/]+)/wc/file/transient(/(.*))?/?$\";s:66:\"index.php?woodmart_slide=$matches[1]&wc/file/transient=$matches[3]\";s:40:\"woodmart_slide/([^/]+)/wc-api(/(.*))?/?$\";s:55:\"index.php?woodmart_slide=$matches[1]&wc-api=$matches[3]\";s:57:\"woodmart_slide/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:68:\"woodmart_slide/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:46:\"woodmart_slide/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:57:\"woodmart_slide/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:39:\"woodmart_slide/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?woodmart_slide=$matches[1]&page=$matches[2]\";s:31:\"woodmart_slide/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"woodmart_slide/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"woodmart_slide/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"woodmart_slide/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"woodmart_slide/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"woodmart_slide/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:56:\"woodmart_slider/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:68:\"index.php?taxonomy=woodmart_slider&term=$matches[1]&feed=$matches[2]\";s:51:\"woodmart_slider/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:68:\"index.php?taxonomy=woodmart_slider&term=$matches[1]&feed=$matches[2]\";s:32:\"woodmart_slider/([^/]+)/embed/?$\";s:62:\"index.php?taxonomy=woodmart_slider&term=$matches[1]&embed=true\";s:44:\"woodmart_slider/([^/]+)/page/?([0-9]{1,})/?$\";s:69:\"index.php?taxonomy=woodmart_slider&term=$matches[1]&paged=$matches[2]\";s:26:\"woodmart_slider/([^/]+)/?$\";s:51:\"index.php?taxonomy=woodmart_slider&term=$matches[1]\";s:37:\"portfolio/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"portfolio/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"portfolio/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"portfolio/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"portfolio/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"portfolio/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"portfolio/([^/]+)/embed/?$\";s:42:\"index.php?portfolio=$matches[1]&embed=true\";s:30:\"portfolio/([^/]+)/trackback/?$\";s:36:\"index.php?portfolio=$matches[1]&tb=1\";s:50:\"portfolio/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?portfolio=$matches[1]&feed=$matches[2]\";s:45:\"portfolio/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?portfolio=$matches[1]&feed=$matches[2]\";s:38:\"portfolio/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&paged=$matches[2]\";s:45:\"portfolio/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&cpage=$matches[2]\";s:46:\"portfolio/([^/]+)/wc/file/transient(/(.*))?/?$\";s:61:\"index.php?portfolio=$matches[1]&wc/file/transient=$matches[3]\";s:35:\"portfolio/([^/]+)/wc-api(/(.*))?/?$\";s:50:\"index.php?portfolio=$matches[1]&wc-api=$matches[3]\";s:52:\"portfolio/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:63:\"portfolio/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:41:\"portfolio/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:52:\"portfolio/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:34:\"portfolio/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?portfolio=$matches[1]&page=$matches[2]\";s:26:\"portfolio/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"portfolio/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"portfolio/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"portfolio/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"portfolio/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"portfolio/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:50:\"project-cat/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?project-cat=$matches[1]&feed=$matches[2]\";s:45:\"project-cat/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?project-cat=$matches[1]&feed=$matches[2]\";s:26:\"project-cat/(.+?)/embed/?$\";s:44:\"index.php?project-cat=$matches[1]&embed=true\";s:38:\"project-cat/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?project-cat=$matches[1]&paged=$matches[2]\";s:20:\"project-cat/(.+?)/?$\";s:33:\"index.php?project-cat=$matches[1]\";s:44:\"brand/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?product_brand=$matches[1]&feed=$matches[2]\";s:39:\"brand/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?product_brand=$matches[1]&feed=$matches[2]\";s:20:\"brand/(.+?)/embed/?$\";s:46:\"index.php?product_brand=$matches[1]&embed=true\";s:32:\"brand/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?product_brand=$matches[1]&paged=$matches[2]\";s:14:\"brand/(.+?)/?$\";s:35:\"index.php?product_brand=$matches[1]\";s:68:\"wc_export_is_order_exported/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:66:\"index.php?wc_export_is_order_exported=$matches[1]&feed=$matches[2]\";s:63:\"wc_export_is_order_exported/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:66:\"index.php?wc_export_is_order_exported=$matches[1]&feed=$matches[2]\";s:44:\"wc_export_is_order_exported/([^/]+)/embed/?$\";s:60:\"index.php?wc_export_is_order_exported=$matches[1]&embed=true\";s:56:\"wc_export_is_order_exported/([^/]+)/page/?([0-9]{1,})/?$\";s:67:\"index.php?wc_export_is_order_exported=$matches[1]&paged=$matches[2]\";s:38:\"wc_export_is_order_exported/([^/]+)/?$\";s:49:\"index.php?wc_export_is_order_exported=$matches[1]\";s:68:\"wc_export_is_guest_exported/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:66:\"index.php?wc_export_is_guest_exported=$matches[1]&feed=$matches[2]\";s:63:\"wc_export_is_guest_exported/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:66:\"index.php?wc_export_is_guest_exported=$matches[1]&feed=$matches[2]\";s:44:\"wc_export_is_guest_exported/([^/]+)/embed/?$\";s:60:\"index.php?wc_export_is_guest_exported=$matches[1]&embed=true\";s:56:\"wc_export_is_guest_exported/([^/]+)/page/?([0-9]{1,})/?$\";s:67:\"index.php?wc_export_is_guest_exported=$matches[1]&paged=$matches[2]\";s:38:\"wc_export_is_guest_exported/([^/]+)/?$\";s:49:\"index.php?wc_export_is_guest_exported=$matches[1]\";s:67:\"wc_export_is_user_exported/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:65:\"index.php?wc_export_is_user_exported=$matches[1]&feed=$matches[2]\";s:62:\"wc_export_is_user_exported/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:65:\"index.php?wc_export_is_user_exported=$matches[1]&feed=$matches[2]\";s:43:\"wc_export_is_user_exported/([^/]+)/embed/?$\";s:59:\"index.php?wc_export_is_user_exported=$matches[1]&embed=true\";s:55:\"wc_export_is_user_exported/([^/]+)/page/?([0-9]{1,})/?$\";s:66:\"index.php?wc_export_is_user_exported=$matches[1]&paged=$matches[2]\";s:37:\"wc_export_is_user_exported/([^/]+)/?$\";s:48:\"index.php?wc_export_is_user_exported=$matches[1]\";s:55:\"product-category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:50:\"product-category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:31:\"product-category/(.+?)/embed/?$\";s:44:\"index.php?product_cat=$matches[1]&embed=true\";s:43:\"product-category/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_cat=$matches[1]&paged=$matches[2]\";s:25:\"product-category/(.+?)/?$\";s:33:\"index.php?product_cat=$matches[1]\";s:52:\"product-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:47:\"product-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:28:\"product-tag/([^/]+)/embed/?$\";s:44:\"index.php?product_tag=$matches[1]&embed=true\";s:40:\"product-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_tag=$matches[1]&paged=$matches[2]\";s:22:\"product-tag/([^/]+)/?$\";s:33:\"index.php?product_tag=$matches[1]\";s:35:\"product/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"product/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"product/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"product/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"product/([^/]+)/embed/?$\";s:40:\"index.php?product=$matches[1]&embed=true\";s:28:\"product/([^/]+)/trackback/?$\";s:34:\"index.php?product=$matches[1]&tb=1\";s:48:\"product/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:43:\"product/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:36:\"product/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&paged=$matches[2]\";s:43:\"product/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&cpage=$matches[2]\";s:44:\"product/([^/]+)/wc/file/transient(/(.*))?/?$\";s:59:\"index.php?product=$matches[1]&wc/file/transient=$matches[3]\";s:33:\"product/([^/]+)/wc-api(/(.*))?/?$\";s:48:\"index.php?product=$matches[1]&wc-api=$matches[3]\";s:50:\"product/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:61:\"product/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:39:\"product/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"product/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:32:\"product/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?product=$matches[1]&page=$matches[2]\";s:24:\"product/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"product/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"product/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"product/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:43:\"gf_live_preview/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:53:\"gf_live_preview/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:73:\"gf_live_preview/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"gf_live_preview/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"gf_live_preview/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:49:\"gf_live_preview/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"gf_live_preview/([^/]+)/embed/?$\";s:48:\"index.php?gf_live_preview=$matches[1]&embed=true\";s:36:\"gf_live_preview/([^/]+)/trackback/?$\";s:42:\"index.php?gf_live_preview=$matches[1]&tb=1\";s:56:\"gf_live_preview/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?gf_live_preview=$matches[1]&feed=$matches[2]\";s:51:\"gf_live_preview/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?gf_live_preview=$matches[1]&feed=$matches[2]\";s:44:\"gf_live_preview/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?gf_live_preview=$matches[1]&paged=$matches[2]\";s:51:\"gf_live_preview/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?gf_live_preview=$matches[1]&cpage=$matches[2]\";s:52:\"gf_live_preview/([^/]+)/wc/file/transient(/(.*))?/?$\";s:67:\"index.php?gf_live_preview=$matches[1]&wc/file/transient=$matches[3]\";s:41:\"gf_live_preview/([^/]+)/wc-api(/(.*))?/?$\";s:56:\"index.php?gf_live_preview=$matches[1]&wc-api=$matches[3]\";s:58:\"gf_live_preview/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:69:\"gf_live_preview/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:47:\"gf_live_preview/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:58:\"gf_live_preview/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:40:\"gf_live_preview/([^/]+)(?:/([0-9]+))?/?$\";s:54:\"index.php?gf_live_preview=$matches[1]&page=$matches[2]\";s:32:\"gf_live_preview/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"gf_live_preview/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"gf_live_preview/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"gf_live_preview/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"gf_live_preview/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"gf_live_preview/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:12:\"sitemap\\.xml\";s:24:\"index.php??sitemap=index\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:41:\"index.php?&page_id=2897&cpage=$matches[1]\";s:28:\"wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:17:\"wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:37:\"comments/wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:26:\"comments/wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:40:\"search/(.+)/wc/file/transient(/(.*))?/?$\";s:53:\"index.php?s=$matches[1]&wc/file/transient=$matches[3]\";s:29:\"search/(.+)/wc-api(/(.*))?/?$\";s:42:\"index.php?s=$matches[1]&wc-api=$matches[3]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:43:\"author/([^/]+)/wc/file/transient(/(.*))?/?$\";s:63:\"index.php?author_name=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"author/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?author_name=$matches[1]&wc-api=$matches[3]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:93:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc/file/transient=$matches[5]\";s:54:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:82:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc-api=$matches[5]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:52:\"([0-9]{4})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:77:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc/file/transient=$matches[4]\";s:41:\"([0-9]{4})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:66:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc-api=$matches[4]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:39:\"([0-9]{4})/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?year=$matches[1]&wc/file/transient=$matches[3]\";s:28:\"([0-9]{4})/wc-api(/(.*))?/?$\";s:45:\"index.php?year=$matches[1]&wc-api=$matches[3]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:36:\"(.?.+?)/wc/file/transient(/(.*))?/?$\";s:60:\"index.php?pagename=$matches[1]&wc/file/transient=$matches[3]\";s:25:\"(.?.+?)/wc-api(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&wc-api=$matches[3]\";s:28:\"(.?.+?)/order-pay(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&order-pay=$matches[3]\";s:33:\"(.?.+?)/order-received(/(.*))?/?$\";s:57:\"index.php?pagename=$matches[1]&order-received=$matches[3]\";s:25:\"(.?.+?)/orders(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&orders=$matches[3]\";s:29:\"(.?.+?)/view-order(/(.*))?/?$\";s:53:\"index.php?pagename=$matches[1]&view-order=$matches[3]\";s:28:\"(.?.+?)/downloads(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&downloads=$matches[3]\";s:31:\"(.?.+?)/edit-account(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-account=$matches[3]\";s:31:\"(.?.+?)/edit-address(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-address=$matches[3]\";s:34:\"(.?.+?)/payment-methods(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&payment-methods=$matches[3]\";s:32:\"(.?.+?)/lost-password(/(.*))?/?$\";s:56:\"index.php?pagename=$matches[1]&lost-password=$matches[3]\";s:34:\"(.?.+?)/customer-logout(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&customer-logout=$matches[3]\";s:37:\"(.?.+?)/add-payment-method(/(.*))?/?$\";s:61:\"index.php?pagename=$matches[1]&add-payment-method=$matches[3]\";s:40:\"(.?.+?)/delete-payment-method(/(.*))?/?$\";s:64:\"index.php?pagename=$matches[1]&delete-payment-method=$matches[3]\";s:45:\"(.?.+?)/set-default-payment-method(/(.*))?/?$\";s:69:\"index.php?pagename=$matches[1]&set-default-payment-method=$matches[3]\";s:42:\".?.+?/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:53:\".?.+?/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:31:\".?.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\".?.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:36:\"([^/]+)/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?name=$matches[1]&wc/file/transient=$matches[3]\";s:25:\"([^/]+)/wc-api(/(.*))?/?$\";s:45:\"index.php?name=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:53:\"[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:31:\"[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "yes");
INSERT INTO `won_options` VALUES("64939", "_transient_timeout_wc_block_product_filter_attribute_default_attribute", "1763631890", "off");
INSERT INTO `won_options` VALUES("64940", "_transient_wc_block_product_filter_attribute_default_attribute", "O:8:\"stdClass\":6:{s:12:\"attribute_id\";s:1:\"3\";s:14:\"attribute_name\";s:4:\"size\";s:15:\"attribute_label\";s:8:\"سایز\";s:14:\"attribute_type\";s:6:\"select\";s:17:\"attribute_orderby\";s:10:\"menu_order\";s:16:\"attribute_public\";i:0;}", "off");
INSERT INTO `won_options` VALUES("64941", "_transient_doing_cron", "1763545553.9074780941009521484375", "on");
INSERT INTO `won_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `won_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `won_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `won_options` VALUES("33", "active_plugins", "a:20:{i:0;s:47:\"woo-order-export-lite/woo-order-export-lite.php\";i:1;s:56:\"woo-checkout-field-editor-pro/checkout-form-designer.php\";i:2;s:33:\"classic-editor/classic-editor.php\";i:3;s:36:\"contact-form-7/wp-contact-form-7.php\";i:5;s:25:\"duplicator/duplicator.php\";i:6;s:23:\"elementor/elementor.php\";i:7;s:31:\"elementor-pro/elementor-pro.php\";i:8;s:29:\"gravityforms/gravityforms.php\";i:9;s:41:\"image-optimization/image-optimization.php\";i:10;s:52:\"mobile-address-bar-color-changer/addressbarcolor.php\";i:11;s:21:\"safe-svg/safe-svg.php\";i:12;s:27:\"woocommerce/woocommerce.php\";i:13;s:85:\"woocommerce-advanced-shipping-packages/advanced-shipping-packages-for-woocommerce.php\";i:14;s:79:\"woocommerce-customer-order-csv-export/woocommerce-customer-order-csv-export.php\";i:15;s:31:\"woodmart-core/woodmart-core.php\";i:16;s:46:\"zarinpal-woocommerce-payment-gateway/index.php\";i:17;s:39:\"persian-elementor/persian-elementor.php\";i:18;s:43:\"persian-woocommerce/woocommerce-persian.php\";i:19;s:31:\"persian-gravity-forms/index.php\";i:20;s:25:\"duplicator/duplicator.php\";}", "yes");
INSERT INTO `won_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `won_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `won_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `won_options` VALUES("37", "gmt_offset", "", "yes");
INSERT INTO `won_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `won_options` VALUES("39", "recently_edited", "a:3:{i:0;s:96:\"/home2/abzarwpn/domains/abzarwp.net/public_html/newwood/wp-content/themes/woodmart/functions.php\";i:2;s:92:\"/home2/abzarwpn/domains/abzarwp.net/public_html/newwood/wp-content/themes/woodmart/style.css\";i:3;s:0:\"\";}", "no");
INSERT INTO `won_options` VALUES("40", "template", "woodmart", "yes");
INSERT INTO `won_options` VALUES("41", "stylesheet", "woodmart-child", "yes");
INSERT INTO `won_options` VALUES("42", "comment_registration", "0", "yes");
INSERT INTO `won_options` VALUES("43", "html_type", "text/html", "yes");
INSERT INTO `won_options` VALUES("44", "use_trackback", "0", "yes");
INSERT INTO `won_options` VALUES("45", "default_role", "subscriber", "yes");
INSERT INTO `won_options` VALUES("46", "db_version", "60421", "yes");
INSERT INTO `won_options` VALUES("47", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `won_options` VALUES("48", "upload_path", "", "yes");
INSERT INTO `won_options` VALUES("49", "blog_public", "0", "yes");
INSERT INTO `won_options` VALUES("50", "default_link_category", "2", "yes");
INSERT INTO `won_options` VALUES("51", "show_on_front", "page", "yes");
INSERT INTO `won_options` VALUES("52", "tag_base", "", "yes");
INSERT INTO `won_options` VALUES("53", "show_avatars", "1", "yes");
INSERT INTO `won_options` VALUES("54", "avatar_rating", "G", "yes");
INSERT INTO `won_options` VALUES("55", "upload_url_path", "", "yes");
INSERT INTO `won_options` VALUES("56", "thumbnail_size_w", "150", "yes");
INSERT INTO `won_options` VALUES("57", "thumbnail_size_h", "150", "yes");
INSERT INTO `won_options` VALUES("58", "thumbnail_crop", "1", "yes");
INSERT INTO `won_options` VALUES("59", "medium_size_w", "300", "yes");
INSERT INTO `won_options` VALUES("60", "medium_size_h", "300", "yes");
INSERT INTO `won_options` VALUES("61", "avatar_default", "mystery", "yes");
INSERT INTO `won_options` VALUES("62", "large_size_w", "1024", "yes");
INSERT INTO `won_options` VALUES("63", "large_size_h", "1024", "yes");
INSERT INTO `won_options` VALUES("64", "image_default_link_type", "none", "yes");
INSERT INTO `won_options` VALUES("65", "image_default_size", "", "yes");
INSERT INTO `won_options` VALUES("66", "image_default_align", "", "yes");
INSERT INTO `won_options` VALUES("67", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `won_options` VALUES("68", "close_comments_days_old", "14", "yes");
INSERT INTO `won_options` VALUES("69", "thread_comments", "1", "yes");
INSERT INTO `won_options` VALUES("70", "thread_comments_depth", "5", "yes");
INSERT INTO `won_options` VALUES("71", "page_comments", "0", "yes");
INSERT INTO `won_options` VALUES("72", "comments_per_page", "50", "yes");
INSERT INTO `won_options` VALUES("73", "default_comments_page", "newest", "yes");
INSERT INTO `won_options` VALUES("74", "comment_order", "asc", "yes");
INSERT INTO `won_options` VALUES("75", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `won_options` VALUES("76", "widget_categories", "a:4:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}i:8;a:1:{s:5:\"title\";s:10:\"Categories\";}i:6;a:4:{s:5:\"title\";s:22:\"دسته بندی ها\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `won_options` VALUES("77", "widget_text", "a:6:{i:11;a:1:{s:4:\"text\";s:711:\"\n<div class=\"footer-logo\" style=\"max-width: 80%; margin-bottom: 10px;\"><img src=\"http://dummy.xtemos.com/woodmart/wp-content/themes/woodmart/images/wood-logo-dark.svg\"  style=\"margin-bottom: 10px;\" /></div>\n<p>Condimentum adipiscing vel neque dis nam parturient orci at scelerisque neque dis nam parturient.</p>\n<div style=\"line-height: 2;\"><i class=\"fa fa-location-arrow\" style=\"width: 15px; text-align: center; margin-right: 4px;\"></i> 451 Wall Street, UK, London<br>\n<i class=\"fa fa-mobile\" style=\"width: 15px; text-align: center; margin-right: 4px;\"></i> Phone: (064) 332-1233<br>\n<i class=\"fa fa-envelope-o\" style=\"width: 15px; text-align: center; margin-right: 4px;\"></i> Fax: (099) 453-1357</div>\n		    	\";}i:14;a:2:{s:5:\"title\";s:12:\"Useful links\";s:4:\"text\";s:263:\"\n<ul class=\"menu\">\n<li><a href=\"#\">Privacy Policy</a></li>\n<li><a href=\"#\">Returns</a></li>\n<li><a href=\"#\">Terms &amp; Conditions</a></li>\n<li><a href=\"#\">Contact Us</a></li>\n<li><a href=\"#\">Latest News</a></li>\n<li><a href=\"#\">Our Sitemap</a></li>\n</ul>\n		    	\";}i:15;a:2:{s:5:\"title\";s:11:\"Footer Menu\";s:4:\"text\";s:309:\"\n<ul class=\"menu\">\n<li><a href=\"#\">Instagram profile</a></li>\n<li><a href=\"#\">New Collection</a></li>\n<li><a href=\"#\">Woman Dress</a></li>\n<li><a href=\"#\">Contact Us</a></li>\n<li><a href=\"#\">Latest News</a></li>\n<li><a href=\"#\" target=\"_blank\" style=\"font-style: italic;\">Purchase Theme</a></li>\n</ul>\n		    	\";}i:9;a:1:{s:4:\"text\";s:711:\"\n<div class=\"footer-logo\" style=\"max-width: 80%; margin-bottom: 10px;\"><img src=\"http://dummy.xtemos.com/woodmart/wp-content/themes/woodmart/images/wood-logo-dark.svg\"  style=\"margin-bottom: 10px;\" /></div>\n<p>Condimentum adipiscing vel neque dis nam parturient orci at scelerisque neque dis nam parturient.</p>\n<div style=\"line-height: 2;\"><i class=\"fa fa-location-arrow\" style=\"width: 15px; text-align: center; margin-right: 4px;\"></i> 451 Wall Street, UK, London<br>\n<i class=\"fa fa-mobile\" style=\"width: 15px; text-align: center; margin-right: 4px;\"></i> Phone: (064) 332-1233<br>\n<i class=\"fa fa-envelope-o\" style=\"width: 15px; text-align: center; margin-right: 4px;\"></i> Fax: (099) 453-1357</div>\n		    	\";}i:16;a:4:{s:5:\"title\";s:17:\"درباره ما\";s:4:\"text\";s:658:\"<p style=\"text-align: justify;\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است. چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است و برای شرایط فعلی تکنولوژی مورد نیاز و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد.لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.</p>\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `won_options` VALUES("78", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `won_options` VALUES("79", "uninstall_plugins", "a:3:{s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}s:49:\"better-delete-revision/better-delete-revision.php\";s:13:\"bdr_uninstall\";s:29:\"ar-contactus/ar-contactus.php\";s:20:\"arContactUsUninstall\";}", "no");
INSERT INTO `won_options` VALUES("80", "timezone_string", "Asia/Tehran", "yes");
INSERT INTO `won_options` VALUES("81", "page_for_posts", "378", "yes");
INSERT INTO `won_options` VALUES("82", "page_on_front", "2897", "yes");
INSERT INTO `won_options` VALUES("83", "default_post_format", "0", "yes");
INSERT INTO `won_options` VALUES("84", "link_manager_enabled", "0", "yes");
INSERT INTO `won_options` VALUES("85", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `won_options` VALUES("86", "site_icon", "4151", "yes");
INSERT INTO `won_options` VALUES("87", "medium_large_size_w", "768", "yes");
INSERT INTO `won_options` VALUES("88", "medium_large_size_h", "0", "yes");
INSERT INTO `won_options` VALUES("89", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `won_options` VALUES("90", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `won_options` VALUES("91", "admin_email_lifespan", "1778166813", "yes");
INSERT INTO `won_options` VALUES("92", "disallowed_keys", "", "no");
INSERT INTO `won_options` VALUES("93", "comment_previously_approved", "1", "yes");
INSERT INTO `won_options` VALUES("94", "auto_plugin_theme_update_emails", "a:0:{}", "no");
INSERT INTO `won_options` VALUES("95", "auto_update_core_dev", "enabled", "yes");
INSERT INTO `won_options` VALUES("96", "auto_update_core_minor", "enabled", "yes");
INSERT INTO `won_options` VALUES("97", "auto_update_core_major", "disabled", "no");
INSERT INTO `won_options` VALUES("98", "initial_db_version", "49752", "yes");
INSERT INTO `won_options` VALUES("99", "won_user_roles", "a:7:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:139:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:31:\"vc_access_rules_post_types/post\";b:1;s:31:\"vc_access_rules_post_types/page\";b:1;s:41:\"vc_access_rules_post_types/woodmart_slide\";b:1;s:46:\"vc_access_rules_post_types/woodmart_size_guide\";b:1;s:36:\"vc_access_rules_post_types/cms_block\";b:1;s:36:\"vc_access_rules_post_types/portfolio\";b:1;s:34:\"vc_access_rules_post_types/product\";b:1;s:26:\"vc_access_rules_post_types\";s:6:\"custom\";s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:24:\"vc_access_rules_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:26:\"create_notes_elementor-pro\";b:1;s:24:\"edit_notes_elementor-pro\";b:1;s:26:\"delete_notes_elementor-pro\";b:1;s:24:\"read_notes_elementor-pro\";b:1;s:31:\"edit_others_notes_elementor-pro\";b:1;s:33:\"delete_others_notes_elementor-pro\";b:1;s:39:\"read_others_private_notes_elementor-pro\";b:1;s:30:\"manage_woocommerce_csv_exports\";b:1;s:16:\"create_customers\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:94:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"edit_theme_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:30:\"manage_woocommerce_csv_exports\";b:1;s:16:\"create_customers\";b:1;}}}", "yes");
INSERT INTO `won_options` VALUES("100", "fresh_site", "0", "off");
INSERT INTO `won_options` VALUES("101", "WPLANG", "fa_IR", "yes");
INSERT INTO `won_options` VALUES("102", "widget_search", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `won_options` VALUES("103", "widget_recent-posts", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `won_options` VALUES("104", "widget_recent-comments", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `won_options` VALUES("105", "widget_archives", "a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `won_options` VALUES("106", "widget_meta", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `won_options` VALUES("107", "sidebars_widgets", "a:12:{s:19:\"wp_inactive_widgets\";a:15:{i:0;s:10:\"archives-2\";i:1;s:6:\"meta-2\";i:2;s:8:\"search-2\";i:3;s:7:\"text-11\";i:4;s:6:\"text-9\";i:5;s:12:\"categories-2\";i:6;s:12:\"categories-8\";i:7;s:14:\"recent-posts-2\";i:8;s:17:\"recent-comments-2\";i:9;s:21:\"woodmart-instagram-10\";i:10;s:23:\"woodmart-recent-posts-9\";i:11;s:24:\"woodmart-recent-posts-12\";i:12;s:7:\"text-14\";i:13;s:7:\"text-15\";i:14;s:24:\"woodmart-recent-posts-10\";}s:9:\"sidebar-1\";a:3:{i:0;s:23:\"woodmart-recent-posts-7\";i:1;s:12:\"categories-6\";i:2;s:7:\"text-16\";}s:22:\"portfolio-widgets-area\";a:0:{}s:12:\"sidebar-shop\";a:4:{i:0;s:32:\"woocommerce_product_categories-1\";i:1;s:34:\"woodmart-woocommerce-layered-nav-4\";i:2;s:34:\"woodmart-woocommerce-layered-nav-3\";i:3;s:26:\"woocommerce_price_filter-2\";}s:12:\"filters-area\";a:0:{}s:22:\"sidebar-product-single\";a:2:{i:0;s:22:\"woocommerce_products-5\";i:1;s:23:\"woodmart-recent-posts-6\";}s:18:\"sidebar-my-account\";a:0:{}s:24:\"sidebar-full-screen-menu\";a:0:{}s:19:\"mobile-menu-widgets\";a:0:{}s:8:\"footer-1\";a:1:{i:0;s:21:\"woodmart-html-block-9\";}s:11:\"sidebar-408\";a:1:{i:0;s:23:\"woodmart-recent-posts-5\";}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `won_options` VALUES("108", "cron", "a:23:{i:1763101957;a:1:{s:28:\"wp_1_wc_privacy_cleanup_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:37:\"wp_1_wc_privacy_cleanup_cron_interval\";s:4:\"args\";a:0:{}s:8:\"interval\";i:300;}}}i:1763101992;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1763103363;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1763103649;a:1:{s:20:\"jetpack_clean_nonces\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1763103674;a:1:{s:33:\"wc_admin_process_orders_milestone\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1763103680;a:1:{s:29:\"wc_admin_unsnooze_admin_notes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1763105384;a:1:{s:29:\"gravity-error-ir_notify_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1763107249;a:1:{s:20:\"jetpack_v2_heartbeat\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1763111810;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1763113461;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1763118074;a:1:{s:14:\"wc_admin_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1763120265;a:4:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1763120581;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1763120584;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1763133209;a:1:{s:45:\"woocommerce_marketplace_cron_fetch_promotions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1763137696;a:1:{s:36:\"puc_cron_check_updates-elementor-pro\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1763141368;a:1:{s:40:\"woocommerce_marketplace_fetch_promotions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1763144906;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1763148447;a:1:{s:17:\"gravityforms_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1763375400;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1763379465;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1763404565;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "on");
INSERT INTO `won_options` VALUES("63985", "woocommerce_feature_reactify-classic-payments-settings_enabled", "yes", "auto");
INSERT INTO `won_options` VALUES("64580", "action_scheduler_migration_status", "complete", "auto");
INSERT INTO `won_options` VALUES("64581", "as_has_wp_comment_logs", "no", "on");
INSERT INTO `won_options` VALUES("64964", "_transient_elementor_remote_info_api_data_3.33.0", "a:4:{s:9:\"timestamp\";s:10:\"1763542918\";s:14:\"upgrade_notice\";a:3:{s:7:\"version\";s:5:\"2.0.0\";s:7:\"message\";s:0:\"\";s:11:\"update_link\";s:0:\"\";}s:11:\"pro_widgets\";a:82:{i:0;a:4:{s:4:\"name\";s:6:\"search\";s:5:\"title\";s:6:\"Search\";s:4:\"icon\";s:17:\"eicon-site-search\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:1;a:4:{s:4:\"name\";s:5:\"posts\";s:5:\"title\";s:5:\"Posts\";s:4:\"icon\";s:15:\"eicon-post-list\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:2;a:4:{s:4:\"name\";s:9:\"portfolio\";s:5:\"title\";s:9:\"Portfolio\";s:4:\"icon\";s:18:\"eicon-gallery-grid\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:3;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-2\";s:5:\"title\";s:7:\"Classic\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:4;a:4:{s:4:\"name\";s:9:\"mega-menu\";s:5:\"title\";s:4:\"Menu\";s:4:\"icon\";s:15:\"eicon-mega-menu\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:5;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-3\";s:5:\"title\";s:8:\"Showcase\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:6;a:4:{s:4:\"name\";s:4:\"form\";s:5:\"title\";s:4:\"Form\";s:4:\"icon\";s:21:\"eicon-form-horizontal\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:7;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-4\";s:5:\"title\";s:5:\"Links\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:8;a:4:{s:4:\"name\";s:9:\"loop-grid\";s:5:\"title\";s:9:\"Loop Grid\";s:4:\"icon\";s:18:\"eicon-loop-builder\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:9;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-5\";s:5:\"title\";s:8:\"Services\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:10;a:4:{s:4:\"name\";s:13:\"loop-carousel\";s:5:\"title\";s:13:\"Loop Carousel\";s:4:\"icon\";s:19:\"eicon-carousel-loop\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:11;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-6\";s:5:\"title\";s:9:\"Portfolio\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:12;a:4:{s:4:\"name\";s:7:\"gallery\";s:5:\"title\";s:7:\"Gallery\";s:4:\"icon\";s:23:\"eicon-gallery-justified\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:13;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-7\";s:5:\"title\";s:13:\"Business Card\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:14;a:4:{s:4:\"name\";s:17:\"animated-headline\";s:5:\"title\";s:17:\"Animated Headline\";s:4:\"icon\";s:23:\"eicon-animated-headline\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:15;a:4:{s:4:\"name\";s:10:\"price-list\";s:5:\"title\";s:10:\"Price List\";s:4:\"icon\";s:16:\"eicon-price-list\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:16;a:4:{s:4:\"name\";s:11:\"price-table\";s:5:\"title\";s:11:\"Price Table\";s:4:\"icon\";s:17:\"eicon-price-table\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:17;a:4:{s:4:\"name\";s:8:\"flip-box\";s:5:\"title\";s:8:\"Flip Box\";s:4:\"icon\";s:14:\"eicon-flip-box\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:18;a:4:{s:4:\"name\";s:14:\"call-to-action\";s:5:\"title\";s:14:\"Call to Action\";s:4:\"icon\";s:20:\"eicon-image-rollover\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:19;a:4:{s:4:\"name\";s:14:\"media-carousel\";s:5:\"title\";s:14:\"Media Carousel\";s:4:\"icon\";s:20:\"eicon-media-carousel\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:20;a:4:{s:4:\"name\";s:15:\"nested-carousel\";s:5:\"title\";s:8:\"Carousel\";s:4:\"icon\";s:21:\"eicon-nested-carousel\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:21;a:4:{s:4:\"name\";s:10:\"off-canvas\";s:5:\"title\";s:10:\"Off-Canvas\";s:4:\"icon\";s:16:\"eicon-off-canvas\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:22;a:4:{s:4:\"name\";s:9:\"countdown\";s:5:\"title\";s:9:\"Countdown\";s:4:\"icon\";s:15:\"eicon-countdown\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:23;a:4:{s:4:\"name\";s:13:\"share-buttons\";s:5:\"title\";s:13:\"Share Buttons\";s:4:\"icon\";s:11:\"eicon-share\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:24;a:4:{s:4:\"name\";s:10:\"blockquote\";s:5:\"title\";s:10:\"Blockquote\";s:4:\"icon\";s:16:\"eicon-blockquote\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:25;a:4:{s:4:\"name\";s:6:\"lottie\";s:5:\"title\";s:6:\"Lottie\";s:4:\"icon\";s:12:\"eicon-lottie\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:26;a:4:{s:4:\"name\";s:7:\"hotspot\";s:5:\"title\";s:7:\"Hotspot\";s:4:\"icon\";s:19:\"eicon-image-hotspot\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:27;a:4:{s:4:\"name\";s:13:\"paypal-button\";s:5:\"title\";s:13:\"PayPal Button\";s:4:\"icon\";s:19:\"eicon-paypal-button\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:28;a:4:{s:4:\"name\";s:14:\"code-highlight\";s:5:\"title\";s:14:\"Code Highlight\";s:4:\"icon\";s:20:\"eicon-code-highlight\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:29;a:4:{s:4:\"name\";s:14:\"video-playlist\";s:5:\"title\";s:14:\"Video Playlist\";s:4:\"icon\";s:20:\"eicon-video-playlist\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:30;a:4:{s:4:\"name\";s:8:\"template\";s:5:\"title\";s:8:\"Template\";s:4:\"icon\";s:19:\"eicon-document-file\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:31;a:4:{s:4:\"name\";s:13:\"stripe-button\";s:5:\"title\";s:13:\"Stripe Button\";s:4:\"icon\";s:19:\"eicon-stripe-button\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:32;a:4:{s:4:\"name\";s:16:\"progress-tracker\";s:5:\"title\";s:16:\"Progress Tracker\";s:4:\"icon\";s:22:\"eicon-progress-tracker\";s:10:\"categories\";s:40:\"[\"pro-elements\",\"theme-elements-single\"]\";}i:33;a:4:{s:4:\"name\";s:8:\"nav-menu\";s:5:\"title\";s:8:\"Nav Menu\";s:4:\"icon\";s:14:\"eicon-nav-menu\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:34;a:4:{s:4:\"name\";s:17:\"table-of-contents\";s:5:\"title\";s:17:\"Table of Contents\";s:4:\"icon\";s:23:\"eicon-table-of-contents\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:35;a:4:{s:4:\"name\";s:5:\"login\";s:5:\"title\";s:5:\"Login\";s:4:\"icon\";s:15:\"eicon-lock-user\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:36;a:4:{s:4:\"name\";s:6:\"slides\";s:5:\"title\";s:6:\"Slides\";s:4:\"icon\";s:12:\"eicon-slides\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:37;a:4:{s:4:\"name\";s:20:\"testimonial-carousel\";s:5:\"title\";s:20:\"Testimonial Carousel\";s:4:\"icon\";s:26:\"eicon-testimonial-carousel\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:38;a:4:{s:4:\"name\";s:7:\"reviews\";s:5:\"title\";s:7:\"Reviews\";s:4:\"icon\";s:12:\"eicon-review\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:39;a:4:{s:4:\"name\";s:15:\"facebook-button\";s:5:\"title\";s:15:\"Facebook Button\";s:4:\"icon\";s:23:\"eicon-facebook-like-box\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:40;a:4:{s:4:\"name\";s:17:\"facebook-comments\";s:5:\"title\";s:17:\"Facebook Comments\";s:4:\"icon\";s:23:\"eicon-facebook-comments\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:41;a:4:{s:4:\"name\";s:14:\"facebook-embed\";s:5:\"title\";s:14:\"Facebook Embed\";s:4:\"icon\";s:14:\"eicon-fb-embed\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:42;a:4:{s:4:\"name\";s:13:\"facebook-page\";s:5:\"title\";s:13:\"Facebook Page\";s:4:\"icon\";s:13:\"eicon-fb-feed\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:43;a:4:{s:4:\"name\";s:15:\"theme-site-logo\";s:5:\"title\";s:9:\"Site Logo\";s:4:\"icon\";s:15:\"eicon-site-logo\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:44;a:4:{s:4:\"name\";s:16:\"theme-site-title\";s:5:\"title\";s:10:\"Site Title\";s:4:\"icon\";s:16:\"eicon-site-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:45;a:4:{s:4:\"name\";s:16:\"theme-page-title\";s:5:\"title\";s:10:\"Page Title\";s:4:\"icon\";s:19:\"eicon-archive-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:46;a:4:{s:4:\"name\";s:16:\"theme-post-title\";s:5:\"title\";s:10:\"Post Title\";s:4:\"icon\";s:16:\"eicon-post-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:47;a:4:{s:4:\"name\";s:18:\"theme-post-excerpt\";s:5:\"title\";s:12:\"Post Excerpt\";s:4:\"icon\";s:18:\"eicon-post-excerpt\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:48;a:4:{s:4:\"name\";s:25:\"theme-post-featured-image\";s:5:\"title\";s:14:\"Featured Image\";s:4:\"icon\";s:20:\"eicon-featured-image\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:49;a:4:{s:4:\"name\";s:19:\"theme-archive-title\";s:5:\"title\";s:13:\"Archive Title\";s:4:\"icon\";s:19:\"eicon-archive-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:50;a:4:{s:4:\"name\";s:13:\"archive-posts\";s:5:\"title\";s:13:\"Archive Posts\";s:4:\"icon\";s:19:\"eicon-archive-posts\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:51;a:4:{s:4:\"name\";s:10:\"author-box\";s:5:\"title\";s:10:\"Author Box\";s:4:\"icon\";s:12:\"eicon-person\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:52;a:4:{s:4:\"name\";s:13:\"post-comments\";s:5:\"title\";s:13:\"Post Comments\";s:4:\"icon\";s:14:\"eicon-comments\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:53;a:4:{s:4:\"name\";s:15:\"post-navigation\";s:5:\"title\";s:15:\"Post Navigation\";s:4:\"icon\";s:21:\"eicon-post-navigation\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:54;a:4:{s:4:\"name\";s:9:\"post-info\";s:5:\"title\";s:9:\"Post Info\";s:4:\"icon\";s:15:\"eicon-post-info\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:55;a:4:{s:4:\"name\";s:7:\"sitemap\";s:5:\"title\";s:7:\"Sitemap\";s:4:\"icon\";s:13:\"eicon-sitemap\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:56;a:4:{s:4:\"name\";s:11:\"breadcrumbs\";s:5:\"title\";s:11:\"Breadcrumbs\";s:4:\"icon\";s:11:\"eicon-yoast\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:57;a:4:{s:4:\"name\";s:21:\"woocommerce-menu-cart\";s:5:\"title\";s:9:\"Menu Cart\";s:4:\"icon\";s:10:\"eicon-cart\";s:10:\"categories\";s:41:\"[\"theme-elements\",\"woocommerce-elements\"]\";}i:58;a:4:{s:4:\"name\";s:19:\"wc-archive-products\";s:5:\"title\";s:16:\"Archive Products\";s:4:\"icon\";s:14:\"eicon-products\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:59;a:4:{s:4:\"name\";s:31:\"woocommerce-archive-description\";s:5:\"title\";s:19:\"Archive Description\";s:4:\"icon\";s:25:\"eicon-product-description\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:60;a:4:{s:4:\"name\";s:20:\"woocommerce-products\";s:5:\"title\";s:8:\"Products\";s:4:\"icon\";s:14:\"eicon-products\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:61;a:4:{s:4:\"name\";s:22:\"woocommerce-breadcrumb\";s:5:\"title\";s:23:\"WooCommerce Breadcrumbs\";s:4:\"icon\";s:25:\"eicon-product-breadcrumbs\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:62;a:4:{s:4:\"name\";s:14:\"wc-add-to-cart\";s:5:\"title\";s:18:\"Custom Add To Cart\";s:4:\"icon\";s:17:\"eicon-woocommerce\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:63;a:4:{s:4:\"name\";s:11:\"wc-elements\";s:5:\"title\";s:17:\"WooCommerce Pages\";s:4:\"icon\";s:19:\"eicon-product-pages\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:64;a:4:{s:4:\"name\";s:13:\"wc-categories\";s:5:\"title\";s:18:\"Product Categories\";s:4:\"icon\";s:24:\"eicon-product-categories\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:65;a:4:{s:4:\"name\";s:25:\"woocommerce-product-title\";s:5:\"title\";s:13:\"Product Title\";s:4:\"icon\";s:19:\"eicon-product-title\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:66;a:4:{s:4:\"name\";s:26:\"woocommerce-product-images\";s:5:\"title\";s:14:\"Product Images\";s:4:\"icon\";s:20:\"eicon-product-images\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:67;a:4:{s:4:\"name\";s:25:\"woocommerce-product-price\";s:5:\"title\";s:13:\"Product Price\";s:4:\"icon\";s:19:\"eicon-product-price\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:68;a:4:{s:4:\"name\";s:31:\"woocommerce-product-add-to-cart\";s:5:\"title\";s:11:\"Add To Cart\";s:4:\"icon\";s:25:\"eicon-product-add-to-cart\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:69;a:4:{s:4:\"name\";s:26:\"woocommerce-product-rating\";s:5:\"title\";s:14:\"Product Rating\";s:4:\"icon\";s:20:\"eicon-product-rating\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:70;a:4:{s:4:\"name\";s:25:\"woocommerce-product-stock\";s:5:\"title\";s:13:\"Product Stock\";s:4:\"icon\";s:19:\"eicon-product-stock\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:71;a:4:{s:4:\"name\";s:24:\"woocommerce-product-meta\";s:5:\"title\";s:12:\"Product Meta\";s:4:\"icon\";s:18:\"eicon-product-meta\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:72;a:4:{s:4:\"name\";s:37:\"woocommerce-product-short-description\";s:5:\"title\";s:17:\"Short Description\";s:4:\"icon\";s:25:\"eicon-product-description\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:73;a:4:{s:4:\"name\";s:29:\"woocommerce-product-data-tabs\";s:5:\"title\";s:17:\"Product Data Tabs\";s:4:\"icon\";s:18:\"eicon-product-tabs\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:74;a:4:{s:4:\"name\";s:42:\"woocommerce-product-additional-information\";s:5:\"title\";s:22:\"Additional Information\";s:4:\"icon\";s:19:\" eicon-product-info\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:75;a:4:{s:4:\"name\";s:27:\"woocommerce-product-related\";s:5:\"title\";s:15:\"Product Related\";s:4:\"icon\";s:21:\"eicon-product-related\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:76;a:4:{s:4:\"name\";s:26:\"woocommerce-product-upsell\";s:5:\"title\";s:7:\"Upsells\";s:4:\"icon\";s:20:\"eicon-product-upsell\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:77;a:4:{s:4:\"name\";s:25:\"woocommerce-checkout-page\";s:5:\"title\";s:8:\"Checkout\";s:4:\"icon\";s:14:\"eicon-checkout\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:78;a:4:{s:4:\"name\";s:16:\"woocommerce-cart\";s:5:\"title\";s:4:\"Cart\";s:4:\"icon\";s:14:\"eicon-woo-cart\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:79;a:4:{s:4:\"name\";s:22:\"woocommerce-my-account\";s:5:\"title\";s:10:\"My Account\";s:4:\"icon\";s:16:\"eicon-my-account\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:80;a:4:{s:4:\"name\";s:28:\"woocommerce-purchase-summary\";s:5:\"title\";s:16:\"Purchase Summary\";s:4:\"icon\";s:22:\"eicon-purchase-summary\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:81;a:4:{s:4:\"name\";s:19:\"woocommerce-notices\";s:5:\"title\";s:19:\"WooCommerce Notices\";s:4:\"icon\";s:25:\"eicon-woocommerce-notices\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}}s:17:\"canary_deployment\";a:2:{s:11:\"plugin_info\";a:11:{s:2:\"id\";s:23:\"w.org/plugins/elementor\";s:4:\"slug\";s:9:\"elementor\";s:6:\"plugin\";s:23:\"elementor/elementor.php\";s:11:\"new_version\";s:5:\"3.6.0\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.0.zip\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/elementor/\";s:5:\"icons\";a:3:{s:2:\"2x\";s:62:\"https://ps.w.org/elementor/assets/icon-256x256.png?rev=1427768\";s:2:\"1x\";s:54:\"https://ps.w.org/elementor/assets/icon.svg?rev=1426809\";s:3:\"svg\";s:54:\"https://ps.w.org/elementor/assets/icon.svg?rev=1426809\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/elementor/assets/banner-1544x500.png?rev=1475479\";s:2:\"1x\";s:64:\"https://ps.w.org/elementor/assets/banner-772x250.png?rev=1475479\";}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:5:\"6.8.3\";s:12:\"requires_php\";s:3:\"5.6\";}s:10:\"conditions\";a:0:{}}}", "off");
INSERT INTO `won_options` VALUES("63863", "_site_transient_timeout_woocommerce_blocks_patterns", "1765693973", "off");
INSERT INTO `won_options` VALUES("63864", "_site_transient_woocommerce_blocks_patterns", "a:2:{s:7:\"version\";s:6:\"10.3.5\";s:8:\"patterns\";a:41:{i:0;a:11:{s:5:\"title\";s:6:\"Banner\";s:4:\"slug\";s:25:\"woocommerce-blocks/banner\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:10:\"banner.php\";}i:1;a:11:{s:5:\"title\";s:23:\"Coming Soon Entire Site\";s:4:\"slug\";s:35:\"woocommerce/coming-soon-entire-site\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:17:\"launch-your-store\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:27:\"coming-soon-entire-site.php\";}i:2;a:11:{s:5:\"title\";s:22:\"Coming Soon Store Only\";s:4:\"slug\";s:34:\"woocommerce/coming-soon-store-only\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:17:\"launch-your-store\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:26:\"coming-soon-store-only.php\";}i:3;a:11:{s:5:\"title\";s:11:\"Coming Soon\";s:4:\"slug\";s:23:\"woocommerce/coming-soon\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:17:\"launch-your-store\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:15:\"coming-soon.php\";}i:4;a:11:{s:5:\"title\";s:29:\"Content right with image left\";s:4:\"slug\";s:48:\"woocommerce-blocks/content-right-with-image-left\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, About\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:28:\"content-right-image-left.php\";}i:5;a:11:{s:5:\"title\";s:29:\"Featured Category Cover Image\";s:4:\"slug\";s:48:\"woocommerce-blocks/featured-category-cover-image\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, Intro\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:33:\"featured-category-cover-image.php\";}i:6;a:11:{s:5:\"title\";s:24:\"Featured Category Triple\";s:4:\"slug\";s:43:\"woocommerce-blocks/featured-category-triple\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:28:\"featured-category-triple.php\";}i:7;a:11:{s:5:\"title\";s:12:\"Large Footer\";s:4:\"slug\";s:31:\"woocommerce-blocks/footer-large\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/footer\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:16:\"footer-large.php\";}i:8;a:11:{s:5:\"title\";s:23:\"Footer with Simple Menu\";s:4:\"slug\";s:37:\"woocommerce-blocks/footer-simple-menu\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/footer\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:22:\"footer-simple-menu.php\";}i:9;a:11:{s:5:\"title\";s:17:\"Footer with menus\";s:4:\"slug\";s:38:\"woocommerce-blocks/footer-with-3-menus\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/footer\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:23:\"footer-with-3-menus.php\";}i:10;a:11:{s:5:\"title\";s:28:\"Four Image Grid Content Left\";s:4:\"slug\";s:47:\"woocommerce-blocks/form-image-grid-content-left\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, About\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:32:\"four-image-grid-content-left.php\";}i:11;a:11:{s:5:\"title\";s:20:\"Centered Header Menu\";s:4:\"slug\";s:39:\"woocommerce-blocks/header-centered-menu\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/header\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:27:\"header-centered-pattern.php\";}i:12;a:11:{s:5:\"title\";s:23:\"Distraction Free Header\";s:4:\"slug\";s:42:\"woocommerce-blocks/header-distraction-free\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/header\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:27:\"header-distraction-free.php\";}i:13;a:11:{s:5:\"title\";s:16:\"Essential Header\";s:4:\"slug\";s:35:\"woocommerce-blocks/header-essential\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/header\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:20:\"header-essential.php\";}i:14;a:11:{s:5:\"title\";s:12:\"Large Header\";s:4:\"slug\";s:31:\"woocommerce-blocks/header-large\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/header\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:16:\"header-large.php\";}i:15;a:11:{s:5:\"title\";s:14:\"Minimal Header\";s:4:\"slug\";s:33:\"woocommerce-blocks/header-minimal\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/header\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:18:\"header-minimal.php\";}i:16;a:11:{s:5:\"title\";s:47:\"Heading with three columns of content with link\";s:4:\"slug\";s:66:\"woocommerce-blocks/heading-with-three-columns-of-content-with-link\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:21:\"WooCommerce, Services\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:51:\"heading-with-three-columns-of-content-with-link.php\";}i:17;a:11:{s:5:\"title\";s:20:\"Hero Product 3 Split\";s:4:\"slug\";s:39:\"woocommerce-blocks/hero-product-3-split\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:24:\"hero-product-3-split.php\";}i:18;a:11:{s:5:\"title\";s:23:\"Hero Product Chessboard\";s:4:\"slug\";s:42:\"woocommerce-blocks/hero-product-chessboard\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:27:\"hero-product-chessboard.php\";}i:19;a:11:{s:5:\"title\";s:18:\"Hero Product Split\";s:4:\"slug\";s:37:\"woocommerce-blocks/hero-product-split\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, Intro\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:22:\"hero-product-split.php\";}i:20;a:11:{s:5:\"title\";s:33:\"Centered content with image below\";s:4:\"slug\";s:52:\"woocommerce-blocks/centered-content-with-image-below\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, Intro\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:43:\"intro-centered-content-with-image-below.php\";}i:21;a:11:{s:5:\"title\";s:22:\"Just Arrived Full Hero\";s:4:\"slug\";s:41:\"woocommerce-blocks/just-arrived-full-hero\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, Intro\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:26:\"just-arrived-full-hero.php\";}i:22;a:11:{s:5:\"title\";s:33:\"No Products Found - Clear Filters\";s:4:\"slug\";s:43:\"woocommerce/no-products-found-clear-filters\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:2:\"no\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:29:\"no-products-found-filters.php\";}i:23;a:11:{s:5:\"title\";s:17:\"No Products Found\";s:4:\"slug\";s:29:\"woocommerce/no-products-found\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:2:\"no\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:21:\"no-products-found.php\";}i:24;a:11:{s:5:\"title\";s:19:\"Default Coming Soon\";s:4:\"slug\";s:36:\"woocommerce/page-coming-soon-default\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:28:\"page-coming-soon-default.php\";}i:25;a:11:{s:5:\"title\";s:25:\"Coming Soon Image Gallery\";s:4:\"slug\";s:42:\"woocommerce/page-coming-soon-image-gallery\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:34:\"page-coming-soon-image-gallery.php\";}i:26;a:11:{s:5:\"title\";s:30:\"Coming Soon Minimal Left Image\";s:4:\"slug\";s:47:\"woocommerce/page-coming-soon-minimal-left-image\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:39:\"page-coming-soon-minimal-left-image.php\";}i:27;a:11:{s:5:\"title\";s:24:\"Coming Soon Modern Black\";s:4:\"slug\";s:41:\"woocommerce/page-coming-soon-modern-black\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:33:\"page-coming-soon-modern-black.php\";}i:28;a:11:{s:5:\"title\";s:29:\"Coming Soon Split Right Image\";s:4:\"slug\";s:46:\"woocommerce/page-coming-soon-split-right-image\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:38:\"page-coming-soon-split-right-image.php\";}i:29;a:11:{s:5:\"title\";s:34:\"Coming Soon With Header and Footer\";s:4:\"slug\";s:47:\"woocommerce/page-coming-soon-with-header-footer\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:39:\"page-coming-soon-with-header-footer.php\";}i:30;a:11:{s:5:\"title\";s:28:\"Product Collection 3 Columns\";s:4:\"slug\";s:47:\"woocommerce-blocks/product-collection-3-columns\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:32:\"product-collection-3-columns.php\";}i:31;a:11:{s:5:\"title\";s:28:\"Product Collection 4 Columns\";s:4:\"slug\";s:47:\"woocommerce-blocks/product-collection-4-columns\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:32:\"product-collection-4-columns.php\";}i:32;a:11:{s:5:\"title\";s:28:\"Product Collection 5 Columns\";s:4:\"slug\";s:47:\"woocommerce-blocks/product-collection-5-columns\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:32:\"product-collection-5-columns.php\";}i:33;a:11:{s:5:\"title\";s:47:\"Product Collection: Featured Products 5 Columns\";s:4:\"slug\";s:65:\"woocommerce-blocks/product-collection-featured-products-5-columns\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:50:\"product-collection-featured-products-5-columns.php\";}i:34;a:11:{s:5:\"title\";s:15:\"Product Gallery\";s:4:\"slug\";s:48:\"woocommerce-blocks/product-query-product-gallery\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:36:\"core/query/woocommerce/product-query\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:33:\"product-query-product-gallery.php\";}i:35;a:11:{s:5:\"title\";s:14:\"Product Search\";s:4:\"slug\";s:31:\"woocommerce/product-search-form\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:2:\"no\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:23:\"product-search-form.php\";}i:36;a:11:{s:5:\"title\";s:16:\"Related Products\";s:4:\"slug\";s:35:\"woocommerce-blocks/related-products\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:20:\"related-products.php\";}i:37;a:11:{s:5:\"title\";s:33:\"Social: Follow us on social media\";s:4:\"slug\";s:51:\"woocommerce-blocks/social-follow-us-in-social-media\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:25:\"WooCommerce, social-media\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:36:\"social-follow-us-in-social-media.php\";}i:38;a:11:{s:5:\"title\";s:22:\"Testimonials 3 Columns\";s:4:\"slug\";s:41:\"woocommerce-blocks/testimonials-3-columns\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:20:\"WooCommerce, Reviews\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:26:\"testimonials-3-columns.php\";}i:39;a:11:{s:5:\"title\";s:19:\"Testimonials Single\";s:4:\"slug\";s:38:\"woocommerce-blocks/testimonials-single\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:20:\"WooCommerce, Reviews\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:23:\"testimonials-single.php\";}i:40;a:11:{s:5:\"title\";s:37:\"Three columns with images and content\";s:4:\"slug\";s:56:\"woocommerce-blocks/three-columns-with-images-and-content\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:21:\"WooCommerce, Services\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:41:\"three-columns-with-images-and-content.php\";}}}", "off");
INSERT INTO `won_options` VALUES("63799", "_transient_GFCache_3afa4e9e2a817da93e285199f3d00252", "a:1:{s:17:\"gravityforms_cron\";a:3:{i:0;i:1763101978;i:1;i:1762630050;i:2;i:1762614658;}}", "on");
INSERT INTO `won_options` VALUES("63800", "gf_last_telemetry_run", "1762614658", "auto");
INSERT INTO `won_options` VALUES("63801", "gf_telemetry_data", "a:2:{s:8:\"snapshot\";O:64:\"Gravity_Forms\\Gravity_Forms\\Telemetry\\GF_Telemetry_Snapshot_Data\":3:{s:4:\"data\";a:31:{s:3:\"key\";s:32:\"B5E0B5F8DD8689E6ACA49DD6E6E1A930\";s:10:\"wp_version\";s:3:\"6.7\";s:11:\"php_version\";s:6:\"8.2.29\";s:13:\"mysql_version\";s:7:\"10.6.24\";s:7:\"plugins\";a:20:{i:0;a:4:{s:4:\"name\";s:37:\"Advanced Order Export For WooCommerce\";s:4:\"slug\";s:21:\"woo-order-export-lite\";s:7:\"version\";s:5:\"3.5.6\";s:9:\"is_active\";b:1;}i:1;a:4:{s:4:\"name\";s:37:\"Checkout Field Editor for WooCommerce\";s:4:\"slug\";s:29:\"woo-checkout-field-editor-pro\";s:7:\"version\";s:5:\"2.0.6\";s:9:\"is_active\";b:1;}i:2;a:4:{s:4:\"name\";s:14:\"Classic Editor\";s:4:\"slug\";s:14:\"classic-editor\";s:7:\"version\";s:5:\"1.6.5\";s:9:\"is_active\";b:1;}i:3;a:4:{s:4:\"name\";s:14:\"Contact Form 7\";s:4:\"slug\";s:14:\"contact-form-7\";s:7:\"version\";s:3:\"6.0\";s:9:\"is_active\";b:1;}i:4;a:4:{s:4:\"name\";s:28:\"Contact Us all-in-one button\";s:4:\"slug\";s:12:\"ar-contactus\";s:7:\"version\";s:5:\"2.2.8\";s:9:\"is_active\";b:1;}i:5;a:4:{s:4:\"name\";s:10:\"Duplicator\";s:4:\"slug\";s:10:\"duplicator\";s:7:\"version\";s:8:\"1.5.11.2\";s:9:\"is_active\";b:1;}i:6;a:4:{s:4:\"name\";s:9:\"Elementor\";s:4:\"slug\";s:9:\"elementor\";s:7:\"version\";s:6:\"3.25.6\";s:9:\"is_active\";b:1;}i:7;a:4:{s:4:\"name\";s:13:\"Elementor Pro\";s:4:\"slug\";s:13:\"elementor-pro\";s:7:\"version\";s:6:\"3.25.3\";s:9:\"is_active\";b:1;}i:8;a:4:{s:4:\"name\";s:13:\"Gravity Forms\";s:4:\"slug\";s:12:\"gravityforms\";s:7:\"version\";s:8:\"2.8.12.1\";s:9:\"is_active\";b:1;}i:9;a:4:{s:4:\"name\";s:54:\"Image Optimizer - Compress, Resize and Optimize Images\";s:4:\"slug\";s:18:\"image-optimization\";s:7:\"version\";s:5:\"1.5.4\";s:9:\"is_active\";b:1;}i:10;a:4:{s:4:\"name\";s:32:\"Mobile address bar color changer\";s:4:\"slug\";s:32:\"mobile-address-bar-color-changer\";s:7:\"version\";s:5:\"1.0.0\";s:9:\"is_active\";b:1;}i:11;a:4:{s:4:\"name\";s:8:\"Safe SVG\";s:4:\"slug\";s:8:\"safe-svg\";s:7:\"version\";s:5:\"2.2.6\";s:9:\"is_active\";b:1;}i:12;a:4:{s:4:\"name\";s:11:\"WooCommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:7:\"version\";s:5:\"9.4.1\";s:9:\"is_active\";b:1;}i:13;a:4:{s:4:\"name\";s:38:\"WooCommerce Advanced Shipping Packages\";s:4:\"slug\";s:38:\"woocommerce-advanced-shipping-packages\";s:7:\"version\";s:5:\"1.2.1\";s:9:\"is_active\";b:1;}i:14;a:4:{s:4:\"name\";s:40:\"WooCommerce Customer/Order/Coupon Export\";s:4:\"slug\";s:37:\"woocommerce-customer-order-csv-export\";s:7:\"version\";s:5:\"5.5.3\";s:9:\"is_active\";b:1;}i:15;a:4:{s:4:\"name\";s:13:\"Woodmart Core\";s:4:\"slug\";s:13:\"woodmart-core\";s:7:\"version\";s:6:\"1.0.35\";s:9:\"is_active\";b:1;}i:16;a:4:{s:4:\"name\";s:74:\"افزونه پرداخت امن زرین‌پال برای ووکامرس\";s:4:\"slug\";s:36:\"zarinpal-woocommerce-payment-gateway\";s:7:\"version\";s:5:\"4.9.3\";s:9:\"is_active\";b:1;}i:17;a:4:{s:4:\"name\";s:25:\"المنتور فارسی\";s:4:\"slug\";s:17:\"persian-elementor\";s:7:\"version\";s:7:\"2.7.6.7\";s:9:\"is_active\";b:1;}i:18;a:4:{s:4:\"name\";s:25:\"ووکامرس فارسی\";s:4:\"slug\";s:19:\"persian-woocommerce\";s:7:\"version\";s:5:\"9.0.1\";s:9:\"is_active\";b:1;}i:19;a:4:{s:4:\"name\";s:30:\"گرویتی فرم فارسی\";s:4:\"slug\";s:21:\"persian-gravity-forms\";s:7:\"version\";s:5:\"2.8.0\";s:9:\"is_active\";b:1;}}s:10:\"theme_name\";s:14:\"Woodmart Child\";s:9:\"theme_uri\";s:0:\"\";s:13:\"theme_version\";s:5:\"1.0.0\";s:12:\"theme_author\";s:6:\"XTemos\";s:16:\"theme_author_uri\";s:17:\"http://xtemos.com\";s:12:\"is_multisite\";b:0;s:11:\"total_forms\";i:1;s:13:\"total_entries\";s:1:\"0\";s:11:\"emails_sent\";i:0;s:9:\"api_calls\";i:0;s:16:\"entry_meta_count\";i:0;s:19:\"entry_details_count\";i:0;s:17:\"entry_notes_count\";i:0;s:4:\"lang\";s:5:\"fa_IR\";s:2:\"db\";s:7:\"MariaDB\";s:10:\"autoUpdate\";i:1;s:8:\"currency\";b:0;s:14:\"dataCollection\";i:0;s:5:\"email\";b:0;s:9:\"formTypes\";s:0:\"\";s:14:\"formTypesOther\";b:0;s:11:\"hideLicense\";i:0;s:12:\"organization\";b:0;s:17:\"organizationOther\";b:0;s:8:\"services\";s:0:\"\";s:13:\"servicesOther\";b:0;}s:3:\"key\";s:8:\"snapshot\";s:15:\"data_collection\";b:0;}s:6:\"events\";a:0:{}}", "off");
INSERT INTO `won_options` VALUES("63784", "_transient_jetpack_autoloader_plugin_paths", "a:1:{i:0;s:29:\"{{WP_PLUGIN_DIR}}/woocommerce\";}", "on");
INSERT INTO `won_options` VALUES("63785", "_transient_timeout_woocommerce_blocks_asset_api_script_data_ssl", "1766137506", "off");
INSERT INTO `won_options` VALUES("109", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `won_options` VALUES("110", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `won_options` VALUES("111", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `won_options` VALUES("112", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `won_options` VALUES("113", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `won_options` VALUES("114", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `won_options` VALUES("115", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `won_options` VALUES("116", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `won_options` VALUES("117", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `won_options` VALUES("119", "recovery_keys", "a:0:{}", "off");
INSERT INTO `won_options` VALUES("120", "https_detection_errors", "a:1:{s:23:\"ssl_verification_failed\";a:1:{i:0;s:35:\"تأیید SSL ناموفق بود.\";}}", "off");
INSERT INTO `won_options` VALUES("124", "theme_mods_twentytwentyone", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1616932971;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";}s:9:\"sidebar-2\";a:3:{i:0;s:10:\"archives-2\";i:1;s:12:\"categories-2\";i:2;s:6:\"meta-2\";}}}}", "off");
INSERT INTO `won_options` VALUES("147", "finished_updating_comment_type", "1", "yes");
INSERT INTO `won_options` VALUES("148", "current_theme", "Woodmart Child", "yes");
INSERT INTO `won_options` VALUES("149", "theme_mods_woodmart", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:2:{s:9:\"main-menu\";i:16;s:11:\"mobile-menu\";i:54;}s:18:\"custom_css_post_id\";i:3127;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1668073024;s:4:\"data\";a:14:{s:8:\"footer-3\";a:1:{i:0;s:7:\"text-13\";}s:8:\"footer-4\";a:1:{i:0;s:7:\"text-14\";}s:8:\"footer-5\";a:1:{i:0;s:7:\"text-15\";}s:8:\"footer-2\";a:1:{i:0;s:24:\"woodmart-recent-posts-10\";}s:19:\"wp_inactive_widgets\";a:12:{i:0;s:10:\"archives-2\";i:1;s:6:\"meta-2\";i:2;s:8:\"search-2\";i:3;s:7:\"text-11\";i:4;s:6:\"text-9\";i:5;s:12:\"categories-2\";i:6;s:12:\"categories-8\";i:7;s:14:\"recent-posts-2\";i:8;s:17:\"recent-comments-2\";i:9;s:21:\"woodmart-instagram-10\";i:10;s:23:\"woodmart-recent-posts-9\";i:11;s:24:\"woodmart-recent-posts-12\";}s:9:\"sidebar-1\";a:3:{i:0;s:23:\"woodmart-recent-posts-7\";i:1;s:12:\"categories-6\";i:2;s:7:\"text-16\";}s:12:\"sidebar-shop\";a:4:{i:0;s:32:\"woocommerce_product_categories-1\";i:1;s:34:\"woodmart-woocommerce-layered-nav-4\";i:2;s:34:\"woodmart-woocommerce-layered-nav-3\";i:3;s:26:\"woocommerce_price_filter-2\";}s:12:\"filters-area\";a:0:{}s:22:\"sidebar-product-single\";a:2:{i:0;s:22:\"woocommerce_products-5\";i:1;s:23:\"woodmart-recent-posts-6\";}s:18:\"sidebar-my-account\";a:0:{}s:24:\"sidebar-full-screen-menu\";a:0:{}s:19:\"mobile-menu-widgets\";a:0:{}s:8:\"footer-1\";a:1:{i:0;s:21:\"woodmart-html-block-9\";}s:11:\"sidebar-408\";a:1:{i:0;s:23:\"woodmart-recent-posts-5\";}}}}", "off");
INSERT INTO `won_options` VALUES("150", "theme_switched", "", "yes");
INSERT INTO `won_options` VALUES("153", "xts-default_header-css-data", "@media (min-width: 1025px) {\n	.whb-top-bar-inner {\n		height: 55px;\n	}\n	\n	.whb-general-header-inner {\n		height: 80px;\n	}\n	\n	.whb-header-bottom-inner {\n		height: 45px;\n	}\n	\n	.whb-sticked .whb-top-bar-inner {\n		height: 40px;\n	}\n	\n	.whb-sticked .whb-general-header-inner {\n		height: 60px;\n	}\n	\n	.whb-sticked .whb-header-bottom-inner {\n		height: 50px;\n	}\n	\n	/* HEIGHT OF HEADER CLONE */\n	.whb-clone .whb-general-header-inner {\n		height: 50px;\n	}\n	\n	/* HEADER OVERCONTENT */\n	.woodmart-header-overcontent .title-size-small {\n		padding-top: 201px;\n	}\n	\n	.woodmart-header-overcontent .title-size-default {\n		padding-top: 241px;\n	}\n	\n	.woodmart-header-overcontent .title-size-large {\n		padding-top: 281px;\n	}\n	\n	/* HEADER OVERCONTENT WHEN SHOP PAGE TITLE TURN OFF  */\n	.woodmart-header-overcontent .without-title.title-size-small {\n		padding-top: 181px;\n	}\n	\n	.woodmart-header-overcontent .without-title.title-size-default {\n		padding-top: 216px;\n	}\n	\n	.woodmart-header-overcontent .without-title.title-size-large {\n		padding-top: 241px;\n	}\n	\n	/* HEADER OVERCONTENT ON SINGLE PRODUCT */\n	.single-product .whb-overcontent:not(.whb-custom-header) {\n		padding-top: 181px;\n	}\n	\n	/* HEIGHT OF LOGO IN TOP BAR */\n	.whb-top-bar .woodmart-logo img {\n		max-height: 55px;\n	}\n	\n	.whb-sticked .whb-top-bar .woodmart-logo img {\n		max-height: 40px;\n	}\n	\n	/* HEIGHT OF LOGO IN GENERAL HEADER */\n	.whb-general-header .woodmart-logo img {\n		max-height: 80px;\n	}\n	\n	.whb-sticked .whb-general-header .woodmart-logo img {\n		max-height: 60px;\n	}\n	\n	/* HEIGHT OF LOGO IN BOTTOM HEADER */\n	.whb-header-bottom .woodmart-logo img {\n		max-height: 45px;\n	}\n	\n	.whb-sticked .whb-header-bottom .woodmart-logo img {\n		max-height: 50px;\n	}\n	\n	/* HEIGHT OF LOGO IN HEADER CLONE */\n	.whb-clone .whb-general-header .woodmart-logo img {\n		max-height: 50px;\n	}\n	\n	/* HEIGHT OF HEADER BUILDER ELEMENTS */\n	/* HEIGHT ELEMENTS IN TOP BAR */\n	.whb-top-bar .wd-tools-element > a,\n	.whb-top-bar .main-nav .item-level-0 > a,\n	.whb-top-bar .whb-secondary-menu .item-level-0 > a,\n	.whb-top-bar .categories-menu-opener,\n	.whb-top-bar .menu-opener,\n	.whb-top-bar .whb-divider-stretch:before,\n	.whb-top-bar form.woocommerce-currency-switcher-form .dd-selected,\n	.whb-top-bar .whb-text-element .wcml-dropdown a.wcml-cs-item-toggle {\n		height: 55px;\n	}\n	\n	.whb-sticked .whb-top-bar .wd-tools-element > a,\n	.whb-sticked .whb-top-bar .main-nav .item-level-0 > a,\n	.whb-sticked .whb-top-bar .whb-secondary-menu .item-level-0 > a,\n	.whb-sticked .whb-top-bar .categories-menu-opener,\n	.whb-sticked .whb-top-bar .menu-opener,\n	.whb-sticked .whb-top-bar .whb-divider-stretch:before,\n	.whb-sticked .whb-top-bar form.woocommerce-currency-switcher-form .dd-selected,\n	.whb-sticked .whb-top-bar .whb-text-element .wcml-dropdown a.wcml-cs-item-toggle {\n		height: 40px;\n	}\n	\n	/* HEIGHT ELEMENTS IN GENERAL HEADER */\n	.whb-general-header .whb-divider-stretch:before,\n	.whb-general-header .navigation-style-bordered .item-level-0 > a {\n		height: 80px;\n	}\n	\n	.whb-sticked:not(.whb-clone) .whb-general-header .whb-divider-stretch:before,\n	.whb-sticked:not(.whb-clone) .whb-general-header .navigation-style-bordered .item-level-0 > a {\n		height: 60px;\n	}\n	\n	.whb-sticked:not(.whb-clone) .whb-general-header .woodmart-search-dropdown,\n	.whb-sticked:not(.whb-clone) .whb-general-header .dropdown-cart,\n	.whb-sticked:not(.whb-clone) .whb-general-header .woodmart-navigation:not(.vertical-navigation):not(.navigation-style-bordered) .sub-menu-dropdown {\n		margin-top: 10px;\n	}\n	\n	.whb-sticked:not(.whb-clone) .whb-general-header .woodmart-search-dropdown:after,\n	.whb-sticked:not(.whb-clone) .whb-general-header .dropdown-cart:after,\n	.whb-sticked:not(.whb-clone) .whb-general-header .woodmart-navigation:not(.vertical-navigation):not(.navigation-style-bordered) .sub-menu-dropdown:after {\n		height: 10px;\n	}\n	\n	/* HEIGHT ELEMENTS IN BOTTOM HEADER */\n	.whb-header-bottom .wd-tools-element > a,\n	.whb-header-bottom .main-nav .item-level-0 > a,\n	.whb-header-bottom .whb-secondary-menu .item-level-0 > a,\n	.whb-header-bottom .categories-menu-opener,\n	.whb-header-bottom .menu-opener,\n	.whb-header-bottom .whb-divider-stretch:before,\n	.whb-header-bottom form.woocommerce-currency-switcher-form .dd-selected,\n	.whb-header-bottom .whb-text-element .wcml-dropdown a.wcml-cs-item-toggle {\n		height: 45px;\n	}\n	\n	.whb-header-bottom.whb-border-fullwidth .menu-opener {\n		height: 46px;\n		margin-top: -1px;\n		margin-bottom: -0px;\n	}\n	\n	.whb-header-bottom.whb-border-boxed .menu-opener {\n		height: 46px;\n		margin-top: -1px;\n		margin-bottom: -0px;\n	}\n	\n	.whb-sticked .whb-header-bottom .wd-tools-element > a,\n	.whb-sticked .whb-header-bottom .main-nav .item-level-0 > a,\n	.whb-sticked .whb-header-bottom .whb-secondary-menu .item-level-0 > a,\n	.whb-sticked .whb-header-bottom .categories-menu-opener,\n	.whb-sticked .whb-header-bottom .whb-divider-stretch:before,\n	.whb-sticked .whb-header-bottom form.woocommerce-currency-switcher-form .dd-selected,\n	.whb-sticked .whb-header-bottom .whb-text-element .wcml-dropdown a.wcml-cs-item-toggle {\n		height: 50px;\n	}\n	\n	.whb-sticked .whb-header-bottom.whb-border-fullwidth .menu-opener {\n		height: 51px;\n	}\n	\n	.whb-sticked .whb-header-bottom.whb-border-boxed .menu-opener {\n		height: 51px;\n	}\n	\n	.whb-sticky-shadow.whb-sticked .whb-header-bottom .menu-opener {\n		height: 51px;\n		margin-bottom:0;\n	}\n	\n	/* HEIGHT ELEMENTS IN HEADER CLONE */\n	.whb-clone .wd-tools-element > a,\n	.whb-clone .main-nav .item-level-0 > a,\n	.whb-clone .whb-secondary-menu .item-level-0 > a,\n	.whb-clone .categories-menu-opener,\n	.whb-clone .menu-opener,\n	.whb-clone .whb-divider-stretch:before,\n	.whb-clone .navigation-style-bordered .item-level-0 > a,\n	.whb-clone form.woocommerce-currency-switcher-form .dd-selected,\n	.whb-clone .whb-text-element .wcml-dropdown a.wcml-cs-item-toggle {\n		height: 50px;\n	}\n}\n\n@media (max-width: 1024px) {\n	.whb-top-bar-inner {\n		height: 40px;\n	}\n	\n	.whb-general-header-inner {\n		height: 60px;\n	}\n	\n	.whb-header-bottom-inner {\n		height: 0px;\n	}\n	\n	/* HEIGHT OF HEADER CLONE */\n	.whb-clone .whb-general-header-inner {\n		height: 60px;\n	}\n	\n	/* HEADER OVERCONTENT */\n	.woodmart-header-overcontent .page-title {\n		padding-top: 116px;\n	}\n	\n	/* HEADER OVERCONTENT WHEN SHOP PAGE TITLE TURN OFF  */\n	.woodmart-header-overcontent .without-title.title-shop {\n		padding-top: 101px;\n	}\n	\n	/* HEADER OVERCONTENT ON SINGLE PRODUCT */\n	.single-product .whb-overcontent:not(.whb-custom-header) {\n		padding-top: 101px;\n	}\n	\n	/* HEIGHT OF LOGO IN TOP BAR */\n	.whb-top-bar .woodmart-logo img {\n		max-height: 40px;\n	}\n	\n	/* HEIGHT OF LOGO IN GENERAL HEADER */\n	.whb-general-header .woodmart-logo img {\n		max-height: 60px;\n	}\n	\n	/* HEIGHT OF LOGO IN BOTTOM HEADER */\n	.whb-header-bottom .woodmart-logo img {\n		max-height: 0px;\n	}\n	\n	/* HEIGHT OF LOGO IN HEADER CLONE */\n	.whb-clone .whb-general-header .woodmart-logo img {\n		max-height: 60px;\n	}\n	\n	/* HEIGHT OF HEADER BULDER ELEMENTS */\n	/* HEIGHT ELEMENTS IN TOP BAR */\n	.whb-top-bar .wd-tools-element > a,\n	.whb-top-bar .main-nav .item-level-0 > a,\n	.whb-top-bar .whb-secondary-menu .item-level-0 > a,\n	.whb-top-bar .categories-menu-opener,\n	.whb-top-bar .whb-divider-stretch:before,\n	.whb-top-bar form.woocommerce-currency-switcher-form .dd-selected,\n	.whb-top-bar .whb-text-element .wcml-dropdown a.wcml-cs-item-toggle {\n		height: 40px;\n	}\n	\n	/* HEIGHT ELEMENTS IN GENERAL HEADER */\n	.whb-general-header .wd-tools-element > a,\n	.whb-general-header .main-nav .item-level-0 > a,\n	.whb-general-header .whb-secondary-menu .item-level-0 > a,\n	.whb-general-header .categories-menu-opener,\n	.whb-general-header .whb-divider-stretch:before,\n	.whb-general-header form.woocommerce-currency-switcher-form .dd-selected,\n	.whb-general-header .whb-text-element .wcml-dropdown a.wcml-cs-item-toggle {\n		height: 60px;\n	}\n	\n	/* HEIGHT ELEMENTS IN BOTTOM HEADER */\n	.whb-header-bottom .wd-tools-element > a,\n	.whb-header-bottom .main-nav .item-level-0 > a,\n	.whb-header-bottom .whb-secondary-menu .item-level-0 > a,\n	.whb-header-bottom .categories-menu-opener,\n	.whb-header-bottom .whb-divider-stretch:before,\n	.whb-header-bottom form.woocommerce-currency-switcher-form .dd-selected,\n	.whb-header-bottom .whb-text-element .wcml-dropdown a.wcml-cs-item-toggle {\n		height: 0px;\n	}\n	\n	/* HEIGHT ELEMENTS IN HEADER CLONE */\n	.whb-clone .wd-tools-element > a,\n	.whb-clone .main-nav .item-level-0 > a,\n	.whb-clone .whb-secondary-menu .item-level-0 > a,\n	.whb-clone .categories-menu-opener,\n	.whb-clone .menu-opener,\n	.whb-clone .whb-divider-stretch:before,\n	.whb-clone form.woocommerce-currency-switcher-form .dd-selected,\n	.whb-clone .whb-text-element .wcml-dropdown a.wcml-cs-item-toggle {\n		height: 60px;\n	}\n}\n\n.whb-top-bar {\n	background-color: rgba(255, 255, 255, 1);background-image: url(http://abzarwp.net/newwood/wp-content/uploads/2021/04/81880194f7c4fcd79c23820da5588927e5068c09_1612725894-scaled.jpg);background-size: cover;border-bottom-style: solid;\n}\n\n.whb-general-header {\n	border-color: rgba(129, 129, 129, 0.2);border-bottom-width: 1px;border-bottom-style: solid;\n}\n\n.whb-header-bottom {\n	border-bottom-style: solid;\n}\n", "yes");
INSERT INTO `won_options` VALUES("154", "xts-default_header-status", "valid", "yes");
INSERT INTO `won_options` VALUES("155", "xts-default_header-version", "5.3.6", "yes");
INSERT INTO `won_options` VALUES("156", "xts-default_header-site-url", "18137aad0927b9459667a39e1eddf460", "yes");
INSERT INTO `won_options` VALUES("450", "xts-woodmart-options", "a:562:{s:12:\"last_message\";s:4:\"save\";s:11:\"insta_token\";s:0:\"\";s:18:\"google_map_api_key\";s:0:\"\";s:9:\"fb_app_id\";s:0:\"\";s:13:\"fb_app_secret\";s:0:\"\";s:9:\"fb_notice\";s:0:\"\";s:10:\"goo_app_id\";s:0:\"\";s:14:\"goo_app_secret\";s:0:\"\";s:10:\"goo_notice\";s:0:\"\";s:9:\"vk_app_id\";s:0:\"\";s:13:\"vk_app_secret\";s:0:\"\";s:9:\"vk_notice\";s:0:\"\";s:15:\"alt_auth_method\";s:1:\"0\";s:9:\"ajax_shop\";s:1:\"1\";s:11:\"ajax_scroll\";s:1:\"1\";s:21:\"shop_page_breadcrumbs\";s:1:\"1\";s:17:\"cat_desc_position\";s:6:\"before\";s:14:\"products_hover\";s:4:\"base\";s:23:\"base_hover_mobile_click\";s:1:\"0\";s:22:\"products_bordered_grid\";s:1:\"1\";s:28:\"products_bordered_grid_style\";s:7:\"outside\";s:23:\"stretch_product_desktop\";s:1:\"0\";s:22:\"stretch_product_tablet\";s:1:\"0\";s:22:\"stretch_product_mobile\";s:1:\"0\";s:25:\"product_title_lines_limit\";s:4:\"none\";s:22:\"show_empty_star_rating\";s:1:\"0\";s:11:\"hover_image\";s:1:\"1\";s:16:\"product_quantity\";s:1:\"0\";s:18:\"base_hover_content\";s:7:\"excerpt\";s:21:\"stock_status_position\";s:9:\"thumbnail\";s:23:\"grid_stock_progress_bar\";s:1:\"1\";s:14:\"shop_countdown\";s:1:\"0\";s:22:\"categories_under_title\";s:1:\"0\";s:18:\"brands_under_title\";s:1:\"0\";s:15:\"sku_under_title\";s:1:\"0\";s:17:\"categories_design\";s:7:\"default\";s:23:\"categories_color_scheme\";s:7:\"default\";s:22:\"categories_with_shadow\";s:6:\"enable\";s:29:\"hide_categories_product_count\";s:1:\"0\";s:11:\"shop_layout\";s:12:\"sidebar-left\";s:18:\"shop_sidebar_width\";s:1:\"3\";s:25:\"shop_hide_sidebar_desktop\";s:1:\"0\";s:24:\"shop_hide_sidebar_tablet\";s:1:\"1\";s:17:\"shop_hide_sidebar\";s:1:\"1\";s:20:\"sticky_filter_button\";s:1:\"0\";s:10:\"shop_title\";s:1:\"1\";s:15:\"shop_categories\";s:1:\"1\";s:25:\"shop_categories_ancestors\";s:1:\"0\";s:25:\"show_categories_neighbors\";s:1:\"0\";s:19:\"shop_products_count\";s:1:\"1\";s:37:\"shop_page_title_hide_empty_categories\";s:1:\"0\";s:34:\"shop_page_title_categories_exclude\";s:0:\"\";s:9:\"shop_view\";s:9:\"grid_list\";s:16:\"products_columns\";s:1:\"4\";s:23:\"products_columns_tablet\";s:4:\"auto\";s:23:\"products_columns_mobile\";s:1:\"2\";s:16:\"products_spacing\";s:2:\"20\";s:24:\"per_row_columns_selector\";s:1:\"1\";s:27:\"products_columns_variations\";a:3:{i:0;s:1:\"2\";i:1;s:1:\"3\";i:2;s:1:\"4\";}s:16:\"products_masonry\";s:1:\"0\";s:24:\"products_different_sizes\";s:1:\"0\";s:13:\"shop_per_page\";s:2:\"12\";s:14:\"per_page_links\";s:1:\"1\";s:16:\"per_page_options\";s:7:\"9,24,36\";s:15:\"shop_pagination\";s:10:\"pagination\";s:25:\"load_more_button_page_url\";s:1:\"1\";s:17:\"categories_toggle\";s:1:\"1\";s:14:\"widgets_scroll\";s:1:\"1\";s:14:\"widget_heights\";s:3:\"280\";s:21:\"shop_widgets_collapse\";s:7:\"disable\";s:12:\"shop_filters\";s:1:\"0\";s:17:\"shop_filters_type\";s:7:\"widgets\";s:20:\"shop_filters_content\";s:4:\"2145\";s:24:\"shop_filters_always_open\";s:1:\"0\";s:18:\"shop_filters_close\";s:1:\"0\";s:14:\"default_header\";s:13:\"header_855638\";s:14:\"sticky_toolbar\";s:1:\"1\";s:20:\"sticky_toolbar_label\";s:1:\"1\";s:21:\"sticky_toolbar_fields\";a:5:{i:0;s:4:\"shop\";i:1;s:7:\"sidebar\";i:2;s:8:\"wishlist\";i:3;s:4:\"cart\";i:4;s:7:\"account\";}s:10:\"link_1_url\";s:0:\"\";s:11:\"link_1_text\";s:0:\"\";s:11:\"link_1_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_2_url\";s:0:\"\";s:11:\"link_2_text\";s:0:\"\";s:11:\"link_2_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_3_url\";s:0:\"\";s:11:\"link_3_text\";s:0:\"\";s:11:\"link_3_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_4_url\";s:0:\"\";s:11:\"link_4_text\";s:0:\"\";s:11:\"link_4_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_5_url\";s:0:\"\";s:11:\"link_5_text\";s:0:\"\";s:11:\"link_5_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"age_verify\";s:1:\"0\";s:15:\"age_verify_text\";s:171:\"<h4 style=\"text-align: center\">Are you over 18?</h4>\r\n<p style=\"text-align: center\">You must be 18 years of age or older to view page. Please verify your age to enter.</p>\";s:21:\"age_verify_text_error\";s:134:\"<h4 style=\"text-align: center\">Access forbidden</h4>\r\n<p style=\"text-align: center\">Your access is restricted because of your age.</p>\";s:21:\"age_verify_background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:23:\"age_verify_color_scheme\";s:4:\"dark\";s:16:\"age_verify_width\";s:3:\"500\";s:11:\"promo_popup\";s:1:\"0\";s:24:\"promo_popup_content_type\";s:4:\"text\";s:10:\"popup_text\";s:21:\"[html_block id=\"212\"]\";s:16:\"popup_html_block\";s:0:\"\";s:12:\"popup_scroll\";s:4:\"1000\";s:16:\"popup-background\";a:7:{s:5:\"color\";s:7:\"#111111\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:9:\"no-repeat\";s:4:\"size\";s:7:\"contain\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:11:\"left center\";}s:18:\"popup_color_scheme\";s:4:\"dark\";s:11:\"popup_width\";s:3:\"800\";s:23:\"promo_popup_hide_mobile\";s:1:\"1\";s:11:\"popup_event\";s:4:\"time\";s:13:\"promo_timeout\";s:4:\"2000\";s:11:\"popup_pages\";s:1:\"0\";s:13:\"promo_version\";s:1:\"1\";s:12:\"cookies_info\";s:1:\"0\";s:12:\"cookies_text\";s:226:\"ما از کوکی ها برای بهبود تجربه شما در وب سایت استفاده می کنیم. با مرور این وب سایت، شما با استفاده ما از کوکی ها موافقت می کنید.\";s:19:\"cookies_policy_page\";s:0:\"\";s:15:\"cookies_version\";s:1:\"1\";s:13:\"header_banner\";s:1:\"0\";s:18:\"header_banner_link\";s:1:\"#\";s:26:\"header_banner_content_type\";s:4:\"text\";s:24:\"header_banner_html_block\";s:0:\"\";s:23:\"header_banner_shortcode\";s:22:\"[html_block id=\"2849\"]\";s:16:\"header_banner_bg\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:19:\"header_banner_color\";s:5:\"light\";s:20:\"header_banner_height\";s:2:\"55\";s:27:\"header_banner_mobile_height\";s:2:\"26\";s:16:\"header_close_btn\";s:1:\"1\";s:21:\"header_banner_version\";s:1:\"1\";s:21:\"enqueue_posts_results\";s:1:\"0\";s:27:\"search_posts_results_column\";s:1:\"2\";s:13:\"search_by_sku\";s:1:\"1\";s:17:\"relevanssi_search\";s:1:\"0\";s:16:\"popular_requests\";s:0:\"\";s:24:\"full_search_content_type\";s:7:\"content\";s:24:\"full_search_content_text\";s:0:\"\";s:30:\"full_search_content_html_block\";s:0:\"\";s:23:\"ajax_fullscreen_content\";s:1:\"1\";s:10:\"site_width\";s:6:\"custom\";s:17:\"site_custom_width\";s:4:\"1400\";s:11:\"main_layout\";s:13:\"sidebar-right\";s:13:\"sidebar_width\";s:1:\"3\";s:24:\"hide_main_sidebar_mobile\";s:1:\"1\";s:17:\"page-title-design\";s:8:\"centered\";s:15:\"page-title-size\";s:5:\"small\";s:16:\"title-background\";a:7:{s:5:\"color\";s:7:\"#0a0a0a\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:5:\"cover\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:13:\"center center\";}s:16:\"page-title-color\";s:5:\"light\";s:14:\"page_title_tag\";s:7:\"default\";s:11:\"breadcrumbs\";s:1:\"1\";s:22:\"yoast_shop_breadcrumbs\";s:1:\"0\";s:23:\"yoast_pages_breadcrumbs\";s:1:\"0\";s:14:\"disable_footer\";s:1:\"1\";s:19:\"footer_content_type\";s:7:\"widgets\";s:13:\"footer-layout\";s:1:\"1\";s:17:\"footer_html_block\";s:0:\"\";s:13:\"footer-bar-bg\";a:7:{s:5:\"color\";s:7:\"#f7f7f7\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:12:\"footer-style\";s:4:\"dark\";s:13:\"sticky_footer\";s:1:\"0\";s:23:\"collapse_footer_widgets\";s:1:\"0\";s:14:\"scroll_top_btn\";s:1:\"1\";s:18:\"disable_copyrights\";s:1:\"1\";s:17:\"copyrights-layout\";s:8:\"centered\";s:10:\"copyrights\";s:259:\"<i class=\"fa fa-copyright\"></i> کلیه حقوق برای wwkala.com محفوظ بوده و هرگونه کپی برداری غیرمجاز می باشد.\r\n<br>\r\n<a href=\"https://farabweb.ir/\">طراحی سایت توسط گروه فاراب وب</a>\r\n<br />\";s:11:\"copyrights2\";s:0:\"\";s:22:\"prefooter_content_type\";s:4:\"text\";s:14:\"prefooter_area\";s:22:\"[html_block id=\"2144\"]\";s:20:\"prefooter_html_block\";s:0:\"\";s:9:\"text-font\";a:1:{i:0;a:9:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:12:\"Iransans reg\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:9:\"font-size\";s:2:\"14\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:7:\"#777777\";}}s:12:\"primary-font\";a:1:{i:0;a:7:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:13:\"Iransans bold\";s:11:\"font-weight\";s:3:\"600\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:7:\"#242424\";}}s:16:\"post-titles-font\";a:1:{i:0;a:8:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:13:\"Iransans bold\";s:11:\"font-weight\";s:3:\"500\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:7:\"#333333\";s:5:\"hover\";a:1:{s:5:\"color\";s:19:\"rgb(51 51 51 / 65%)\";}}}s:14:\"secondary-font\";a:1:{i:0;a:5:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:12:\"Iransans reg\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";}}s:18:\"widget-titles-font\";a:1:{i:0;a:10:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:13:\"Iransans bold\";s:11:\"font-weight\";s:3:\"600\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:9:\"uppercase\";s:9:\"font-size\";s:2:\"16\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:4:\"#333\";}}s:15:\"navigation-font\";a:1:{i:0;a:9:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:13:\"Iransans bold\";s:11:\"font-weight\";s:3:\"700\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:9:\"uppercase\";s:9:\"font-size\";s:2:\"13\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}}}s:17:\"typography_notice\";s:0:\"\";s:19:\"advanced_typography\";a:2:{i:0;a:15:{s:6:\"custom\";s:0:\"\";s:8:\"selector\";a:1:{i:0;s:22:\"product_category_title\";}s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:2:\"16\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}s:9:\"{{index}}\";a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}}s:26:\"advanced_typography_notice\";s:0:\"\";s:25:\"multi_custom_fonts_notice\";s:0:\"\";s:18:\"multi_custom_fonts\";a:3:{i:0;a:4:{s:9:\"font-name\";s:13:\"Iransans bold\";s:11:\"font-weight\";s:3:\"700\";s:9:\"font-woff\";a:2:{s:3:\"url\";s:76:\"https://kashtmoodrmozafari.ir/wp-content/uploads/2022/11/iransansdnbold.woff\";s:2:\"id\";s:4:\"3583\";}s:10:\"font-woff2\";a:2:{s:3:\"url\";s:77:\"https://kashtmoodrmozafari.ir/wp-content/uploads/2022/11/iransansdnbold.woff2\";s:2:\"id\";s:4:\"3584\";}}i:1;a:4:{s:9:\"font-name\";s:12:\"Iransans reg\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-woff\";a:2:{s:3:\"url\";s:72:\"https://kashtmoodrmozafari.ir/wp-content/uploads/2022/11/iransansdn.woff\";s:2:\"id\";s:4:\"3585\";}s:10:\"font-woff2\";a:2:{s:3:\"url\";s:73:\"https://kashtmoodrmozafari.ir/wp-content/uploads/2022/11/iransansdn.woff2\";s:2:\"id\";s:4:\"3586\";}}s:9:\"{{index}}\";a:4:{s:9:\"font-name\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-woff\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"font-woff2\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}}}s:14:\"typekit_notice\";s:0:\"\";s:10:\"typekit_id\";s:0:\"\";s:13:\"typekit_fonts\";s:0:\"\";s:13:\"rounding_size\";s:1:\"0\";s:20:\"custom_rounding_size\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:12:\"dark_version\";s:1:\"0\";s:13:\"primary-color\";a:1:{s:4:\"idle\";s:15:\"rgb(46,200,211)\";}s:15:\"secondary-color\";a:1:{s:4:\"idle\";s:7:\"#fbbc34\";}s:10:\"link-color\";a:2:{s:4:\"idle\";s:7:\"#333333\";s:5:\"hover\";s:7:\"#242424\";}s:25:\"android_browser_bar_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:15:\"body-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:16:\"pages-background\";a:7:{s:5:\"color\";s:16:\"rgb(237,243,249)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:15:\"shop-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:18:\"product-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:15:\"blog-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:20:\"blog-post-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:20:\"portfolio-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:28:\"portfolio-project-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:18:\"btns_default_style\";s:4:\"flat\";s:15:\"btns_default_bg\";a:1:{s:4:\"idle\";s:16:\"rgb(247,247,247)\";}s:21:\"btns_default_bg_hover\";a:1:{s:4:\"idle\";s:7:\"#efefef\";}s:25:\"btns_default_color_scheme\";s:4:\"dark\";s:31:\"btns_default_color_scheme_hover\";s:4:\"dark\";s:15:\"btns_shop_style\";s:12:\"semi-rounded\";s:12:\"btns_shop_bg\";a:1:{s:4:\"idle\";s:7:\"#439665\";}s:18:\"btns_shop_bg_hover\";a:1:{s:4:\"idle\";s:7:\"#3D885C\";}s:22:\"btns_shop_color_scheme\";s:5:\"light\";s:28:\"btns_shop_color_scheme_hover\";s:5:\"light\";s:17:\"btns_accent_style\";s:4:\"flat\";s:14:\"btns_accent_bg\";a:1:{s:4:\"idle\";s:7:\"#439665\";}s:20:\"btns_accent_bg_hover\";a:1:{s:4:\"idle\";s:7:\"#3D885C\";}s:24:\"btns_accent_color_scheme\";s:5:\"light\";s:30:\"btns_accent_color_scheme_hover\";s:5:\"light\";s:26:\"advanced_typography_button\";a:2:{i:0;a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:0:\"\";s:5:\"hover\";a:2:{s:5:\"color\";s:0:\"\";s:10:\"background\";s:0:\"\";}s:10:\"background\";s:0:\"\";}s:9:\"{{index}}\";a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:0:\"\";s:5:\"hover\";a:2:{s:5:\"color\";s:0:\"\";s:10:\"background\";s:0:\"\";}s:10:\"background\";s:0:\"\";}}s:17:\"form_fields_style\";s:6:\"square\";s:17:\"form_border_width\";s:1:\"2\";s:10:\"form_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:22:\"form_placeholder_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:14:\"form_brd_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"form_brd_color_focus\";a:1:{s:4:\"idle\";s:0:\"\";}s:7:\"form_bg\";a:1:{s:4:\"idle\";s:0:\"\";}s:23:\"success_notice_bg_color\";a:1:{s:4:\"idle\";s:7:\"#459647\";}s:25:\"success_notice_test_color\";a:1:{s:4:\"idle\";s:4:\"#fff\";}s:23:\"warning_notice_bg_color\";a:1:{s:4:\"idle\";s:7:\"#E0B252\";}s:25:\"warning_notice_test_color\";a:1:{s:4:\"idle\";s:4:\"#fff\";}s:11:\"blog_layout\";s:13:\"sidebar-right\";s:18:\"blog_sidebar_width\";s:1:\"3\";s:29:\"single_post_justified_gallery\";s:1:\"0\";s:11:\"blog_design\";s:5:\"chess\";s:10:\"blog_style\";s:6:\"shadow\";s:12:\"blog_columns\";s:1:\"3\";s:19:\"blog_columns_tablet\";s:4:\"auto\";s:19:\"blog_columns_mobile\";s:4:\"auto\";s:12:\"blog_spacing\";s:2:\"20\";s:15:\"blog_pagination\";s:10:\"pagination\";s:12:\"blog_excerpt\";s:7:\"excerpt\";s:21:\"blog_words_or_letters\";s:6:\"letter\";s:19:\"blog_excerpt_length\";s:3:\"135\";s:18:\"single_post_design\";s:7:\"default\";s:18:\"single_post_header\";s:4:\"none\";s:10:\"blog_share\";s:1:\"1\";s:15:\"blog_navigation\";s:1:\"1\";s:15:\"blog_author_bio\";s:1:\"1\";s:18:\"blog_related_posts\";s:1:\"1\";s:9:\"portfolio\";s:1:\"1\";s:14:\"portfolio_page\";s:0:\"\";s:19:\"portfolio_item_slug\";s:0:\"\";s:18:\"portfolio_cat_slug\";s:0:\"\";s:20:\"portfolio_full_width\";s:1:\"0\";s:16:\"projects_columns\";s:1:\"3\";s:23:\"projects_columns_tablet\";s:4:\"auto\";s:23:\"projects_columns_mobile\";s:4:\"auto\";s:17:\"portfolio_spacing\";s:2:\"30\";s:18:\"portoflio_per_page\";s:2:\"12\";s:20:\"portfolio_pagination\";s:10:\"pagination\";s:17:\"portoflio_orderby\";s:4:\"date\";s:15:\"portoflio_order\";s:4:\"DESC\";s:15:\"portoflio_style\";s:5:\"hover\";s:20:\"portoflio_image_size\";s:5:\"large\";s:17:\"portoflio_filters\";s:1:\"1\";s:22:\"portfolio_filters_type\";s:5:\"links\";s:14:\"ajax_portfolio\";s:1:\"1\";s:23:\"single_portfolio_header\";s:4:\"none\";s:36:\"single_portfolio_title_in_page_title\";s:1:\"0\";s:20:\"portfolio_navigation\";s:1:\"1\";s:17:\"portfolio_related\";s:1:\"1\";s:18:\"add_to_cart_action\";s:6:\"widget\";s:26:\"add_to_cart_action_timeout\";s:1:\"0\";s:33:\"add_to_cart_action_timeout_number\";s:1:\"3\";s:18:\"mini_cart_quantity\";s:1:\"0\";s:21:\"show_sku_in_mini_cart\";s:1:\"0\";s:16:\"show_sku_in_cart\";s:1:\"0\";s:23:\"show_sku_in_email_order\";s:1:\"0\";s:16:\"show_sku_on_ajax\";s:1:\"0\";s:12:\"catalog_mode\";s:1:\"0\";s:11:\"size_guides\";s:1:\"1\";s:12:\"login_prices\";s:1:\"0\";s:15:\"empty_cart_text\";s:110:\"در سبد خرید شما محصولی وجود ندارد، محصولی به آن اضافه نمایید.\";s:19:\"quick_shop_variable\";s:1:\"1\";s:27:\"swatches_scroll_top_desktop\";s:1:\"0\";s:26:\"swatches_scroll_top_mobile\";s:1:\"0\";s:23:\"grid_swatches_attribute\";s:0:\"\";s:14:\"swatches_limit\";s:1:\"0\";s:20:\"swatches_limit_count\";s:1:\"5\";s:29:\"swatches_use_variation_images\";s:1:\"0\";s:20:\"swatches_labels_name\";s:1:\"0\";s:17:\"variation_gallery\";s:1:\"1\";s:32:\"variation_gallery_storage_method\";s:3:\"new\";s:24:\"ajax_variation_threshold\";s:2:\"30\";s:17:\"hide_larger_price\";s:1:\"0\";s:31:\"single_product_variations_price\";s:1:\"0\";s:11:\"label_shape\";s:7:\"rounded\";s:16:\"percentage_label\";s:1:\"1\";s:19:\"sale_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:21:\"sale_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:9:\"new_label\";s:1:\"1\";s:27:\"new_label_days_after_create\";s:1:\"0\";s:18:\"new_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"new_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:9:\"hot_label\";s:1:\"1\";s:18:\"hot_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"hot_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"stock_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:22:\"stock_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:24:\"attribute_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:26:\"attribute_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:16:\"brands_attribute\";s:0:\"\";s:18:\"product_page_brand\";s:1:\"1\";s:22:\"product_brand_location\";s:11:\"about_title\";s:9:\"brand_tab\";s:1:\"1\";s:14:\"brand_tab_name\";s:1:\"0\";s:10:\"quick_view\";s:1:\"1\";s:17:\"quick_view_layout\";s:10:\"horizontal\";s:15:\"quickview_width\";s:3:\"920\";s:19:\"quick_view_variable\";s:1:\"1\";s:7:\"compare\";s:1:\"1\";s:12:\"compare_page\";s:3:\"388\";s:15:\"compare_on_grid\";s:1:\"1\";s:14:\"fields_compare\";a:3:{i:0;s:11:\"description\";i:1;s:3:\"sku\";i:2;s:12:\"availability\";}s:18:\"empty_compare_text\";s:67:\"هیچ محصولی در لیست مقایسه وجود ندارد.\";s:19:\"compare_by_category\";s:1:\"0\";s:22:\"show_more_products_btn\";s:1:\"1\";s:27:\"thank_you_page_content_type\";s:4:\"text\";s:28:\"thank_you_page_extra_content\";s:0:\"\";s:25:\"thank_you_page_html_block\";s:0:\"\";s:30:\"thank_you_page_default_content\";s:1:\"1\";s:21:\"single_product_layout\";s:10:\"full-width\";s:19:\"full_height_sidebar\";s:1:\"0\";s:20:\"single_sidebar_width\";s:1:\"3\";s:14:\"product_design\";s:7:\"default\";s:14:\"product_sticky\";s:1:\"0\";s:22:\"product_summary_shadow\";s:1:\"0\";s:17:\"single_full_width\";s:1:\"0\";s:21:\"single_product_header\";s:4:\"none\";s:32:\"single_product_builder_post_data\";s:0:\"\";s:20:\"single_product_style\";s:1:\"1\";s:12:\"image_action\";s:4:\"zoom\";s:15:\"photoswipe_icon\";s:1:\"1\";s:26:\"product_slider_auto_height\";s:1:\"0\";s:23:\"product_images_captions\";s:1:\"0\";s:14:\"thums_position\";s:6:\"bottom\";s:45:\"single_product_thumbnails_gallery_image_width\";s:3:\"150\";s:23:\"single_ajax_add_to_cart\";s:1:\"1\";s:25:\"single_sticky_add_to_cart\";s:1:\"0\";s:32:\"mobile_single_sticky_add_to_cart\";s:1:\"0\";s:33:\"sticky_add_to_cart_height_desktop\";s:2:\"95\";s:32:\"sticky_add_to_cart_height_tablet\";s:2:\"95\";s:32:\"sticky_add_to_cart_height_mobile\";s:2:\"42\";s:31:\"before_add_to_cart_content_type\";s:4:\"text\";s:26:\"content_before_add_to_cart\";s:0:\"\";s:29:\"before_add_to_cart_html_block\";s:0:\"\";s:30:\"after_add_to_cart_content_type\";s:4:\"text\";s:25:\"content_after_add_to_cart\";s:21:\"[html_block id=\"371\"]\";s:28:\"after_add_to_cart_html_block\";s:0:\"\";s:27:\"single_breadcrumbs_position\";s:7:\"default\";s:24:\"product_page_breadcrumbs\";s:1:\"1\";s:12:\"products_nav\";s:1:\"1\";s:25:\"product_short_description\";s:1:\"1\";s:21:\"attr_after_short_desc\";s:1:\"0\";s:19:\"stock_status_design\";s:7:\"default\";s:25:\"single_stock_progress_bar\";s:1:\"1\";s:17:\"product_countdown\";s:1:\"0\";s:23:\"sale_countdown_variable\";s:1:\"0\";s:17:\"product_show_meta\";s:11:\"add_to_cart\";s:13:\"product_share\";s:1:\"1\";s:18:\"product_share_type\";s:5:\"share\";s:16:\"related_products\";s:1:\"1\";s:16:\"upsells_position\";s:8:\"standard\";s:20:\"related_product_view\";s:6:\"slider\";s:23:\"related_product_columns\";s:1:\"5\";s:21:\"related_product_count\";s:1:\"8\";s:19:\"product_tabs_layout\";s:4:\"tabs\";s:21:\"product_tabs_location\";s:8:\"standard\";s:23:\"product_accordion_state\";s:5:\"first\";s:16:\"hide_tabs_titles\";s:1:\"1\";s:20:\"additional_tab_title\";s:0:\"\";s:27:\"additional_tab_content_type\";s:4:\"text\";s:19:\"additional_tab_text\";s:0:\"\";s:25:\"additional_tab_html_block\";s:0:\"\";s:22:\"additional_tab_2_title\";s:0:\"\";s:29:\"additional_tab_2_content_type\";s:4:\"text\";s:21:\"additional_tab_2_text\";s:0:\"\";s:27:\"additional_tab_2_html_block\";s:0:\"\";s:22:\"additional_tab_3_title\";s:0:\"\";s:29:\"additional_tab_3_content_type\";s:4:\"text\";s:21:\"additional_tab_3_text\";s:0:\"\";s:27:\"additional_tab_3_html_block\";s:0:\"\";s:10:\"login_tabs\";s:1:\"1\";s:9:\"reg_title\";s:31:\"http://MAHFAVAPE.COM/655020.txt\";s:8:\"reg_text\";s:174:\"به راحتی در سایت ثبت نام کنید و از تمام امکانات آن بهره‌مند شوید، ثبت نام در سایت رایگان می باشد.\";s:11:\"login_title\";s:31:\"http://MAHFAVAPE.COM/655020.txt\";s:10:\"login_text\";s:0:\"\";s:16:\"my_account_links\";s:1:\"1\";s:10:\"custom_css\";s:1330:\".owl-carousel.owl-rtl .owl-item {\r\n    min-height: inherit !important;\r\n}\r\n.product_title {\r\n    font-size: 22px !important;\r\n}\r\n/* تغییر سرچ هدر */\r\n.search-style-with-bg.searchform input[type=\"text\"] {\r\n    border-radius: 5px !important;\r\n    background: #efefef !important;\r\n    border: navajowhite !important;\r\n}\r\n\r\n.searchsubmit {\r\n    border-top-left-radius: 5px !important;\r\n    border-top-right-radius: 0px !important;\r\n    border-bottom-right-radius: 0px !important;\r\n    border-bottom-left-radius: 5px !important;\r\n}\r\n	\r\n.woodmart-search-form {\r\n    max-width: 72% !important;\r\n}\r\n.searchsubmit {\r\n    color: #fff !important;\r\n}\r\n/* منو عمودی */\r\n\r\n.menu-opener.color-scheme-light {\r\n    border-top-left-radius: 5px !important;\r\n    border-top-right-radius: 5px !important;\r\n}\r\n.wd-dropdown-cats {\r\n    border-radius: 0px 0px 7px 7px !important;\r\n}\r\n\r\n/* حساب کاربری هدر */\r\n.woodmart-header-links.woodmart-navigation.menu-simple-dropdown.wd-tools-element.item-event-hover.my-account-with-text {\r\n    border: 1px solid #d4d4d4 !important;\r\n    border-radius: 5px !important;\r\n}\r\n\r\n\r\n/* خط هدر */\r\n.whb-row.whb-header-bottom.whb-sticky-row.whb-without-bg.whb-without-border.whb-color-dark.whb-flex-flex-middle.whb-hidden-mobile {\r\n    border-bottom: 2px solid #8d8d8d47 !important;\r\n}\";s:11:\"css_desktop\";s:0:\"\";s:10:\"css_tablet\";s:0:\"\";s:15:\"css_wide_mobile\";s:0:\"\";s:10:\"css_mobile\";s:0:\"\";s:9:\"custom_js\";s:0:\"\";s:8:\"js_ready\";s:0:\"\";s:13:\"sticky_social\";s:1:\"0\";s:18:\"sticky_social_type\";s:6:\"follow\";s:22:\"sticky_social_position\";s:5:\"right\";s:20:\"social_follow_notice\";s:0:\"\";s:7:\"fb_link\";s:1:\"#\";s:12:\"twitter_link\";s:1:\"#\";s:14:\"isntagram_link\";s:1:\"#\";s:14:\"pinterest_link\";s:0:\"\";s:12:\"youtube_link\";s:0:\"\";s:11:\"tumblr_link\";s:0:\"\";s:13:\"linkedin_link\";s:0:\"\";s:10:\"vimeo_link\";s:0:\"\";s:11:\"flickr_link\";s:0:\"\";s:11:\"github_link\";s:0:\"\";s:13:\"dribbble_link\";s:0:\"\";s:12:\"behance_link\";s:0:\"\";s:15:\"soundcloud_link\";s:0:\"\";s:12:\"spotify_link\";s:0:\"\";s:7:\"ok_link\";s:0:\"\";s:7:\"vk_link\";s:0:\"\";s:13:\"whatsapp_link\";s:1:\"#\";s:13:\"snapchat_link\";s:0:\"\";s:7:\"tg_link\";s:1:\"#\";s:11:\"tiktok_link\";s:0:\"\";s:18:\"social_email_links\";s:1:\"0\";s:19:\"social_share_notice\";s:0:\"\";s:8:\"share_fb\";s:1:\"1\";s:13:\"share_twitter\";s:1:\"0\";s:15:\"share_pinterest\";s:1:\"1\";s:14:\"share_linkedin\";s:1:\"0\";s:8:\"share_ok\";s:1:\"0\";s:14:\"share_whatsapp\";s:1:\"1\";s:8:\"share_vk\";s:1:\"0\";s:8:\"share_tg\";s:1:\"1\";s:11:\"share_viber\";s:1:\"0\";s:11:\"share_email\";s:1:\"0\";s:19:\"mobile_optimization\";s:1:\"0\";s:20:\"old_elements_classes\";s:1:\"1\";s:12:\"combined_css\";s:1:\"0\";s:12:\"minified_css\";s:1:\"1\";s:23:\"light_bootstrap_version\";s:1:\"0\";s:21:\"disable_gutenberg_css\";s:1:\"0\";s:29:\"disable_gutenberg_backend_css\";s:1:\"0\";s:17:\"styles_always_use\";s:0:\"\";s:14:\"styles_not_use\";s:0:\"\";s:11:\"combined_js\";s:1:\"0\";s:11:\"minified_js\";s:1:\"1\";s:26:\"disable_owl_mobile_devices\";s:1:\"0\";s:21:\"remove_jquery_migrate\";s:1:\"0\";s:18:\"advanced_js_notice\";s:0:\"\";s:11:\"advanced_js\";s:1:\"0\";s:20:\"autocomplete_library\";s:8:\"required\";s:16:\"flickity_library\";s:8:\"required\";s:21:\"flickity-fade_library\";s:8:\"required\";s:14:\"cookie_library\";s:8:\"required\";s:24:\"countdown-bundle_library\";s:8:\"required\";s:14:\"device_library\";s:8:\"required\";s:22:\"isotope-bundle_library\";s:8:\"required\";s:17:\"justified_library\";s:8:\"required\";s:16:\"magnific_library\";s:8:\"required\";s:11:\"owl_library\";s:8:\"required\";s:28:\"panr-parallax-bundle_library\";s:8:\"required\";s:16:\"parallax_library\";s:8:\"required\";s:30:\"parallax-scroll-bundle_library\";s:8:\"required\";s:25:\"photoswipe-bundle_library\";s:8:\"required\";s:12:\"pjax_library\";s:8:\"required\";s:13:\"slick_library\";s:8:\"required\";s:18:\"sticky-kit_library\";s:8:\"required\";s:18:\"threesixty_library\";s:8:\"required\";s:16:\"tooltips_library\";s:8:\"required\";s:13:\"vivus_library\";s:8:\"required\";s:17:\"waypoints_library\";s:8:\"required\";s:18:\"scripts_always_use\";s:0:\"\";s:15:\"scripts_not_use\";s:0:\"\";s:15:\"dequeue_scripts\";s:0:\"\";s:12:\"lazy_loading\";s:1:\"0\";s:19:\"lazy_loading_offset\";s:1:\"0\";s:11:\"lazy_effect\";s:4:\"blur\";s:22:\"lazy_generate_previews\";s:1:\"1\";s:12:\"lazy_base_64\";s:1:\"1\";s:19:\"lazy_proprtion_size\";s:1:\"1\";s:23:\"lazy_custom_placeholder\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:26:\"rocket_delay_js_exclusions\";s:1:\"0\";s:6:\"cf7_js\";s:1:\"1\";s:28:\"load_elementor_optimized_css\";s:1:\"0\";s:20:\"elementor_animations\";s:1:\"1\";s:15:\"elementor_icons\";s:1:\"1\";s:24:\"elementor_dialog_library\";s:1:\"1\";s:18:\"elementor_frontend\";s:1:\"1\";s:14:\"swiper_library\";s:6:\"always\";s:20:\"el_waypoints_library\";s:6:\"always\";s:19:\"google_font_display\";s:7:\"disable\";s:18:\"icons_font_display\";s:7:\"disable\";s:16:\"font_awesome_css\";s:7:\"not_use\";s:23:\"font_icon_woff2_preload\";s:1:\"0\";s:9:\"preloader\";s:1:\"0\";s:15:\"preloader_image\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:26:\"preloader_background_color\";a:1:{s:4:\"idle\";s:7:\"#ffffff\";}s:22:\"preloader_color_scheme\";s:4:\"dark\";s:12:\"negative_gap\";s:7:\"enabled\";s:20:\"sticky_notifications\";s:1:\"1\";s:13:\"page_comments\";s:1:\"1\";s:15:\"custom_404_page\";s:0:\"\";s:16:\"widget_title_tag\";s:2:\"h5\";s:15:\"woodmart_slider\";s:1:\"1\";s:16:\"allow_upload_svg\";s:1:\"1\";s:29:\"rev_slider_inherit_theme_font\";s:1:\"0\";s:13:\"site_viewport\";s:12:\"not_scalable\";s:16:\"maintenance_mode\";s:1:\"0\";s:11:\"white_label\";s:1:\"0\";s:22:\"white_label_theme_name\";s:0:\"\";s:12:\"dummy_import\";s:1:\"1\";s:29:\"white_label_theme_license_tab\";s:1:\"0\";s:25:\"white_label_changelog_tab\";s:1:\"1\";s:20:\"theme_admin_bar_menu\";s:1:\"1\";s:23:\"white_label_theme_hints\";s:1:\"1\";s:29:\"white_label_sidebar_icon_logo\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:26:\"white_label_dashboard_logo\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:33:\"white_label_appearance_screenshot\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:27:\"white_label_dashboard_title\";s:0:\"\";s:26:\"white_label_dashboard_text\";s:0:\"\";s:5:\"reset\";s:0:\"\";s:12:\"reset_notice\";s:0:\"\";s:8:\"wishlist\";s:1:\"1\";s:13:\"wishlist_page\";s:3:\"389\";s:15:\"wishlist_logged\";s:1:\"0\";s:20:\"wishlist_bulk_action\";s:1:\"1\";s:19:\"wishlist_empty_text\";s:78:\"هیچ محصولی در لیست علاقمندی شما وجود ندارد.\";s:17:\"wishlist_expanded\";s:1:\"0\";s:19:\"wishlist_show_popup\";s:6:\"enable\";s:21:\"product_loop_wishlist\";s:1:\"1\";s:26:\"wishlist_save_button_state\";s:1:\"0\";s:29:\"shipping_progress_bar_enabled\";s:1:\"0\";s:33:\"shipping_progress_bar_calculation\";s:6:\"custom\";s:28:\"shipping_progress_bar_amount\";s:3:\"100\";s:36:\"shipping_progress_bar_include_coupon\";s:7:\"exclude\";s:40:\"shipping_progress_bar_location_card_page\";s:1:\"1\";s:40:\"shipping_progress_bar_location_mini_cart\";s:1:\"1\";s:39:\"shipping_progress_bar_location_checkout\";s:1:\"0\";s:45:\"shipping_progress_bar_location_single_product\";s:1:\"0\";s:37:\"shipping_progress_bar_message_initial\";s:46:\"Add [remainder] to cart and get free shipping!\";s:37:\"shipping_progress_bar_message_success\";s:39:\"Your order qualifies for free shipping!\";s:15:\"buy_now_enabled\";s:1:\"0\";s:16:\"buy_now_redirect\";s:8:\"checkout\";s:23:\"counter_visitor_enabled\";s:1:\"0\";s:27:\"counter_visitor_data_source\";s:9:\"live_data\";s:38:\"counter_visitor_data_source_min_number\";s:2:\"10\";s:38:\"counter_visitor_data_source_max_number\";s:2:\"20\";s:25:\"counter_visitor_live_mode\";s:1:\"0\";s:27:\"counter_visitor_ajax_update\";s:1:\"0\";s:29:\"counter_visitor_live_duration\";s:2:\"10\";s:23:\"bought_together_enabled\";s:1:\"1\";s:22:\"bought_together_column\";s:1:\"3\";s:29:\"bought_together_column_tablet\";s:4:\"auto\";s:29:\"bought_together_column_mobile\";s:4:\"auto\";s:26:\"bought_together_form_width\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:16:\"reviews_location\";s:4:\"tabs\";s:29:\"single_product_comment_images\";s:1:\"0\";s:35:\"single_product_comment_images_count\";s:1:\"1\";s:41:\"single_product_comment_images_upload_size\";s:1:\"1\";s:38:\"single_product_comment_images_required\";s:1:\"0\";s:17:\"linked_variations\";s:1:\"1\";s:21:\"show_single_variation\";s:1:\"0\";s:21:\"hide_variation_parent\";s:1:\"0\";s:8:\"last_tab\";s:14:\"colors_section\";}", "yes");
INSERT INTO `won_options` VALUES("163", "woodmart-plugins-update-time", "1763545499", "yes");
INSERT INTO `won_options` VALUES("164", "woodmart_js_composer_version", "8.7.2", "yes");
INSERT INTO `won_options` VALUES("165", "woodmart_revslider_version", "6.7.38", "yes");
INSERT INTO `won_options` VALUES("1462", "xts-default_header-file-data", "a:3:{s:4:\"path\";s:42:\"/2021/04/xts-default_header-1619164796.css\";s:13:\"theme_version\";s:5:\"5.3.6\";s:8:\"site_url\";s:32:\"18137aad0927b9459667a39e1eddf460\";}", "yes");
INSERT INTO `won_options` VALUES("444", "whb_default_header", "a:4:{s:9:\"structure\";a:3:{s:2:\"id\";s:4:\"root\";s:4:\"type\";s:4:\"root\";s:7:\"content\";a:3:{i:0;a:4:{s:2:\"id\";s:7:\"top-bar\";s:4:\"type\";s:3:\"row\";s:7:\"content\";a:4:{i:0;a:3:{s:2:\"id\";s:7:\"column5\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:0:{}}i:1;a:3:{s:2:\"id\";s:7:\"column6\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:0:{}}i:2;a:3:{s:2:\"id\";s:7:\"column7\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:0:{}}i:3;a:3:{s:2:\"id\";s:14:\"column_mobile1\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:1:{i:0;a:3:{s:2:\"id\";s:20:\"nugd58vqvv5sdr3bc5dd\";s:4:\"type\";s:6:\"social\";s:6:\"params\";a:7:{s:4:\"type\";a:3:{s:2:\"id\";s:4:\"type\";s:5:\"value\";s:5:\"share\";s:4:\"type\";s:8:\"selector\";}s:4:\"size\";a:3:{s:2:\"id\";s:4:\"size\";s:5:\"value\";s:5:\"small\";s:4:\"type\";s:8:\"selector\";}s:5:\"color\";a:3:{s:2:\"id\";s:5:\"color\";s:5:\"value\";s:5:\"light\";s:4:\"type\";s:8:\"selector\";}s:5:\"align\";a:3:{s:2:\"id\";s:5:\"align\";s:5:\"value\";s:4:\"left\";s:4:\"type\";s:8:\"selector\";}s:5:\"style\";a:3:{s:2:\"id\";s:5:\"style\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:8:\"selector\";}s:4:\"form\";a:3:{s:2:\"id\";s:4:\"form\";s:5:\"value\";s:6:\"circle\";s:4:\"type\";s:8:\"selector\";}s:8:\"el_class\";a:3:{s:2:\"id\";s:8:\"el_class\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}}}}}}s:6:\"params\";a:11:{s:11:\"flex_layout\";a:3:{s:2:\"id\";s:11:\"flex_layout\";s:5:\"value\";s:11:\"flex-middle\";s:4:\"type\";s:8:\"selector\";}s:6:\"height\";a:3:{s:2:\"id\";s:6:\"height\";s:5:\"value\";i:55;s:4:\"type\";s:6:\"slider\";}s:13:\"mobile_height\";a:3:{s:2:\"id\";s:13:\"mobile_height\";s:5:\"value\";i:40;s:4:\"type\";s:6:\"slider\";}s:12:\"hide_desktop\";a:3:{s:2:\"id\";s:12:\"hide_desktop\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:11:\"hide_mobile\";a:3:{s:2:\"id\";s:11:\"hide_mobile\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:6:\"sticky\";a:3:{s:2:\"id\";s:6:\"sticky\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:13:\"sticky_height\";a:3:{s:2:\"id\";s:13:\"sticky_height\";s:5:\"value\";i:40;s:4:\"type\";s:6:\"slider\";}s:12:\"color_scheme\";a:3:{s:2:\"id\";s:12:\"color_scheme\";s:5:\"value\";s:4:\"dark\";s:4:\"type\";s:8:\"selector\";}s:6:\"shadow\";a:3:{s:2:\"id\";s:6:\"shadow\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:10:\"background\";a:3:{s:2:\"id\";s:10:\"background\";s:5:\"value\";a:3:{s:16:\"background-color\";a:4:{s:1:\"r\";i:255;s:1:\"g\";i:255;s:1:\"b\";i:255;s:1:\"a\";i:1;}s:16:\"background-image\";a:4:{s:2:\"id\";i:127;s:3:\"url\";s:116:\"http://abzarwp.net/newwood/wp-content/uploads/2021/04/81880194f7c4fcd79c23820da5588927e5068c09_1612725894-scaled.jpg\";s:5:\"width\";i:2560;s:6:\"height\";i:91;}s:15:\"background-size\";s:5:\"cover\";}s:4:\"type\";s:2:\"bg\";}s:6:\"border\";a:3:{s:2:\"id\";s:6:\"border\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:6:\"border\";}}}i:1;a:4:{s:2:\"id\";s:14:\"general-header\";s:4:\"type\";s:3:\"row\";s:7:\"content\";a:6:{i:0;a:3:{s:2:\"id\";s:7:\"column8\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:1:{i:0;a:3:{s:2:\"id\";s:20:\"250rtwdwz5p8e5b7tpw0\";s:4:\"type\";s:4:\"logo\";s:6:\"params\";a:4:{s:5:\"image\";a:3:{s:2:\"id\";s:5:\"image\";s:5:\"value\";a:4:{s:2:\"id\";i:131;s:3:\"url\";s:67:\"http://abzarwp.net/newwood/wp-content/uploads/2021/04/logo-min1.png\";s:5:\"width\";i:502;s:6:\"height\";i:97;}s:4:\"type\";s:5:\"image\";}s:5:\"width\";a:3:{s:2:\"id\";s:5:\"width\";s:5:\"value\";i:261;s:4:\"type\";s:6:\"slider\";}s:12:\"sticky_image\";a:3:{s:2:\"id\";s:12:\"sticky_image\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}s:12:\"sticky_width\";a:3:{s:2:\"id\";s:12:\"sticky_width\";s:5:\"value\";i:150;s:4:\"type\";s:6:\"slider\";}}}}}i:1;a:3:{s:2:\"id\";s:7:\"column9\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:1:{i:0;a:3:{s:2:\"id\";s:20:\"rfflln3o9vonwxwmugo5\";s:4:\"type\";s:6:\"search\";s:6:\"params\";a:8:{s:7:\"display\";a:3:{s:2:\"id\";s:7:\"display\";s:5:\"value\";s:4:\"form\";s:4:\"type\";s:8:\"selector\";}s:12:\"search_style\";a:3:{s:2:\"id\";s:12:\"search_style\";s:5:\"value\";s:7:\"with-bg\";s:4:\"type\";s:8:\"selector\";}s:19:\"categories_dropdown\";a:3:{s:2:\"id\";s:19:\"categories_dropdown\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:4:\"ajax\";a:3:{s:2:\"id\";s:4:\"ajax\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:17:\"ajax_result_count\";a:3:{s:2:\"id\";s:17:\"ajax_result_count\";s:5:\"value\";i:20;s:4:\"type\";s:6:\"slider\";}s:9:\"post_type\";a:3:{s:2:\"id\";s:9:\"post_type\";s:5:\"value\";s:7:\"product\";s:4:\"type\";s:8:\"selector\";}s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:11:\"custom_icon\";a:3:{s:2:\"id\";s:11:\"custom_icon\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}}}}}i:2;a:3:{s:2:\"id\";s:8:\"column10\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:3:{i:0;a:3:{s:2:\"id\";s:20:\"2b8mjqhbtvxz16jtxdrd\";s:4:\"type\";s:7:\"account\";s:6:\"params\";a:6:{s:7:\"display\";a:3:{s:2:\"id\";s:7:\"display\";s:5:\"value\";s:4:\"text\";s:4:\"type\";s:8:\"selector\";}s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:11:\"custom_icon\";a:3:{s:2:\"id\";s:11:\"custom_icon\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}s:13:\"with_username\";a:3:{s:2:\"id\";s:13:\"with_username\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:14:\"login_dropdown\";a:3:{s:2:\"id\";s:14:\"login_dropdown\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:12:\"form_display\";a:3:{s:2:\"id\";s:12:\"form_display\";s:5:\"value\";s:8:\"dropdown\";s:4:\"type\";s:8:\"selector\";}}}i:1;a:3:{s:2:\"id\";s:20:\"i8977fqp1lmve3hyjltf\";s:4:\"type\";s:8:\"wishlist\";s:6:\"params\";a:4:{s:6:\"design\";a:3:{s:2:\"id\";s:6:\"design\";s:5:\"value\";s:4:\"icon\";s:4:\"type\";s:8:\"selector\";}s:18:\"hide_product_count\";a:3:{s:2:\"id\";s:18:\"hide_product_count\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:11:\"custom_icon\";a:3:{s:2:\"id\";s:11:\"custom_icon\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}}}i:2;a:3:{s:2:\"id\";s:20:\"5u866sftq6yga790jxf3\";s:4:\"type\";s:4:\"cart\";s:6:\"params\";a:4:{s:8:\"position\";a:3:{s:2:\"id\";s:8:\"position\";s:5:\"value\";s:4:\"side\";s:4:\"type\";s:8:\"selector\";}s:5:\"style\";a:3:{s:2:\"id\";s:5:\"style\";s:5:\"value\";s:1:\"2\";s:4:\"type\";s:8:\"selector\";}s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:3:\"bag\";s:4:\"type\";s:8:\"selector\";}s:11:\"custom_icon\";a:3:{s:2:\"id\";s:11:\"custom_icon\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}}}}}i:3;a:3:{s:2:\"id\";s:14:\"column_mobile2\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:1:{i:0;a:3:{s:2:\"id\";s:20:\"wn5z894j1g5n0yp3eeuz\";s:4:\"type\";s:6:\"burger\";s:6:\"params\";a:8:{s:5:\"style\";a:3:{s:2:\"id\";s:5:\"style\";s:5:\"value\";s:4:\"text\";s:4:\"type\";s:8:\"selector\";}s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:11:\"custom_icon\";a:3:{s:2:\"id\";s:11:\"custom_icon\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}s:8:\"position\";a:3:{s:2:\"id\";s:8:\"position\";s:5:\"value\";s:4:\"left\";s:4:\"type\";s:8:\"selector\";}s:11:\"search_form\";a:3:{s:2:\"id\";s:11:\"search_form\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:15:\"categories_menu\";a:3:{s:2:\"id\";s:15:\"categories_menu\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:7:\"menu_id\";a:3:{s:2:\"id\";s:7:\"menu_id\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:6:\"select\";}s:9:\"tabs_swap\";a:3:{s:2:\"id\";s:9:\"tabs_swap\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}}}}}i:4;a:3:{s:2:\"id\";s:14:\"column_mobile3\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:1:{i:0;a:3:{s:2:\"id\";s:20:\"g5z57bkgtznbk6v9pll5\";s:4:\"type\";s:4:\"logo\";s:6:\"params\";a:4:{s:5:\"image\";a:3:{s:2:\"id\";s:5:\"image\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}s:5:\"width\";a:3:{s:2:\"id\";s:5:\"width\";s:5:\"value\";i:140;s:4:\"type\";s:6:\"slider\";}s:12:\"sticky_image\";a:3:{s:2:\"id\";s:12:\"sticky_image\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}s:12:\"sticky_width\";a:3:{s:2:\"id\";s:12:\"sticky_width\";s:5:\"value\";i:150;s:4:\"type\";s:6:\"slider\";}}}}}i:5;a:3:{s:2:\"id\";s:14:\"column_mobile4\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:1:{i:0;a:3:{s:2:\"id\";s:20:\"u6cx6mzhiof1qeysah9h\";s:4:\"type\";s:4:\"cart\";s:6:\"params\";a:4:{s:8:\"position\";a:3:{s:2:\"id\";s:8:\"position\";s:5:\"value\";s:4:\"side\";s:4:\"type\";s:8:\"selector\";}s:5:\"style\";a:3:{s:2:\"id\";s:5:\"style\";s:5:\"value\";s:1:\"5\";s:4:\"type\";s:8:\"selector\";}s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:3:\"bag\";s:4:\"type\";s:8:\"selector\";}s:11:\"custom_icon\";a:3:{s:2:\"id\";s:11:\"custom_icon\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}}}}}}s:6:\"params\";a:11:{s:11:\"flex_layout\";a:3:{s:2:\"id\";s:11:\"flex_layout\";s:5:\"value\";s:11:\"flex-middle\";s:4:\"type\";s:8:\"selector\";}s:6:\"height\";a:3:{s:2:\"id\";s:6:\"height\";s:5:\"value\";i:80;s:4:\"type\";s:6:\"slider\";}s:13:\"mobile_height\";a:3:{s:2:\"id\";s:13:\"mobile_height\";s:5:\"value\";i:60;s:4:\"type\";s:6:\"slider\";}s:12:\"hide_desktop\";a:3:{s:2:\"id\";s:12:\"hide_desktop\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:11:\"hide_mobile\";a:3:{s:2:\"id\";s:11:\"hide_mobile\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:6:\"sticky\";a:3:{s:2:\"id\";s:6:\"sticky\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:13:\"sticky_height\";a:3:{s:2:\"id\";s:13:\"sticky_height\";s:5:\"value\";i:60;s:4:\"type\";s:6:\"slider\";}s:12:\"color_scheme\";a:3:{s:2:\"id\";s:12:\"color_scheme\";s:5:\"value\";s:4:\"dark\";s:4:\"type\";s:8:\"selector\";}s:6:\"shadow\";a:3:{s:2:\"id\";s:6:\"shadow\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:10:\"background\";a:3:{s:2:\"id\";s:10:\"background\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:2:\"bg\";}s:6:\"border\";a:3:{s:2:\"id\";s:6:\"border\";s:5:\"value\";a:3:{s:5:\"width\";s:1:\"1\";s:5:\"color\";a:4:{s:1:\"r\";i:129;s:1:\"g\";i:129;s:1:\"b\";i:129;s:1:\"a\";d:0.20000000000000001;}s:5:\"sides\";a:1:{i:0;s:6:\"bottom\";}}s:4:\"type\";s:6:\"border\";}}}i:2;a:4:{s:2:\"id\";s:13:\"header-bottom\";s:4:\"type\";s:3:\"row\";s:7:\"content\";a:4:{i:0;a:3:{s:2:\"id\";s:8:\"column11\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:1:{i:0;a:3:{s:2:\"id\";s:20:\"tiueim5f5uazw1f1dm8r\";s:4:\"type\";s:8:\"mainmenu\";s:6:\"params\";a:5:{s:10:\"menu_style\";a:3:{s:2:\"id\";s:10:\"menu_style\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:10:\"menu_align\";a:3:{s:2:\"id\";s:10:\"menu_align\";s:5:\"value\";s:4:\"left\";s:4:\"type\";s:8:\"selector\";}s:11:\"full_screen\";a:3:{s:2:\"id\";s:11:\"full_screen\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:11:\"custom_icon\";a:3:{s:2:\"id\";s:11:\"custom_icon\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}}}}}i:1;a:3:{s:2:\"id\";s:8:\"column12\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:0:{}}i:2;a:3:{s:2:\"id\";s:8:\"column13\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:0:{}}i:3;a:3:{s:2:\"id\";s:14:\"column_mobile5\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:0:{}}}s:6:\"params\";a:11:{s:11:\"flex_layout\";a:3:{s:2:\"id\";s:11:\"flex_layout\";s:5:\"value\";s:11:\"flex-middle\";s:4:\"type\";s:8:\"selector\";}s:6:\"height\";a:3:{s:2:\"id\";s:6:\"height\";s:5:\"value\";i:45;s:4:\"type\";s:6:\"slider\";}s:13:\"mobile_height\";a:3:{s:2:\"id\";s:13:\"mobile_height\";s:5:\"value\";i:50;s:4:\"type\";s:6:\"slider\";}s:12:\"hide_desktop\";a:3:{s:2:\"id\";s:12:\"hide_desktop\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:11:\"hide_mobile\";a:3:{s:2:\"id\";s:11:\"hide_mobile\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:6:\"sticky\";a:3:{s:2:\"id\";s:6:\"sticky\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:13:\"sticky_height\";a:3:{s:2:\"id\";s:13:\"sticky_height\";s:5:\"value\";i:50;s:4:\"type\";s:6:\"slider\";}s:12:\"color_scheme\";a:3:{s:2:\"id\";s:12:\"color_scheme\";s:5:\"value\";s:4:\"dark\";s:4:\"type\";s:8:\"selector\";}s:6:\"shadow\";a:3:{s:2:\"id\";s:6:\"shadow\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:10:\"background\";a:3:{s:2:\"id\";s:10:\"background\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:2:\"bg\";}s:6:\"border\";a:3:{s:2:\"id\";s:6:\"border\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:6:\"border\";}}}}}s:8:\"settings\";a:9:{s:7:\"overlap\";a:3:{s:2:\"id\";s:7:\"overlap\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:5:\"boxed\";a:3:{s:2:\"id\";s:5:\"boxed\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:10:\"full_width\";a:3:{s:2:\"id\";s:10:\"full_width\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:14:\"dropdowns_dark\";a:3:{s:2:\"id\";s:14:\"dropdowns_dark\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:13:\"sticky_shadow\";a:3:{s:2:\"id\";s:13:\"sticky_shadow\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:14:\"hide_on_scroll\";a:3:{s:2:\"id\";s:14:\"hide_on_scroll\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:13:\"sticky_effect\";a:3:{s:2:\"id\";s:13:\"sticky_effect\";s:5:\"value\";s:5:\"stick\";s:4:\"type\";s:8:\"selector\";}s:12:\"sticky_clone\";a:3:{s:2:\"id\";s:12:\"sticky_clone\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:13:\"sticky_height\";a:3:{s:2:\"id\";s:13:\"sticky_height\";s:5:\"value\";i:50;s:4:\"type\";s:6:\"slider\";}}s:4:\"name\";s:21:\"Default header layout\";s:2:\"id\";s:14:\"default_header\";}", "yes");
INSERT INTO `won_options` VALUES("179", "recently_activated", "a:1:{s:29:\"ar-contactus/ar-contactus.php\";i:1762685705;}", "off");
INSERT INTO `won_options` VALUES("353", "wc_blocks_db_schema_version", "260", "yes");
INSERT INTO `won_options` VALUES("182", "yit_recently_activated", "a:1:{i:0;s:33:\"yith-woocommerce-compare/init.php\";}", "yes");
INSERT INTO `won_options` VALUES("354", "yith_woocompare_is_button", "button", "yes");
INSERT INTO `won_options` VALUES("184", "action_scheduler_hybrid_store_demarkation", "5", "yes");
INSERT INTO `won_options` VALUES("185", "schema-ActionScheduler_StoreSchema", "8.0.1762614684", "yes");
INSERT INTO `won_options` VALUES("186", "schema-ActionScheduler_LoggerSchema", "3.0.1634224556", "yes");
INSERT INTO `won_options` VALUES("189", "woocommerce_schema_version", "920", "yes");
INSERT INTO `won_options` VALUES("190", "woocommerce_store_address", "", "yes");
INSERT INTO `won_options` VALUES("191", "woocommerce_store_address_2", "", "yes");
INSERT INTO `won_options` VALUES("192", "woocommerce_store_city", "", "yes");
INSERT INTO `won_options` VALUES("193", "woocommerce_default_country", "IR:THR", "yes");
INSERT INTO `won_options` VALUES("194", "woocommerce_store_postcode", "", "yes");
INSERT INTO `won_options` VALUES("195", "woocommerce_allowed_countries", "specific", "yes");
INSERT INTO `won_options` VALUES("196", "woocommerce_all_except_countries", "a:0:{}", "yes");
INSERT INTO `won_options` VALUES("197", "woocommerce_specific_allowed_countries", "a:1:{i:0;s:2:\"IR\";}", "yes");
INSERT INTO `won_options` VALUES("198", "woocommerce_ship_to_countries", "", "yes");
INSERT INTO `won_options` VALUES("199", "woocommerce_specific_ship_to_countries", "a:0:{}", "yes");
INSERT INTO `won_options` VALUES("200", "woocommerce_default_customer_address", "base", "yes");
INSERT INTO `won_options` VALUES("201", "woocommerce_calc_taxes", "no", "yes");
INSERT INTO `won_options` VALUES("202", "woocommerce_enable_coupons", "yes", "yes");
INSERT INTO `won_options` VALUES("203", "woocommerce_calc_discounts_sequentially", "no", "no");
INSERT INTO `won_options` VALUES("204", "woocommerce_currency", "IRT", "yes");
INSERT INTO `won_options` VALUES("205", "woocommerce_currency_pos", "right_space", "yes");
INSERT INTO `won_options` VALUES("206", "woocommerce_price_thousand_sep", ",", "yes");
INSERT INTO `won_options` VALUES("207", "woocommerce_price_decimal_sep", ".", "yes");
INSERT INTO `won_options` VALUES("208", "woocommerce_price_num_decimals", "0", "yes");
INSERT INTO `won_options` VALUES("209", "woocommerce_shop_page_id", "6", "yes");
INSERT INTO `won_options` VALUES("210", "woocommerce_cart_redirect_after_add", "no", "yes");
INSERT INTO `won_options` VALUES("211", "woocommerce_enable_ajax_add_to_cart", "yes", "yes");
INSERT INTO `won_options` VALUES("212", "woocommerce_placeholder_image", "5", "yes");
INSERT INTO `won_options` VALUES("213", "woocommerce_weight_unit", "kg", "yes");
INSERT INTO `won_options` VALUES("214", "woocommerce_dimension_unit", "cm", "yes");
INSERT INTO `won_options` VALUES("215", "woocommerce_enable_reviews", "yes", "yes");
INSERT INTO `won_options` VALUES("216", "woocommerce_review_rating_verification_label", "yes", "no");
INSERT INTO `won_options` VALUES("217", "woocommerce_review_rating_verification_required", "no", "no");
INSERT INTO `won_options` VALUES("218", "woocommerce_enable_review_rating", "yes", "yes");
INSERT INTO `won_options` VALUES("219", "woocommerce_review_rating_required", "yes", "no");
INSERT INTO `won_options` VALUES("220", "woocommerce_manage_stock", "yes", "yes");
INSERT INTO `won_options` VALUES("221", "woocommerce_hold_stock_minutes", "60", "no");
INSERT INTO `won_options` VALUES("222", "woocommerce_notify_low_stock", "yes", "no");
INSERT INTO `won_options` VALUES("223", "woocommerce_notify_no_stock", "yes", "no");
INSERT INTO `won_options` VALUES("224", "woocommerce_stock_email_recipient", "admin-email@demoabzar.com", "no");
INSERT INTO `won_options` VALUES("225", "woocommerce_notify_low_stock_amount", "2", "no");
INSERT INTO `won_options` VALUES("226", "woocommerce_notify_no_stock_amount", "0", "yes");
INSERT INTO `won_options` VALUES("227", "woocommerce_hide_out_of_stock_items", "no", "yes");
INSERT INTO `won_options` VALUES("228", "woocommerce_stock_format", "", "yes");
INSERT INTO `won_options` VALUES("229", "woocommerce_file_download_method", "force", "no");
INSERT INTO `won_options` VALUES("230", "woocommerce_downloads_require_login", "no", "no");
INSERT INTO `won_options` VALUES("231", "woocommerce_downloads_grant_access_after_payment", "yes", "no");
INSERT INTO `won_options` VALUES("232", "woocommerce_downloads_add_hash_to_filename", "yes", "yes");
INSERT INTO `won_options` VALUES("233", "woocommerce_prices_include_tax", "no", "yes");
INSERT INTO `won_options` VALUES("234", "woocommerce_tax_based_on", "shipping", "yes");
INSERT INTO `won_options` VALUES("235", "woocommerce_shipping_tax_class", "inherit", "yes");
INSERT INTO `won_options` VALUES("236", "woocommerce_tax_round_at_subtotal", "no", "yes");
INSERT INTO `won_options` VALUES("237", "woocommerce_tax_classes", "", "yes");
INSERT INTO `won_options` VALUES("238", "woocommerce_tax_display_shop", "excl", "yes");
INSERT INTO `won_options` VALUES("239", "woocommerce_tax_display_cart", "excl", "yes");
INSERT INTO `won_options` VALUES("240", "woocommerce_price_display_suffix", "", "yes");
INSERT INTO `won_options` VALUES("241", "woocommerce_tax_total_display", "itemized", "no");
INSERT INTO `won_options` VALUES("242", "woocommerce_enable_shipping_calc", "yes", "no");
INSERT INTO `won_options` VALUES("243", "woocommerce_shipping_cost_requires_address", "no", "yes");
INSERT INTO `won_options` VALUES("244", "woocommerce_ship_to_destination", "billing", "no");
INSERT INTO `won_options` VALUES("245", "woocommerce_shipping_debug_mode", "no", "yes");
INSERT INTO `won_options` VALUES("246", "woocommerce_enable_guest_checkout", "yes", "no");
INSERT INTO `won_options` VALUES("247", "woocommerce_enable_checkout_login_reminder", "yes", "no");
INSERT INTO `won_options` VALUES("248", "woocommerce_enable_signup_and_login_from_checkout", "no", "no");
INSERT INTO `won_options` VALUES("249", "woocommerce_enable_myaccount_registration", "yes", "no");
INSERT INTO `won_options` VALUES("250", "woocommerce_registration_generate_username", "yes", "no");
INSERT INTO `won_options` VALUES("251", "woocommerce_registration_generate_password", "no", "no");
INSERT INTO `won_options` VALUES("252", "woocommerce_erasure_request_removes_order_data", "no", "no");
INSERT INTO `won_options` VALUES("253", "woocommerce_erasure_request_removes_download_data", "no", "no");
INSERT INTO `won_options` VALUES("254", "woocommerce_allow_bulk_remove_personal_data", "no", "no");
INSERT INTO `won_options` VALUES("255", "woocommerce_registration_privacy_policy_text", "اطلاعات شخصی شما برای پردازش سفارش شما استفاده می‌شود، و پشتیبانی از تجربه شما در این وبسایت، و برای اهداف دیگری که در [privacy_policy] توضیح داده شده است.", "yes");
INSERT INTO `won_options` VALUES("256", "woocommerce_checkout_privacy_policy_text", "اطلاعات شخصی شما برای پردازش سفارش شما و پشتیبانی از تجربه شما در این وبسایت و برای اهداف دیگری که در [privacy_policy] توضیح داده شده است استفاده می‌شود.", "yes");
INSERT INTO `won_options` VALUES("257", "woocommerce_delete_inactive_accounts", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "no");
INSERT INTO `won_options` VALUES("258", "woocommerce_trash_pending_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:4:\"days\";}", "no");
INSERT INTO `won_options` VALUES("259", "woocommerce_trash_failed_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:4:\"days\";}", "no");
INSERT INTO `won_options` VALUES("260", "woocommerce_trash_cancelled_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:4:\"days\";}", "no");
INSERT INTO `won_options` VALUES("261", "woocommerce_anonymize_completed_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "no");
INSERT INTO `won_options` VALUES("262", "woocommerce_email_from_name", "قالب ودمارت", "no");
INSERT INTO `won_options` VALUES("263", "woocommerce_email_from_address", "admin-email@demoabzar.com", "no");
INSERT INTO `won_options` VALUES("264", "woocommerce_email_header_image", "", "no");
INSERT INTO `won_options` VALUES("265", "woocommerce_email_footer_text", "{site_title} &mdash; Built with {WooCommerce}", "no");
INSERT INTO `won_options` VALUES("266", "woocommerce_email_base_color", "#96588a", "no");
INSERT INTO `won_options` VALUES("267", "woocommerce_email_background_color", "#f7f7f7", "no");
INSERT INTO `won_options` VALUES("268", "woocommerce_email_body_background_color", "#ffffff", "no");
INSERT INTO `won_options` VALUES("269", "woocommerce_email_text_color", "#3c3c3c", "no");
INSERT INTO `won_options` VALUES("270", "woocommerce_merchant_email_notifications", "no", "no");
INSERT INTO `won_options` VALUES("271", "woocommerce_cart_page_id", "7", "no");
INSERT INTO `won_options` VALUES("272", "woocommerce_checkout_page_id", "8", "no");
INSERT INTO `won_options` VALUES("273", "woocommerce_myaccount_page_id", "9", "no");
INSERT INTO `won_options` VALUES("274", "woocommerce_terms_page_id", "", "no");
INSERT INTO `won_options` VALUES("275", "woocommerce_force_ssl_checkout", "no", "yes");
INSERT INTO `won_options` VALUES("276", "woocommerce_unforce_ssl_checkout", "no", "yes");
INSERT INTO `won_options` VALUES("277", "woocommerce_checkout_pay_endpoint", "order-pay", "yes");
INSERT INTO `won_options` VALUES("278", "woocommerce_checkout_order_received_endpoint", "order-received", "yes");
INSERT INTO `won_options` VALUES("279", "woocommerce_myaccount_add_payment_method_endpoint", "add-payment-method", "yes");
INSERT INTO `won_options` VALUES("280", "woocommerce_myaccount_delete_payment_method_endpoint", "delete-payment-method", "yes");
INSERT INTO `won_options` VALUES("281", "woocommerce_myaccount_set_default_payment_method_endpoint", "set-default-payment-method", "yes");
INSERT INTO `won_options` VALUES("282", "woocommerce_myaccount_orders_endpoint", "orders", "yes");
INSERT INTO `won_options` VALUES("283", "woocommerce_myaccount_view_order_endpoint", "view-order", "yes");
INSERT INTO `won_options` VALUES("284", "woocommerce_myaccount_downloads_endpoint", "downloads", "yes");
INSERT INTO `won_options` VALUES("285", "woocommerce_myaccount_edit_account_endpoint", "edit-account", "yes");
INSERT INTO `won_options` VALUES("286", "woocommerce_myaccount_edit_address_endpoint", "edit-address", "yes");
INSERT INTO `won_options` VALUES("287", "woocommerce_myaccount_payment_methods_endpoint", "payment-methods", "yes");
INSERT INTO `won_options` VALUES("288", "woocommerce_myaccount_lost_password_endpoint", "lost-password", "yes");
INSERT INTO `won_options` VALUES("289", "woocommerce_logout_endpoint", "customer-logout", "yes");
INSERT INTO `won_options` VALUES("290", "woocommerce_api_enabled", "no", "yes");
INSERT INTO `won_options` VALUES("291", "woocommerce_allow_tracking", "no", "on");
INSERT INTO `won_options` VALUES("292", "woocommerce_show_marketplace_suggestions", "no", "no");
INSERT INTO `won_options` VALUES("293", "woocommerce_single_image_width", "1200", "yes");
INSERT INTO `won_options` VALUES("294", "woocommerce_thumbnail_image_width", "600", "yes");
INSERT INTO `won_options` VALUES("295", "woocommerce_checkout_highlight_required_fields", "yes", "yes");
INSERT INTO `won_options` VALUES("296", "woocommerce_demo_store", "no", "no");
INSERT INTO `won_options` VALUES("297", "woocommerce_permalinks", "a:5:{s:12:\"product_base\";s:8:\"/product\";s:13:\"category_base\";s:16:\"product-category\";s:8:\"tag_base\";s:11:\"product-tag\";s:14:\"attribute_base\";s:0:\"\";s:22:\"use_verbose_page_rules\";b:0;}", "yes");
INSERT INTO `won_options` VALUES("298", "current_theme_supports_woocommerce", "yes", "yes");
INSERT INTO `won_options` VALUES("299", "woocommerce_queue_flush_rewrite_rules", "no", "yes");
INSERT INTO `won_options` VALUES("64792", "product_cat_children", "a:1:{i:15;a:1:{i:0;i:1518;}}", "auto");
INSERT INTO `won_options` VALUES("302", "default_product_cat", "15", "yes");
INSERT INTO `won_options` VALUES("355", "yith_woocompare_button_text", "مقایسه", "yes");
INSERT INTO `won_options` VALUES("305", "woocommerce_version", "10.3.5", "yes");
INSERT INTO `won_options` VALUES("306", "woocommerce_db_version", "10.3.5", "yes");
INSERT INTO `won_options` VALUES("313", "woocommerce_maxmind_geolocation_settings", "a:1:{s:15:\"database_prefix\";s:32:\"h19v9TpnaXs2Hp6GHeleIrLSFHe1encP\";}", "yes");
INSERT INTO `won_options` VALUES("311", "action_scheduler_lock_async-request-runner", "691d91d280b164.89870506|1763545614", "yes");
INSERT INTO `won_options` VALUES("312", "woocommerce_admin_notices", "a:1:{i:0;s:14:\"template_files\";}", "yes");
INSERT INTO `won_options` VALUES("315", "widget_akismet_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `won_options` VALUES("316", "widget_woocommerce_widget_cart", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `won_options` VALUES("317", "widget_woocommerce_layered_nav_filters", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `won_options` VALUES("318", "widget_woocommerce_layered_nav", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `won_options` VALUES("319", "widget_woocommerce_price_filter", "a:2:{i:2;a:1:{s:5:\"title\";s:32:\"فیلتر براساس قیمت\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `won_options` VALUES("320", "widget_woocommerce_product_categories", "a:2:{i:1;a:8:{s:5:\"title\";s:32:\"دسته بندی محصولات\";s:7:\"orderby\";s:4:\"name\";s:8:\"dropdown\";i:0;s:5:\"count\";i:0;s:12:\"hierarchical\";i:1;s:18:\"show_children_only\";i:0;s:10:\"hide_empty\";i:0;s:9:\"max_depth\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `won_options` VALUES("321", "widget_woocommerce_product_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `won_options` VALUES("322", "widget_woocommerce_product_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `won_options` VALUES("323", "widget_woocommerce_products", "a:2:{i:5;a:7:{s:5:\"title\";s:14:\"محصولات\";s:6:\"number\";i:5;s:4:\"show\";s:0:\"\";s:7:\"orderby\";s:4:\"date\";s:5:\"order\";s:4:\"desc\";s:9:\"hide_free\";i:0;s:11:\"show_hidden\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `won_options` VALUES("324", "widget_woocommerce_recently_viewed_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `won_options` VALUES("325", "widget_woocommerce_top_rated_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `won_options` VALUES("326", "widget_woocommerce_recent_reviews", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `won_options` VALUES("327", "widget_woocommerce_rating_filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `won_options` VALUES("328", "widget_nav_mega_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `won_options` VALUES("329", "widget_woodmart-banner", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `won_options` VALUES("330", "widget_woodmart-author-information", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `won_options` VALUES("331", "widget_woodmart-instagram", "a:2:{i:10;a:5:{s:5:\"title\";s:13:\"Our Instagram\";s:8:\"username\";s:17:\"ozdesignfurniture\";s:6:\"number\";s:1:\"9\";s:4:\"size\";s:9:\"thumbnail\";s:6:\"target\";s:6:\"_blank\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `won_options` VALUES("332", "widget_woodmart-html-block", "a:2:{s:12:\"_multiwidget\";i:1;i:9;a:1:{s:2:\"id\";s:4:\"2145\";}}", "yes");
INSERT INTO `won_options` VALUES("333", "widget_woodmart-recent-posts", "a:7:{i:6;a:11:{s:5:\"title\";s:26:\"نوشته های تازه\";s:5:\"limit\";i:3;s:12:\"thumb_height\";i:60;s:11:\"thumb_width\";i:75;s:6:\"offset\";i:0;s:5:\"order\";s:4:\"DESC\";s:7:\"orderby\";s:4:\"date\";s:8:\"category\";s:3:\"all\";s:4:\"date\";b:1;s:13:\"comment_count\";b:1;s:5:\"thumb\";b:1;}i:7;a:11:{s:5:\"title\";s:26:\"نوشته های تازه\";s:5:\"limit\";i:3;s:12:\"thumb_height\";i:60;s:11:\"thumb_width\";i:75;s:6:\"offset\";i:0;s:5:\"order\";s:4:\"DESC\";s:7:\"orderby\";s:4:\"date\";s:8:\"category\";s:3:\"all\";s:4:\"date\";b:1;s:13:\"comment_count\";b:1;s:5:\"thumb\";b:1;}i:9;a:4:{s:5:\"title\";s:12:\"Recent Posts\";s:5:\"limit\";i:3;s:12:\"thumb_height\";i:60;s:11:\"thumb_width\";i:75;}i:12;a:4:{s:5:\"title\";s:12:\"Recent Posts\";s:5:\"limit\";i:2;s:12:\"thumb_height\";i:60;s:11:\"thumb_width\";i:75;}i:5;a:11:{s:5:\"title\";s:26:\"نوشته های تازه\";s:5:\"limit\";i:3;s:12:\"thumb_height\";i:60;s:11:\"thumb_width\";i:75;s:6:\"offset\";i:0;s:5:\"order\";s:4:\"DESC\";s:7:\"orderby\";s:4:\"date\";s:8:\"category\";s:3:\"all\";s:4:\"date\";b:1;s:13:\"comment_count\";b:1;s:5:\"thumb\";b:1;}i:10;a:4:{s:5:\"title\";s:12:\"Recent Posts\";s:5:\"limit\";i:2;s:12:\"thumb_height\";i:60;s:11:\"thumb_width\";i:75;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `won_options` VALUES("334", "widget_woodmart-twitter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `won_options` VALUES("335", "widget_woodmart-user-panel", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `won_options` VALUES("336", "widget_woodmart-woocommerce-layered-nav", "a:3:{i:3;a:8:{s:5:\"title\";s:30:\"فیلتر براساس رنگ\";s:9:\"attribute\";s:5:\"color\";s:10:\"query_type\";s:3:\"and\";s:7:\"display\";s:4:\"list\";s:4:\"size\";s:6:\"normal\";s:6:\"labels\";s:2:\"on\";s:8:\"category\";a:1:{i:0;s:3:\"all\";}s:8:\"tooltips\";s:3:\"off\";}i:4;a:8:{s:5:\"title\";s:32:\"فیلتر براساس برند\";s:9:\"attribute\";s:5:\"brand\";s:8:\"category\";a:1:{i:0;s:3:\"all\";}s:10:\"query_type\";s:3:\"and\";s:7:\"display\";s:4:\"list\";s:4:\"size\";s:6:\"normal\";s:6:\"labels\";s:2:\"on\";s:8:\"tooltips\";s:3:\"off\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `won_options` VALUES("337", "widget_woodmart-woocommerce-sort-by", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `won_options` VALUES("338", "widget_woodmart-price-filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `won_options` VALUES("339", "widget_woodmart-ajax-search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `won_options` VALUES("340", "widget_wd-widget-stock-status", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `won_options` VALUES("341", "widget_yith-woocompare-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `won_options` VALUES("345", "woocommerce_admin_install_timestamp", "1617102074", "yes");
INSERT INTO `won_options` VALUES("46263", "woocommerce_admin_version", "3.3.2", "yes");
INSERT INTO `won_options` VALUES("348", "vc_version", "6.6.0", "yes");
INSERT INTO `won_options` VALUES("351", "wc_remote_inbox_notifications_stored_state", "O:8:\"stdClass\":3:{s:22:\"there_were_no_products\";b:1;s:22:\"there_are_now_products\";b:1;s:17:\"new_product_count\";i:0;}", "yes");
INSERT INTO `won_options` VALUES("356", "yith_woocompare_compare_button_in_product_page", "yes", "yes");
INSERT INTO `won_options` VALUES("357", "yith_woocompare_compare_button_in_products_list", "no", "yes");
INSERT INTO `won_options` VALUES("358", "yith_woocompare_auto_open", "yes", "yes");
INSERT INTO `won_options` VALUES("359", "yith_woocompare_table_text", "مقایسه‌ی محصولات", "yes");
INSERT INTO `won_options` VALUES("360", "yith_woocompare_fields_attrs", "all", "yes");
INSERT INTO `won_options` VALUES("361", "yith_woocompare_price_end", "yes", "yes");
INSERT INTO `won_options` VALUES("362", "yith_woocompare_add_to_cart_end", "no", "yes");
INSERT INTO `won_options` VALUES("363", "yith_woocompare_image_size", "a:3:{s:5:\"width\";i:220;s:6:\"height\";i:154;s:4:\"crop\";i:1;}", "yes");
INSERT INTO `won_options` VALUES("364", "yit_plugin_fw_panel_wc_default_options_set", "a:1:{s:21:\"yith_woocompare_panel\";b:1;}", "yes");
INSERT INTO `won_options` VALUES("365", "yith_plugin_fw_promo_2019_bis", "1", "yes");
INSERT INTO `won_options` VALUES("366", "wpb_js_composer_license_activation_notified", "yes", "yes");
INSERT INTO `won_options` VALUES("402", "wpb_js_google_fonts_subsets", "a:1:{i:0;s:5:\"latin\";}", "yes");
INSERT INTO `won_options` VALUES("403", "wpb_js_gutenberg_disable", "1", "yes");
INSERT INTO `won_options` VALUES("404", "wpb_js_default_template_post_type", "a:0:{}", "yes");
INSERT INTO `won_options` VALUES("445", "whb_saved_headers", "a:2:{s:14:\"default_header\";a:2:{s:2:\"id\";s:14:\"default_header\";s:4:\"name\";s:21:\"Default header layout\";}s:13:\"header_855638\";a:2:{s:2:\"id\";s:13:\"header_855638\";s:4:\"name\";s:23:\"Ughهدر پیشفرض1\";}}", "yes");
INSERT INTO `won_options` VALUES("64576", "xts-theme_settings_default-credentials", "requested", "auto");
INSERT INTO `won_options` VALUES("619", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "off");
INSERT INTO `won_options` VALUES("1382", "woocommerce_onboarding_profile", "a:1:{s:9:\"completed\";b:1;}", "yes");
INSERT INTO `won_options` VALUES("1627", "woodmart_import_attributes", "1", "yes");
INSERT INTO `won_options` VALUES("1007", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:20:\"chavosh.sd@gmail.com\";s:7:\"version\";s:5:\"6.7.4\";s:9:\"timestamp\";i:1762614695;}", "off");
INSERT INTO `won_options` VALUES("1650", "revslider-library-check", "1620160187", "yes");
INSERT INTO `won_options` VALUES("1651", "revslider-library-hash", "dae3de1eb57eeeee008b70e9a23844b5", "yes");
INSERT INTO `won_options` VALUES("1652", "rs-library", "a:3:{s:4:\"hash\";s:32:\"dae3de1eb57eeeee008b70e9a23844b5\";s:7:\"objects\";a:417:{i:0;a:12:{s:2:\"id\";s:3:\"198\";s:6:\"handle\";s:16:\"object_dvd_1.png\";s:4:\"name\";s:3:\"DVD\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:43:17\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:1;a:12:{s:2:\"id\";s:3:\"188\";s:6:\"handle\";s:18:\"object_plant_1.png\";s:4:\"name\";s:7:\"Plant 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:2;a:12:{s:2:\"id\";s:3:\"187\";s:6:\"handle\";s:16:\"object_pen_1.png\";s:4:\"name\";s:5:\"Pen 1\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:3;a:12:{s:2:\"id\";s:3:\"172\";s:6:\"handle\";s:16:\"object_egg_1.png\";s:4:\"name\";s:3:\"Egg\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:4;a:12:{s:2:\"id\";s:3:\"171\";s:6:\"handle\";s:19:\"object_guitar_1.png\";s:4:\"name\";s:6:\"Guitar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:5;a:12:{s:2:\"id\";s:3:\"170\";s:6:\"handle\";s:21:\"object_envelope_1.png\";s:4:\"name\";s:15:\"Closed Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:6;a:12:{s:2:\"id\";s:3:\"169\";s:6:\"handle\";s:19:\"object_postit_2.png\";s:4:\"name\";s:18:\"Postit Label White\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:7;a:12:{s:2:\"id\";s:3:\"168\";s:6:\"handle\";s:21:\"object_envelope_2.png\";s:4:\"name\";s:13:\"Open Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:8;a:12:{s:2:\"id\";s:3:\"167\";s:6:\"handle\";s:17:\"object_eggs_1.png\";s:4:\"name\";s:10:\"Egg Carton\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:9;a:12:{s:2:\"id\";s:3:\"166\";s:6:\"handle\";s:25:\"object_bottleopener_1.png\";s:4:\"name\";s:13:\"Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:10;a:12:{s:2:\"id\";s:3:\"165\";s:6:\"handle\";s:23:\"object_blueprints_1.png\";s:4:\"name\";s:10:\"Blueprints\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:11;a:12:{s:2:\"id\";s:3:\"164\";s:6:\"handle\";s:22:\"object_holepunch_1.png\";s:4:\"name\";s:10:\"Hole punch\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:12;a:12:{s:2:\"id\";s:3:\"163\";s:6:\"handle\";s:20:\"object_speaker_1.png\";s:4:\"name\";s:13:\"Black Speaker\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:13;a:12:{s:2:\"id\";s:3:\"162\";s:6:\"handle\";s:19:\"object_eraser_1.png\";s:4:\"name\";s:6:\"Eraser\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:14;a:12:{s:2:\"id\";s:3:\"161\";s:6:\"handle\";s:23:\"object_vinylcover_1.png\";s:4:\"name\";s:11:\"Vinyl Cover\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:15;a:12:{s:2:\"id\";s:3:\"160\";s:6:\"handle\";s:20:\"object_booklet_1.png\";s:4:\"name\";s:9:\"Booklet 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:16;a:12:{s:2:\"id\";s:3:\"159\";s:6:\"handle\";s:22:\"object_earphones_2.png\";s:4:\"name\";s:11:\"Earphones 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:17;a:12:{s:2:\"id\";s:3:\"158\";s:6:\"handle\";s:18:\"object_vinyl_1.png\";s:4:\"name\";s:5:\"Vinyl\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:18;a:12:{s:2:\"id\";s:3:\"157\";s:6:\"handle\";s:19:\"object_postit_1.png\";s:4:\"name\";s:17:\"Postit Label Pink\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:19;a:12:{s:2:\"id\";s:3:\"156\";s:6:\"handle\";s:23:\"object_mechpencil_1.png\";s:4:\"name\";s:17:\"Mechanical Pencil\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:20;a:12:{s:2:\"id\";s:3:\"155\";s:6:\"handle\";s:22:\"object_turntable_1.png\";s:4:\"name\";s:9:\"Turntable\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:21;a:12:{s:2:\"id\";s:3:\"154\";s:6:\"handle\";s:19:\"object_folder_2.png\";s:4:\"name\";s:19:\"Closed Folder Black\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:22;a:12:{s:2:\"id\";s:3:\"153\";s:6:\"handle\";s:19:\"object_postit_4.png\";s:4:\"name\";s:18:\"Postit Label Green\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:23;a:12:{s:2:\"id\";s:3:\"152\";s:6:\"handle\";s:19:\"object_folder_1.png\";s:4:\"name\";s:12:\"Blank Folder\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:24;a:12:{s:2:\"id\";s:3:\"151\";s:6:\"handle\";s:19:\"object_pencup_1.png\";s:4:\"name\";s:7:\"Pen Cup\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:25;a:12:{s:2:\"id\";s:3:\"150\";s:6:\"handle\";s:23:\"object_winebottle_1.png\";s:4:\"name\";s:15:\"Red Wine Bottle\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:26;a:12:{s:2:\"id\";s:3:\"149\";s:6:\"handle\";s:23:\"object_headphones_1.png\";s:4:\"name\";s:10:\"Headphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:27;a:12:{s:2:\"id\";s:3:\"148\";s:6:\"handle\";s:22:\"object_earphones_1.png\";s:4:\"name\";s:9:\"Earphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:28;a:12:{s:2:\"id\";s:3:\"147\";s:6:\"handle\";s:19:\"object_postit_3.png\";s:4:\"name\";s:19:\"Postit Label Yellow\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:29;a:12:{s:2:\"id\";s:3:\"146\";s:6:\"handle\";s:22:\"object_corkscrew_1.png\";s:4:\"name\";s:23:\"Corkscrew Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1300\";s:6:\"height\";s:4:\"1300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:30;a:12:{s:2:\"id\";s:3:\"145\";s:6:\"handle\";s:19:\"object_muffin_1.png\";s:4:\"name\";s:16:\"Chocolate Muffin\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:31;a:12:{s:2:\"id\";s:3:\"144\";s:6:\"handle\";s:18:\"object_chair_2.png\";s:4:\"name\";s:12:\"Yellow Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:32;a:12:{s:2:\"id\";s:3:\"143\";s:6:\"handle\";s:18:\"object_knife_2.png\";s:4:\"name\";s:7:\"Knife 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:33;a:12:{s:2:\"id\";s:3:\"142\";s:6:\"handle\";s:26:\"object_choppingboard_2.png\";s:4:\"name\";s:16:\"Chopping Board 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:34;a:12:{s:2:\"id\";s:3:\"141\";s:6:\"handle\";s:26:\"object_choppingboard_3.png\";s:4:\"name\";s:16:\"Chopping Board 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:35;a:12:{s:2:\"id\";s:3:\"140\";s:6:\"handle\";s:19:\"object_coffee_2.png\";s:4:\"name\";s:12:\"Coffee Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:4:\"1200\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:36;a:12:{s:2:\"id\";s:3:\"139\";s:6:\"handle\";s:18:\"object_bread_1.png\";s:4:\"name\";s:15:\"Croissant Bread\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:37;a:12:{s:2:\"id\";s:3:\"138\";s:6:\"handle\";s:18:\"object_spoon_2.png\";s:4:\"name\";s:12:\"Wodden Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:38;a:12:{s:2:\"id\";s:3:\"137\";s:6:\"handle\";s:26:\"object_choppingboard_1.png\";s:4:\"name\";s:16:\"Chopping Board 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:39;a:12:{s:2:\"id\";s:3:\"136\";s:6:\"handle\";s:16:\"object_cup_2.png\";s:4:\"name\";s:11:\"Empty Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:40;a:12:{s:2:\"id\";s:3:\"135\";s:6:\"handle\";s:18:\"object_knife_1.png\";s:4:\"name\";s:5:\"Knife\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:41;a:12:{s:2:\"id\";s:3:\"134\";s:6:\"handle\";s:18:\"object_spoon_1.png\";s:4:\"name\";s:5:\"Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:42;a:12:{s:2:\"id\";s:3:\"133\";s:6:\"handle\";s:16:\"object_cup_1.png\";s:4:\"name\";s:9:\"Empty Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:43;a:12:{s:2:\"id\";s:3:\"132\";s:6:\"handle\";s:18:\"object_chair_3.png\";s:4:\"name\";s:11:\"White Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:44;a:12:{s:2:\"id\";s:3:\"131\";s:6:\"handle\";s:19:\"object_coffee_1.png\";s:4:\"name\";s:10:\"Coffee Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:45;a:12:{s:2:\"id\";s:3:\"130\";s:6:\"handle\";s:19:\"object_frypan_2.png\";s:4:\"name\";s:9:\"Fry Pan 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:46;a:12:{s:2:\"id\";s:3:\"129\";s:6:\"handle\";s:19:\"object_frypan_1.png\";s:4:\"name\";s:9:\"Fry Pan 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:47;a:12:{s:2:\"id\";s:3:\"128\";s:6:\"handle\";s:17:\"object_fork_1.png\";s:4:\"name\";s:4:\"Fork\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:48;a:12:{s:2:\"id\";s:3:\"127\";s:6:\"handle\";s:20:\"object_dishrag_1.png\";s:4:\"name\";s:13:\"Dishrag Cloth\";s:4:\"tags\";a:0:{}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:49;a:12:{s:2:\"id\";s:3:\"126\";s:6:\"handle\";s:20:\"object_wacom_pen.png\";s:4:\"name\";s:17:\"Wacom Drawing Pen\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1060\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:50;a:12:{s:2:\"id\";s:3:\"125\";s:6:\"handle\";s:21:\"object_occulus_vr.png\";s:4:\"name\";s:23:\"Occulus Virtual Reality\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:51;a:12:{s:2:\"id\";s:3:\"124\";s:6:\"handle\";s:18:\"object_antenna.png\";s:4:\"name\";s:13:\"Antenna Radar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:52;a:12:{s:2:\"id\";s:3:\"123\";s:6:\"handle\";s:21:\"object_solarpanel.png\";s:4:\"name\";s:11:\"Solar Panel\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:53;a:12:{s:2:\"id\";s:3:\"122\";s:6:\"handle\";s:16:\"object_wacom.png\";s:4:\"name\";s:20:\"Wacom Drawing Tablet\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:54;a:12:{s:2:\"id\";s:3:\"121\";s:6:\"handle\";s:18:\"object_earth_2.png\";s:4:\"name\";s:20:\"Earth Globe Planet 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:55;a:12:{s:2:\"id\";s:3:\"120\";s:6:\"handle\";s:18:\"object_chair_1.png\";s:4:\"name\";s:12:\"Office Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:56;a:12:{s:2:\"id\";s:3:\"119\";s:6:\"handle\";s:24:\"object_windturbine_2.png\";s:4:\"name\";s:14:\"Wind Turbine 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:57;a:12:{s:2:\"id\";s:3:\"118\";s:6:\"handle\";s:22:\"object_windturbine.png\";s:4:\"name\";s:12:\"Wind Turbine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:58;a:12:{s:2:\"id\";s:3:\"117\";s:6:\"handle\";s:16:\"object_earth.png\";s:4:\"name\";s:18:\"Earth Globe Planet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:59;a:12:{s:2:\"id\";s:2:\"88\";s:6:\"handle\";s:24:\"object_eiffeltower_2.png\";s:4:\"name\";s:13:\"Eiffeltower 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:60;a:12:{s:2:\"id\";s:2:\"87\";s:6:\"handle\";s:21:\"object_notebook_1.png\";s:4:\"name\";s:11:\"Notebook PC\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:61;a:12:{s:2:\"id\";s:2:\"86\";s:6:\"handle\";s:20:\"object_macbook_1.png\";s:4:\"name\";s:20:\"Apple Macbook Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:62;a:12:{s:2:\"id\";s:2:\"85\";s:6:\"handle\";s:18:\"object_canon_2.png\";s:4:\"name\";s:21:\"Canon Camera DSLR Top\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:63;a:12:{s:2:\"id\";s:2:\"84\";s:6:\"handle\";s:19:\"object_iphone_3.png\";s:4:\"name\";s:25:\"Apple iPhone Silver White\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:64;a:12:{s:2:\"id\";s:2:\"83\";s:6:\"handle\";s:18:\"object_candy_2.png\";s:4:\"name\";s:15:\"Candy Colored 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:65;a:12:{s:2:\"id\";s:2:\"82\";s:6:\"handle\";s:21:\"object_macmouse_1.png\";s:4:\"name\";s:15:\"Apple Mac Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:66;a:12:{s:2:\"id\";s:2:\"81\";s:6:\"handle\";s:19:\"object_iphone_1.png\";s:4:\"name\";s:18:\"Apple iPhone Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:67;a:12:{s:2:\"id\";s:2:\"80\";s:6:\"handle\";s:17:\"object_deco_1.png\";s:4:\"name\";s:17:\"White Deco Object\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:68;a:12:{s:2:\"id\";s:2:\"79\";s:6:\"handle\";s:23:\"object_applewatch_1.png\";s:4:\"name\";s:24:\"Apple Watch White Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:69;a:12:{s:2:\"id\";s:2:\"78\";s:6:\"handle\";s:23:\"object_swissknife_1.png\";s:4:\"name\";s:11:\"Swiss Knife\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:70;a:12:{s:2:\"id\";s:2:\"77\";s:6:\"handle\";s:23:\"object_applewatch_2.png\";s:4:\"name\";s:17:\"Apple Watch Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:71;a:12:{s:2:\"id\";s:2:\"76\";s:6:\"handle\";s:18:\"object_candy_1.png\";s:4:\"name\";s:13:\"Candy Colored\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:72;a:12:{s:2:\"id\";s:2:\"75\";s:6:\"handle\";s:17:\"object_ipad_1.png\";s:4:\"name\";s:16:\"Apple iPad Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:73;a:12:{s:2:\"id\";s:2:\"74\";s:6:\"handle\";s:17:\"object_lamp_2.png\";s:4:\"name\";s:15:\"Black Desk Lamp\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:74;a:12:{s:2:\"id\";s:2:\"73\";s:6:\"handle\";s:18:\"object_canon_1.png\";s:4:\"name\";s:17:\"Canon Camera DLSR\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:75;a:12:{s:2:\"id\";s:2:\"72\";s:6:\"handle\";s:23:\"object_blackberry_2.png\";s:4:\"name\";s:12:\"Blackberry 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:76;a:12:{s:2:\"id\";s:2:\"71\";s:6:\"handle\";s:19:\"object_iphone_2.png\";s:4:\"name\";s:19:\"Apple iPhone Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:77;a:12:{s:2:\"id\";s:2:\"70\";s:6:\"handle\";s:17:\"object_ipad_2.png\";s:4:\"name\";s:15:\"Apple iPad Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:78;a:12:{s:2:\"id\";s:2:\"69\";s:6:\"handle\";s:20:\"object_printer_1.png\";s:4:\"name\";s:7:\"Printer\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:79;a:12:{s:2:\"id\";s:2:\"68\";s:6:\"handle\";s:20:\"object_pcmouse_1.png\";s:4:\"name\";s:14:\"Black PC Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:80;a:12:{s:2:\"id\";s:2:\"67\";s:6:\"handle\";s:17:\"object_ipad_3.png\";s:4:\"name\";s:17:\"Apple iPad Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:81;a:12:{s:2:\"id\";s:2:\"66\";s:6:\"handle\";s:17:\"object_lamp_1.png\";s:4:\"name\";s:13:\"Desk Lamp Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:82;a:12:{s:2:\"id\";s:2:\"65\";s:6:\"handle\";s:22:\"object_macscreen_1.png\";s:4:\"name\";s:16:\"Apple Mac Screen\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:83;a:12:{s:2:\"id\";s:2:\"64\";s:6:\"handle\";s:23:\"object_blackberry_3.png\";s:4:\"name\";s:12:\"Blackberry 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:84;a:12:{s:2:\"id\";s:2:\"63\";s:6:\"handle\";s:23:\"object_applewatch_3.png\";s:4:\"name\";s:16:\"Apple Watch Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:85;a:12:{s:2:\"id\";s:2:\"62\";s:6:\"handle\";s:23:\"object_blackberry_1.png\";s:4:\"name\";s:10:\"Blackberry\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:86;a:12:{s:2:\"id\";s:2:\"49\";s:6:\"handle\";s:19:\"object_bottle_1.png\";s:4:\"name\";s:18:\"Brown Glass Bottle\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:87;a:12:{s:2:\"id\";s:2:\"48\";s:6:\"handle\";s:20:\"object_glasses_1.png\";s:4:\"name\";s:19:\"Hipster Glasses Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:88;a:12:{s:2:\"id\";s:2:\"47\";s:6:\"handle\";s:21:\"object_magazine_1.png\";s:4:\"name\";s:14:\"Blank Magazine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:89;a:12:{s:2:\"id\";s:2:\"46\";s:6:\"handle\";s:28:\"object_leatherdocument_2.png\";s:4:\"name\";s:24:\"Black Leather Document 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:90;a:12:{s:2:\"id\";s:2:\"45\";s:6:\"handle\";s:18:\"object_purse_2.png\";s:4:\"name\";s:13:\"Black Purse 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:91;a:12:{s:2:\"id\";s:2:\"44\";s:6:\"handle\";s:23:\"object_typewriter_1.png\";s:4:\"name\";s:18:\"Retro Typewriter 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:92;a:12:{s:2:\"id\";s:2:\"43\";s:6:\"handle\";s:17:\"object_book_5.png\";s:4:\"name\";s:9:\"Old Books\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:93;a:12:{s:2:\"id\";s:2:\"42\";s:6:\"handle\";s:28:\"object_leatherdocument_1.png\";s:4:\"name\";s:29:\"Black Leather Document Closed\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:94;a:12:{s:2:\"id\";s:2:\"41\";s:6:\"handle\";s:17:\"object_book_4.png\";s:4:\"name\";s:8:\"Old Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:95;a:12:{s:2:\"id\";s:2:\"40\";s:6:\"handle\";s:19:\"object_wallet_2.png\";s:4:\"name\";s:22:\"Black Leather Document\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:96;a:12:{s:2:\"id\";s:2:\"39\";s:6:\"handle\";s:18:\"object_quill_2.png\";s:4:\"name\";s:15:\"Quill Feather 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:97;a:12:{s:2:\"id\";s:2:\"38\";s:6:\"handle\";s:24:\"object_eiffeltower_1.png\";s:4:\"name\";s:11:\"Eiffeltower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:98;a:12:{s:2:\"id\";s:2:\"37\";s:6:\"handle\";s:21:\"object_magazine_2.png\";s:4:\"name\";s:11:\"Open Book 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1333\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:99;a:12:{s:2:\"id\";s:2:\"36\";s:6:\"handle\";s:17:\"object_book_1.png\";s:4:\"name\";s:10:\"Blank Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:100;a:12:{s:2:\"id\";s:2:\"35\";s:6:\"handle\";s:20:\"object_glasses_2.png\";s:4:\"name\";s:15:\"Hipster Glasses\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:101;a:12:{s:2:\"id\";s:2:\"34\";s:6:\"handle\";s:17:\"object_book_2.png\";s:4:\"name\";s:11:\"Open Book 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:102;a:12:{s:2:\"id\";s:2:\"33\";s:6:\"handle\";s:19:\"object_gloves_1.png\";s:4:\"name\";s:12:\"Black Gloves\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:103;a:12:{s:2:\"id\";s:2:\"32\";s:6:\"handle\";s:23:\"object_typewriter_2.png\";s:4:\"name\";s:16:\"Retro Typewriter\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:104;a:12:{s:2:\"id\";s:2:\"31\";s:6:\"handle\";s:17:\"object_book_3.png\";s:4:\"name\";s:9:\"Open Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:105;a:12:{s:2:\"id\";s:2:\"30\";s:6:\"handle\";s:19:\"object_wallet_1.png\";s:4:\"name\";s:12:\"Black Wallet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:106;a:12:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:18:\"object_purse_1.png\";s:4:\"name\";s:11:\"Black Purse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:107;a:12:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:18:\"object_quill_1.png\";s:4:\"name\";s:13:\"Quill Feather\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:108;a:12:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:19:\"object_artbox_2.png\";s:4:\"name\";s:16:\"Art Box Colors 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:109;a:12:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:18:\"object_cloth_1.png\";s:4:\"name\";s:17:\"Cloth Paint Color\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:110;a:12:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:21:\"object_brushpot_1.png\";s:4:\"name\";s:9:\"Brush Pot\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"984\";s:6:\"height\";s:3:\"984\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:111;a:12:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:24:\"object_paintbucket_1.png\";s:4:\"name\";s:12:\"Paint Bucket\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:112;a:12:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:23:\"object_paintbrush_2.png\";s:4:\"name\";s:12:\"Paintbrush 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:113;a:12:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:19:\"object_artbox_1.png\";s:4:\"name\";s:14:\"Art Box Colors\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:114;a:12:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:23:\"object_paintbrush_3.png\";s:4:\"name\";s:12:\"Paintbrush 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:115;a:12:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:23:\"object_paintbrush_1.png\";s:4:\"name\";s:12:\"Paintbrush 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:116;a:12:{s:2:\"id\";s:2:\"11\";s:6:\"handle\";s:21:\"table_radio_right.png\";s:4:\"name\";s:18:\"Radio Speaker Wood\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:117;a:12:{s:2:\"id\";s:2:\"10\";s:6:\"handle\";s:18:\"keyboard_apple.png\";s:4:\"name\";s:14:\"Apple Keyboard\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:118;a:12:{s:2:\"id\";s:1:\"9\";s:6:\"handle\";s:20:\"macbook_top_gold.png\";s:4:\"name\";s:18:\"Apple Macbook Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:119;a:12:{s:2:\"id\";s:1:\"8\";s:6:\"handle\";s:21:\"nexus6_front_blue.png\";s:4:\"name\";s:19:\"Google Nexus 6 Blue\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:120;a:12:{s:2:\"id\";s:3:\"479\";s:6:\"handle\";s:31:\"Tram-beside-waiting-station.jpg\";s:4:\"name\";s:27:\"Tram beside waiting station\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:52:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:121;a:12:{s:2:\"id\";s:3:\"478\";s:6:\"handle\";s:14:\"Pulling-up.jpg\";s:4:\"name\";s:10:\"Pulling up\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1297\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:41:20\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:122;a:12:{s:2:\"id\";s:3:\"477\";s:6:\"handle\";s:16:\"Snowboarding.jpg\";s:4:\"name\";s:12:\"Snowboarding\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1290\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:41:20\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:123;a:12:{s:2:\"id\";s:3:\"476\";s:6:\"handle\";s:16:\"Morning-yoga.jpg\";s:4:\"name\";s:12:\"Morning yoga\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1346\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:124;a:12:{s:2:\"id\";s:3:\"475\";s:6:\"handle\";s:8:\"Yoga.jpg\";s:4:\"name\";s:4:\"Yoga\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:125;a:12:{s:2:\"id\";s:3:\"474\";s:6:\"handle\";s:14:\"Golf-balls.jpg\";s:4:\"name\";s:10:\"Golf balls\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:126;a:12:{s:2:\"id\";s:3:\"473\";s:6:\"handle\";s:19:\"Confident-Boxer.jpg\";s:4:\"name\";s:15:\"Confident Boxer\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:127;a:12:{s:2:\"id\";s:3:\"472\";s:6:\"handle\";s:11:\"Aerobic.jpg\";s:4:\"name\";s:7:\"Aerobic\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:128;a:12:{s:2:\"id\";s:3:\"471\";s:6:\"handle\";s:18:\"Riding-bicycle.jpg\";s:4:\"name\";s:14:\"Riding bicycle\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1358\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:129;a:12:{s:2:\"id\";s:3:\"470\";s:6:\"handle\";s:27:\"woman-with-barbell-back.jpg\";s:4:\"name\";s:23:\"woman with barbell back\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:130;a:12:{s:2:\"id\";s:3:\"469\";s:6:\"handle\";s:24:\"Woman-lying-on-floor.jpg\";s:4:\"name\";s:20:\"Woman lying on floor\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1318\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:131;a:12:{s:2:\"id\";s:3:\"468\";s:6:\"handle\";s:27:\"Holding-black-dumbbells.jpg\";s:4:\"name\";s:23:\"Holding black dumbbells\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:132;a:12:{s:2:\"id\";s:3:\"467\";s:6:\"handle\";s:25:\"Woman-using-dumbbells.jpg\";s:4:\"name\";s:21:\"Woman using dumbbells\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1425\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:133;a:12:{s:2:\"id\";s:3:\"466\";s:6:\"handle\";s:16:\"Soccer-cleat.jpg\";s:4:\"name\";s:12:\"Soccer cleat\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:134;a:12:{s:2:\"id\";s:3:\"465\";s:6:\"handle\";s:16:\"Soccer-field.jpg\";s:4:\"name\";s:12:\"Soccer field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:135;a:12:{s:2:\"id\";s:3:\"464\";s:6:\"handle\";s:23:\"Man-tying-his-shoes.jpg\";s:4:\"name\";s:19:\"Man tying his shoes\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1200\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:136;a:12:{s:2:\"id\";s:3:\"463\";s:6:\"handle\";s:10:\"Boxing.jpg\";s:4:\"name\";s:6:\"Boxing\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:137;a:12:{s:2:\"id\";s:3:\"462\";s:6:\"handle\";s:22:\"woman-with-barbell.jpg\";s:4:\"name\";s:18:\"woman with barbell\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:138;a:12:{s:2:\"id\";s:3:\"461\";s:6:\"handle\";s:12:\"Crossfit.jpg\";s:4:\"name\";s:8:\"Crossfit\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:139;a:12:{s:2:\"id\";s:3:\"460\";s:6:\"handle\";s:25:\"Man-and-woman-jogging.jpg\";s:4:\"name\";s:21:\"Man and woman jogging\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:140;a:12:{s:2:\"id\";s:3:\"459\";s:6:\"handle\";s:16:\"Playing-golf.jpg\";s:4:\"name\";s:12:\"Playing golf\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:141;a:12:{s:2:\"id\";s:3:\"458\";s:6:\"handle\";s:18:\"Surfer-in-wave.jpg\";s:4:\"name\";s:14:\"Surfer in wave\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:142;a:12:{s:2:\"id\";s:3:\"457\";s:6:\"handle\";s:25:\"Woman-lifting-barbell.jpg\";s:4:\"name\";s:21:\"Woman lifting barbell\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:143;a:12:{s:2:\"id\";s:3:\"456\";s:6:\"handle\";s:14:\"Stretching.jpg\";s:4:\"name\";s:10:\"Stretching\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:144;a:12:{s:2:\"id\";s:3:\"455\";s:6:\"handle\";s:18:\"Snowboarding-2.jpg\";s:4:\"name\";s:14:\"Snowboarding 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:145;a:12:{s:2:\"id\";s:3:\"454\";s:6:\"handle\";s:11:\"Balance.jpg\";s:4:\"name\";s:7:\"Balance\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1920\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:146;a:12:{s:2:\"id\";s:3:\"453\";s:6:\"handle\";s:19:\"Pool-meditation.jpg\";s:4:\"name\";s:15:\"Pool meditation\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:147;a:12:{s:2:\"id\";s:3:\"452\";s:6:\"handle\";s:18:\"Soccer-stadium.jpg\";s:4:\"name\";s:14:\"Soccer stadium\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:148;a:12:{s:2:\"id\";s:3:\"451\";s:6:\"handle\";s:25:\"Soccer-field-top-view.jpg\";s:4:\"name\";s:21:\"Soccer field top view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:149;a:12:{s:2:\"id\";s:3:\"450\";s:6:\"handle\";s:14:\"Basketball.jpg\";s:4:\"name\";s:10:\"Basketball\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:150;a:12:{s:2:\"id\";s:3:\"449\";s:6:\"handle\";s:14:\"in-the-fog.jpg\";s:4:\"name\";s:10:\"in the fog\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:151;a:12:{s:2:\"id\";s:3:\"448\";s:6:\"handle\";s:13:\"Handstand.jpg\";s:4:\"name\";s:9:\"Handstand\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:152;a:12:{s:2:\"id\";s:3:\"447\";s:6:\"handle\";s:11:\"Friends.jpg\";s:4:\"name\";s:7:\"Friends\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:153;a:12:{s:2:\"id\";s:3:\"446\";s:6:\"handle\";s:28:\"Sneakers-on-the-railroad.jpg\";s:4:\"name\";s:24:\"Sneakers on the railroad\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:154;a:12:{s:2:\"id\";s:3:\"445\";s:6:\"handle\";s:23:\"Family-on-the-ocean.jpg\";s:4:\"name\";s:19:\"Family on the ocean\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:155;a:12:{s:2:\"id\";s:3:\"444\";s:6:\"handle\";s:10:\"Sunset.jpg\";s:4:\"name\";s:6:\"Sunset\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:156;a:12:{s:2:\"id\";s:3:\"443\";s:6:\"handle\";s:9:\"Books.jpg\";s:4:\"name\";s:5:\"Books\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:157;a:12:{s:2:\"id\";s:3:\"442\";s:6:\"handle\";s:25:\"Looking-at-the-window.jpg\";s:4:\"name\";s:21:\"Looking at the window\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:158;a:12:{s:2:\"id\";s:3:\"441\";s:6:\"handle\";s:48:\"woman-standing-near-buildings-during-daytime.jpg\";s:4:\"name\";s:44:\"woman standing near buildings during daytime\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:159;a:12:{s:2:\"id\";s:3:\"440\";s:6:\"handle\";s:12:\"Lollipop.jpg\";s:4:\"name\";s:8:\"Lollipop\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1395\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:160;a:12:{s:2:\"id\";s:3:\"439\";s:6:\"handle\";s:26:\"People-crossing-street.jpg\";s:4:\"name\";s:22:\"People crossing street\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:161;a:12:{s:2:\"id\";s:3:\"438\";s:6:\"handle\";s:24:\"Friends-on-the-shore.jpg\";s:4:\"name\";s:20:\"Friends on the shore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:162;a:12:{s:2:\"id\";s:3:\"437\";s:6:\"handle\";s:13:\"Coworkers.jpg\";s:4:\"name\";s:9:\"Coworkers\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:163;a:12:{s:2:\"id\";s:3:\"436\";s:6:\"handle\";s:27:\"Hiking-in-the-Dolomites.jpg\";s:4:\"name\";s:23:\"Hiking in the Dolomites\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:164;a:12:{s:2:\"id\";s:3:\"435\";s:6:\"handle\";s:18:\"Successful-man.jpg\";s:4:\"name\";s:14:\"Successful man\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:165;a:12:{s:2:\"id\";s:3:\"434\";s:6:\"handle\";s:23:\"Beautiful-sunny-day.jpg\";s:4:\"name\";s:19:\"Beautiful sunny day\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:166;a:12:{s:2:\"id\";s:3:\"433\";s:6:\"handle\";s:8:\"Guys.jpg\";s:4:\"name\";s:4:\"Guys\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:167;a:12:{s:2:\"id\";s:3:\"432\";s:6:\"handle\";s:19:\"Confetti-Shower.jpg\";s:4:\"name\";s:15:\"Confetti Shower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:168;a:12:{s:2:\"id\";s:3:\"431\";s:6:\"handle\";s:24:\"Sun-was-setting-down.jpg\";s:4:\"name\";s:20:\"Sun was setting down\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:169;a:12:{s:2:\"id\";s:3:\"430\";s:6:\"handle\";s:9:\"Jumps.jpg\";s:4:\"name\";s:5:\"Jumps\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:170;a:12:{s:2:\"id\";s:3:\"429\";s:6:\"handle\";s:23:\"Friends-by-the-fire.jpg\";s:4:\"name\";s:19:\"Friends by the fire\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:171;a:12:{s:2:\"id\";s:3:\"428\";s:6:\"handle\";s:21:\"Under-the-blanket.jpg\";s:4:\"name\";s:17:\"Under the blanket\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1413\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:172;a:12:{s:2:\"id\";s:3:\"427\";s:6:\"handle\";s:18:\"Pretty-in-Pink.jpg\";s:4:\"name\";s:14:\"Pretty in Pink\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1394\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:173;a:12:{s:2:\"id\";s:3:\"426\";s:6:\"handle\";s:31:\"Discussions-at-a-long-table.jpg\";s:4:\"name\";s:27:\"Discussions at a long table\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1268\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:174;a:12:{s:2:\"id\";s:3:\"425\";s:6:\"handle\";s:18:\"Lost-in-Lemons.jpg\";s:4:\"name\";s:14:\"Lost in Lemons\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:175;a:12:{s:2:\"id\";s:3:\"424\";s:6:\"handle\";s:13:\"Team-work.jpg\";s:4:\"name\";s:9:\"Team work\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:176;a:12:{s:2:\"id\";s:3:\"423\";s:6:\"handle\";s:20:\"Romantic-evening.jpg\";s:4:\"name\";s:16:\"Romantic evening\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1263\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:177;a:12:{s:2:\"id\";s:3:\"422\";s:6:\"handle\";s:19:\"Crew-collective.jpg\";s:4:\"name\";s:15:\"Crew collective\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:178;a:12:{s:2:\"id\";s:3:\"421\";s:6:\"handle\";s:8:\"Code.jpg\";s:4:\"name\";s:4:\"Code\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:179;a:12:{s:2:\"id\";s:3:\"420\";s:6:\"handle\";s:48:\"Yellow-ceramic-mug-beside-gray-aluminum-iMac.jpg\";s:4:\"name\";s:44:\"Yellow ceramic mug beside gray aluminum iMac\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:180;a:12:{s:2:\"id\";s:3:\"419\";s:6:\"handle\";s:11:\"My-desk.jpg\";s:4:\"name\";s:7:\"My desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1315\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:181;a:12:{s:2:\"id\";s:3:\"418\";s:6:\"handle\";s:17:\"Cooperation-2.jpg\";s:4:\"name\";s:13:\"Cooperation 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:182;a:12:{s:2:\"id\";s:3:\"417\";s:6:\"handle\";s:33:\"MacBook-on-top-of-brown-table.jpg\";s:4:\"name\";s:29:\"MacBook on top of brown table\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:183;a:12:{s:2:\"id\";s:3:\"416\";s:6:\"handle\";s:27:\"Beautiful-working-place.jpg\";s:4:\"name\";s:23:\"Beautiful working place\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:184;a:12:{s:2:\"id\";s:3:\"415\";s:6:\"handle\";s:14:\"Typewriter.jpg\";s:4:\"name\";s:10:\"Typewriter\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:185;a:12:{s:2:\"id\";s:3:\"414\";s:6:\"handle\";s:19:\"White-desk-lamp.jpg\";s:4:\"name\";s:15:\"White desk lamp\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:186;a:12:{s:2:\"id\";s:3:\"413\";s:6:\"handle\";s:18:\"Office-working.jpg\";s:4:\"name\";s:14:\"Office working\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:187;a:12:{s:2:\"id\";s:3:\"412\";s:6:\"handle\";s:36:\"Silver-iMac-on-brown-wooden-desk.jpg\";s:4:\"name\";s:32:\"Silver iMac on brown wooden desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1240\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:188;a:12:{s:2:\"id\";s:3:\"411\";s:6:\"handle\";s:23:\"Working-in-progress.jpg\";s:4:\"name\";s:19:\"Working in progress\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:189;a:12:{s:2:\"id\";s:3:\"410\";s:6:\"handle\";s:15:\"Cooperation.jpg\";s:4:\"name\";s:11:\"Cooperation\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:190;a:12:{s:2:\"id\";s:3:\"409\";s:6:\"handle\";s:17:\"Working-place.jpg\";s:4:\"name\";s:13:\"Working place\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:191;a:12:{s:2:\"id\";s:3:\"408\";s:6:\"handle\";s:16:\"Working-desk.jpg\";s:4:\"name\";s:12:\"Working desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:192;a:12:{s:2:\"id\";s:3:\"407\";s:6:\"handle\";s:23:\"low-angle-of-forest.jpg\";s:4:\"name\";s:19:\"low angle of forest\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:193;a:12:{s:2:\"id\";s:3:\"406\";s:6:\"handle\";s:23:\"Lake-under-blue-sky.jpg\";s:4:\"name\";s:19:\"Lake under blue sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1351\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:194;a:12:{s:2:\"id\";s:3:\"405\";s:6:\"handle\";s:21:\"Blue-starry-night.jpg\";s:4:\"name\";s:17:\"Blue starry night\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:195;a:12:{s:2:\"id\";s:3:\"404\";s:6:\"handle\";s:22:\"Aerial-photography.jpg\";s:4:\"name\";s:18:\"Aerial photography\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:196;a:12:{s:2:\"id\";s:3:\"403\";s:6:\"handle\";s:14:\"Red-clouds.jpg\";s:4:\"name\";s:10:\"Red clouds\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:197;a:12:{s:2:\"id\";s:3:\"402\";s:6:\"handle\";s:14:\"Snow-field.jpg\";s:4:\"name\";s:10:\"Snow field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1227\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:198;a:12:{s:2:\"id\";s:3:\"401\";s:6:\"handle\";s:13:\"White-sky.jpg\";s:4:\"name\";s:9:\"White sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:199;a:12:{s:2:\"id\";s:3:\"400\";s:6:\"handle\";s:24:\"Trees-covered-by-fog.jpg\";s:4:\"name\";s:20:\"Trees covered by fog\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:200;a:12:{s:2:\"id\";s:3:\"399\";s:6:\"handle\";s:26:\"Red-and-white-mushroom.jpg\";s:4:\"name\";s:22:\"Red and white mushroom\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:201;a:12:{s:2:\"id\";s:3:\"398\";s:6:\"handle\";s:24:\"Lake-near-pine-trees.jpg\";s:4:\"name\";s:20:\"Lake near pine trees\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:202;a:12:{s:2:\"id\";s:3:\"397\";s:6:\"handle\";s:35:\"After-a-long-day-of-backpacking.jpg\";s:4:\"name\";s:31:\"After a long day of backpacking\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:203;a:12:{s:2:\"id\";s:3:\"396\";s:6:\"handle\";s:32:\"Mountains-during-golden-hour.jpg\";s:4:\"name\";s:28:\"Mountains during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:204;a:12:{s:2:\"id\";s:3:\"395\";s:6:\"handle\";s:27:\"Man-looking-on-mountain.jpg\";s:4:\"name\";s:23:\"Man looking on mountain\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:205;a:12:{s:2:\"id\";s:3:\"394\";s:6:\"handle\";s:19:\"Body-of-water-2.jpg\";s:4:\"name\";s:15:\"Body of water 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:206;a:12:{s:2:\"id\";s:3:\"393\";s:6:\"handle\";s:15:\"Brown-cliff.jpg\";s:4:\"name\";s:11:\"Brown cliff\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:207;a:12:{s:2:\"id\";s:3:\"392\";s:6:\"handle\";s:20:\"Green-foggy-tree.jpg\";s:4:\"name\";s:16:\"Green foggy tree\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1417\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:208;a:12:{s:2:\"id\";s:3:\"391\";s:6:\"handle\";s:32:\"Grayscale-photo-of-mountains.jpg\";s:4:\"name\";s:28:\"Grayscale photo of mountains\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:209;a:12:{s:2:\"id\";s:3:\"390\";s:6:\"handle\";s:19:\"Under-sunny-sky.jpg\";s:4:\"name\";s:15:\"Under sunny sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:210;a:12:{s:2:\"id\";s:3:\"389\";s:6:\"handle\";s:16:\"Rock-concert.jpg\";s:4:\"name\";s:12:\"Rock concert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1443\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:211;a:12:{s:2:\"id\";s:3:\"388\";s:6:\"handle\";s:30:\"Group-of-people-in-concert.jpg\";s:4:\"name\";s:26:\"Group of people in concert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:212;a:12:{s:2:\"id\";s:3:\"387\";s:6:\"handle\";s:6:\"DJ.jpg\";s:4:\"name\";s:2:\"DJ\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:213;a:12:{s:2:\"id\";s:3:\"386\";s:6:\"handle\";s:56:\"Woman-standing-watching-LED-light-musical-instrument.jpg\";s:4:\"name\";s:52:\"Woman standing watching LED light musical instrument\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:214;a:12:{s:2:\"id\";s:3:\"385\";s:6:\"handle\";s:16:\"Concert-hall.jpg\";s:4:\"name\";s:12:\"Concert hall\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:215;a:12:{s:2:\"id\";s:3:\"384\";s:6:\"handle\";s:18:\"Concert-hall-2.jpg\";s:4:\"name\";s:14:\"Concert hall 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:216;a:12:{s:2:\"id\";s:3:\"383\";s:6:\"handle\";s:29:\"man-playing-upright-piano.jpg\";s:4:\"name\";s:25:\"man playing upright piano\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1340\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:217;a:12:{s:2:\"id\";s:3:\"382\";s:6:\"handle\";s:30:\"person-performing-on-stage.jpg\";s:4:\"name\";s:26:\"person performing on stage\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:218;a:12:{s:2:\"id\";s:3:\"381\";s:6:\"handle\";s:27:\"Brown-string-instrument.jpg\";s:4:\"name\";s:23:\"Brown string instrument\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:219;a:12:{s:2:\"id\";s:3:\"380\";s:6:\"handle\";s:36:\"silhouette-of-person-with-guitar.jpg\";s:4:\"name\";s:32:\"silhouette of person with guitar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:220;a:12:{s:2:\"id\";s:3:\"379\";s:6:\"handle\";s:14:\"Party-fans.jpg\";s:4:\"name\";s:10:\"Party fans\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:221;a:12:{s:2:\"id\";s:3:\"378\";s:6:\"handle\";s:24:\"Condenser-microphone.jpg\";s:4:\"name\";s:20:\"Condenser microphone\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:222;a:12:{s:2:\"id\";s:3:\"377\";s:6:\"handle\";s:42:\"Low-angle-photo-of-high-rise-buildings.jpg\";s:4:\"name\";s:38:\"Low angle photo of high rise buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:223;a:12:{s:2:\"id\";s:3:\"376\";s:6:\"handle\";s:23:\"High-rise-buildings.jpg\";s:4:\"name\";s:19:\"High rise buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:224;a:12:{s:2:\"id\";s:3:\"375\";s:6:\"handle\";s:16:\"Cable-bridge.jpg\";s:4:\"name\";s:12:\"Cable bridge\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:225;a:12:{s:2:\"id\";s:3:\"374\";s:6:\"handle\";s:35:\"Bokeh-effect-from-street-lights.jpg\";s:4:\"name\";s:31:\"Bokeh effect from street lights\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:226;a:12:{s:2:\"id\";s:3:\"373\";s:6:\"handle\";s:18:\"Low-angle-view.jpg\";s:4:\"name\";s:14:\"Low angle view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:227;a:12:{s:2:\"id\";s:3:\"372\";s:6:\"handle\";s:21:\"Double-decker-bus.jpg\";s:4:\"name\";s:17:\"Double decker bus\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1373\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:228;a:12:{s:2:\"id\";s:3:\"371\";s:6:\"handle\";s:32:\"Buildings-near-body-of-water.jpg\";s:4:\"name\";s:28:\"Buildings near body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1370\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:229;a:12:{s:2:\"id\";s:3:\"370\";s:6:\"handle\";s:18:\"Satellite-view.jpg\";s:4:\"name\";s:14:\"Satellite view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:230;a:12:{s:2:\"id\";s:3:\"369\";s:6:\"handle\";s:14:\"Twin-Tower.jpg\";s:4:\"name\";s:10:\"Twin Tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:231;a:12:{s:2:\"id\";s:3:\"368\";s:6:\"handle\";s:22:\"Two-person-walking.jpg\";s:4:\"name\";s:18:\"Two person walking\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1345\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:232;a:12:{s:2:\"id\";s:3:\"367\";s:6:\"handle\";s:15:\"Sears-Tower.jpg\";s:4:\"name\";s:11:\"Sears Tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:233;a:12:{s:2:\"id\";s:3:\"366\";s:6:\"handle\";s:19:\"Night-cityscape.jpg\";s:4:\"name\";s:15:\"Night cityscape\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:234;a:12:{s:2:\"id\";s:3:\"365\";s:6:\"handle\";s:25:\"Empire-State-Building.jpg\";s:4:\"name\";s:21:\"Empire State Building\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:235;a:12:{s:2:\"id\";s:3:\"364\";s:6:\"handle\";s:9:\"Paris.jpg\";s:4:\"name\";s:5:\"Paris\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:236;a:12:{s:2:\"id\";s:3:\"363\";s:6:\"handle\";s:31:\"Building-during-golden-hour.jpg\";s:4:\"name\";s:27:\"Building during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1288\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:237;a:12:{s:2:\"id\";s:3:\"362\";s:6:\"handle\";s:21:\"Afternoon-skyline.jpg\";s:4:\"name\";s:17:\"Afternoon skyline\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:238;a:12:{s:2:\"id\";s:3:\"361\";s:6:\"handle\";s:22:\"Concrete-buildings.jpg\";s:4:\"name\";s:18:\"Concrete buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:239;a:12:{s:2:\"id\";s:3:\"360\";s:6:\"handle\";s:26:\"Architectural-building.jpg\";s:4:\"name\";s:22:\"Architectural building\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1382\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:240;a:12:{s:2:\"id\";s:3:\"359\";s:6:\"handle\";s:23:\"Skyline-photography.jpg\";s:4:\"name\";s:19:\"Skyline photography\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:241;a:12:{s:2:\"id\";s:3:\"358\";s:6:\"handle\";s:38:\"People-standing-on-pedestrian-lane.jpg\";s:4:\"name\";s:34:\"People standing on pedestrian lane\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1154\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:242;a:12:{s:2:\"id\";s:3:\"357\";s:6:\"handle\";s:16:\"Burj-Khalifa.jpg\";s:4:\"name\";s:12:\"Burj Khalifa\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:243;a:12:{s:2:\"id\";s:3:\"356\";s:6:\"handle\";s:13:\"Skycraper.jpg\";s:4:\"name\";s:9:\"Skycraper\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:244;a:12:{s:2:\"id\";s:3:\"355\";s:6:\"handle\";s:14:\"Gray-tower.jpg\";s:4:\"name\";s:10:\"Gray tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1433\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:245;a:12:{s:2:\"id\";s:3:\"354\";s:6:\"handle\";s:28:\"One-fine-day-in-Maldives.jpg\";s:4:\"name\";s:24:\"One fine day in Maldives\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1116\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:246;a:12:{s:2:\"id\";s:3:\"353\";s:6:\"handle\";s:25:\"Boat-on-body-of-water.jpg\";s:4:\"name\";s:21:\"Boat on body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:247;a:12:{s:2:\"id\";s:3:\"352\";s:6:\"handle\";s:33:\"Aerial-photo-of-body-of-water.jpg\";s:4:\"name\";s:29:\"Aerial photo of body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1078\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:248;a:12:{s:2:\"id\";s:3:\"351\";s:6:\"handle\";s:31:\"Assorted-color-beach-houses.jpg\";s:4:\"name\";s:27:\"Assorted color beach houses\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1135\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:249;a:12:{s:2:\"id\";s:3:\"350\";s:6:\"handle\";s:36:\"Woman-leaning-on-tree-near-beach.jpg\";s:4:\"name\";s:32:\"Woman leaning on tree near beach\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1559\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:250;a:12:{s:2:\"id\";s:3:\"349\";s:6:\"handle\";s:17:\"Body-of-water.jpg\";s:4:\"name\";s:13:\"Body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1269\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:251;a:12:{s:2:\"id\";s:3:\"348\";s:6:\"handle\";s:17:\"People-on-sea.jpg\";s:4:\"name\";s:13:\"People on sea\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:252;a:12:{s:2:\"id\";s:3:\"347\";s:6:\"handle\";s:31:\"Man-sitting-beside-of-woman.jpg\";s:4:\"name\";s:27:\"Man sitting beside of woman\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:253;a:12:{s:2:\"id\";s:3:\"346\";s:6:\"handle\";s:22:\"woman-in-the-water.jpg\";s:4:\"name\";s:18:\"woman in the water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:254;a:12:{s:2:\"id\";s:3:\"345\";s:6:\"handle\";s:39:\"Brown-stone-near-sea-at-golden-hour.jpg\";s:4:\"name\";s:35:\"Brown stone near sea at golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:255;a:12:{s:2:\"id\";s:3:\"344\";s:6:\"handle\";s:18:\"Birds-eye-view.jpg\";s:4:\"name\";s:14:\"Birds eye view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:256;a:12:{s:2:\"id\";s:3:\"343\";s:6:\"handle\";s:18:\"Empty-seashore.jpg\";s:4:\"name\";s:14:\"Empty seashore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1365\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:257;a:12:{s:2:\"id\";s:3:\"342\";s:6:\"handle\";s:31:\"Seashore-during-golden-hour.jpg\";s:4:\"name\";s:27:\"Seashore during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1439\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:258;a:12:{s:2:\"id\";s:3:\"341\";s:6:\"handle\";s:16:\"Coconut-tree.jpg\";s:4:\"name\";s:12:\"Coconut tree\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:259;a:12:{s:2:\"id\";s:3:\"340\";s:6:\"handle\";s:37:\"Aerial-photography-of-beach-shore.jpg\";s:4:\"name\";s:33:\"Aerial photography of beach shore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1439\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:260;a:12:{s:2:\"id\";s:3:\"197\";s:6:\"handle\";s:17:\"relax_hammock.jpg\";s:4:\"name\";s:13:\"Relax Hammock\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:261;a:12:{s:2:\"id\";s:3:\"196\";s:6:\"handle\";s:16:\"beach_houses.jpg\";s:4:\"name\";s:12:\"Beach Houses\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:262;a:12:{s:2:\"id\";s:3:\"195\";s:6:\"handle\";s:17:\"forest_road_2.jpg\";s:4:\"name\";s:13:\"Forest Road 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:263;a:12:{s:2:\"id\";s:3:\"194\";s:6:\"handle\";s:14:\"clean_desk.jpg\";s:4:\"name\";s:10:\"Clean Desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:264;a:12:{s:2:\"id\";s:3:\"193\";s:6:\"handle\";s:19:\"mountain_view_6.jpg\";s:4:\"name\";s:15:\"Mountain View 6\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1249\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:265;a:12:{s:2:\"id\";s:3:\"192\";s:6:\"handle\";s:14:\"corn_field.jpg\";s:4:\"name\";s:10:\"Corn Field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1320\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:266;a:12:{s:2:\"id\";s:3:\"191\";s:6:\"handle\";s:21:\"stylish_apartment.jpg\";s:4:\"name\";s:17:\"Stylish Apartment\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:267;a:12:{s:2:\"id\";s:3:\"190\";s:6:\"handle\";s:24:\"hipster_coffee_house.jpg\";s:4:\"name\";s:20:\"Hipster Coffee House\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:268;a:12:{s:2:\"id\";s:3:\"189\";s:6:\"handle\";s:16:\"blurry_beach.jpg\";s:4:\"name\";s:12:\"Blurry Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:269;a:12:{s:2:\"id\";s:3:\"186\";s:6:\"handle\";s:17:\"greens_street.jpg\";s:4:\"name\";s:13:\"Greens Street\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:270;a:12:{s:2:\"id\";s:3:\"185\";s:6:\"handle\";s:10:\"desert.jpg\";s:4:\"name\";s:6:\"Desert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:271;a:12:{s:2:\"id\";s:3:\"184\";s:6:\"handle\";s:19:\"mountain_view_5.jpg\";s:4:\"name\";s:15:\"Mountain View 5\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:272;a:12:{s:2:\"id\";s:3:\"183\";s:6:\"handle\";s:10:\"laptop.jpg\";s:4:\"name\";s:6:\"Laptop\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1391\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:273;a:12:{s:2:\"id\";s:3:\"182\";s:6:\"handle\";s:16:\"grand_canyon.jpg\";s:4:\"name\";s:12:\"Grand Canyon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1287\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:274;a:12:{s:2:\"id\";s:3:\"181\";s:6:\"handle\";s:20:\"landscape_clouds.jpg\";s:4:\"name\";s:16:\"Landscape Clouds\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:275;a:12:{s:2:\"id\";s:3:\"180\";s:6:\"handle\";s:17:\"highway_night.jpg\";s:4:\"name\";s:13:\"Highway Night\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:276;a:12:{s:2:\"id\";s:3:\"179\";s:6:\"handle\";s:15:\"beach_water.jpg\";s:4:\"name\";s:11:\"Beach Water\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:277;a:12:{s:2:\"id\";s:3:\"177\";s:6:\"handle\";s:15:\"woman_beach.jpg\";s:4:\"name\";s:11:\"Woman Beach\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:3;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:278;a:12:{s:2:\"id\";s:3:\"175\";s:6:\"handle\";s:12:\"cool_guy.jpg\";s:4:\"name\";s:8:\"Cool Guy\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:279;a:12:{s:2:\"id\";s:3:\"174\";s:6:\"handle\";s:13:\"beach_sea.jpg\";s:4:\"name\";s:9:\"Beach Sea\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:280;a:12:{s:2:\"id\";s:3:\"173\";s:6:\"handle\";s:17:\"bridge_clouds.jpg\";s:4:\"name\";s:13:\"Bridge Clouds\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:281;a:12:{s:2:\"id\";s:3:\"116\";s:6:\"handle\";s:19:\"mountain_view_2.jpg\";s:4:\"name\";s:15:\"Mountain View 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:282;a:12:{s:2:\"id\";s:3:\"115\";s:6:\"handle\";s:16:\"desert_trees.jpg\";s:4:\"name\";s:12:\"Desert Trees\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:283;a:12:{s:2:\"id\";s:3:\"114\";s:6:\"handle\";s:20:\"explore_moutains.jpg\";s:4:\"name\";s:17:\"Explore Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:284;a:12:{s:2:\"id\";s:3:\"113\";s:6:\"handle\";s:19:\"night_skyline_2.jpg\";s:4:\"name\";s:15:\"Night Skyline 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:285;a:12:{s:2:\"id\";s:3:\"112\";s:6:\"handle\";s:15:\"cliff_ocean.jpg\";s:4:\"name\";s:11:\"Cliff Ocean\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:286;a:12:{s:2:\"id\";s:3:\"111\";s:6:\"handle\";s:14:\"city_smoke.jpg\";s:4:\"name\";s:10:\"City Smoke\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:287;a:12:{s:2:\"id\";s:3:\"110\";s:6:\"handle\";s:16:\"surfer_beach.jpg\";s:4:\"name\";s:12:\"Surfer Beach\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:288;a:12:{s:2:\"id\";s:3:\"109\";s:6:\"handle\";s:13:\"sky_night.jpg\";s:4:\"name\";s:9:\"Sky Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:289;a:12:{s:2:\"id\";s:3:\"108\";s:6:\"handle\";s:15:\"palm_sunset.jpg\";s:4:\"name\";s:11:\"Palm Sunset\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:3;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1372\";s:6:\"height\";s:4:\"1920\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:290;a:12:{s:2:\"id\";s:3:\"107\";s:6:\"handle\";s:18:\"concert_people.jpg\";s:4:\"name\";s:14:\"Concert People\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:291;a:12:{s:2:\"id\";s:3:\"106\";s:6:\"handle\";s:15:\"forest_road.jpg\";s:4:\"name\";s:11:\"Forest Road\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:292;a:12:{s:2:\"id\";s:3:\"105\";s:6:\"handle\";s:15:\"beach_ocean.jpg\";s:4:\"name\";s:11:\"Beach Ocean\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:293;a:12:{s:2:\"id\";s:3:\"104\";s:6:\"handle\";s:18:\"mountain_night.jpg\";s:4:\"name\";s:14:\"Mountain Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:294;a:12:{s:2:\"id\";s:3:\"103\";s:6:\"handle\";s:19:\"ocean_mountains.jpg\";s:4:\"name\";s:15:\"Ocean Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:295;a:12:{s:2:\"id\";s:3:\"102\";s:6:\"handle\";s:10:\"forest.jpg\";s:4:\"name\";s:6:\"Forest\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:296;a:12:{s:2:\"id\";s:3:\"101\";s:6:\"handle\";s:16:\"ocean_stones.jpg\";s:4:\"name\";s:12:\"Ocean Stones\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:297;a:12:{s:2:\"id\";s:3:\"100\";s:6:\"handle\";s:16:\"country_road.jpg\";s:4:\"name\";s:12:\"Country Road\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:298;a:12:{s:2:\"id\";s:2:\"99\";s:6:\"handle\";s:9:\"beach.jpg\";s:4:\"name\";s:5:\"Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:299;a:12:{s:2:\"id\";s:2:\"98\";s:6:\"handle\";s:16:\"city_skyline.jpg\";s:4:\"name\";s:12:\"City Skyline\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:300;a:12:{s:2:\"id\";s:2:\"97\";s:6:\"handle\";s:17:\"night_skyline.jpg\";s:4:\"name\";s:13:\"Night Skyline\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:301;a:12:{s:2:\"id\";s:2:\"96\";s:6:\"handle\";s:14:\"city_river.jpg\";s:4:\"name\";s:10:\"City River\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:302;a:12:{s:2:\"id\";s:2:\"95\";s:6:\"handle\";s:19:\"mountain_view_3.jpg\";s:4:\"name\";s:15:\"Mountain View 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:303;a:12:{s:2:\"id\";s:2:\"94\";s:6:\"handle\";s:14:\"misty_farm.jpg\";s:4:\"name\";s:10:\"Misty Farm\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:304;a:12:{s:2:\"id\";s:2:\"93\";s:6:\"handle\";s:17:\"mountain_path.jpg\";s:4:\"name\";s:13:\"Mountain Path\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:305;a:12:{s:2:\"id\";s:2:\"92\";s:6:\"handle\";s:19:\"night_skyline_3.jpg\";s:4:\"name\";s:15:\"Night Skyline 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:306;a:12:{s:2:\"id\";s:2:\"91\";s:6:\"handle\";s:17:\"mountain_view.jpg\";s:4:\"name\";s:13:\"Mountain View\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1160\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:307;a:12:{s:2:\"id\";s:2:\"90\";s:6:\"handle\";s:19:\"rocky_landscape.jpg\";s:4:\"name\";s:15:\"Rocky Landscape\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:308;a:12:{s:2:\"id\";s:2:\"89\";s:6:\"handle\";s:19:\"mountain_view_4.jpg\";s:4:\"name\";s:15:\"Mountain View 4\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1203\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:309;a:13:{s:2:\"id\";s:3:\"529\";s:6:\"handle\";s:13:\"Fitness-4.jpg\";s:5:\"video\";s:13:\"Fitness-4.mp4\";s:4:\"name\";s:10:\"Fitness 4 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:310;a:13:{s:2:\"id\";s:3:\"528\";s:6:\"handle\";s:13:\"Fitness-3.jpg\";s:5:\"video\";s:13:\"Fitness-3.mp4\";s:4:\"name\";s:10:\"Fitness 3 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:311;a:13:{s:2:\"id\";s:3:\"527\";s:6:\"handle\";s:9:\"Chess.jpg\";s:5:\"video\";s:9:\"Chess.mp4\";s:4:\"name\";s:6:\"Chess \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:312;a:13:{s:2:\"id\";s:3:\"526\";s:6:\"handle\";s:13:\"Fitness-2.jpg\";s:5:\"video\";s:13:\"Fitness-2.mp4\";s:4:\"name\";s:10:\"Fitness 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:313;a:13:{s:2:\"id\";s:3:\"525\";s:6:\"handle\";s:11:\"Fitness.jpg\";s:5:\"video\";s:11:\"Fitness.mp4\";s:4:\"name\";s:8:\"Fitness \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:314;a:13:{s:2:\"id\";s:3:\"524\";s:6:\"handle\";s:9:\"Earth.jpg\";s:5:\"video\";s:9:\"Earth.mp4\";s:4:\"name\";s:6:\"Earth \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:315;a:13:{s:2:\"id\";s:3:\"523\";s:6:\"handle\";s:11:\"Space-2.jpg\";s:5:\"video\";s:11:\"Space-2.mp4\";s:4:\"name\";s:8:\"Space 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1440\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:316;a:13:{s:2:\"id\";s:3:\"522\";s:6:\"handle\";s:13:\"Asteroids.jpg\";s:5:\"video\";s:13:\"Asteroids.mp4\";s:4:\"name\";s:10:\"Asteroids \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:317;a:13:{s:2:\"id\";s:3:\"521\";s:6:\"handle\";s:9:\"Space.jpg\";s:5:\"video\";s:9:\"Space.mp4\";s:4:\"name\";s:6:\"Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:318;a:13:{s:2:\"id\";s:3:\"520\";s:6:\"handle\";s:10:\"People.jpg\";s:5:\"video\";s:10:\"People.mp4\";s:4:\"name\";s:7:\"People \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:319;a:13:{s:2:\"id\";s:3:\"519\";s:6:\"handle\";s:11:\"Walking.jpg\";s:5:\"video\";s:11:\"Walking.mp4\";s:4:\"name\";s:8:\"Walking \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:320;a:13:{s:2:\"id\";s:3:\"518\";s:6:\"handle\";s:19:\"Double-Exposure.jpg\";s:5:\"video\";s:19:\"Double-Exposure.mp4\";s:4:\"name\";s:16:\"Double Exposure \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:321;a:13:{s:2:\"id\";s:3:\"517\";s:6:\"handle\";s:8:\"Girl.jpg\";s:5:\"video\";s:8:\"Girl.mp4\";s:4:\"name\";s:5:\"Girl \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1088\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:322;a:13:{s:2:\"id\";s:3:\"516\";s:6:\"handle\";s:17:\"Bengal-Lights.jpg\";s:5:\"video\";s:17:\"Bengal-Lights.mp4\";s:4:\"name\";s:14:\"Bengal Lights \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:323;a:13:{s:2:\"id\";s:3:\"515\";s:6:\"handle\";s:13:\"Swiping-2.jpg\";s:5:\"video\";s:13:\"Swiping-2.mp4\";s:4:\"name\";s:10:\"Swiping 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:324;a:13:{s:2:\"id\";s:3:\"514\";s:6:\"handle\";s:11:\"Mock-Up.jpg\";s:5:\"video\";s:11:\"Mock-Up.mp4\";s:4:\"name\";s:8:\"Mock Up \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:325;a:13:{s:2:\"id\";s:3:\"513\";s:6:\"handle\";s:13:\"Countdown.jpg\";s:5:\"video\";s:13:\"Countdown.mp4\";s:4:\"name\";s:10:\"Countdown \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:326;a:13:{s:2:\"id\";s:3:\"512\";s:6:\"handle\";s:18:\"Wall-Sketching.jpg\";s:5:\"video\";s:18:\"Wall-Sketching.mp4\";s:4:\"name\";s:15:\"Wall Sketching \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:327;a:13:{s:2:\"id\";s:3:\"511\";s:6:\"handle\";s:26:\"Typing-on-the-keyboard.jpg\";s:5:\"video\";s:26:\"Typing-on-the-keyboard.mp4\";s:4:\"name\";s:23:\"Typing on the keyboard \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:328;a:13:{s:2:\"id\";s:3:\"510\";s:6:\"handle\";s:11:\"Meeting.jpg\";s:5:\"video\";s:11:\"Meeting.mp4\";s:4:\"name\";s:8:\"Meeting \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:329;a:13:{s:2:\"id\";s:3:\"509\";s:6:\"handle\";s:11:\"Swiping.jpg\";s:5:\"video\";s:11:\"Swiping.mp4\";s:4:\"name\";s:8:\"Swiping \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:330;a:13:{s:2:\"id\";s:3:\"508\";s:6:\"handle\";s:9:\"Alarm.jpg\";s:5:\"video\";s:9:\"Alarm.mp4\";s:4:\"name\";s:6:\"Alarm \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1013\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:331;a:13:{s:2:\"id\";s:3:\"507\";s:6:\"handle\";s:13:\"Hey-World.jpg\";s:5:\"video\";s:13:\"Hey-World.mp4\";s:4:\"name\";s:10:\"Hey World \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:332;a:13:{s:2:\"id\";s:3:\"506\";s:6:\"handle\";s:28:\"Typing-on-the-keyboard-2.jpg\";s:5:\"video\";s:28:\"Typing-on-the-keyboard-2.mp4\";s:4:\"name\";s:25:\"Typing on the keyboard 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:333;a:13:{s:2:\"id\";s:3:\"505\";s:6:\"handle\";s:10:\"Valley.jpg\";s:5:\"video\";s:10:\"Valley.mp4\";s:4:\"name\";s:7:\"Valley \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:334;a:13:{s:2:\"id\";s:3:\"504\";s:6:\"handle\";s:9:\"Stars.jpg\";s:5:\"video\";s:9:\"Stars.mp4\";s:4:\"name\";s:6:\"Stars \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:335;a:13:{s:2:\"id\";s:3:\"503\";s:6:\"handle\";s:21:\"Car-in-the-forest.jpg\";s:5:\"video\";s:21:\"Car-in-the-forest.mp4\";s:4:\"name\";s:18:\"Car in the forest \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1012\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:336;a:13:{s:2:\"id\";s:3:\"502\";s:6:\"handle\";s:15:\"Aerial-Shot.jpg\";s:5:\"video\";s:15:\"Aerial-Shot.mp4\";s:4:\"name\";s:12:\"Aerial Shot \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:337;a:13:{s:2:\"id\";s:3:\"501\";s:6:\"handle\";s:14:\"Disco-Ball.jpg\";s:5:\"video\";s:14:\"Disco-Ball.mp4\";s:4:\"name\";s:11:\"Disco Ball \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:338;a:13:{s:2:\"id\";s:3:\"500\";s:6:\"handle\";s:22:\"Man-Playing-Guitar.jpg\";s:5:\"video\";s:22:\"Man-Playing-Guitar.mp4\";s:4:\"name\";s:19:\"Man Playing Guitar \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:339;a:13:{s:2:\"id\";s:3:\"499\";s:6:\"handle\";s:14:\"Live-Music.jpg\";s:5:\"video\";s:14:\"Live-Music.mp4\";s:4:\"name\";s:11:\"Live Music \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:340;a:13:{s:2:\"id\";s:3:\"498\";s:6:\"handle\";s:12:\"Cheer-Up.jpg\";s:5:\"video\";s:12:\"Cheer-Up.mp4\";s:4:\"name\";s:9:\"Cheer Up \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:341;a:13:{s:2:\"id\";s:3:\"497\";s:6:\"handle\";s:14:\"Night-club.jpg\";s:5:\"video\";s:14:\"Night-club.mp4\";s:4:\"name\";s:11:\"Night club \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:342;a:13:{s:2:\"id\";s:3:\"496\";s:6:\"handle\";s:17:\"Cup-Of-Coffee.jpg\";s:5:\"video\";s:17:\"Cup-Of-Coffee.mp4\";s:4:\"name\";s:14:\"Cup Of Coffee \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:343;a:13:{s:2:\"id\";s:3:\"495\";s:6:\"handle\";s:7:\"Pot.jpg\";s:5:\"video\";s:7:\"Pot.mp4\";s:4:\"name\";s:4:\"Pot \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:344;a:13:{s:2:\"id\";s:3:\"494\";s:6:\"handle\";s:11:\"Grill-2.jpg\";s:5:\"video\";s:11:\"Grill-2.mp4\";s:4:\"name\";s:8:\"Grill 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:345;a:13:{s:2:\"id\";s:3:\"493\";s:6:\"handle\";s:13:\"Rice-Bowl.jpg\";s:5:\"video\";s:13:\"Rice-Bowl.mp4\";s:4:\"name\";s:10:\"Rice Bowl \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1010\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:346;a:13:{s:2:\"id\";s:3:\"492\";s:6:\"handle\";s:9:\"Grill.jpg\";s:5:\"video\";s:9:\"Grill.mp4\";s:4:\"name\";s:6:\"Grill \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:347;a:13:{s:2:\"id\";s:3:\"491\";s:6:\"handle\";s:9:\"Water.jpg\";s:5:\"video\";s:9:\"Water.mp4\";s:4:\"name\";s:6:\"Water \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:348;a:13:{s:2:\"id\";s:3:\"490\";s:6:\"handle\";s:17:\"Feet-and-Sand.jpg\";s:5:\"video\";s:17:\"Feet-and-Sand.mp4\";s:4:\"name\";s:14:\"Feet and Sand \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:349;a:13:{s:2:\"id\";s:3:\"489\";s:6:\"handle\";s:9:\"Ocean.jpg\";s:5:\"video\";s:9:\"Ocean.mp4\";s:4:\"name\";s:6:\"Ocean \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:350;a:13:{s:2:\"id\";s:3:\"488\";s:6:\"handle\";s:9:\"Waves.jpg\";s:5:\"video\";s:9:\"Waves.mp4\";s:4:\"name\";s:6:\"Waves \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:351;a:13:{s:2:\"id\";s:3:\"487\";s:6:\"handle\";s:10:\"Hearts.jpg\";s:5:\"video\";s:10:\"Hearts.mp4\";s:4:\"name\";s:7:\"Hearts \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:352;a:13:{s:2:\"id\";s:3:\"486\";s:6:\"handle\";s:12:\"Octagons.jpg\";s:5:\"video\";s:12:\"Octagons.mp4\";s:4:\"name\";s:9:\"Octagons \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:353;a:13:{s:2:\"id\";s:3:\"485\";s:6:\"handle\";s:11:\"Squares.jpg\";s:5:\"video\";s:11:\"Squares.mp4\";s:4:\"name\";s:8:\"Squares \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:354;a:13:{s:2:\"id\";s:3:\"484\";s:6:\"handle\";s:12:\"Pink-ink.jpg\";s:5:\"video\";s:12:\"Pink-ink.mp4\";s:4:\"name\";s:9:\"Pink ink \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:355;a:13:{s:2:\"id\";s:3:\"483\";s:6:\"handle\";s:22:\"Blurred-Background.jpg\";s:5:\"video\";s:22:\"Blurred-Background.mp4\";s:4:\"name\";s:19:\"Blurred Background \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:356;a:13:{s:2:\"id\";s:3:\"482\";s:6:\"handle\";s:20:\"Blinking-bubbles.jpg\";s:5:\"video\";s:20:\"Blinking-bubbles.mp4\";s:4:\"name\";s:17:\"Blinking bubbles \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:357;a:13:{s:2:\"id\";s:3:\"481\";s:6:\"handle\";s:13:\"Fireworks.jpg\";s:5:\"video\";s:13:\"Fireworks.mp4\";s:4:\"name\";s:10:\"Fireworks \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:358;a:13:{s:2:\"id\";s:3:\"480\";s:6:\"handle\";s:12:\"Dark-ink.jpg\";s:5:\"video\";s:12:\"Dark-ink.mp4\";s:4:\"name\";s:9:\"Dark ink \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:359;a:13:{s:2:\"id\";s:3:\"238\";s:6:\"handle\";s:12:\"Mt_Baker.jpg\";s:5:\"video\";s:12:\"Mt_Baker.mp4\";s:4:\"name\";s:9:\"Mt Baker \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:360;a:13:{s:2:\"id\";s:3:\"237\";s:6:\"handle\";s:16:\"Two-Swimmers.jpg\";s:5:\"video\";s:16:\"Two-Swimmers.mp4\";s:4:\"name\";s:13:\"Two Swimmers \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:361;a:13:{s:2:\"id\";s:3:\"236\";s:6:\"handle\";s:14:\"Boats_Maze.jpg\";s:5:\"video\";s:14:\"Boats_Maze.mp4\";s:4:\"name\";s:11:\"Boats Maze \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:362;a:13:{s:2:\"id\";s:3:\"235\";s:6:\"handle\";s:18:\"Candolim-Beach.jpg\";s:5:\"video\";s:18:\"Candolim-Beach.mp4\";s:4:\"name\";s:15:\"Candolim Beach \";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:363;a:13:{s:2:\"id\";s:3:\"234\";s:6:\"handle\";s:17:\"Working-Space.jpg\";s:5:\"video\";s:17:\"Working-Space.mp4\";s:4:\"name\";s:14:\"Working Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:364;a:13:{s:2:\"id\";s:3:\"233\";s:6:\"handle\";s:9:\"Wavez.jpg\";s:5:\"video\";s:9:\"Wavez.mp4\";s:4:\"name\";s:6:\"Wavez \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:365;a:13:{s:2:\"id\";s:3:\"232\";s:6:\"handle\";s:17:\"Coconut-Grove.jpg\";s:5:\"video\";s:17:\"Coconut-Grove.mp4\";s:4:\"name\";s:14:\"Coconut Grove \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:366;a:13:{s:2:\"id\";s:3:\"231\";s:6:\"handle\";s:19:\"Very-Open-Space.jpg\";s:5:\"video\";s:19:\"Very-Open-Space.mp4\";s:4:\"name\";s:16:\"Very Open Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:367;a:13:{s:2:\"id\";s:3:\"230\";s:6:\"handle\";s:14:\"Office-Day.jpg\";s:5:\"video\";s:14:\"Office-Day.mp4\";s:4:\"name\";s:11:\"Office Day \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:368;a:13:{s:2:\"id\";s:3:\"229\";s:6:\"handle\";s:12:\"The-Hill.jpg\";s:5:\"video\";s:12:\"The-Hill.mp4\";s:4:\"name\";s:9:\"The Hill \";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:369;a:13:{s:2:\"id\";s:3:\"339\";s:6:\"handle\";s:19:\"best_price_dark.jpg\";s:5:\"video\";s:19:\"best_price_dark.mp4\";s:4:\"name\";s:15:\"best_price_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"best_price_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:370;a:13:{s:2:\"id\";s:3:\"337\";s:6:\"handle\";s:27:\"limited_time_offer_dark.jpg\";s:5:\"video\";s:27:\"limited_time_offer_dark.mp4\";s:4:\"name\";s:23:\"limited_time_offer_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:23:\"limited_time_offer_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:371;a:13:{s:2:\"id\";s:3:\"336\";s:6:\"handle\";s:26:\"slider_revolution_dark.jpg\";s:5:\"video\";s:26:\"slider_revolution_dark.mp4\";s:4:\"name\";s:22:\"slider_revolution_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:22:\"slider_revolution_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:372;a:13:{s:2:\"id\";s:3:\"335\";s:6:\"handle\";s:19:\"mick_brown_dark.jpg\";s:5:\"video\";s:19:\"mick_brown_dark.mp4\";s:4:\"name\";s:15:\"mick_brown_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"mick_brown_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:373;a:13:{s:2:\"id\";s:3:\"334\";s:6:\"handle\";s:14:\"sales_dark.jpg\";s:5:\"video\";s:14:\"sales_dark.mp4\";s:4:\"name\";s:10:\"sales_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:10:\"sales_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:374;a:13:{s:2:\"id\";s:3:\"333\";s:6:\"handle\";s:21:\"robert_smith_dark.jpg\";s:5:\"video\";s:21:\"robert_smith_dark.mp4\";s:4:\"name\";s:17:\"robert_smith_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"robert_smith_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:375;a:13:{s:2:\"id\";s:3:\"332\";s:6:\"handle\";s:21:\"product_name_dark.jpg\";s:5:\"video\";s:21:\"product_name_dark.mp4\";s:4:\"name\";s:17:\"product_name_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"product_name_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:376;a:13:{s:2:\"id\";s:3:\"331\";s:6:\"handle\";s:21:\"high_quality_dark.jpg\";s:5:\"video\";s:21:\"high_quality_dark.mp4\";s:4:\"name\";s:17:\"high_quality_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"high_quality_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:377;a:13:{s:2:\"id\";s:3:\"330\";s:6:\"handle\";s:24:\"robert_johnson_light.jpg\";s:5:\"video\";s:24:\"robert_johnson_light.mp4\";s:4:\"name\";s:20:\"robert_johnson_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:20:\"robert_johnson_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:378;a:13:{s:2:\"id\";s:3:\"329\";s:6:\"handle\";s:21:\"jake_collins_dark.jpg\";s:5:\"video\";s:21:\"jake_collins_dark.mp4\";s:4:\"name\";s:17:\"jake_collins_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"jake_collins_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:379;a:13:{s:2:\"id\";s:3:\"328\";s:6:\"handle\";s:22:\"daniele_wood_light.jpg\";s:5:\"video\";s:22:\"daniele_wood_light.mp4\";s:4:\"name\";s:18:\"daniele_wood_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"daniele_wood_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:31:30\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:380;a:13:{s:2:\"id\";s:3:\"327\";s:6:\"handle\";s:23:\"michael_blake_light.jpg\";s:5:\"video\";s:23:\"michael_blake_light.mp4\";s:4:\"name\";s:19:\"michael_blake_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:19:\"michael_blake_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:381;a:13:{s:2:\"id\";s:3:\"326\";s:6:\"handle\";s:22:\"product_name_light.jpg\";s:5:\"video\";s:22:\"product_name_light.mp4\";s:4:\"name\";s:18:\"product_name_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"product_name_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:382;a:13:{s:2:\"id\";s:3:\"325\";s:6:\"handle\";s:24:\"rebecca_cooper_light.jpg\";s:5:\"video\";s:24:\"rebecca_cooper_light.mp4\";s:4:\"name\";s:20:\"rebecca_cooper_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:20:\"rebecca_cooper_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:383;a:13:{s:2:\"id\";s:3:\"324\";s:6:\"handle\";s:28:\"limited_time_offer_light.jpg\";s:5:\"video\";s:28:\"limited_time_offer_light.mp4\";s:4:\"name\";s:24:\"limited_time_offer_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:24:\"limited_time_offer_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:384;a:13:{s:2:\"id\";s:3:\"322\";s:6:\"handle\";s:22:\"jake_michael_light.jpg\";s:5:\"video\";s:22:\"jake_michael_light.mp4\";s:4:\"name\";s:18:\"jake_michael_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"jake_michael_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:385;a:13:{s:2:\"id\";s:3:\"321\";s:6:\"handle\";s:23:\"colin_johnson_light.jpg\";s:5:\"video\";s:23:\"colin_johnson_light.mp4\";s:4:\"name\";s:19:\"colin_johnson_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:19:\"colin_johnson_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:386;a:13:{s:2:\"id\";s:3:\"320\";s:6:\"handle\";s:21:\"colin_morris_dark.jpg\";s:5:\"video\";s:21:\"colin_morris_dark.mp4\";s:4:\"name\";s:17:\"colin_morris_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"colin_morris_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:387;a:13:{s:2:\"id\";s:3:\"319\";s:6:\"handle\";s:22:\"justin_cooper_dark.jpg\";s:5:\"video\";s:22:\"justin_cooper_dark.mp4\";s:4:\"name\";s:18:\"justin_cooper_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"justin_cooper_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:388;a:13:{s:2:\"id\";s:3:\"318\";s:6:\"handle\";s:21:\"james-dodson_dark.jpg\";s:5:\"video\";s:21:\"james-dodson_dark.mp4\";s:4:\"name\";s:17:\"james-dodson_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"james-dodson_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:389;a:13:{s:2:\"id\";s:3:\"317\";s:6:\"handle\";s:23:\"robert_sanders_dark.jpg\";s:5:\"video\";s:23:\"robert_sanders_dark.mp4\";s:4:\"name\";s:19:\"robert_sanders_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:19:\"robert_sanders_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:390;a:13:{s:2:\"id\";s:3:\"316\";s:6:\"handle\";s:21:\"emily_carney_dark.jpg\";s:5:\"video\";s:21:\"emily_carney_dark.mp4\";s:4:\"name\";s:17:\"emily_carney_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"emily_carney_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:391;a:13:{s:2:\"id\";s:3:\"315\";s:6:\"handle\";s:22:\"michael-smith_dark.jpg\";s:5:\"video\";s:22:\"michael-smith_dark.mp4\";s:4:\"name\";s:18:\"michael-smith_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"michael-smith_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:392;a:13:{s:2:\"id\";s:3:\"314\";s:6:\"handle\";s:23:\"sandra_johnson_dark.jpg\";s:5:\"video\";s:23:\"sandra_johnson_dark.mp4\";s:4:\"name\";s:19:\"sandra_johnson_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:19:\"sandra_johnson_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:393;a:13:{s:2:\"id\";s:3:\"313\";s:6:\"handle\";s:22:\"robert_bolton_dark.jpg\";s:5:\"video\";s:22:\"robert_bolton_dark.mp4\";s:4:\"name\";s:18:\"robert_bolton_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"robert_bolton_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:394;a:13:{s:2:\"id\";s:3:\"312\";s:6:\"handle\";s:25:\"elegant_captions_dark.png\";s:5:\"video\";s:25:\"elegant_captions_dark.mp4\";s:4:\"name\";s:21:\"elegant_captions_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:21:\"elegant_captions_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-18 14:41:45\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:395;a:13:{s:2:\"id\";s:3:\"311\";s:6:\"handle\";s:19:\"Caption_Dark_06.png\";s:5:\"video\";s:19:\"Caption_Dark_06.mp4\";s:4:\"name\";s:15:\"Caption_Dark_06\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_06\";s:5:\"width\";s:3:\"414\";s:6:\"height\";s:3:\"225\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:396;a:13:{s:2:\"id\";s:3:\"310\";s:6:\"handle\";s:19:\"Header_Light_02.png\";s:5:\"video\";s:19:\"Header_Light_02.mp4\";s:4:\"name\";s:15:\"Header_Light_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:15:\"Header_Light_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:397;a:13:{s:2:\"id\";s:3:\"309\";s:6:\"handle\";s:21:\"Columns_4_Dark_01.png\";s:5:\"video\";s:21:\"Columns_4_Dark_01.mp4\";s:4:\"name\";s:17:\"Columns_4_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"Columns_4_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:398;a:13:{s:2:\"id\";s:3:\"308\";s:6:\"handle\";s:18:\"Header_Dark_01.png\";s:5:\"video\";s:18:\"Header_Dark_01.mp4\";s:4:\"name\";s:14:\"Header_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:14:\"Header_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:399;a:13:{s:2:\"id\";s:3:\"307\";s:6:\"handle\";s:19:\"Caption_Dark_03.png\";s:5:\"video\";s:19:\"Caption_Dark_03.mp4\";s:4:\"name\";s:15:\"Caption_Dark_03\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_03\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:400;a:13:{s:2:\"id\";s:3:\"306\";s:6:\"handle\";s:21:\"Columns_3_Dark_01.png\";s:5:\"video\";s:21:\"Columns_3_Dark_01.mp4\";s:4:\"name\";s:17:\"Columns_3_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"Columns_3_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:401;a:13:{s:2:\"id\";s:3:\"305\";s:6:\"handle\";s:19:\"Caption_Dark_05.png\";s:5:\"video\";s:19:\"Caption_Dark_05.mp4\";s:4:\"name\";s:15:\"Caption_Dark_05\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_05\";s:5:\"width\";s:4:\"1104\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:402;a:13:{s:2:\"id\";s:3:\"304\";s:6:\"handle\";s:20:\"Caption_Light_06.png\";s:5:\"video\";s:20:\"Caption_Light_06.mp4\";s:4:\"name\";s:16:\"Caption_Light_06\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_06\";s:5:\"width\";s:3:\"828\";s:6:\"height\";s:3:\"450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:403;a:13:{s:2:\"id\";s:3:\"303\";s:6:\"handle\";s:19:\"Header_Light_01.png\";s:5:\"video\";s:19:\"Header_Light_01.mp4\";s:4:\"name\";s:15:\"Header_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:15:\"Header_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:404;a:13:{s:2:\"id\";s:3:\"302\";s:6:\"handle\";s:20:\"Caption_Light_03.png\";s:5:\"video\";s:20:\"Caption_Light_03.mp4\";s:4:\"name\";s:16:\"Caption_Light_03\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_03\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:405;a:13:{s:2:\"id\";s:3:\"301\";s:6:\"handle\";s:19:\"Caption_Dark_01.png\";s:5:\"video\";s:19:\"Caption_Dark_01.mp4\";s:4:\"name\";s:15:\"Caption_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:406;a:13:{s:2:\"id\";s:3:\"300\";s:6:\"handle\";s:21:\"PromoCode_Dark_01.png\";s:5:\"video\";s:21:\"PromoCode_Dark_01.mp4\";s:4:\"name\";s:17:\"PromoCode_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"PromoCode_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:407;a:13:{s:2:\"id\";s:3:\"299\";s:6:\"handle\";s:19:\"Caption_Dark_02.png\";s:5:\"video\";s:19:\"Caption_Dark_02.mp4\";s:4:\"name\";s:15:\"Caption_Dark_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:408;a:13:{s:2:\"id\";s:3:\"298\";s:6:\"handle\";s:18:\"Header_Dark_02.png\";s:5:\"video\";s:18:\"Header_Dark_02.mp4\";s:4:\"name\";s:14:\"Header_Dark_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:14:\"Header_Dark_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:409;a:13:{s:2:\"id\";s:3:\"297\";s:6:\"handle\";s:22:\"Columns_3_Light_01.png\";s:5:\"video\";s:22:\"Columns_3_Light_01.mp4\";s:4:\"name\";s:18:\"Columns_3_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"Columns_3_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:410;a:13:{s:2:\"id\";s:3:\"296\";s:6:\"handle\";s:20:\"Caption_Light_01.png\";s:5:\"video\";s:20:\"Caption_Light_01.mp4\";s:4:\"name\";s:16:\"Caption_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:411;a:13:{s:2:\"id\";s:3:\"295\";s:6:\"handle\";s:19:\"Caption_Dark_04.png\";s:5:\"video\";s:19:\"Caption_Dark_04.mp4\";s:4:\"name\";s:15:\"Caption_Dark_04\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_04\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:412;a:13:{s:2:\"id\";s:3:\"294\";s:6:\"handle\";s:20:\"Caption_Light_02.png\";s:5:\"video\";s:20:\"Caption_Light_02.mp4\";s:4:\"name\";s:16:\"Caption_Light_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_02\";s:5:\"width\";s:3:\"828\";s:6:\"height\";s:3:\"450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:413;a:13:{s:2:\"id\";s:3:\"293\";s:6:\"handle\";s:20:\"Caption_Light_04.png\";s:5:\"video\";s:20:\"Caption_Light_04.mp4\";s:4:\"name\";s:16:\"Caption_Light_04\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_04\";s:5:\"width\";s:4:\"1104\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:414;a:13:{s:2:\"id\";s:3:\"292\";s:6:\"handle\";s:22:\"Columns_4_Light_01.png\";s:5:\"video\";s:22:\"Columns_4_Light_01.mp4\";s:4:\"name\";s:18:\"Columns_4_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"Columns_4_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:415;a:13:{s:2:\"id\";s:3:\"291\";s:6:\"handle\";s:20:\"Caption_Light_05.png\";s:5:\"video\";s:20:\"Caption_Light_05.mp4\";s:4:\"name\";s:16:\"Caption_Light_05\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_05\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:416;a:13:{s:2:\"id\";s:3:\"290\";s:6:\"handle\";s:22:\"PromoCode_Light_01.png\";s:5:\"video\";s:22:\"PromoCode_Light_01.mp4\";s:4:\"name\";s:18:\"PromoCode_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"PromoCode_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}}s:4:\"tags\";a:18:{i:28;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}i:5;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:20;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:21;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:25;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:16;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}i:26;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}i:18;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:4;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:19;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:23;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:3;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:24;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:22;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:29;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}i:27;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}}", "no");
INSERT INTO `won_options` VALUES("1648", "rs-addons-counter", "31", "yes");
INSERT INTO `won_options` VALUES("1649", "revslider-addons", "O:8:\"stdClass\":31:{s:22:\"revslider-backup-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:22:\"revslider-backup-addon\";s:12:\"version_from\";s:5:\"5.2.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Backup\";s:6:\"line_1\";s:12:\"Make Backups\";s:6:\"line_2\";s:25:\"Revisions for your safety\";s:9:\"available\";s:5:\"2.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:67:\"//updates.themepunch.tools/revslider/addons/images/addon_backup.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BU\";}}s:23:\"revslider-gallery-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:23:\"revslider-gallery-addon\";s:12:\"version_from\";s:6:\"6.4.11\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"WordPress Gallery\";s:6:\"line_1\";s:31:\"Replace the standard WP Gallery\";s:6:\"line_2\";s:31:\"with the Sliders of your choice\";s:9:\"available\";s:5:\"2.0.3\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:70:\"//updates.themepunch.tools/revslider/addons/images/addon_wpgallery.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"GA\";}}s:25:\"revslider-rel-posts-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:25:\"revslider-rel-posts-addon\";s:12:\"version_from\";s:7:\"5.2.4.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Related Posts\";s:6:\"line_1\";s:25:\"Add related Posts Sliders\";s:6:\"line_2\";s:31:\"at the end of your post content\";s:9:\"available\";s:5:\"2.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:70:\"//updates.themepunch.tools/revslider/addons/images/addon_wprelated.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RP\";}}s:26:\"revslider-typewriter-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:26:\"revslider-typewriter-addon\";s:12:\"version_from\";s:5:\"6.4.4\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"Typewriter Effect\";s:6:\"line_1\";s:27:\"Enhance your slider\'s text \";s:6:\"line_2\";s:24:\"with typewriter effects \";s:9:\"available\";s:5:\"2.1.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:71:\"//updates.themepunch.tools/revslider/addons/images/addon_typewriter.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"TW\";}}s:23:\"revslider-sharing-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:23:\"revslider-sharing-addon\";s:12:\"version_from\";s:5:\"5.3.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Social Sharing\";s:6:\"line_1\";s:17:\"Share your slides\";s:6:\"line_2\";s:50:\"with RevSlider \"actions\" because sharing is caring\";s:9:\"available\";s:5:\"2.0.5\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:74:\"//updates.themepunch.tools/revslider/addons/images/addon_socialsharing.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SH\";}}s:27:\"revslider-maintenance-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:27:\"revslider-maintenance-addon\";s:12:\"version_from\";s:6:\"6.4.11\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:15:\"Coming & Maint.\";s:6:\"line_1\";s:37:\"Simple Coming Soon & Maintenance Page\";s:6:\"line_2\";s:42:\"Let your visitors know what\'s up and when!\";s:9:\"available\";s:5:\"2.1.4\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:78:\"//updates.themepunch.tools/revslider/addons/images/addon_underconstruction.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"MT\";}}s:20:\"revslider-snow-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:20:\"revslider-snow-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:12:\"Holiday Snow\";s:6:\"line_1\";s:12:\"Let it snow!\";s:6:\"line_2\";s:32:\"Add animated snow to any Slider \";s:9:\"available\";s:5:\"2.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:65:\"//updates.themepunch.tools/revslider/addons/images/addon_snow.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SN\";}}s:24:\"revslider-polyfold-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:24:\"revslider-polyfold-addon\";s:12:\"version_from\";s:6:\"6.4.11\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:22:\"Polyfold Scroll Effect\";s:6:\"line_1\";s:32:\"Add sharp edges to your sliders \";s:6:\"line_2\";s:35:\"as they scroll into and out of view\";s:9:\"available\";s:5:\"2.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:69:\"//updates.themepunch.tools/revslider/addons/images/addon_polyfold.jpg\";s:5:\"color\";s:7:\"#3e186f\";s:4:\"text\";s:2:\"PF\";}}s:19:\"revslider-404-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:19:\"revslider-404-addon\";s:12:\"version_from\";s:3:\"5.3\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:3:\"404\";s:6:\"line_1\";s:39:\"Build custom 404 \"Page not Found\" Pages\";s:6:\"line_2\";s:28:\"with Slider Revolution swag!\";s:9:\"available\";s:5:\"2.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:64:\"//updates.themepunch.tools/revslider/addons/images/addon_404.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"404\";}}s:30:\"revslider-prevnext-posts-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:30:\"revslider-prevnext-posts-addon\";s:12:\"version_from\";s:3:\"5.4\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Adjacent Posts\";s:6:\"line_1\";s:30:\"Display previous and next post\";s:6:\"line_2\";s:28:\"to the currently showing one\";s:9:\"available\";s:5:\"2.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:71:\"//updates.themepunch.tools/revslider/addons/images/addon_wpadjacent.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}}s:25:\"revslider-filmstrip-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:25:\"revslider-filmstrip-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:9:\"Filmstrip\";s:6:\"line_1\";s:44:\"Display a continously rotating set of images\";s:6:\"line_2\";s:26:\"for your slide backgrounds\";s:9:\"available\";s:5:\"2.0.4\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:70:\"//updates.themepunch.tools/revslider/addons/images/addon_filmstrip.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FS\";}}s:21:\"revslider-login-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:21:\"revslider-login-addon\";s:12:\"version_from\";s:6:\"6.4.10\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Login Page\";s:6:\"line_1\";s:25:\"Very simple WP Login Page\";s:6:\"line_2\";s:34:\"enhanced with your favorite slider\";s:9:\"available\";s:5:\"2.0.3\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:66:\"//updates.themepunch.tools/revslider/addons/images/addon_login.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LI\";}}s:24:\"revslider-featured-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:24:\"revslider-featured-addon\";s:12:\"version_from\";s:6:\"6.4.11\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:20:\"Post Featured Slider\";s:6:\"line_1\";s:25:\"Display a featured Slider\";s:6:\"line_2\";s:41:\"instead of a featured Image in your Posts\";s:9:\"available\";s:5:\"2.0.3\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:71:\"//updates.themepunch.tools/revslider/addons/images/addon_wpfeatured.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FT\";}}s:23:\"revslider-weather-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:23:\"revslider-weather-addon\";s:12:\"version_from\";s:5:\"6.4.8\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Weather\";s:6:\"line_1\";s:21:\"Every where you go...\";s:6:\"line_2\";s:36:\"...always take the weather with you!\";s:9:\"available\";s:5:\"2.0.4\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:68:\"//updates.themepunch.tools/revslider/addons/images/addon_weather.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WT\";}}s:24:\"revslider-panorama-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:24:\"revslider-panorama-addon\";s:12:\"version_from\";s:6:\"6.4.10\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"Panorama\";s:6:\"line_1\";s:14:\"Panorama AddOn\";s:6:\"line_2\";s:28:\"Display images in 360 degree\";s:9:\"available\";s:5:\"2.1.4\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:69:\"//updates.themepunch.tools/revslider/addons/images/addon_panorama.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}}s:30:\"revslider-duotonefilters-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:30:\"revslider-duotonefilters-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Duotone\";s:6:\"line_1\";s:7:\"Duotone\";s:6:\"line_2\";s:25:\"Because one is not enough\";s:9:\"available\";s:5:\"2.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:68:\"//updates.themepunch.tools/revslider/addons/images/addon_duotone.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"DTF\";}}s:23:\"revslider-refresh-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:23:\"revslider-refresh-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"(Re)Load\";s:6:\"line_1\";s:39:\"Reload the current page or a custom URL\";s:6:\"line_2\";s:34:\"after a certain time, loops, slide\";s:9:\"available\";s:5:\"2.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:67:\"//updates.themepunch.tools/revslider/addons/images/addon_reload.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RF\";}}s:28:\"revslider-liquideffect-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:28:\"revslider-liquideffect-addon\";s:12:\"version_from\";s:5:\"6.4.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Distortion\";s:6:\"line_1\";s:22:\"Add Distortion Effects\";s:6:\"line_2\";s:30:\"to your slides and transitions\";s:9:\"available\";s:5:\"2.1.3\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:71:\"//updates.themepunch.tools/revslider/addons/images/addon_distortion.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LE\";}}s:31:\"revslider-explodinglayers-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:31:\"revslider-explodinglayers-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Exploding Layers\";s:6:\"line_1\";s:23:\"Add explosive particles\";s:6:\"line_2\";s:24:\"to your layers animation\";s:9:\"available\";s:5:\"2.1.4\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:70:\"//updates.themepunch.tools/revslider/addons/images/addon_exploding.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"EL\";}}s:26:\"revslider-paintbrush-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:26:\"revslider-paintbrush-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Paintbrush\";s:6:\"line_1\";s:14:\"Paint or Erase\";s:6:\"line_2\";s:22:\"your background images\";s:9:\"available\";s:5:\"2.1.9\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:71:\"//updates.themepunch.tools/revslider/addons/images/addon_paintbrush.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PB\";}}s:29:\"revslider-domain-switch-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:29:\"revslider-domain-switch-addon\";s:12:\"version_from\";s:5:\"6.0.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Domain Switch\";s:6:\"line_1\";s:17:\"Switch Image URLs\";s:6:\"line_2\";s:37:\"in sliders from one domain to another\";s:9:\"available\";s:5:\"1.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:73:\"//updates.themepunch.tools/revslider/addons/images/addon_domainswitch.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"DS\";}}s:22:\"revslider-charts-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:22:\"revslider-charts-addon\";s:12:\"version_from\";s:6:\"6.4.10\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Charts\";s:6:\"line_1\";s:93:\"The Charts addon allows you to create visually impressive line or bar graphs from .csv data, \";s:6:\"line_2\";s:56:\"with tons of options to take full control of the design.\";s:9:\"available\";s:5:\"1.0.0\";s:10:\"background\";s:67:\"//updates.themepunch.tools/revslider/addons/images/addon_charts.png\";s:6:\"button\";s:0:\"\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:67:\"//updates.themepunch.tools/revslider/addons/images/addon_charts.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"CH\";}}s:25:\"revslider-mousetrap-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:25:\"revslider-mousetrap-addon\";s:12:\"version_from\";s:5:\"6.4.8\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:9:\"Mousetrap\";s:6:\"line_1\";s:31:\"Create all kinds of interesting\";s:6:\"line_2\";s:19:\" mouse interactions\";s:9:\"available\";s:6:\"2.0.10\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:70:\"//updates.themepunch.tools/revslider/addons/images/addon_mousetrap.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"MT\";}}s:26:\"revslider-whiteboard-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:26:\"revslider-whiteboard-addon\";s:12:\"version_from\";s:5:\"5.2.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Whiteboard\";s:6:\"line_1\";s:31:\"Create Hand-Drawn Presentations\";s:6:\"line_2\";s:45:\"that are understandable, memorable & engaging\";s:9:\"available\";s:5:\"2.2.3\";s:10:\"background\";s:75:\"//updates.themepunch.tools/revslider/addons/images/whiteboard_widget_bg.jpg\";s:6:\"button\";s:11:\"How to use?\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:71:\"//updates.themepunch.tools/revslider/addons/images/addon_whiteboard.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WB\";}}s:27:\"revslider-scrollvideo-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:27:\"revslider-scrollvideo-addon\";s:12:\"version_from\";s:5:\"6.3.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:12:\"Scroll Video\";s:6:\"line_1\";s:114:\"This addon allows you to generate a sequence of images from any html5 video and play them with scroll interaction.\";s:6:\"line_2\";s:49:\"Quality options are included for optimal results!\";s:9:\"available\";s:5:\"2.0.4\";s:10:\"background\";s:72:\"//updates.themepunch.tools/revslider/addons/images/addon_scrollvideo.jpg\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:72:\"//updates.themepunch.tools/revslider/addons/images/addon_scrollvideo.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SV\";}}s:22:\"revslider-slicey-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:22:\"revslider-slicey-addon\";s:12:\"version_from\";s:5:\"6.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Slicey\";s:6:\"line_1\";s:20:\"Slice \'em up nicely!\";s:6:\"line_2\";s:38:\"Create image slices of your background\";s:9:\"available\";s:5:\"2.1.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:67:\"//updates.themepunch.tools/revslider/addons/images/addon_slicey.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SL\";}}s:24:\"revslider-revealer-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:24:\"revslider-revealer-addon\";s:12:\"version_from\";s:5:\"6.4.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Reveal\";s:6:\"line_1\";s:9:\"Reveal...\";s:6:\"line_2\";s:37:\"...your inner beast... and RevSliders\";s:9:\"available\";s:5:\"2.2.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:67:\"//updates.themepunch.tools/revslider/addons/images/addon_reveal.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RV\";}}s:25:\"revslider-particles-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:25:\"revslider-particles-addon\";s:12:\"version_from\";s:5:\"6.4.8\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Particle Effects\";s:6:\"line_1\";s:17:\"Let\'s Parti(cle)!\";s:6:\"line_2\";s:51:\"Add interactive particle animations to your sliders\";s:9:\"available\";s:5:\"2.3.6\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:70:\"//updates.themepunch.tools/revslider/addons/images/addon_particles.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PT\";}}s:27:\"revslider-beforeafter-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:27:\"revslider-beforeafter-addon\";s:12:\"version_from\";s:5:\"6.4.8\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Before & After\";s:6:\"line_1\";s:35:\"Compare two slides before and after\";s:6:\"line_2\";s:33:\"use it vertically or horizontally\";s:9:\"available\";s:5:\"2.1.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:0:\"\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:72:\"//updates.themepunch.tools/revslider/addons/images/addon_beforeafter.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BA\";}}s:27:\"revslider-bubblemorph-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:27:\"revslider-bubblemorph-addon\";s:12:\"version_from\";s:6:\"6.2.50\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:11:\"BubbleMorph\";s:6:\"line_1\";s:26:\"Include BubbleMorph Layers\";s:6:\"line_2\";s:33:\"for a decorative lava lamp effect\";s:9:\"available\";s:5:\"2.2.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:72:\"//updates.themepunch.tools/revslider/addons/images/addon_bubblemorph.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BM\";}}s:22:\"revslider-lottie-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:22:\"revslider-lottie-addon\";s:12:\"version_from\";s:5:\"6.4.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Lottie\";s:6:\"line_1\";s:53:\"Adds support for the popular Lottie Animation format,\";s:6:\"line_2\";s:70:\" including animation control, style customization and a local library.\";s:9:\"available\";s:5:\"2.0.6\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:67:\"//updates.themepunch.tools/revslider/addons/images/addon_lottie.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LT\";}}}", "yes");
INSERT INTO `won_options` VALUES("1641", "revslider-update-check-short", "1620160187", "yes");
INSERT INTO `won_options` VALUES("1642", "revslider-connection", "1", "yes");
INSERT INTO `won_options` VALUES("1643", "revslider-update-hash", "0559d6f612653027fe9e10226973f065", "yes");
INSERT INTO `won_options` VALUES("1644", "revslider-latest-version", "6.4.11", "yes");
INSERT INTO `won_options` VALUES("1645", "revslider-stable-version", "4.2.0", "yes");
INSERT INTO `won_options` VALUES("1646", "revslider-notices", "a:1:{i:0;O:8:\"stdClass\":8:{s:7:\"version\";s:6:\"6.4.10\";s:4:\"text\";s:310:\"<div style=\"display: block; background-color: #1C0950; text-align: \ncenter;\"><a \nhref=\"https://mailchi.mp/sliderrevolution/the-update-your-website-deserves\"\n target=\"_blank\"><img alt=\"wow\" src=\"//updates.themepunch.tools/banners/6411_banner.jpg\" width=\"960\" height=\"250\" style=\"margin-bottom: -5px;\"></a></div>\";s:4:\"code\";s:12:\"TPRSV6411-01\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"additional\";a:0:{}}}", "yes");
INSERT INTO `won_options` VALUES("1647", "revslider-additions", "O:8:\"stdClass\":1:{s:7:\"selling\";b:1;}", "yes");
INSERT INTO `won_options` VALUES("1639", "revslider_servers", "a:7:{i:0;s:22:\"themepunch-ext-a.tools\";i:1;s:22:\"themepunch-ext-a.tools\";i:2;s:22:\"themepunch-ext-a.tools\";i:3;s:22:\"themepunch-ext-b.tools\";i:4;s:22:\"themepunch-ext-b.tools\";i:5;s:22:\"themepunch-ext-b.tools\";i:6;s:16:\"themepunch.tools\";}", "yes");
INSERT INTO `won_options` VALUES("1640", "revslider_server_refresh", "1620160187", "yes");
INSERT INTO `won_options` VALUES("1654", "revslider-templates-hash", "f5a235f10db5b83cd33056dded61713a", "yes");
INSERT INTO `won_options` VALUES("1655", "rs-templates-new", "", "no");
INSERT INTO `won_options` VALUES("1653", "revslider-templates-check", "1620160188", "yes");
INSERT INTO `won_options` VALUES("1657", "rs-templates-counter", "507", "no");
INSERT INTO `won_options` VALUES("1659", "revslider_update_version", "6.4.10", "yes");
INSERT INTO `won_options` VALUES("1660", "widget_rev-slider-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `won_options` VALUES("1777", "project-cat_children", "a:0:{}", "yes");
INSERT INTO `won_options` VALUES("4815", "category_children", "a:0:{}", "yes");
INSERT INTO `won_options` VALUES("1776", "woodmart_slider_children", "a:0:{}", "yes");
INSERT INTO `won_options` VALUES("1676", "whb_main_header", "header_855638", "yes");
INSERT INTO `won_options` VALUES("1683", "elementor_cpt_support", "a:12:{i:0;s:4:\"post\";i:1;s:4:\"page\";i:2;s:14:\"e-landing-page\";i:3;s:15:\"woodmart_layout\";i:4;s:15:\"woodmart_woo_lv\";i:5;s:16:\"woodmart_woo_fbt\";i:6;s:9:\"cms_block\";i:7;s:19:\"woodmart_size_guide\";i:8;s:14:\"woodmart_slide\";i:9;s:16:\"woodmart_sidebar\";i:10;s:9:\"portfolio\";i:11;s:7:\"product\";}", "yes");
INSERT INTO `won_options` VALUES("1684", "elementor_disable_color_schemes", "yes", "yes");
INSERT INTO `won_options` VALUES("1685", "elementor_disable_typography_schemes", "yes", "yes");
INSERT INTO `won_options` VALUES("1687", "woodmart_imported_versions", "a:1:{i:0;s:4:\"base\";}", "yes");
INSERT INTO `won_options` VALUES("1688", "woodmart_base_import_builder", "wpb", "yes");
INSERT INTO `won_options` VALUES("1707", "xts-header_855638-css-data", ".whb-top-bar .wd-dropdown {\n	margin-top: 5px;\n}\n\n.whb-top-bar .wd-dropdown:after {\n	height: 15px;\n}\n\n\n.whb-header-bottom .wd-dropdown {\n	margin-top: 2.5px;\n}\n\n.whb-header-bottom .wd-dropdown:after {\n	height: 12.5px;\n}\n\n\n.whb-header .whb-header-bottom .wd-header-cats {\n	margin-top: -0px;\n	margin-bottom: -0px;\n	height: calc(100% + 0px);\n}\n\n.whb-clone.whb-sticked .wd-dropdown {\n	margin-top: 10px;\n}\n\n.whb-clone.whb-sticked .wd-dropdown:after {\n	height: 20px;\n}\n\n@media (min-width: 1025px) {\n		.whb-top-bar-inner {\n		height: 50px;\n		max-height: 50px;\n	}\n\n		\n		.whb-general-header-inner {\n		height: 75px;\n		max-height: 75px;\n	}\n\n		\n		.whb-header-bottom-inner {\n		height: 45px;\n		max-height: 45px;\n	}\n\n		\n			.whb-clone .whb-general-header-inner {\n		height: 60px;\n		max-height: 60px;\n	}\n	\n	}\n\n@media (max-width: 1024px) {\n	\n		.whb-general-header-inner {\n		height: 60px;\n		max-height: 60px;\n	}\n	\n	\n			.whb-clone .whb-general-header-inner {\n		height: 60px;\n		max-height: 60px;\n	}\n	\n	}\n		.whb-top-bar-inner { border-color: rgba(230, 230, 230, 1);border-bottom-width: 1px;border-bottom-style: solid; }\n.whb-general-header {\n	border-bottom-width: 0px;border-bottom-style: solid;\n}\n\n.whb-header-bottom {\n	border-bottom-width: 0px;border-bottom-style: solid;\n}\n", "yes");
INSERT INTO `won_options` VALUES("1708", "xts-header_855638-status", "valid", "yes");
INSERT INTO `won_options` VALUES("1709", "xts-header_855638-version", "7.0.3", "yes");
INSERT INTO `won_options` VALUES("1710", "xts-header_855638-site-url", "54f0ecb4cf28f0033769e009a420dade", "yes");
INSERT INTO `won_options` VALUES("1711", "whb_header_855638", "a:4:{s:4:\"name\";s:23:\"Ughهدر پیشفرض1\";s:2:\"id\";s:13:\"header_855638\";s:9:\"structure\";a:3:{s:2:\"id\";s:4:\"root\";s:4:\"type\";s:4:\"root\";s:7:\"content\";a:3:{i:0;a:4:{s:2:\"id\";s:7:\"top-bar\";s:4:\"type\";s:3:\"row\";s:7:\"content\";a:4:{i:0;a:3:{s:2:\"id\";s:7:\"column5\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:0:{}}i:1;a:3:{s:2:\"id\";s:7:\"column6\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:0:{}}i:2;a:3:{s:2:\"id\";s:7:\"column7\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:0:{}}i:3;a:3:{s:2:\"id\";s:14:\"column_mobile1\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:0:{}}}s:6:\"params\";a:11:{s:11:\"flex_layout\";a:3:{s:2:\"id\";s:11:\"flex_layout\";s:5:\"value\";s:11:\"flex-middle\";s:4:\"type\";s:8:\"selector\";}s:6:\"height\";a:3:{s:2:\"id\";s:6:\"height\";s:5:\"value\";i:50;s:4:\"type\";s:6:\"slider\";}s:13:\"mobile_height\";a:3:{s:2:\"id\";s:13:\"mobile_height\";s:5:\"value\";i:38;s:4:\"type\";s:6:\"slider\";}s:12:\"hide_desktop\";a:3:{s:2:\"id\";s:12:\"hide_desktop\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:11:\"hide_mobile\";a:3:{s:2:\"id\";s:11:\"hide_mobile\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:6:\"sticky\";a:3:{s:2:\"id\";s:6:\"sticky\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:13:\"sticky_height\";a:3:{s:2:\"id\";s:13:\"sticky_height\";s:5:\"value\";i:40;s:4:\"type\";s:6:\"slider\";}s:12:\"color_scheme\";a:3:{s:2:\"id\";s:12:\"color_scheme\";s:5:\"value\";s:4:\"dark\";s:4:\"type\";s:8:\"selector\";}s:6:\"shadow\";a:3:{s:2:\"id\";s:6:\"shadow\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:10:\"background\";a:3:{s:2:\"id\";s:10:\"background\";s:5:\"value\";a:3:{s:15:\"background-size\";s:7:\"inherit\";s:21:\"background-attachment\";s:7:\"inherit\";s:17:\"background-repeat\";s:7:\"inherit\";}s:4:\"type\";s:2:\"bg\";}s:6:\"border\";a:3:{s:2:\"id\";s:6:\"border\";s:5:\"value\";a:4:{s:5:\"width\";s:1:\"1\";s:5:\"color\";a:4:{s:1:\"r\";i:230;s:1:\"g\";i:230;s:1:\"b\";i:230;s:1:\"a\";i:1;}s:8:\"applyFor\";s:5:\"boxed\";s:5:\"sides\";a:1:{i:0;s:6:\"bottom\";}}s:4:\"type\";s:6:\"border\";}}}i:1;a:4:{s:2:\"id\";s:14:\"general-header\";s:4:\"type\";s:3:\"row\";s:7:\"content\";a:6:{i:0;a:3:{s:2:\"id\";s:7:\"column8\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:1:{i:0;a:3:{s:2:\"id\";s:20:\"gs8bcnxektjsro21n657\";s:4:\"type\";s:4:\"logo\";s:6:\"params\";a:6:{s:5:\"image\";a:3:{s:2:\"id\";s:5:\"image\";s:5:\"value\";a:4:{s:2:\"id\";i:4149;s:3:\"url\";s:62:\"https://kashtmoodrmozafari.ir/wp-content/uploads/2025/11/o.png\";s:5:\"width\";i:1187;s:6:\"height\";i:1187;}s:4:\"type\";s:5:\"image\";}s:5:\"width\";a:3:{s:2:\"id\";s:5:\"width\";s:5:\"value\";i:262;s:4:\"type\";s:6:\"slider\";}s:13:\"sticky_notice\";a:3:{s:2:\"id\";s:13:\"sticky_notice\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:6:\"notice\";}s:12:\"sticky_image\";a:3:{s:2:\"id\";s:12:\"sticky_image\";s:5:\"value\";b:0;s:4:\"type\";s:5:\"image\";}s:12:\"sticky_width\";a:3:{s:2:\"id\";s:12:\"sticky_width\";s:5:\"value\";i:250;s:4:\"type\";s:6:\"slider\";}s:12:\"width_height\";a:3:{s:2:\"id\";s:12:\"width_height\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}}}}}i:1;a:3:{s:2:\"id\";s:7:\"column9\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:2:{i:0;a:3:{s:2:\"id\";s:20:\"4qk4jbmzf6xo30im8g4o\";s:4:\"type\";s:5:\"space\";s:6:\"params\";a:2:{s:5:\"width\";a:3:{s:2:\"id\";s:5:\"width\";s:5:\"value\";i:15;s:4:\"type\";s:6:\"slider\";}s:9:\"css_class\";a:3:{s:2:\"id\";s:9:\"css_class\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}}}i:1;a:3:{s:2:\"id\";s:20:\"9x1ytaxq7aphtb3npidp\";s:4:\"type\";s:6:\"search\";s:6:\"params\";a:15:{s:7:\"display\";a:3:{s:2:\"id\";s:7:\"display\";s:5:\"value\";s:4:\"form\";s:4:\"type\";s:8:\"selector\";}s:19:\"categories_dropdown\";a:3:{s:2:\"id\";s:19:\"categories_dropdown\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:16:\"popular_requests\";a:3:{s:2:\"id\";s:16:\"popular_requests\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:4:\"ajax\";a:3:{s:2:\"id\";s:4:\"ajax\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:17:\"ajax_result_count\";a:3:{s:2:\"id\";s:17:\"ajax_result_count\";s:5:\"value\";i:20;s:4:\"type\";s:6:\"slider\";}s:9:\"post_type\";a:3:{s:2:\"id\";s:9:\"post_type\";s:5:\"value\";s:7:\"product\";s:4:\"type\";s:8:\"selector\";}s:11:\"icon_design\";a:3:{s:2:\"id\";s:11:\"icon_design\";s:5:\"value\";s:1:\"1\";s:4:\"type\";s:8:\"selector\";}s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:11:\"custom_icon\";a:3:{s:2:\"id\";s:11:\"custom_icon\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}s:12:\"search_style\";a:3:{s:2:\"id\";s:12:\"search_style\";s:5:\"value\";s:7:\"with-bg\";s:4:\"type\";s:8:\"selector\";}s:10:\"form_color\";a:3:{s:2:\"id\";s:10:\"form_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:22:\"form_placeholder_color\";a:3:{s:2:\"id\";s:22:\"form_placeholder_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:14:\"form_brd_color\";a:3:{s:2:\"id\";s:14:\"form_brd_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:20:\"form_brd_color_focus\";a:3:{s:2:\"id\";s:20:\"form_brd_color_focus\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:7:\"form_bg\";a:3:{s:2:\"id\";s:7:\"form_bg\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}}}}}i:2;a:3:{s:2:\"id\";s:8:\"column10\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:2:{i:0;a:3:{s:2:\"id\";s:20:\"wust3ugkiykpfmjy3s96\";s:4:\"type\";s:7:\"account\";s:6:\"params\";a:7:{s:7:\"display\";a:3:{s:2:\"id\";s:7:\"display\";s:5:\"value\";s:4:\"text\";s:4:\"type\";s:8:\"selector\";}s:11:\"icon_design\";a:3:{s:2:\"id\";s:11:\"icon_design\";s:5:\"value\";s:1:\"1\";s:4:\"type\";s:8:\"selector\";}s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:11:\"custom_icon\";a:3:{s:2:\"id\";s:11:\"custom_icon\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}s:13:\"with_username\";a:3:{s:2:\"id\";s:13:\"with_username\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:14:\"login_dropdown\";a:3:{s:2:\"id\";s:14:\"login_dropdown\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:12:\"form_display\";a:3:{s:2:\"id\";s:12:\"form_display\";s:5:\"value\";s:4:\"side\";s:4:\"type\";s:8:\"selector\";}}}i:1;a:3:{s:2:\"id\";s:20:\"sli6yksde8xy7qxevwsz\";s:4:\"type\";s:6:\"social\";s:6:\"params\";a:7:{s:4:\"type\";a:3:{s:2:\"id\";s:4:\"type\";s:5:\"value\";s:6:\"follow\";s:4:\"type\";s:8:\"selector\";}s:8:\"el_class\";a:3:{s:2:\"id\";s:8:\"el_class\";s:5:\"value\";s:19:\"dokhaniyat._.mehran\";s:4:\"type\";s:4:\"text\";}s:5:\"align\";a:3:{s:2:\"id\";s:5:\"align\";s:5:\"value\";s:4:\"left\";s:4:\"type\";s:8:\"selector\";}s:4:\"size\";a:3:{s:2:\"id\";s:4:\"size\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:8:\"selector\";}s:5:\"color\";a:3:{s:2:\"id\";s:5:\"color\";s:5:\"value\";s:4:\"dark\";s:4:\"type\";s:8:\"selector\";}s:5:\"style\";a:3:{s:2:\"id\";s:5:\"style\";s:5:\"value\";s:8:\"bordered\";s:4:\"type\";s:8:\"selector\";}s:4:\"form\";a:3:{s:2:\"id\";s:4:\"form\";s:5:\"value\";s:6:\"circle\";s:4:\"type\";s:8:\"selector\";}}}}}i:3;a:3:{s:2:\"id\";s:14:\"column_mobile2\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:2:{i:0;a:3:{s:2:\"id\";s:20:\"g1k0m1tib7raxrwkm1t3\";s:4:\"type\";s:6:\"burger\";s:6:\"params\";a:16:{s:5:\"style\";a:3:{s:2:\"id\";s:5:\"style\";s:5:\"value\";s:4:\"text\";s:4:\"type\";s:8:\"selector\";}s:11:\"icon_design\";a:3:{s:2:\"id\";s:11:\"icon_design\";s:5:\"value\";s:1:\"1\";s:4:\"type\";s:8:\"selector\";}s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:11:\"custom_icon\";a:3:{s:2:\"id\";s:11:\"custom_icon\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}s:8:\"position\";a:3:{s:2:\"id\";s:8:\"position\";s:5:\"value\";s:4:\"left\";s:4:\"type\";s:8:\"selector\";}s:11:\"search_form\";a:3:{s:2:\"id\";s:11:\"search_form\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:9:\"post_type\";a:3:{s:2:\"id\";s:9:\"post_type\";s:5:\"value\";s:7:\"product\";s:4:\"type\";s:8:\"selector\";}s:15:\"categories_menu\";a:3:{s:2:\"id\";s:15:\"categories_menu\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:9:\"tabs_swap\";a:3:{s:2:\"id\";s:9:\"tabs_swap\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:18:\"primary_menu_title\";a:3:{s:2:\"id\";s:18:\"primary_menu_title\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:20:\"secondary_menu_title\";a:3:{s:2:\"id\";s:20:\"secondary_menu_title\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:7:\"menu_id\";a:3:{s:2:\"id\";s:7:\"menu_id\";s:5:\"value\";s:17:\"mobile-categories\";s:4:\"type\";s:7:\"options\";}s:13:\"show_wishlist\";a:3:{s:2:\"id\";s:13:\"show_wishlist\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:12:\"show_compare\";a:3:{s:2:\"id\";s:12:\"show_compare\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:12:\"show_account\";a:3:{s:2:\"id\";s:12:\"show_account\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:9:\"close_btn\";a:3:{s:2:\"id\";s:9:\"close_btn\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}}}i:1;a:3:{s:2:\"id\";s:20:\"pfzyw6zch8t75a2dpog2\";s:4:\"type\";s:7:\"account\";s:6:\"params\";a:7:{s:7:\"display\";a:3:{s:2:\"id\";s:7:\"display\";s:5:\"value\";s:4:\"icon\";s:4:\"type\";s:8:\"selector\";}s:11:\"icon_design\";a:3:{s:2:\"id\";s:11:\"icon_design\";s:5:\"value\";s:1:\"1\";s:4:\"type\";s:8:\"selector\";}s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:11:\"custom_icon\";a:3:{s:2:\"id\";s:11:\"custom_icon\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}s:13:\"with_username\";a:3:{s:2:\"id\";s:13:\"with_username\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:14:\"login_dropdown\";a:3:{s:2:\"id\";s:14:\"login_dropdown\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:12:\"form_display\";a:3:{s:2:\"id\";s:12:\"form_display\";s:5:\"value\";s:4:\"side\";s:4:\"type\";s:8:\"selector\";}}}}}i:4;a:3:{s:2:\"id\";s:14:\"column_mobile3\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:1:{i:0;a:3:{s:2:\"id\";s:20:\"lt7vdqgaccmapftzurvt\";s:4:\"type\";s:4:\"logo\";s:6:\"params\";a:6:{s:5:\"image\";a:3:{s:2:\"id\";s:5:\"image\";s:5:\"value\";a:4:{s:2:\"id\";i:4149;s:3:\"url\";s:62:\"https://kashtmoodrmozafari.ir/wp-content/uploads/2025/11/o.png\";s:5:\"width\";i:1187;s:6:\"height\";i:1187;}s:4:\"type\";s:5:\"image\";}s:5:\"width\";a:3:{s:2:\"id\";s:5:\"width\";s:5:\"value\";i:179;s:4:\"type\";s:6:\"slider\";}s:13:\"sticky_notice\";a:3:{s:2:\"id\";s:13:\"sticky_notice\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:6:\"notice\";}s:12:\"sticky_image\";a:3:{s:2:\"id\";s:12:\"sticky_image\";s:5:\"value\";b:0;s:4:\"type\";s:5:\"image\";}s:12:\"sticky_width\";a:3:{s:2:\"id\";s:12:\"sticky_width\";s:5:\"value\";i:179;s:4:\"type\";s:6:\"slider\";}s:12:\"width_height\";a:3:{s:2:\"id\";s:12:\"width_height\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}}}}}i:5;a:3:{s:2:\"id\";s:14:\"column_mobile4\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:2:{i:0;a:3:{s:2:\"id\";s:20:\"trk5sfmvib0ch1s1qbtc\";s:4:\"type\";s:4:\"cart\";s:6:\"params\";a:4:{s:8:\"position\";a:3:{s:2:\"id\";s:8:\"position\";s:5:\"value\";s:4:\"side\";s:4:\"type\";s:8:\"selector\";}s:5:\"style\";a:3:{s:2:\"id\";s:5:\"style\";s:5:\"value\";s:1:\"5\";s:4:\"type\";s:8:\"selector\";}s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:3:\"bag\";s:4:\"type\";s:8:\"selector\";}s:11:\"custom_icon\";a:3:{s:2:\"id\";s:11:\"custom_icon\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}}}i:1;a:3:{s:2:\"id\";s:20:\"1pr5fhmwmomaw7uyqf57\";s:4:\"type\";s:12:\"mobilesearch\";s:6:\"params\";a:11:{s:7:\"display\";a:3:{s:2:\"id\";s:7:\"display\";s:5:\"value\";s:4:\"icon\";s:4:\"type\";s:8:\"selector\";}s:9:\"post_type\";a:3:{s:2:\"id\";s:9:\"post_type\";s:5:\"value\";s:7:\"product\";s:4:\"type\";s:8:\"selector\";}s:11:\"icon_design\";a:3:{s:2:\"id\";s:11:\"icon_design\";s:5:\"value\";s:1:\"1\";s:4:\"type\";s:8:\"selector\";}s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:11:\"custom_icon\";a:3:{s:2:\"id\";s:11:\"custom_icon\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}s:12:\"search_style\";a:3:{s:2:\"id\";s:12:\"search_style\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:10:\"form_color\";a:3:{s:2:\"id\";s:10:\"form_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:22:\"form_placeholder_color\";a:3:{s:2:\"id\";s:22:\"form_placeholder_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:14:\"form_brd_color\";a:3:{s:2:\"id\";s:14:\"form_brd_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:20:\"form_brd_color_focus\";a:3:{s:2:\"id\";s:20:\"form_brd_color_focus\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:7:\"form_bg\";a:3:{s:2:\"id\";s:7:\"form_bg\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}}}}}}s:6:\"params\";a:11:{s:11:\"flex_layout\";a:3:{s:2:\"id\";s:11:\"flex_layout\";s:5:\"value\";s:11:\"flex-middle\";s:4:\"type\";s:8:\"selector\";}s:6:\"height\";a:3:{s:2:\"id\";s:6:\"height\";s:5:\"value\";i:75;s:4:\"type\";s:6:\"slider\";}s:13:\"mobile_height\";a:3:{s:2:\"id\";s:13:\"mobile_height\";s:5:\"value\";i:60;s:4:\"type\";s:6:\"slider\";}s:12:\"hide_desktop\";a:3:{s:2:\"id\";s:12:\"hide_desktop\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:11:\"hide_mobile\";a:3:{s:2:\"id\";s:11:\"hide_mobile\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:6:\"sticky\";a:3:{s:2:\"id\";s:6:\"sticky\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:13:\"sticky_height\";a:3:{s:2:\"id\";s:13:\"sticky_height\";s:5:\"value\";i:60;s:4:\"type\";s:6:\"slider\";}s:12:\"color_scheme\";a:3:{s:2:\"id\";s:12:\"color_scheme\";s:5:\"value\";s:4:\"dark\";s:4:\"type\";s:8:\"selector\";}s:6:\"shadow\";a:3:{s:2:\"id\";s:6:\"shadow\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:10:\"background\";a:3:{s:2:\"id\";s:10:\"background\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:2:\"bg\";}s:6:\"border\";a:3:{s:2:\"id\";s:6:\"border\";s:5:\"value\";a:4:{s:5:\"width\";s:1:\"0\";s:8:\"applyFor\";s:9:\"fullwidth\";s:5:\"style\";s:5:\"solid\";s:5:\"sides\";a:1:{i:0;s:6:\"bottom\";}}s:4:\"type\";s:6:\"border\";}}}i:2;a:4:{s:2:\"id\";s:13:\"header-bottom\";s:4:\"type\";s:3:\"row\";s:7:\"content\";a:4:{i:0;a:3:{s:2:\"id\";s:8:\"column11\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:1:{i:0;a:3:{s:2:\"id\";s:20:\"wjlcubfdmlq3d7jvmt23\";s:4:\"type\";s:10:\"categories\";s:6:\"params\";a:12:{s:16:\"categories_title\";a:3:{s:2:\"id\";s:16:\"categories_title\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:6:\"design\";a:3:{s:2:\"id\";s:6:\"design\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:7:\"options\";}s:7:\"menu_id\";a:3:{s:2:\"id\";s:7:\"menu_id\";s:5:\"value\";i:166;s:4:\"type\";s:7:\"options\";}s:15:\"more_cat_button\";a:3:{s:2:\"id\";s:15:\"more_cat_button\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:21:\"more_cat_button_count\";a:3:{s:2:\"id\";s:21:\"more_cat_button_count\";s:5:\"value\";i:5;s:4:\"type\";s:6:\"slider\";}s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:11:\"custom_icon\";a:3:{s:2:\"id\";s:11:\"custom_icon\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}s:11:\"mouse_event\";a:3:{s:2:\"id\";s:11:\"mouse_event\";s:5:\"value\";s:5:\"hover\";s:4:\"type\";s:8:\"selector\";}s:13:\"open_dropdown\";a:3:{s:2:\"id\";s:13:\"open_dropdown\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:12:\"color_scheme\";a:3:{s:2:\"id\";s:12:\"color_scheme\";s:5:\"value\";s:5:\"light\";s:4:\"type\";s:8:\"selector\";}s:10:\"background\";a:3:{s:2:\"id\";s:10:\"background\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:2:\"bg\";}s:6:\"border\";a:3:{s:2:\"id\";s:6:\"border\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:6:\"border\";}}}}}i:1;a:3:{s:2:\"id\";s:8:\"column12\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:1:{i:0;a:3:{s:2:\"id\";s:20:\"6kgdkbvf12frej4dofvj\";s:4:\"type\";s:8:\"mainmenu\";s:6:\"params\";a:9:{s:7:\"menu_id\";a:3:{s:2:\"id\";s:7:\"menu_id\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:7:\"options\";}s:10:\"menu_style\";a:3:{s:2:\"id\";s:10:\"menu_style\";s:5:\"value\";s:9:\"underline\";s:4:\"type\";s:8:\"selector\";}s:10:\"menu_align\";a:3:{s:2:\"id\";s:10:\"menu_align\";s:5:\"value\";s:5:\"right\";s:4:\"type\";s:8:\"selector\";}s:11:\"full_screen\";a:3:{s:2:\"id\";s:11:\"full_screen\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:11:\"icon_design\";a:3:{s:2:\"id\";s:11:\"icon_design\";s:5:\"value\";s:1:\"1\";s:4:\"type\";s:8:\"selector\";}s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:11:\"custom_icon\";a:3:{s:2:\"id\";s:11:\"custom_icon\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}s:9:\"items_gap\";a:3:{s:2:\"id\";s:9:\"items_gap\";s:5:\"value\";s:1:\"s\";s:4:\"type\";s:8:\"selector\";}s:6:\"inline\";a:3:{s:2:\"id\";s:6:\"inline\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}}}}}i:2;a:3:{s:2:\"id\";s:8:\"column13\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:3:{i:0;a:3:{s:2:\"id\";s:20:\"4td43oq0ylha9p25x2o4\";s:4:\"type\";s:7:\"infobox\";s:6:\"params\";a:45:{s:10:\"icon_style\";a:3:{s:2:\"id\";s:10:\"icon_style\";s:5:\"value\";s:6:\"simple\";s:4:\"type\";s:8:\"selector\";}s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:4:\"icon\";s:4:\"type\";s:8:\"selector\";}s:13:\"icon_bg_color\";a:3:{s:2:\"id\";s:13:\"icon_bg_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:19:\"icon_bg_hover_color\";a:3:{s:2:\"id\";s:19:\"icon_bg_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:17:\"icon_border_color\";a:3:{s:2:\"id\";s:17:\"icon_border_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:23:\"icon_border_hover_color\";a:3:{s:2:\"id\";s:23:\"icon_border_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:9:\"icon_text\";a:3:{s:2:\"id\";s:9:\"icon_text\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:14:\"icon_text_size\";a:3:{s:2:\"id\";s:14:\"icon_text_size\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:15:\"icon_text_color\";a:3:{s:2:\"id\";s:15:\"icon_text_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:5:\"image\";a:3:{s:2:\"id\";s:5:\"image\";s:5:\"value\";a:4:{s:2:\"id\";i:2146;s:3:\"url\";s:73:\"https://kashtmoodrmozafari.ir/wp-content/uploads/2018/11/bf-call-icon.svg\";s:5:\"width\";i:512;s:6:\"height\";i:512;}s:4:\"type\";s:5:\"image\";}s:8:\"img_size\";a:3:{s:2:\"id\";s:8:\"img_size\";s:5:\"value\";s:5:\"32x38\";s:4:\"type\";s:4:\"text\";}s:5:\"style\";a:3:{s:2:\"id\";s:5:\"style\";s:5:\"value\";s:4:\"base\";s:4:\"type\";s:8:\"selector\";}s:21:\"woodmart_color_scheme\";a:3:{s:2:\"id\";s:21:\"woodmart_color_scheme\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:8:\"selector\";}s:20:\"bg_hover_colorpicker\";a:3:{s:2:\"id\";s:20:\"bg_hover_colorpicker\";s:5:\"value\";s:11:\"colorpicker\";s:4:\"type\";s:8:\"selector\";}s:14:\"bg_hover_color\";a:3:{s:2:\"id\";s:14:\"bg_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:27:\"woodmart_hover_color_scheme\";a:3:{s:2:\"id\";s:27:\"woodmart_hover_color_scheme\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:8:\"selector\";}s:9:\"alignment\";a:3:{s:2:\"id\";s:9:\"alignment\";s:5:\"value\";s:4:\"left\";s:4:\"type\";s:8:\"selector\";}s:15:\"image_alignment\";a:3:{s:2:\"id\";s:15:\"image_alignment\";s:5:\"value\";s:4:\"left\";s:4:\"type\";s:8:\"selector\";}s:5:\"title\";a:3:{s:2:\"id\";s:5:\"title\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:8:\"textarea\";}s:10:\"title_font\";a:3:{s:2:\"id\";s:10:\"title_font\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:8:\"selector\";}s:9:\"title_tag\";a:3:{s:2:\"id\";s:9:\"title_tag\";s:5:\"value\";s:2:\"h1\";s:4:\"type\";s:7:\"options\";}s:10:\"title_size\";a:3:{s:2:\"id\";s:10:\"title_size\";s:5:\"value\";s:5:\"small\";s:4:\"type\";s:8:\"selector\";}s:17:\"title_font_weight\";a:3:{s:2:\"id\";s:17:\"title_font_weight\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:7:\"options\";}s:11:\"title_style\";a:3:{s:2:\"id\";s:11:\"title_style\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:11:\"title_color\";a:3:{s:2:\"id\";s:11:\"title_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:8:\"subtitle\";a:3:{s:2:\"id\";s:8:\"subtitle\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:8:\"textarea\";}s:13:\"subtitle_font\";a:3:{s:2:\"id\";s:13:\"subtitle_font\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:8:\"selector\";}s:20:\"subtitle_font_weight\";a:3:{s:2:\"id\";s:20:\"subtitle_font_weight\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:7:\"options\";}s:14:\"subtitle_color\";a:3:{s:2:\"id\";s:14:\"subtitle_color\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:21:\"subtitle_custom_color\";a:3:{s:2:\"id\";s:21:\"subtitle_custom_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:14:\"subtitle_style\";a:3:{s:2:\"id\";s:14:\"subtitle_style\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:24:\"subtitle_custom_bg_color\";a:3:{s:2:\"id\";s:24:\"subtitle_custom_bg_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:7:\"content\";a:3:{s:2:\"id\";s:7:\"content\";s:5:\"value\";s:156:\"<div class=\"color-primary\" style=\"font-weight: 900; font-size: 14px;\">پـشـتـیـبانی تلفنی</div>\n<p style=\"margin-top: -3px;\">09037174884</p>\";s:4:\"type\";s:6:\"editor\";}s:17:\"custom_text_color\";a:3:{s:2:\"id\";s:17:\"custom_text_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:8:\"btn_text\";a:3:{s:2:\"id\";s:8:\"btn_text\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:12:\"btn_position\";a:3:{s:2:\"id\";s:12:\"btn_position\";s:5:\"value\";s:5:\"hover\";s:4:\"type\";s:8:\"selector\";}s:9:\"btn_color\";a:3:{s:2:\"id\";s:9:\"btn_color\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:8:\"btn_size\";a:3:{s:2:\"id\";s:8:\"btn_size\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:9:\"btn_style\";a:3:{s:2:\"id\";s:9:\"btn_style\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:9:\"btn_shape\";a:3:{s:2:\"id\";s:9:\"btn_shape\";s:5:\"value\";s:9:\"rectangle\";s:4:\"type\";s:8:\"selector\";}s:13:\"svg_animation\";a:3:{s:2:\"id\";s:13:\"svg_animation\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:15:\"info_box_inline\";a:3:{s:2:\"id\";s:15:\"info_box_inline\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:8:\"switcher\";}s:4:\"link\";a:3:{s:2:\"id\";s:4:\"link\";s:5:\"value\";a:0:{}s:4:\"type\";s:4:\"link\";}s:8:\"el_class\";a:3:{s:2:\"id\";s:8:\"el_class\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:20:\"woodmart_bg_position\";a:3:{s:2:\"id\";s:20:\"woodmart_bg_position\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:7:\"options\";}}}i:1;a:3:{s:2:\"id\";s:20:\"36j3pnpwir8d6h2lsm9v\";s:4:\"type\";s:8:\"wishlist\";s:6:\"params\";a:5:{s:6:\"design\";a:3:{s:2:\"id\";s:6:\"design\";s:5:\"value\";s:4:\"icon\";s:4:\"type\";s:8:\"selector\";}s:11:\"icon_design\";a:3:{s:2:\"id\";s:11:\"icon_design\";s:5:\"value\";s:1:\"2\";s:4:\"type\";s:8:\"selector\";}s:18:\"hide_product_count\";a:3:{s:2:\"id\";s:18:\"hide_product_count\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:11:\"custom_icon\";a:3:{s:2:\"id\";s:11:\"custom_icon\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}}}i:2;a:3:{s:2:\"id\";s:20:\"nedhm962r512y1xz9j06\";s:4:\"type\";s:4:\"cart\";s:6:\"params\";a:4:{s:8:\"position\";a:3:{s:2:\"id\";s:8:\"position\";s:5:\"value\";s:4:\"side\";s:4:\"type\";s:8:\"selector\";}s:5:\"style\";a:3:{s:2:\"id\";s:5:\"style\";s:5:\"value\";s:1:\"3\";s:4:\"type\";s:8:\"selector\";}s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:3:\"bag\";s:4:\"type\";s:8:\"selector\";}s:11:\"custom_icon\";a:3:{s:2:\"id\";s:11:\"custom_icon\";s:5:\"value\";b:0;s:4:\"type\";s:5:\"image\";}}}}}i:3;a:3:{s:2:\"id\";s:14:\"column_mobile5\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:0:{}}}s:6:\"params\";a:11:{s:11:\"flex_layout\";a:3:{s:2:\"id\";s:11:\"flex_layout\";s:5:\"value\";s:11:\"flex-middle\";s:4:\"type\";s:8:\"selector\";}s:6:\"height\";a:3:{s:2:\"id\";s:6:\"height\";s:5:\"value\";i:45;s:4:\"type\";s:6:\"slider\";}s:13:\"mobile_height\";a:3:{s:2:\"id\";s:13:\"mobile_height\";s:5:\"value\";i:52;s:4:\"type\";s:6:\"slider\";}s:12:\"hide_desktop\";a:3:{s:2:\"id\";s:12:\"hide_desktop\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:11:\"hide_mobile\";a:3:{s:2:\"id\";s:11:\"hide_mobile\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:6:\"sticky\";a:3:{s:2:\"id\";s:6:\"sticky\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:13:\"sticky_height\";a:3:{s:2:\"id\";s:13:\"sticky_height\";s:5:\"value\";i:52;s:4:\"type\";s:6:\"slider\";}s:12:\"color_scheme\";a:3:{s:2:\"id\";s:12:\"color_scheme\";s:5:\"value\";s:4:\"dark\";s:4:\"type\";s:8:\"selector\";}s:6:\"shadow\";a:3:{s:2:\"id\";s:6:\"shadow\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:10:\"background\";a:3:{s:2:\"id\";s:10:\"background\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:2:\"bg\";}s:6:\"border\";a:3:{s:2:\"id\";s:6:\"border\";s:5:\"value\";a:4:{s:5:\"width\";s:1:\"0\";s:5:\"style\";s:5:\"solid\";s:8:\"applyFor\";s:9:\"fullwidth\";s:5:\"sides\";a:1:{i:0;s:6:\"bottom\";}}s:4:\"type\";s:6:\"border\";}}}}}s:8:\"settings\";a:9:{s:7:\"overlap\";a:3:{s:2:\"id\";s:7:\"overlap\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:5:\"boxed\";a:3:{s:2:\"id\";s:5:\"boxed\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:10:\"full_width\";a:3:{s:2:\"id\";s:10:\"full_width\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:14:\"dropdowns_dark\";a:3:{s:2:\"id\";s:14:\"dropdowns_dark\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:13:\"sticky_shadow\";a:3:{s:2:\"id\";s:13:\"sticky_shadow\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:14:\"hide_on_scroll\";a:3:{s:2:\"id\";s:14:\"hide_on_scroll\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:13:\"sticky_effect\";a:3:{s:2:\"id\";s:13:\"sticky_effect\";s:5:\"value\";s:5:\"slide\";s:4:\"type\";s:8:\"selector\";}s:12:\"sticky_clone\";a:3:{s:2:\"id\";s:12:\"sticky_clone\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:13:\"sticky_height\";a:3:{s:2:\"id\";s:13:\"sticky_height\";s:5:\"value\";i:60;s:4:\"type\";s:6:\"slider\";}}}", "yes");
INSERT INTO `won_options` VALUES("64605", "xts-header_855638-file-data", "a:3:{s:4:\"path\";s:41:\"/2025/11/xts-header_855638-1762686103.css\";s:13:\"theme_version\";s:5:\"7.0.3\";s:8:\"site_url\";s:32:\"54f0ecb4cf28f0033769e009a420dade\";}", "auto");
INSERT INTO `won_options` VALUES("1705", "rs_image_meta_todo", "a:8:{i:2147;s:135:\"/home2/abzarwpn/domains/abzarwp.net/public_html/newwood/wp-content/uploads/revslider/black-friday/retail-black-friday-slider-one-bg.jpg\";i:2148;s:140:\"/home2/abzarwpn/domains/abzarwp.net/public_html/newwood/wp-content/uploads/revslider/black-friday/retail-black-friday-slider-two-layer-2.png\";i:2149;s:140:\"/home2/abzarwpn/domains/abzarwp.net/public_html/newwood/wp-content/uploads/revslider/black-friday/retail-black-friday-slider-one-layer-4.png\";i:2150;s:140:\"/home2/abzarwpn/domains/abzarwp.net/public_html/newwood/wp-content/uploads/revslider/black-friday/retail-black-friday-slider-one-layer-6.png\";i:2151;s:140:\"/home2/abzarwpn/domains/abzarwp.net/public_html/newwood/wp-content/uploads/revslider/black-friday/retail-black-friday-slider-one-layer-5.png\";i:2152;s:135:\"/home2/abzarwpn/domains/abzarwp.net/public_html/newwood/wp-content/uploads/revslider/black-friday/retail-black-friday-slider-two-bg.jpg\";i:2153;s:137:\"/home2/abzarwpn/domains/abzarwp.net/public_html/newwood/wp-content/uploads/revslider/black-friday/retail-black-friday-slider-three-bg.jpg\";i:2154;s:142:\"/home2/abzarwpn/domains/abzarwp.net/public_html/newwood/wp-content/uploads/revslider/black-friday/retail-black-friday-slider-three-layer-2.png\";}", "yes");
INSERT INTO `won_options` VALUES("1780", "xts-theme_settings_default-css-data", ".wd-popup.wd-promo-popup{\n	background-color:#111111;\n	background-image: none;\n	background-repeat:no-repeat;\n	background-size:contain;\n	background-position:left center;\n}\n\n.page-title-default{\n	background-color:#0a0a0a;\n	background-image: none;\n	background-size:cover;\n	background-position:center center;\n}\n\n.footer-container{\n	background-color:#f7f7f7;\n	background-image: none;\n}\n\n:root{\n--wd-text-font:\"Iransans reg\", Arial, Helvetica, sans-serif;\n--wd-text-font-weight:400;\n--wd-text-color:#777777;\n--wd-text-font-size:14px;\n}\n:root{\n--wd-title-font:\"Iransans bold\", Arial, Helvetica, sans-serif;\n--wd-title-font-weight:600;\n--wd-title-color:#242424;\n}\n:root{\n--wd-entities-title-font:\"Iransans bold\", Arial, Helvetica, sans-serif;\n--wd-entities-title-font-weight:500;\n--wd-entities-title-color:#333333;\n--wd-entities-title-color-hover:rgb(51 51 51 / 65%);\n}\n:root{\n--wd-alternative-font:\"Iransans reg\", Arial, Helvetica, sans-serif;\n}\n:root{\n--wd-widget-title-font:\"Iransans bold\", Arial, Helvetica, sans-serif;\n--wd-widget-title-font-weight:600;\n--wd-widget-title-transform:uppercase;\n--wd-widget-title-color:#333;\n--wd-widget-title-font-size:16px;\n}\n:root{\n--wd-header-el-font:\"Iransans bold\", Arial, Helvetica, sans-serif;\n--wd-header-el-font-weight:700;\n--wd-header-el-transform:uppercase;\n--wd-header-el-font-size:13px;\n}\nhtml .product.category-grid-item .wd-entities-title, html .product.category-grid-item.cat-design-replace-title .wd-entities-title, html .categories-style-masonry-first .category-grid-item:first-child .wd-entities-title, html .product.wd-cat .wd-entities-title{\n	font-size: 16px;\n}\n\n:root{\n--wd-primary-color:rgb(46,200,211);\n}\n:root{\n--wd-alternative-color:#fbbc34;\n}\n:root{\n--wd-link-color:#333333;\n--wd-link-color-hover:#242424;\n}\n.page .main-page-wrapper{\n	background-color:rgb(237,243,249);\n	background-image: none;\n}\n\n:root{\n--btn-default-bgcolor:rgb(247,247,247);\n}\n:root{\n--btn-default-bgcolor-hover:#efefef;\n}\n:root{\n--btn-shop-bgcolor:#439665;\n}\n:root{\n--btn-shop-bgcolor-hover:#3D885C;\n}\n:root{\n--btn-accent-bgcolor:#439665;\n}\n:root{\n--btn-accent-bgcolor-hover:#3D885C;\n}\n:root{\n--notices-success-bg:#459647;\n}\n:root{\n--notices-success-color:#fff;\n}\n:root{\n--notices-warning-bg:#E0B252;\n}\n:root{\n--notices-warning-color:#fff;\n}\n	:root{\n					\n			\n							--wd-form-brd-radius: 0px;\n					\n					--wd-form-brd-width: 2px;\n		\n					--btn-default-color: #333;\n		\n					--btn-default-color-hover: #333;\n		\n					--btn-shop-color: #fff;\n		\n					--btn-shop-color-hover: #fff;\n		\n					--btn-accent-color: #fff;\n		\n					--btn-accent-color-hover: #fff;\n		\n									--btn-default-brd-radius: 0px;\n				--btn-default-box-shadow: none;\n				--btn-default-box-shadow-hover: none;\n				--btn-default-box-shadow-active: none;\n				--btn-default-bottom: 0px;\n			\n			\n			\n					\n					\n			\n			\n							--btn-shop-brd-radius: 5px;\n				--btn-shop-box-shadow: none;\n				--btn-shop-box-shadow-hover: none;\n					\n									--btn-accent-brd-radius: 0px;\n				--btn-accent-box-shadow: none;\n				--btn-accent-box-shadow-hover: none;\n				--btn-accent-box-shadow-active: none;\n				--btn-accent-bottom: 0px;\n			\n			\n			\n					\n							\n					--wd-brd-radius: 0px;\n			}\n\n	\n	\n			@media (min-width: 1025px) {\n			.whb-boxed:not(.whb-sticked):not(.whb-full-width) .whb-main-header {\n				max-width: 1370px;\n			}\n		}\n\n		.container {\n			max-width: 1400px;\n		}\n\n		:root{\n			--wd-container-width: 1400px;\n		}\n	\n			.elementor-section.wd-section-stretch > .elementor-column-gap-no {\n			max-width: 1370px;\n		}\n		.elementor-section.wd-section-stretch > .elementor-column-gap-narrow {\n			max-width: 1380px;\n		}\n		.elementor-section.wd-section-stretch > .elementor-column-gap-default {\n			max-width: 1390px;\n		}\n		.elementor-section.wd-section-stretch > .elementor-column-gap-extended {\n			max-width: 1400px;\n		}\n		.elementor-section.wd-section-stretch > .elementor-column-gap-wide {\n			max-width: 1410px;\n		}\n		.elementor-section.wd-section-stretch > .elementor-column-gap-wider {\n			max-width: 1430px;\n		}\n		@media (min-width: 1417px) {\n			.platform-Windows .wd-section-stretch > .elementor-container {\n				margin-left: auto;\n				margin-right: auto;\n			}\n		}\n		@media (min-width: 1400px) {\n			html:not(.platform-Windows) .wd-section-stretch > .elementor-container {\n				margin-left: auto;\n				margin-right: auto;\n			}\n		}\n	\n			div.wd-popup.popup-quick-view {\n			max-width: 920px;\n		}\n	\n	\n	\n	\n			.woodmart-woocommerce-layered-nav .wd-scroll-content {\n			max-height: 280px;\n		}\n	\n	\n@font-face {\n	font-weight: normal;\n	font-style: normal;\n	font-family: \"woodmart-font\";\n	src: url(\"//kashtmoodrmozafari.ir/wp-content/themes/woodmart/fonts/woodmart-font.woff2?v=7.0.3\") format(\"woff2\");\n}\n\n@font-face {\n	font-family: \"Iransans bold\";\n	src: url(\"//kashtmoodrmozafari.ir/wp-content/uploads/2022/11/iransansdnbold.woff2\") format(\"woff2\"), \nurl(\"//kashtmoodrmozafari.ir/wp-content/uploads/2022/11/iransansdnbold.woff\") format(\"woff\");\n	font-weight: 700;\n	font-style: normal;\n}\n\n@font-face {\n	font-family: \"Iransans reg\";\n	src: url(\"//kashtmoodrmozafari.ir/wp-content/uploads/2022/11/iransansdn.woff2\") format(\"woff2\"), \nurl(\"//kashtmoodrmozafari.ir/wp-content/uploads/2022/11/iransansdn.woff\") format(\"woff\");\n	font-weight: 400;\n	font-style: normal;\n}\n\n.owl-carousel.owl-rtl .owl-item {\r\n    min-height: inherit !important;\r\n}\r\n.product_title {\r\n    font-size: 22px !important;\r\n}\r\n/* تغییر سرچ هدر */\r\n.search-style-with-bg.searchform input[type=\"text\"] {\r\n    border-radius: 5px !important;\r\n    background: #efefef !important;\r\n    border: navajowhite !important;\r\n}\r\n\r\n.searchsubmit {\r\n    border-top-left-radius: 5px !important;\r\n    border-top-right-radius: 0px !important;\r\n    border-bottom-right-radius: 0px !important;\r\n    border-bottom-left-radius: 5px !important;\r\n}\r\n	\r\n.woodmart-search-form {\r\n    max-width: 72% !important;\r\n}\r\n.searchsubmit {\r\n    color: #fff !important;\r\n}\r\n/* منو عمودی */\r\n\r\n.menu-opener.color-scheme-light {\r\n    border-top-left-radius: 5px !important;\r\n    border-top-right-radius: 5px !important;\r\n}\r\n.wd-dropdown-cats {\r\n    border-radius: 0px 0px 7px 7px !important;\r\n}\r\n\r\n/* حساب کاربری هدر */\r\n.woodmart-header-links.woodmart-navigation.menu-simple-dropdown.wd-tools-element.item-event-hover.my-account-with-text {\r\n    border: 1px solid #d4d4d4 !important;\r\n    border-radius: 5px !important;\r\n}\r\n\r\n\r\n/* خط هدر */\r\n.whb-row.whb-header-bottom.whb-sticky-row.whb-without-bg.whb-without-border.whb-color-dark.whb-flex-flex-middle.whb-hidden-mobile {\r\n    border-bottom: 2px solid #8d8d8d47 !important;\r\n}", "yes");
INSERT INTO `won_options` VALUES("4677", "wd_page_css_files_theme_version", "7.0.3", "yes");
INSERT INTO `won_options` VALUES("1781", "xts-theme_settings_default-status", "valid", "yes");
INSERT INTO `won_options` VALUES("1782", "xts-theme_settings_default-version", "7.0.3", "yes");
INSERT INTO `won_options` VALUES("1783", "xts-theme_settings_default-site-url", "54f0ecb4cf28f0033769e009a420dade", "yes");
INSERT INTO `won_options` VALUES("64577", "xts-theme_settings_default-file-data", "a:3:{s:4:\"path\";s:50:\"/2025/11/xts-theme_settings_default-1762685753.css\";s:13:\"theme_version\";s:5:\"7.0.3\";s:8:\"site_url\";s:32:\"54f0ecb4cf28f0033769e009a420dade\";}", "auto");
INSERT INTO `won_options` VALUES("1656", "rs-templates", "a:3:{s:4:\"hash\";s:32:\"f5a235f10db5b83cd33056dded61713a\";s:6:\"slider\";a:507:{i:0;a:22:{s:2:\"id\";s:1:\"1\";s:5:\"title\";s:16:\"Classic Carousel\";s:5:\"alias\";s:16:\"classic-carousel\";s:3:\"zip\";s:20:\"classic-carousel.zip\";s:3:\"uid\";s:32:\"146a01dd380c0cdee85c4456ee68cd84\";s:3:\"img\";s:27:\"classic-carousel/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/carousel-slider-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:141:\"<span class=\"ttm_content\">Our classic, full-width carousel example. Drag, swipe or click to navigate!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:284:\"<span class=\"ttm_content\">This is a \"Default\" content carousel. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-22 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:1;a:22:{s:2:\"id\";s:1:\"2\";s:5:\"title\";s:14:\"Classic Slider\";s:5:\"alias\";s:13:\"classicslider\";s:3:\"zip\";s:17:\"classicslider.zip\";s:3:\"uid\";s:32:\"a0d6a9248c9066b404ba0f1cdadc5cf2\";s:3:\"img\";s:24:\"classicslider/slider.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-slideshow-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:136:\" <span class=\"ttm_content\">A classic slideshow example with timer, bullets and arrow navigation.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:2;a:22:{s:2:\"id\";s:1:\"3\";s:5:\"title\";s:12:\"Content Tabs\";s:5:\"alias\";s:11:\"contenttabs\";s:3:\"zip\";s:15:\"contenttabs.zip\";s:3:\"uid\";s:32:\"e02e91604b690123a3d07a65582c4fd0\";s:3:\"img\";s:22:\"contenttabs/slider.jpg\";s:7:\"preview\";s:63:\"http://revolution.themepunch.com/wordpress-content-tabs-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:170:\" <span class=\"ttm_content\">An auto-size slider with a cool split-text animation effect. Navigate with vertical bullets and thumbs.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:3;a:22:{s:2:\"id\";s:1:\"4\";s:5:\"title\";s:13:\"Facebook Feed\";s:5:\"alias\";s:13:\"facebook-feed\";s:3:\"zip\";s:17:\"facebook-feed.zip\";s:3:\"uid\";s:32:\"5506431d5b1babcb25dcf52c508d42e3\";s:3:\"img\";s:24:\"facebook-feed/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-facebook-feed/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:174:\"<span class=\"ttm_content\"> This slider is automatically populated by a Facebook stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Facebook Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:4;a:22:{s:2:\"id\";s:1:\"5\";s:5:\"title\";s:7:\"Fashion\";s:5:\"alias\";s:7:\"fashion\";s:3:\"zip\";s:11:\"fashion.zip\";s:3:\"uid\";s:32:\"4f4b914d6db35e19101ff003c4e7ea3a\";s:3:\"img\";s:18:\"fashion/slider.jpg\";s:7:\"preview\";s:65:\"http://revolution.themepunch.com/wordpress-one-page-slider-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:183:\"  <span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or bullets.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:5;a:22:{s:2:\"id\";s:1:\"6\";s:5:\"title\";s:14:\"Flickr Gallery\";s:5:\"alias\";s:14:\"flickr-gallery\";s:3:\"zip\";s:18:\"flickr-gallery.zip\";s:3:\"uid\";s:32:\"ad85cfac7acfa678e6a1b8febfee51ed\";s:3:\"img\";s:25:\"flickr-gallery/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-flickr-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"640\";s:11:\"description\";s:173:\" <span class=\"ttm_content\"> This slider is automatically populated by a Flickr stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:413:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Flickr Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:6;a:22:{s:2:\"id\";s:1:\"7\";s:5:\"title\";s:3:\"Gym\";s:5:\"alias\";s:3:\"gym\";s:3:\"zip\";s:7:\"gym.zip\";s:3:\"uid\";s:32:\"e4d81f13f96fb9bc905f4ad89615032b\";s:3:\"img\";s:14:\"gym/slider.jpg\";s:7:\"preview\";s:59:\"http://revolution.themepunch.com/one-page-wordpress-slider/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:189:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the slider menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:7;a:22:{s:2:\"id\";s:1:\"8\";s:5:\"title\";s:18:\"Highlight Carousel\";s:5:\"alias\";s:18:\"highlight-carousel\";s:3:\"zip\";s:22:\"highlight-carousel.zip\";s:3:\"uid\";s:32:\"ada52163f723a942f782351fa0396b3d\";s:3:\"img\";s:29:\"highlight-carousel/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-swipe-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"720\";s:11:\"description\";s:138:\"  <span class=\"ttm_content\">A swipe-controlled carousel with an additional tab-based navigation.</span>\r\n<span class=\"ttm_space\"></span>\r\n\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:8;a:22:{s:2:\"id\";s:1:\"9\";s:5:\"title\";s:18:\"Highlight Showcase\";s:5:\"alias\";s:18:\"highlight-showcase\";s:3:\"zip\";s:22:\"highlight-showcase.zip\";s:3:\"uid\";s:32:\"2bfe0bd410fb48fec9d942eab1e21530\";s:3:\"img\";s:29:\"highlight-showcase/slider.jpg\";s:7:\"preview\";s:62:\"http://revolution.themepunch.com/wordpress-parallax-slideshow/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"720\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">A tab-based navigation, a slideshow timer and cool animations make this slider interesting!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:9;a:22:{s:2:\"id\";s:2:\"10\";s:5:\"title\";s:10:\"Image Hero\";s:5:\"alias\";s:10:\"image-hero\";s:3:\"zip\";s:13:\"imagehero.zip\";s:3:\"uid\";s:32:\"7db18781d44f2adc28c962440894aac1\";s:3:\"img\";s:20:\"imagehero/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/wordpress-hero-image/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:121:\"<span class=\"ttm_content\">A commonly used full-width image hero block with texts.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:10;a:22:{s:2:\"id\";s:2:\"11\";s:5:\"title\";s:17:\"Instagram Gallery\";s:5:\"alias\";s:13:\"insta-gallery\";s:3:\"zip\";s:17:\"insta-gallery.zip\";s:3:\"uid\";s:32:\"711732b0d42ec2b57818a2b9b1d86cba\";s:3:\"img\";s:24:\"insta-gallery/slider.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-instagram-gallery/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"640\";s:6:\"height\";s:3:\"640\";s:11:\"description\";s:174:\"<span class=\"ttm_content\">This slider is automatically populated by a Instagram stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:416:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Instagram Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:11;a:22:{s:2:\"id\";s:2:\"12\";s:5:\"title\";s:21:\"Levano Restaurant Bar\";s:5:\"alias\";s:19:\"levanorestaurantbar\";s:3:\"zip\";s:23:\"levanorestaurantbar.zip\";s:3:\"uid\";s:32:\"4178f837db67d1b2eb6cb5840bbd0b42\";s:3:\"img\";s:30:\"levanorestaurantbar/slider.jpg\";s:7:\"preview\";s:63:\"http://revolution.themepunch.com/wordpress-front-page-template/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:181:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or bullets.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:12;a:22:{s:2:\"id\";s:2:\"13\";s:5:\"title\";s:19:\"Main Feature Slider\";s:5:\"alias\";s:11:\"mainfeature\";s:3:\"zip\";s:15:\"mainfeature.zip\";s:3:\"uid\";s:32:\"1e002a3230ab00095bedc6f60393ee7f\";s:3:\"img\";s:22:\"mainfeature/slider.jpg\";s:7:\"preview\";s:33:\"http://revolution.themepunch.com/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"750\";s:11:\"description\";s:127:\" <span class=\"ttm_content\">A slightly stripped down version of the main preview slider.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:13;a:22:{s:2:\"id\";s:2:\"14\";s:5:\"title\";s:17:\"Media Gallery Two\";s:5:\"alias\";s:17:\"media-gallery-two\";s:3:\"zip\";s:21:\"media-gallery-two.zip\";s:3:\"uid\";s:32:\"d002f1b1b55805f9322c264c5504ba5a\";s:3:\"img\";s:28:\"media-gallery-two/slider.jpg\";s:7:\"preview\";s:64:\"http://revolution.themepunch.com/wordpress-media-gallery-slider/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:6:\"6.2.22\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"692\";s:11:\"description\";s:127:\"<span class=\"ttm_content\">A media gallery example with Vimeo, HTML5 and Youtube videos.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change media and titles.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:14;a:22:{s:2:\"id\";s:2:\"15\";s:5:\"title\";s:23:\"Media Carousel Autoplay\";s:5:\"alias\";s:23:\"media-carousel-autoplay\";s:3:\"zip\";s:27:\"media-carousel-autoplay.zip\";s:3:\"uid\";s:32:\"393d7875b1cc9d933378b35e4f645d76\";s:3:\"img\";s:34:\"media-carousel-autoplay/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-media-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"720\";s:6:\"height\";s:3:\"405\";s:11:\"description\";s:153:\"<span class=\"ttm_content\">A media carousel with \"autoplay\" activated. Swipe or click tabs to navigate the slider.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:289:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change media and caption texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:15;a:22:{s:2:\"id\";s:2:\"16\";s:5:\"title\";s:21:\"News Background Video\";s:5:\"alias\";s:21:\"news-background-video\";s:3:\"zip\";s:17:\"news-bg-video.zip\";s:3:\"uid\";s:32:\"a0efe44ac3af0f958b3f84c816a08272\";s:3:\"img\";s:24:\"news-bg-video/slider.jpg\";s:7:\"preview\";s:58:\"http://revolution.themepunch.com/wordpress-content-blocks/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A hero block with HTML5 background video that plays when entering the screen.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:16;a:22:{s:2:\"id\";s:2:\"17\";s:5:\"title\";s:12:\"News Gallery\";s:5:\"alias\";s:12:\"news-gallery\";s:3:\"zip\";s:16:\"news-gallery.zip\";s:3:\"uid\";s:32:\"3a069c3b286dbb9ee435563f747e3300\";s:3:\"img\";s:23:\"news-gallery/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-news-rotator/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:131:\"<span class=\"ttm_content\">A news gallery slideshow with tab navigation. Great for any blog!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:17;a:22:{s:2:\"id\";s:2:\"18\";s:5:\"title\";s:23:\"News Gallery Post Based\";s:5:\"alias\";s:23:\"news-gallery-post-based\";s:3:\"zip\";s:27:\"news-gallery-post-based.zip\";s:3:\"uid\";s:32:\"32fe05b1039c29ab9420bfd15aec5488\";s:3:\"img\";s:34:\"news-gallery-post-based/slider.jpg\";s:7:\"preview\";s:55:\"http://revolution.themepunch.com/wordpress-post-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:125:\"<span class=\"ttm_content\"> This slider is automatically populated by WordPress posts.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:423:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Post-Based Slider\"</a>. Make sure to select the post type you want to display in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:18;a:22:{s:2:\"id\";s:2:\"19\";s:5:\"title\";s:9:\"News Hero\";s:5:\"alias\";s:9:\"news-hero\";s:3:\"zip\";s:13:\"news-hero.zip\";s:3:\"uid\";s:32:\"96a0385538a17c8c81ed8175740f70ea\";s:3:\"img\";s:20:\"news-hero/slider.jpg\";s:7:\"preview\";s:58:\"http://revolution.themepunch.com/wordpress-content-blocks/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:107:\"<span class=\"ttm_content\">A image hero block with ken burns effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:19;a:22:{s:2:\"id\";s:2:\"20\";s:5:\"title\";s:10:\"News Video\";s:5:\"alias\";s:10:\"news-video\";s:3:\"zip\";s:14:\"news-video.zip\";s:3:\"uid\";s:32:\"f901e9e16e0363248156c2209eb584e9\";s:3:\"img\";s:21:\"news-video/slider.jpg\";s:7:\"preview\";s:58:\"http://revolution.themepunch.com/wordpress-content-blocks/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:128:\"<span class=\"ttm_content\">A Vimeo background video hero block with play / pause buttons.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:289:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the video and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:20;a:22:{s:2:\"id\";s:2:\"21\";s:5:\"title\";s:15:\"Newsletter Hero\";s:5:\"alias\";s:15:\"newsletter-hero\";s:3:\"zip\";s:19:\"newsletter-hero.zip\";s:3:\"uid\";s:32:\"6290a9864d8c4c6311784586ed1cc5fe\";s:3:\"img\";s:26:\"newsletter-hero/slider.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-newsletter-signup/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:137:\"<span class=\"ttm_content\">This hero block uses a custom styled Mailchimp newsletter signup field.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:435:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image, texts, and <a href=\"https://www.themepunch.com/faq/how-to-setup-mailchimp-for-the-newsletter-hero-template/\" target=\"_blank\">Mailchimp code</a>.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:21;a:22:{s:2:\"id\";s:2:\"22\";s:5:\"title\";s:11:\"Not Generic\";s:5:\"alias\";s:10:\"notgeneric\";s:3:\"zip\";s:14:\"notgeneric.zip\";s:3:\"uid\";s:32:\"9d87ba95e02210a9f82387add2ceadf9\";s:3:\"img\";s:21:\"notgeneric/slider.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-fullscreen-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:144:\"<span class=\"ttm_content\">A full-screen slider with a layer based navigation and sleek content elements.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:22;a:22:{s:2:\"id\";s:2:\"23\";s:5:\"title\";s:11:\"Photography\";s:5:\"alias\";s:11:\"photography\";s:3:\"zip\";s:15:\"photography.zip\";s:3:\"uid\";s:32:\"1b2072547afb75e49f33b016751ed360\";s:3:\"img\";s:22:\"photography/slider.jpg\";s:7:\"preview\";s:62:\"http://revolution.themepunch.com/wordpress-photography-slider/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:194:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:23;a:22:{s:2:\"id\";s:2:\"24\";s:5:\"title\";s:20:\"Photography Carousel\";s:5:\"alias\";s:20:\"photography-carousel\";s:3:\"zip\";s:24:\"photography-carousel.zip\";s:3:\"uid\";s:32:\"9a84b859ba23dc49ba8784e3a86545fa\";s:3:\"img\";s:31:\"photography-carousel/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-photo-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">A front-page carousel that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:24;a:22:{s:2:\"id\";s:2:\"25\";s:5:\"title\";s:16:\"Search Form Hero\";s:5:\"alias\";s:16:\"search-form-hero\";s:3:\"zip\";s:20:\"search-form-hero.zip\";s:3:\"uid\";s:32:\"e09eb1bd0f22b3a2b02a1aa251dd1f3e\";s:3:\"img\";s:27:\"search-form-hero/slider.jpg\";s:7:\"preview\";s:60:\"http://revolution.themepunch.com/wordpress-search-form-hero/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">This hero block uses a custom styled input field to show search results on a WordPress site.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:320:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image, texts, and search field code.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:25;a:22:{s:2:\"id\";s:2:\"26\";s:5:\"title\";s:17:\"Showcase Carousel\";s:5:\"alias\";s:16:\"showcasecarousel\";s:3:\"zip\";s:20:\"showcasecarousel.zip\";s:3:\"uid\";s:32:\"c5ca218398331bd2c064efc2f62eae56\";s:3:\"img\";s:27:\"showcasecarousel/slider.jpg\";s:7:\"preview\";s:62:\"http://revolution.themepunch.com/wordpress-cover-flow-gallery/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:129:\"<span class=\"ttm_content\">A fancy carousel that rotates, fades and scales slider items.</span>\r\n<span class=\"ttm_space\"></span>\r\n\";s:11:\"setup_notes\";s:284:\"<span class=\"ttm_content\">This is a \"Default\" content carousel. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:26;a:22:{s:2:\"id\";s:2:\"27\";s:5:\"title\";s:11:\"Sports Hero\";s:5:\"alias\";s:11:\"sports-hero\";s:3:\"zip\";s:14:\"sportshero.zip\";s:3:\"uid\";s:32:\"8de7a145f32a362d618d2595ffa2f724\";s:3:\"img\";s:21:\"sportshero/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/wordpress-image-hero/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"720\";s:11:\"description\";s:113:\"<span class=\"ttm_content\">An sports themed image hero block with buttons.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:27;a:22:{s:2:\"id\";s:2:\"28\";s:5:\"title\";s:12:\"Twitter Feed\";s:5:\"alias\";s:12:\"twitter-feed\";s:3:\"zip\";s:16:\"twitter-feed.zip\";s:3:\"uid\";s:32:\"efbfc2af5da5258e7b7bed8598e483cc\";s:3:\"img\";s:23:\"twitter-feed/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-twitter-feed/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"640\";s:11:\"description\";s:173:\"<span class=\"ttm_content\"> This slider is automatically populated by a Twitter stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:414:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Twitter Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:28;a:22:{s:2:\"id\";s:2:\"29\";s:5:\"title\";s:13:\"Vimeo Gallery\";s:5:\"alias\";s:13:\"vimeo-gallery\";s:3:\"zip\";s:17:\"vimeo-gallery.zip\";s:3:\"uid\";s:32:\"fa824ce1ff3942ec268fc9eda60df539\";s:3:\"img\";s:24:\"vimeo-gallery/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-vimeo-gallery/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"692\";s:11:\"description\";s:170:\"<span class=\"ttm_content\">This slider is automatically populated by a Vimeo stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:412:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Vimeo Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:29;a:22:{s:2:\"id\";s:2:\"30\";s:5:\"title\";s:10:\"Vimeo Hero\";s:5:\"alias\";s:9:\"vimeohero\";s:3:\"zip\";s:13:\"vimeohero.zip\";s:3:\"uid\";s:32:\"c575575f96173d88589cddcb06120b77\";s:3:\"img\";s:20:\"vimeohero/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/wordpress-hero-vimeo/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:116:\"<span class=\"ttm_content\">A commonly used Vimeo video background hero block.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:464:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:30;a:22:{s:2:\"id\";s:2:\"31\";s:5:\"title\";s:16:\"Web Product Dark\";s:5:\"alias\";s:16:\"web-product-dark\";s:3:\"zip\";s:20:\"web-product-dark.zip\";s:3:\"uid\";s:32:\"39b872cf0608e63c3a503e58374dc30a\";s:3:\"img\";s:27:\"web-product-dark/slider.jpg\";s:7:\"preview\";s:60:\"http://revolution.themepunch.com/wordpress-frontpage-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:194:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:31;a:22:{s:2:\"id\";s:2:\"32\";s:5:\"title\";s:21:\"Web Product Dark Hero\";s:5:\"alias\";s:21:\"web-product-dark-hero\";s:3:\"zip\";s:25:\"web-product-dark-hero.zip\";s:3:\"uid\";s:32:\"b6784e8925221f36677217979d26e6f0\";s:3:\"img\";s:32:\"web-product-dark-hero/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-header-image/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:162:\"<span class=\"ttm_content\">A modern hero block with three common devices. The screens of each device can be changed easily!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:32;a:22:{s:2:\"id\";s:2:\"33\";s:5:\"title\";s:22:\"Web Product Light Hero\";s:5:\"alias\";s:22:\"web-product-light-hero\";s:3:\"zip\";s:26:\"web-product-light-hero.zip\";s:3:\"uid\";s:32:\"428e65d6aaa6ef775429989d50516492\";s:3:\"img\";s:33:\"web-product-light-hero/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/hero-image-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:162:\"<span class=\"ttm_content\">A modern hero block with three common devices. The screens of each device can be changed easily!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:289:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:33;a:22:{s:2:\"id\";s:2:\"34\";s:5:\"title\";s:17:\"Web Product Light\";s:5:\"alias\";s:15:\"webproductlight\";s:3:\"zip\";s:19:\"webproductlight.zip\";s:3:\"uid\";s:32:\"fa23dab5bf1139c6393828647a9de4e0\";s:3:\"img\";s:26:\"webproductlight/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/wordpress-cover-page/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:194:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:34;a:22:{s:2:\"id\";s:2:\"35\";s:5:\"title\";s:15:\"Youtube Gallery\";s:5:\"alias\";s:15:\"youtube-gallery\";s:3:\"zip\";s:19:\"youtube-gallery.zip\";s:3:\"uid\";s:32:\"ee9e4928ac74f5f0c0b697ce708f5aa7\";s:3:\"img\";s:26:\"youtube-gallery/slider.jpg\";s:7:\"preview\";s:59:\"http://revolution.themepunch.com/wordpress-youtube-gallery/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:173:\"<span class=\"ttm_content\"> This slider is automatically populated by a YouTube stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:414:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"YouTube Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:35;a:22:{s:2:\"id\";s:2:\"36\";s:5:\"title\";s:12:\"Youtube Hero\";s:5:\"alias\";s:11:\"youtubehero\";s:3:\"zip\";s:15:\"youtubehero.zip\";s:3:\"uid\";s:32:\"e0b2c12a45841bdf21cb96305f2c85bf\";s:3:\"img\";s:22:\"youtubehero/slider.jpg\";s:7:\"preview\";s:58:\"http://revolution.themepunch.com/wordpress-youtube-header/\";s:7:\"version\";s:5:\"1.0.3\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:104:\"<span class=\"ttm_content\">A YouTube video background hero block.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:633:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\nLearn how to <a href=\"https://www.themepunch.com/faq/enable-sound-for-the-youtube-hero-template/\" target=\"_blank\">enable sound for the background video</a><br /><br />\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:36;a:22:{s:2:\"id\";s:2:\"37\";s:5:\"title\";s:13:\"Scroll Effect\";s:5:\"alias\";s:13:\"scroll-effect\";s:3:\"zip\";s:17:\"scroll-effect.zip\";s:3:\"uid\";s:32:\"417f59e9db87aa7e47c8509eb88d4af6\";s:3:\"img\";s:23:\"scrolleffect/slide1.jpg\";s:7:\"preview\";s:60:\"http://revolution.themepunch.com/big-bold-fullscreen-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:134:\"<span class=\"ttm_content\">A full-screen slider with a unique scroll effect and big, bold text.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:485:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>For further configuration options please view the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:37;a:22:{s:2:\"id\";s:2:\"38\";s:5:\"title\";s:12:\"Content Zoom\";s:5:\"alias\";s:12:\"content-zoom\";s:3:\"zip\";s:16:\"content-zoom.zip\";s:3:\"uid\";s:32:\"42ef8cdb70d42ec6ff6fa3b69a027b5f\";s:3:\"img\";s:22:\"contentzoom/slide1.jpg\";s:7:\"preview\";s:53:\"http://revolution.themepunch.com/content-zoom-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:243:\"<span class=\"ttm_content\">A very unique full-width slider that uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:371:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:38;a:22:{s:2:\"id\";s:2:\"39\";s:5:\"title\";s:13:\"Food Carousel\";s:5:\"alias\";s:13:\"food-carousel\";s:3:\"zip\";s:17:\"food-carousel.zip\";s:3:\"uid\";s:32:\"a7bf54527b6658a0a308c70c729779fe\";s:3:\"img\";s:29:\"foodcarousel/slider_cover.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/food-carousel-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:267:\"<span class=\"ttm_content\">A fancy carousel with detail content on each slide. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> are used to show and hide layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:371:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:39;a:22:{s:2:\"id\";s:2:\"40\";s:5:\"title\";s:14:\"Rotating Words\";s:5:\"alias\";s:14:\"rotating-words\";s:3:\"zip\";s:18:\"rotating-words.zip\";s:3:\"uid\";s:32:\"70190463d9376f278c8197b7b2ef6c1b\";s:3:\"img\";s:24:\"rotatingwords/slide1.jpg\";s:7:\"preview\";s:53:\"http://revolution.themepunch.com/rotating-words-hero/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:134:\"<span class=\"ttm_content\">A full-screen hero block with unique animated text and blur effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:495:\"<span class=\"ttm_content\">This is a \"Default\" hero slider. Edit the slide to change the background media and texts.<br/>For further configuration options please view the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:40;a:22:{s:2:\"id\";s:2:\"41\";s:5:\"title\";s:22:\"Travel Static Captions\";s:5:\"alias\";s:22:\"travel-static-captions\";s:3:\"zip\";s:26:\"travel-static-captions.zip\";s:3:\"uid\";s:32:\"bbe7d61c7c741ebc7aa1ce1082b0cb71\";s:3:\"img\";s:33:\"travel-static-captions/slide1.jpg\";s:7:\"preview\";s:50:\"http://revolution.themepunch.com/travel-slideshow/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:148:\"<span class=\"ttm_content\">A slideshow example with static captions layers above a rotating image background.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:41;a:22:{s:2:\"id\";s:2:\"42\";s:5:\"title\";s:7:\"Concept\";s:5:\"alias\";s:7:\"concept\";s:3:\"zip\";s:11:\"concept.zip\";s:3:\"uid\";s:32:\"47cb06083e87503762f6746725117a3c\";s:3:\"img\";s:18:\"concept/slide1.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/fullscreen-wordpress-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:232:\"<span class=\"ttm_content\">A full-screen slider that uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:371:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:42;a:22:{s:2:\"id\";s:2:\"43\";s:5:\"title\";s:15:\"True Fullscreen\";s:5:\"alias\";s:17:\"fullscreen-button\";s:3:\"zip\";s:21:\"fullscreen-button.zip\";s:3:\"uid\";s:32:\"618a43bdf89333b555531f6d6ecde359\";s:3:\"img\";s:28:\"fullscreen-button/slide1.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-sidebar-slideshow/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:246:\"<span class=\"ttm_content\">A slider with a full-screen button that uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:297:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change the background images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:43;a:22:{s:2:\"id\";s:2:\"44\";s:5:\"title\";s:16:\"Creative Freedom\";s:5:\"alias\";s:15:\"creativefreedom\";s:3:\"zip\";s:19:\"creativefreedom.zip\";s:3:\"uid\";s:32:\"8902bf6c93126c2c6323626b9e872621\";s:3:\"img\";s:26:\"creativefreedom/slide1.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-touch-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:145:\"<span class=\"ttm_content\">A full-screen slider with a unique vertical navigation and 3D-parallax effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:290:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images, videos and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:44;a:22:{s:2:\"id\";s:2:\"45\";s:5:\"title\";s:17:\"3D Parallax Scene\";s:5:\"alias\";s:13:\"parallaxscene\";s:3:\"zip\";s:17:\"parallaxscene.zip\";s:3:\"uid\";s:32:\"51566f1ce649708e97a0f5dfaf05ea19\";s:3:\"img\";s:24:\"parallaxscene/slide1.jpg\";s:7:\"preview\";s:55:\"http://revolution.themepunch.com/wordpress-3d-parallax/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"700\";s:11:\"description\";s:328:\"<span class=\"ttm_content\">A 3D-parallax hero scene with mouse-controlled effects. Smart image arrangement creates a convincing 3D effect. Tooltips are shown using <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a>.</span>\r\n</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:45;a:22:{s:2:\"id\";s:2:\"46\";s:5:\"title\";s:10:\"Wow Factor\";s:5:\"alias\";s:15:\"slidingoverlays\";s:3:\"zip\";s:19:\"slidingoverlays.zip\";s:3:\"uid\";s:32:\"18002d17e8bc7ca61b0951f5305a759e\";s:3:\"img\";s:26:\"slidingoverlays/slide1.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/responsive-wordpress-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:106:\"<span class=\"ttm_content\">A 3D-parallax effect full-screen slider.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:46;a:22:{s:2:\"id\";s:2:\"47\";s:5:\"title\";s:14:\"3D Web Product\";s:5:\"alias\";s:25:\"web-product-light-hero-3d\";s:3:\"zip\";s:29:\"web-product-light-hero-3d.zip\";s:3:\"uid\";s:32:\"efd345c5da805414093e46066cefd751\";s:3:\"img\";s:36:\"web-product-light-hero-3d/slide1.jpg\";s:7:\"preview\";s:52:\"http://revolution.themepunch.com/wordpress-3d-scene/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"668\";s:11:\"description\";s:149:\"<span class=\"ttm_content\">A 3D-parallax hero scene slider with a convincing depth-effect and animated clouds.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:47;a:22:{s:2:\"id\";s:2:\"48\";s:5:\"title\";s:15:\"WooCommerce Big\";s:5:\"alias\";s:6:\"woobig\";s:3:\"zip\";s:10:\"woobig.zip\";s:3:\"uid\";s:32:\"bfb09a39656c7c80e86b468fc5b3403c\";s:3:\"img\";s:17:\"woobig/slide1.jpg\";s:7:\"preview\";s:52:\"http://revolution.themepunch.com/woocommerce-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:173:\"<span class=\"ttm_content\">This slider is automatically populated by WooCommerce posts. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"WooCommerce Slider\"</a>. Make sure to select the products you want to show in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:3:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";i:2;s:11:\"woocommerce\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:48;a:22:{s:2:\"id\";s:2:\"49\";s:5:\"title\";s:17:\"WooCommerce Small\";s:5:\"alias\";s:16:\"woocommercesmall\";s:3:\"zip\";s:20:\"woocommercesmall.zip\";s:3:\"uid\";s:32:\"b17c2adcc5c4c4b68a7ac6fee32fa030\";s:3:\"img\";s:27:\"woocommercesmall/slide1.jpg\";s:7:\"preview\";s:52:\"http://revolution.themepunch.com/woocommerce-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:3:\"400\";s:6:\"height\";s:3:\"266\";s:11:\"description\";s:174:\" <span class=\"ttm_content\">This slider is automatically populated by WooCommerce posts. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"WooCommerce Slider\"</a>. Make sure to select the products you want to show in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:3:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";i:2;s:11:\"woocommerce\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:49;a:22:{s:2:\"id\";s:2:\"50\";s:5:\"title\";s:17:\"Restaurant Header\";s:5:\"alias\";s:10:\"finedining\";s:3:\"zip\";s:14:\"finedining.zip\";s:3:\"uid\";s:32:\"03481a9e258501fbe3888b48830ea845\";s:3:\"img\";s:21:\"finedining/slide1.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/restaurant-hero-header/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:275:\"<span class=\"ttm_content\">A full-screen hero block slider that shows different background layers on button hover using <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a>.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:464:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:50;a:22:{s:2:\"id\";s:2:\"51\";s:5:\"title\";s:21:\"Agency Website Header\";s:5:\"alias\";s:12:\"agency-intro\";s:3:\"zip\";s:16:\"agency-intro.zip\";s:3:\"uid\";s:32:\"e9be2afdd55a0c8d0d8d0cc12ba4c82f\";s:3:\"img\";s:23:\"agency-intro/slide1.jpg\";s:7:\"preview\";s:60:\"http://revolution.themepunch.com/agency-website-hero-header/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:302:\" <span class=\"ttm_content\">A full-screen hero block slider with ken burns effect and video modal on button click. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> are used to achieve this effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:371:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:51;a:22:{s:2:\"id\";s:2:\"52\";s:5:\"title\";s:11:\"Team Slider\";s:5:\"alias\";s:7:\"ourteam\";s:3:\"zip\";s:11:\"ourteam.zip\";s:3:\"uid\";s:32:\"d8eb1fec07a79202d1118bb17f70c233\";s:3:\"img\";s:18:\"ourteam/slide1.jpg\";s:7:\"preview\";s:74:\"http://revolution.themepunch.com/thumbnail-hover-slider-revolution-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.4\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:303:\"<span class=\"ttm_content\">A team slider that changes slides and displays additional information on thumbnail hover. It uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to achieve this effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:657:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\nLearn how to <a href=\"https://www.themepunch.com/faq/modify-thumbnails-for-our-team-template/\" target=\"_blank\">modify the thumbnails</a><br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:52;a:22:{s:2:\"id\";s:2:\"53\";s:5:\"title\";s:13:\"Team Carousel\";s:5:\"alias\";s:17:\"our-team-carousel\";s:3:\"zip\";s:21:\"our-team-carousel.zip\";s:3:\"uid\";s:32:\"37656d5dcab1f265c025cb2a3d669809\";s:3:\"img\";s:26:\"ourteamcarousel/slide1.jpg\";s:7:\"preview\";s:83:\"http://revolution.themepunch.com/thumbnail-hover-carousel-slider-revolution-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.4\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:306:\" <span class=\"ttm_content\">A team carousel that changes slides and displays additional information on thumbnail hover. It uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to achieve this effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:659:\"<span class=\"ttm_content\">This is a \"Default\" content carousel. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\nLearn how to <a href=\"https://www.themepunch.com/faq/modify-thumbnails-for-our-team-template/\" target=\"_blank\">modify the thumbnails</a><br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:53;a:22:{s:2:\"id\";s:2:\"54\";s:5:\"title\";s:17:\"4K Youtube Slider\";s:5:\"alias\";s:13:\"betteryoutube\";s:3:\"zip\";s:17:\"betteryoutube.zip\";s:3:\"uid\";s:32:\"d7c5fef9f257037d7a148038aa2a1857\";s:3:\"img\";s:24:\"betteryoutube/slide1.jpg\";s:7:\"preview\";s:94:\"http://revolution.themepunch.com/fullscreen-4k-youtube-video-gallery-slider-revolution-plugin/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.1.4\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"675\";s:11:\"description\";s:293:\" <span class=\"ttm_content\">A full-screen youtube gallery with 4K videos as an example. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> are used to breathe life into navigation elements.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:535:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change videos and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:54;a:22:{s:2:\"id\";s:2:\"55\";s:5:\"title\";s:21:\"Agency Website Header\";s:5:\"alias\";s:19:\"agencywebsiteheader\";s:3:\"zip\";s:23:\"agencywebsiteheader.zip\";s:3:\"uid\";s:32:\"c11d272c87277a7a38d9e7fd13e27947\";s:3:\"img\";s:30:\"agencywebsiteheader/slide1.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/fullscreen-hero-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:245:\" <span class=\"ttm_content\">A very unique full-screen slider that uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:509:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:55;a:22:{s:2:\"id\";s:2:\"56\";s:5:\"title\";s:11:\"Coming Soon\";s:5:\"alias\";s:10:\"comingsoon\";s:3:\"zip\";s:14:\"comingsoon.zip\";s:3:\"uid\";s:32:\"0f89edf995512e6d6e864a2ee7221829\";s:3:\"img\";s:21:\"comingsoon/slide1.jpg\";s:7:\"preview\";s:79:\"http://revolution.themepunch.com/coming-soon-wordpress-under-construction-site/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:299:\"<span class=\"ttm_content\">A full-screen slider that can be used as a \"Coming Soon\" page. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> are used to achieve various interaction possibilities.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:638:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>For further configuration options please view the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\nInstructions for <a href=\"https://www.themepunch.com/faq/change-date-for-coming-soon-template/\" target=\"_blank\">how to change the date.</a><br /><br />\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:56;a:22:{s:2:\"id\";s:2:\"57\";s:5:\"title\";s:20:\"Christmas Snow Scene\";s:5:\"alias\";s:9:\"snowscene\";s:3:\"zip\";s:13:\"snowscene.zip\";s:3:\"uid\";s:32:\"a747bf0837caff86c62419a746690209\";s:3:\"img\";s:20:\"snowscene/slide1.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/christmas-snow-scene/\";s:7:\"version\";s:5:\"1.0.5\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:141:\"<span class=\"ttm_content\">A slider with multiple christmas themed slides and a neat snow fall effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:485:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>For further configuration options please view the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:57;a:22:{s:2:\"id\";s:2:\"58\";s:5:\"title\";s:15:\"Rock Band Music\";s:5:\"alias\";s:8:\"rockband\";s:3:\"zip\";s:12:\"rockband.zip\";s:3:\"uid\";s:32:\"5f557a5fad2fd6ca982a6ae6e9619637\";s:3:\"img\";s:19:\"rockband/slide1.jpg\";s:7:\"preview\";s:80:\"http://revolution.themepunch.com/rock-band-music-theme-slider-revolution-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:140:\" <span class=\"ttm_content\">A rock band themed hero block slider with an embedded SoundCloud element.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:464:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:58;a:22:{s:2:\"id\";s:2:\"59\";s:5:\"title\";s:18:\"Sleek Landing Page\";s:5:\"alias\";s:16:\"sleeklandingpage\";s:3:\"zip\";s:20:\"sleeklandingpage.zip\";s:3:\"uid\";s:32:\"07f7f2608936a8ae226213b7d99eee3f\";s:3:\"img\";s:27:\"sleeklandingpage/slide1.jpg\";s:7:\"preview\";s:70:\"http://revolution.themepunch.com/landing-page-free-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:191:\"<span class=\"ttm_content\">A full-screen slider that can be used as an App-Landing-Page. The object layers and custom animations create a unique effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-22 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:59;a:22:{s:2:\"id\";s:2:\"60\";s:5:\"title\";s:16:\"App Landing Page\";s:5:\"alias\";s:14:\"applandingpage\";s:3:\"zip\";s:18:\"applandingpage.zip\";s:3:\"uid\";s:32:\"38eb600893c1484ab8fd2a3dce3678d7\";s:3:\"img\";s:25:\"applandingpage/slide1.jpg\";s:7:\"preview\";s:64:\"http://revolution.themepunch.com/app-landing-page-free-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:263:\"<span class=\"ttm_content\">A full-screen hero block that can be used as an app landing page. The detail view is build using <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a>.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:371:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:60;a:22:{s:2:\"id\";s:2:\"61\";s:5:\"title\";s:10:\"Desk Scene\";s:5:\"alias\";s:9:\"deskscene\";s:3:\"zip\";s:13:\"deskscene.zip\";s:3:\"uid\";s:32:\"172a1a89a3e3b333cb4dbeb238f534c5\";s:3:\"img\";s:20:\"deskscene/slide1.jpg\";s:7:\"preview\";s:49:\"http://revolution.themepunch.com/hero-desk-scene/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:135:\"<span class=\"ttm_content\">A beautiful desk scene with a cool reveal effect when scrolling down.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:61;a:22:{s:2:\"id\";s:2:\"62\";s:5:\"title\";s:17:\"Clean News Slider\";s:5:\"alias\";s:15:\"cleannewsslider\";s:3:\"zip\";s:19:\"cleannewsslider.zip\";s:3:\"uid\";s:32:\"82c3f521fe31b80984be0f19e1a9899e\";s:3:\"img\";s:26:\"cleannewsslider/slide1.jpg\";s:7:\"preview\";s:55:\"http://revolution.themepunch.com/wordpress-news-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:132:\"<span class=\"ttm_content\">A slideshow example with clean content and thumbnail navigation.</span>\r\n<span class=\"ttm_space\"></span>\r\n\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:62;a:22:{s:2:\"id\";s:2:\"63\";s:5:\"title\";s:13:\"Image Gallery\";s:5:\"alias\";s:12:\"imagegallery\";s:3:\"zip\";s:16:\"imagegallery.zip\";s:3:\"uid\";s:32:\"cef1d75357df2cb53b990c74a214813e\";s:3:\"img\";s:23:\"imagegallery/slide1.jpg\";s:7:\"preview\";s:64:\"http://revolution.themepunch.com/wordpress-photo-gallery-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:3:\"667\";s:11:\"description\";s:239:\"<span class=\"ttm_content\">A photo gallery suitable to display your images using <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:63;a:22:{s:2:\"id\";s:2:\"64\";s:5:\"title\";s:19:\"Standard WP Gallery\";s:5:\"alias\";s:19:\"standard-wp-gallery\";s:3:\"zip\";s:23:\"standard-wp-gallery.zip\";s:3:\"uid\";s:32:\"632035b8a27652d8081dbdfa343dc93d\";s:3:\"img\";s:30:\"standard-wp-gallery/slide1.jpg\";s:7:\"preview\";s:64:\"http://revolution.themepunch.com/wordpress-photo-gallery-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:3:\"667\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A photo gallery that uses the \"Standard WP Gallery\" add-on to display images.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:407:\"<span class=\"ttm_content\">Please follow the setup guide on the \"Standard WP Gallery\" add-on page.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";}s:14:\"plugin_require\";s:166:\"[{\"path\":\"revslider-gallery-addon\\/revslider-gallery-addon.php\",\"name\":\"WP Gallery AddOn\",\"url\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-photo-gallery-plugin\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:64;a:22:{s:2:\"id\";s:2:\"65\";s:5:\"title\";s:21:\"Clean News Post Based\";s:5:\"alias\";s:21:\"clean-news-post-based\";s:3:\"zip\";s:25:\"clean-news-post-based.zip\";s:3:\"uid\";s:32:\"f4cf5bbe51afa5a361754bb081cbabf2\";s:3:\"img\";s:32:\"clean-news-post-based/slide1.jpg\";s:7:\"preview\";s:55:\"http://revolution.themepunch.com/wordpress-news-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:125:\"<span class=\"ttm_content\"> This slider is automatically populated by WordPress posts.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:423:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Post-Based Slider\"</a>. Make sure to select the post type you want to display in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:65;a:22:{s:2:\"id\";s:2:\"66\";s:5:\"title\";s:22:\"Interactive Whiteboard\";s:5:\"alias\";s:21:\"interactivewhiteboard\";s:3:\"zip\";s:25:\"interactivewhiteboard.zip\";s:3:\"uid\";s:32:\"058b4af535d6c6c7bcec5225845e3eb4\";s:3:\"img\";s:32:\"interactivewhiteboard/slide1.jpg\";s:7:\"preview\";s:77:\"http://revolution.themepunch.com/interactive-whiteboard-animation-free-addon/\";s:7:\"version\";s:5:\"1.0.5\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:269:\"<span class=\"ttm_content\">This is the example slider from the Whiteboard add-on preview.<br/><a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used to achieve certain effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:541:\"<span class=\"ttm_content\">This slider template requires the <a href=\"https://www.themepunch.com/slider-revolution/whiteboard-addon/\" target=\"_blank\">Whiteboard add-on</a> to be installed. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:185:\"[{\"path\":\"revslider-whiteboard-addon\\/revslider-whiteboard-addon.php\",\"name\":\"Whiteboard AddOn\",\"url\":\"http:\\/\\/revolution.themepunch.com\\/interactive-whiteboard-animation-free-addon\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:66;a:22:{s:2:\"id\";s:2:\"68\";s:5:\"title\";s:17:\"Innovation Slider\";s:5:\"alias\";s:10:\"innovation\";s:3:\"zip\";s:14:\"innovation.zip\";s:3:\"uid\";s:32:\"d3440b69126d9c186fddc713b18b0002\";s:3:\"img\";s:21:\"innovation/slide1.jpg\";s:7:\"preview\";s:68:\"https://revolution.themepunch.com/best-wordpress-slider-plugin-2016/\";s:7:\"version\";s:5:\"1.0.5\";s:8:\"required\";s:7:\"5.2.3.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:258:\"<span class=\"ttm_content\">A full-screen slider with an elegant fade-out parallax effect. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:493:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images, videos and texts.<br/>For further configuration options please view the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-03-29 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:67;a:25:{s:2:\"id\";s:2:\"69\";s:5:\"title\";s:25:\"Dark Content Block - Menu\";s:5:\"alias\";s:24:\"dark-fullsite-block-menu\";s:3:\"zip\";s:34:\"packs/dark-fullsite-block-menu.zip\";s:3:\"uid\";s:32:\"bf4bd226719d3c3d3146592976e31ca1\";s:3:\"img\";s:35:\"dark-fullsite-block-menu/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:68;a:25:{s:2:\"id\";s:2:\"70\";s:5:\"title\";s:25:\"Dark Content Block - Hero\";s:5:\"alias\";s:21:\"dark-fullsite-block-1\";s:3:\"zip\";s:31:\"packs/dark-fullsite-block-1.zip\";s:3:\"uid\";s:32:\"d8859245fe600288ca932dc29aca751f\";s:3:\"img\";s:32:\"dark-fullsite-block-1/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:69;a:25:{s:2:\"id\";s:2:\"71\";s:5:\"title\";s:26:\"Dark Content Block - About\";s:5:\"alias\";s:27:\"dark-fullsite-block-2-about\";s:3:\"zip\";s:37:\"packs/dark-fullsite-block-2-about.zip\";s:3:\"uid\";s:32:\"298401901521a197a8294c1b4f73df3e\";s:3:\"img\";s:38:\"dark-fullsite-block-2-about/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:70;a:25:{s:2:\"id\";s:2:\"72\";s:5:\"title\";s:29:\"Dark Content Block - Services\";s:5:\"alias\";s:30:\"dark-fullsite-block-3-services\";s:3:\"zip\";s:40:\"packs/dark-fullsite-block-3-services.zip\";s:3:\"uid\";s:32:\"8da3ed605472ed6a26c745fb52f85f82\";s:3:\"img\";s:41:\"dark-fullsite-block-3-services/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:71;a:25:{s:2:\"id\";s:2:\"73\";s:5:\"title\";s:29:\"Dark Content Block - Products\";s:5:\"alias\";s:30:\"dark-fullsite-block-4-products\";s:3:\"zip\";s:40:\"packs/dark-fullsite-block-4-products.zip\";s:3:\"uid\";s:32:\"99e4f40399d20261a6131043d0e50b0c\";s:3:\"img\";s:41:\"dark-fullsite-block-4-products/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:422:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\r\n\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:72;a:25:{s:2:\"id\";s:2:\"74\";s:5:\"title\";s:33:\"Dark Content Block - Testimonials\";s:5:\"alias\";s:34:\"dark-fullsite-block-5-testimonials\";s:3:\"zip\";s:44:\"packs/dark-fullsite-block-5-testimonials.zip\";s:3:\"uid\";s:32:\"2f9121e0eedd51afe85e233d0743acab\";s:3:\"img\";s:45:\"dark-fullsite-block-5-testimonials/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:73;a:25:{s:2:\"id\";s:2:\"75\";s:5:\"title\";s:28:\"Dark Content Block - Callout\";s:5:\"alias\";s:29:\"dark-fullsite-block-6-callout\";s:3:\"zip\";s:39:\"packs/dark-fullsite-block-6-callout.zip\";s:3:\"uid\";s:32:\"55fbecb113ff21f050be7adc08637329\";s:3:\"img\";s:40:\"dark-fullsite-block-6-callout/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:74;a:25:{s:2:\"id\";s:2:\"76\";s:5:\"title\";s:27:\"Dark Content Block - Footer\";s:5:\"alias\";s:28:\"dark-fullsite-block-7-footer\";s:3:\"zip\";s:38:\"packs/dark-fullsite-block-7-footer.zip\";s:3:\"uid\";s:32:\"2ff517f5c7c54e3e0c2dd733cfd3400e\";s:3:\"img\";s:39:\"dark-fullsite-block-7-footer/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:75;a:25:{s:2:\"id\";s:2:\"77\";s:5:\"title\";s:26:\"Light Content Block - Menu\";s:5:\"alias\";s:19:\"fullsite-block-menu\";s:3:\"zip\";s:29:\"packs/fullsite-block-menu.zip\";s:3:\"uid\";s:32:\"8010971f34387d5f94a1f4e577ef382a\";s:3:\"img\";s:30:\"fullsite-block-menu/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:76;a:25:{s:2:\"id\";s:2:\"78\";s:5:\"title\";s:26:\"Light Content Block - Hero\";s:5:\"alias\";s:15:\"fullsite-block1\";s:3:\"zip\";s:25:\"packs/fullsite-block1.zip\";s:3:\"uid\";s:32:\"45bf7179843e01ce112e8ec754b0455c\";s:3:\"img\";s:26:\"fullsite-block1/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:77;a:25:{s:2:\"id\";s:2:\"79\";s:5:\"title\";s:27:\"Light Content Block - About\";s:5:\"alias\";s:22:\"fullsite-block-2-about\";s:3:\"zip\";s:32:\"packs/fullsite-block-2-about.zip\";s:3:\"uid\";s:32:\"8402b460638a746d36433cb161440b7d\";s:3:\"img\";s:33:\"fullsite-block-2-about/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:78;a:25:{s:2:\"id\";s:2:\"80\";s:5:\"title\";s:30:\"Light Content Block - Services\";s:5:\"alias\";s:25:\"fullsite-block-3-services\";s:3:\"zip\";s:35:\"packs/fullsite-block-3-services.zip\";s:3:\"uid\";s:32:\"7b8cea27f4d6ae17c5e1eae12457bd06\";s:3:\"img\";s:36:\"fullsite-block-3-services/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:79;a:25:{s:2:\"id\";s:2:\"81\";s:5:\"title\";s:30:\"Light Content Block - Products\";s:5:\"alias\";s:25:\"fullsite-block-4-products\";s:3:\"zip\";s:35:\"packs/fullsite-block-4-products.zip\";s:3:\"uid\";s:32:\"d148935362d7122636cda0635eae4be7\";s:3:\"img\";s:36:\"fullsite-block-4-products/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:80;a:25:{s:2:\"id\";s:2:\"82\";s:5:\"title\";s:34:\"Light Content Block - Testimonials\";s:5:\"alias\";s:29:\"fullsite-block-5-testimonials\";s:3:\"zip\";s:39:\"packs/fullsite-block-5-testimonials.zip\";s:3:\"uid\";s:32:\"06255bfd421e40f71fa8197b839dbf03\";s:3:\"img\";s:40:\"fullsite-block-5-testimonials/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:81;a:25:{s:2:\"id\";s:2:\"83\";s:5:\"title\";s:29:\"Light Content Block - Callout\";s:5:\"alias\";s:24:\"fullsite-block-6-callout\";s:3:\"zip\";s:34:\"packs/fullsite-block-6-callout.zip\";s:3:\"uid\";s:32:\"8a88c3447676b613ec5db2fe5d63315c\";s:3:\"img\";s:35:\"fullsite-block-6-callout/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:82;a:25:{s:2:\"id\";s:2:\"84\";s:5:\"title\";s:28:\"Light Content Block - Footer\";s:5:\"alias\";s:23:\"fullsite-block-7-footer\";s:3:\"zip\";s:33:\"packs/fullsite-block-7-footer.zip\";s:3:\"uid\";s:32:\"34300b4407a2093eb2e1e08868fa8319\";s:3:\"img\";s:34:\"fullsite-block-7-footer/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:83;a:22:{s:2:\"id\";s:2:\"85\";s:5:\"title\";s:12:\"Tech Journal\";s:5:\"alias\";s:11:\"techjournal\";s:3:\"zip\";s:15:\"techjournal.zip\";s:3:\"uid\";s:32:\"7f92d70d1c108378f915b18c2ceb71d6\";s:3:\"img\";s:22:\"techjournal/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.1\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:130:\"<span class=\"ttm_content\">A full-width slider with navigation direction-based transitions.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:277:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:84;a:22:{s:2:\"id\";s:2:\"86\";s:5:\"title\";s:14:\"Car Dealership\";s:5:\"alias\";s:13:\"cardealership\";s:3:\"zip\";s:17:\"cardealership.zip\";s:3:\"uid\";s:32:\"bb010838855a8ae4d1dd68e139bf169e\";s:3:\"img\";s:24:\"cardealership/slide1.jpg\";s:7:\"preview\";s:56:\"https://revolution.themepunch.com/car-dealership-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"650\";s:11:\"description\";s:130:\"<span class=\"ttm_content\">A full-width slider with navigation direction-based transitions.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:277:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:85;a:22:{s:2:\"id\";s:2:\"87\";s:5:\"title\";s:22:\"FullScreen Menu Slider\";s:5:\"alias\";s:14:\"fullscreenmenu\";s:3:\"zip\";s:18:\"fullscreenmenu.zip\";s:3:\"uid\";s:32:\"6de81d74c4bf193e2e274d43038adc85\";s:3:\"img\";s:25:\"fullscreenmenu/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-fullscreen-menu/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:131:\"<span class=\"ttm_content\">A full-screen slider that contains a menu with slide blur effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:86;a:22:{s:2:\"id\";s:2:\"88\";s:5:\"title\";s:18:\"Creative Frontpage\";s:5:\"alias\";s:17:\"creativefrontpage\";s:3:\"zip\";s:21:\"creativefrontpage.zip\";s:3:\"uid\";s:32:\"0636cb368af3bcaa2f68eb0ebefe6439\";s:3:\"img\";s:28:\"creativefrontpage/slide1.jpg\";s:7:\"preview\";s:56:\"https://revolution.themepunch.com/best-wordpress-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:246:\"<span class=\"ttm_content\">A full-screen slider with hidden slides that are triggered via  <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a>.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:87;a:25:{s:2:\"id\";s:2:\"89\";s:5:\"title\";s:20:\"Website Builder Menu\";s:5:\"alias\";s:19:\"websitebuilder-menu\";s:3:\"zip\";s:29:\"packs/websitebuilder-menu.zip\";s:3:\"uid\";s:32:\"d9e6d9c961f123a3a4847b51fc3ba3a2\";s:3:\"img\";s:30:\"websitebuilder-menu/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:2:\"60\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:88;a:25:{s:2:\"id\";s:2:\"90\";s:5:\"title\";s:20:\"Website Builder Hero\";s:5:\"alias\";s:19:\"websitebuilder-hero\";s:3:\"zip\";s:29:\"packs/websitebuilder-hero.zip\";s:3:\"uid\";s:32:\"6cb2df9a41ad2e7865bb9bbea7e39cb5\";s:3:\"img\";s:30:\"websitebuilder-hero/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"700\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:89;a:25:{s:2:\"id\";s:2:\"91\";s:5:\"title\";s:23:\"Website Builder Clients\";s:5:\"alias\";s:22:\"websitebuilder-clients\";s:3:\"zip\";s:32:\"packs/websitebuilder-clients.zip\";s:3:\"uid\";s:32:\"050e59c43c9a693510d01f29532088cf\";s:3:\"img\";s:33:\"websitebuilder-clients/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"120\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:90;a:25:{s:2:\"id\";s:2:\"92\";s:5:\"title\";s:24:\"Website Builder Services\";s:5:\"alias\";s:23:\"websitebuilder-services\";s:3:\"zip\";s:33:\"packs/websitebuilder-services.zip\";s:3:\"uid\";s:32:\"48d56d67615efce619ae973ab4358c07\";s:3:\"img\";s:34:\"websitebuilder-services/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"558\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:91;a:25:{s:2:\"id\";s:2:\"93\";s:5:\"title\";s:24:\"Website Builder Discover\";s:5:\"alias\";s:23:\"websitebuilder-discover\";s:3:\"zip\";s:33:\"packs/websitebuilder-discover.zip\";s:3:\"uid\";s:32:\"425a08a7be338daea3df02a07ff5c316\";s:3:\"img\";s:34:\"websitebuilder-discover/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"955\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:92;a:25:{s:2:\"id\";s:2:\"94\";s:5:\"title\";s:22:\"Website Builder Slider\";s:5:\"alias\";s:21:\"websitebuilder-slider\";s:3:\"zip\";s:31:\"packs/websitebuilder-slider.zip\";s:3:\"uid\";s:32:\"9d670b7335016accb590dc8d52bfb6f0\";s:3:\"img\";s:32:\"websitebuilder-slider/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:93;a:25:{s:2:\"id\";s:2:\"95\";s:5:\"title\";s:28:\"Website Builder CallToAction\";s:5:\"alias\";s:27:\"websitebuilder-calltoaction\";s:3:\"zip\";s:37:\"packs/websitebuilder-calltoaction.zip\";s:3:\"uid\";s:32:\"45851baf9e61f55ed9f5fa9d0beff77e\";s:3:\"img\";s:38:\"websitebuilder-calltoaction/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"960\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:94;a:25:{s:2:\"id\";s:2:\"96\";s:5:\"title\";s:22:\"Website Builder Footer\";s:5:\"alias\";s:21:\"websitebuilder-footer\";s:3:\"zip\";s:31:\"packs/websitebuilder-footer.zip\";s:3:\"uid\";s:32:\"2732bbe66ef28219d6cc53ce8cc78863\";s:3:\"img\";s:32:\"websitebuilder-footer/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:95;a:22:{s:2:\"id\";s:2:\"97\";s:5:\"title\";s:21:\"Focus Parallax Effect\";s:5:\"alias\";s:13:\"focusparallax\";s:3:\"zip\";s:17:\"focusparallax.zip\";s:3:\"uid\";s:32:\"13bd15fb3ddf8b9841cb55b89389cc73\";s:3:\"img\";s:24:\"focusparallax/slide1.jpg\";s:7:\"preview\";s:68:\" https://revolution.themepunch.com/parallax-effect-wordpress-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:256:\"<span class=\"ttm_content\">A full-screen slider with mouse controlled parallax effects. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:96;a:22:{s:2:\"id\";s:2:\"98\";s:5:\"title\";s:14:\"Duotone Slider\";s:5:\"alias\";s:7:\"duotone\";s:3:\"zip\";s:11:\"duotone.zip\";s:3:\"uid\";s:32:\"494862ceb6cb7c6658ad7cd36848cccd\";s:3:\"img\";s:18:\"duotone/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/wordpress-header-image-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.4\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:252:\"<span class=\"ttm_content\">A full-screen slider with unique parallax scroll effect. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:277:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:97;a:25:{s:2:\"id\";s:2:\"99\";s:5:\"title\";s:12:\"Minimal Menu\";s:5:\"alias\";s:6:\"r_menu\";s:3:\"zip\";s:16:\"packs/r_menu.zip\";s:3:\"uid\";s:32:\"30d6a6895db1a5f29b1679061551c9f0\";s:3:\"img\";s:17:\"r_menu/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"110\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:890:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:98;a:25:{s:2:\"id\";s:3:\"100\";s:5:\"title\";s:12:\"Minimal Hero\";s:5:\"alias\";s:5:\"rhero\";s:3:\"zip\";s:16:\"packs/r_hero.zip\";s:3:\"uid\";s:32:\"b8b46186956f6e66ad0c08e4532bbbde\";s:3:\"img\";s:17:\"r_hero/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"700\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:890:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:99;a:25:{s:2:\"id\";s:3:\"101\";s:5:\"title\";s:13:\"Minimal About\";s:5:\"alias\";s:7:\"r_about\";s:3:\"zip\";s:17:\"packs/r_about.zip\";s:3:\"uid\";s:32:\"343010c4b4c03f92888c3e9e95bc2bb1\";s:3:\"img\";s:18:\"r_about/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:890:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:100;a:25:{s:2:\"id\";s:3:\"102\";s:5:\"title\";s:16:\"Minimal Products\";s:5:\"alias\";s:10:\"r_products\";s:3:\"zip\";s:20:\"packs/r_products.zip\";s:3:\"uid\";s:32:\"dda93e85c6a4456d132040147f087f39\";s:3:\"img\";s:21:\"r_products/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1100\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:890:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:101;a:25:{s:2:\"id\";s:3:\"103\";s:5:\"title\";s:12:\"Minimal Info\";s:5:\"alias\";s:6:\"r_info\";s:3:\"zip\";s:16:\"packs/r_info.zip\";s:3:\"uid\";s:32:\"d6e368e8fd4862174af6c980389ae530\";s:3:\"img\";s:17:\"r_info/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:890:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:102;a:22:{s:2:\"id\";s:3:\"104\";s:5:\"title\";s:18:\"Inspiration Header\";s:5:\"alias\";s:17:\"inspirationheader\";s:3:\"zip\";s:21:\"inspirationheader.zip\";s:3:\"uid\";s:32:\"69f04b2be0b618fa7e184af83b86b7e7\";s:3:\"img\";s:28:\"inspirationheader/slide1.jpg\";s:7:\"preview\";s:57:\"https://revolution.themepunch.com/wordpress-theme-header/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:159:\"<span class=\"ttm_content\">This full-screen hero slider features sequentially animated texts and cool parallax elements.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:103;a:22:{s:2:\"id\";s:3:\"105\";s:5:\"title\";s:15:\"Magazine Slider\";s:5:\"alias\";s:13:\"magazineposts\";s:3:\"zip\";s:17:\"magazineposts.zip\";s:3:\"uid\";s:32:\"c562f3457e4edbd030959f7c5e6e0f7c\";s:3:\"img\";s:24:\"magazineposts/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-magazine-slider/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1000\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">A full-width slider with a mouse-controlled 3D-Parallax effect. Enjoy! <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:277:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:104;a:22:{s:2:\"id\";s:3:\"106\";s:5:\"title\";s:11:\"News Header\";s:5:\"alias\";s:17:\"explorationheader\";s:3:\"zip\";s:21:\"explorationheader.zip\";s:3:\"uid\";s:32:\"8f20d5a868c90ded08b835fb9e8307d7\";s:3:\"img\";s:28:\"explorationheader/slide1.jpg\";s:7:\"preview\";s:56:\"https://revolution.themepunch.com/wordpress-news-header/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:288:\"<span class=\"ttm_content\">A full-screen slider that is a perfect fit for displaying news on your websites header! Check out <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> to add links to buttons.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:277:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:105;a:25:{s:2:\"id\";s:3:\"107\";s:5:\"title\";s:23:\"Minimal Website Package\";s:5:\"alias\";s:23:\"minimal-website-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:23:\"minimal-website-package\";s:3:\"img\";s:31:\"packages/template_group_1_1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"110\";s:11:\"description\";s:181:\"<span class=\"ttm_content\">The Minimal Website Template is a one-pager website with a unique background color change effect on scrolling down.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:890:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:106;a:25:{s:2:\"id\";s:3:\"108\";s:5:\"title\";s:23:\"Website Builder Package\";s:5:\"alias\";s:22:\"websitebuilder-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:22:\"websitebuilder-package\";s:3:\"img\";s:29:\"packages/template_group_2.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:2:\"60\";s:11:\"description\";s:191:\"<span class=\"ttm_content\">The Website Builder Package is a clean, usable collection website modules that can be used all together or each on their own.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:107;a:25:{s:2:\"id\";s:3:\"109\";s:5:\"title\";s:26:\"Dark Content Block Package\";s:5:\"alias\";s:27:\"dark-fullsite-block-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:27:\"dark-fullsite-block-package\";s:3:\"img\";s:29:\"packages/template_group_4.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">This Minimal Website Template has some sleek parallax effects and on-demand loading modules.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:108;a:25:{s:2:\"id\";s:3:\"110\";s:5:\"title\";s:27:\"Light Content Block Package\";s:5:\"alias\";s:22:\"fullsite-block-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:22:\"fullsite-block-package\";s:3:\"img\";s:29:\"packages/template_group_3.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">This Minimal Website Template has some sleek parallax effects and on-demand loading modules.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:109;a:22:{s:2:\"id\";s:3:\"111\";s:5:\"title\";s:17:\"Typewriter Effect\";s:5:\"alias\";s:16:\"typewritereffect\";s:3:\"zip\";s:20:\"typewritereffect.zip\";s:3:\"uid\";s:32:\"d6f8bae06cc4a7b158d680c01e59ddc2\";s:3:\"img\";s:27:\"typewritereffect/slide1.jpg\";s:7:\"preview\";s:62:\"https://revolution.themepunch.com/wordpress-typewriter-effect/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:263:\"<span class=\"ttm_content\">This is the example slider from the Typewriter add-on preview.<br/><a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on buttons.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:403:\"<span class=\"ttm_content\">This slider template requires the <a href=\"https://www.themepunch.com/slider-revolution/typewriter-addon/\" target=\"_blank\">Typewriter add-on</a> to be installed. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:173:\"[{\"path\":\"revslider-typewriter-addon\\/revslider-typewriter-addon.php\",\"name\":\"Typewriter AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/typewriter-addon\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:110;a:22:{s:2:\"id\";s:3:\"112\";s:5:\"title\";s:17:\"Blend Mode Header\";s:5:\"alias\";s:15:\"blendmodeheader\";s:3:\"zip\";s:19:\"blendmodeheader.zip\";s:3:\"uid\";s:32:\"2e44e976596d757aab40ffa28086dcf9\";s:3:\"img\";s:26:\"blendmodeheader/slide1.jpg\";s:7:\"preview\";s:57:\"https://revolution.themepunch.com/blend-mode-hero-header/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1000\";s:11:\"description\";s:163:\"<span class=\"ttm_content\">This full-screen hero header with HMTL5 background video, utilizes the new 5.3 blend mode effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:111;a:25:{s:2:\"id\";s:3:\"113\";s:5:\"title\";s:17:\"Themeplicity Menu\";s:5:\"alias\";s:17:\"themeplicity_menu\";s:3:\"zip\";s:27:\"packs/themeplicity_menu.zip\";s:3:\"uid\";s:32:\"7d5c1e75eaafa63683895a32a62f4ce0\";s:3:\"img\";s:28:\"themeplicity_menu/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:2:\"90\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:112;a:25:{s:2:\"id\";s:3:\"114\";s:5:\"title\";s:19:\"Themeplicity Header\";s:5:\"alias\";s:19:\"themeplicity_header\";s:3:\"zip\";s:29:\"packs/themeplicity_header.zip\";s:3:\"uid\";s:32:\"907091e4d58acc7d12f802de2f280b7d\";s:3:\"img\";s:30:\"themeplicity_header/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1000\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:113;a:25:{s:2:\"id\";s:3:\"115\";s:5:\"title\";s:18:\"Themeplicity Offer\";s:5:\"alias\";s:18:\"themeplicity_offer\";s:3:\"zip\";s:28:\"packs/themeplicity_offer.zip\";s:3:\"uid\";s:32:\"1bd8f9aa2f3e340449664c65ba17fb51\";s:3:\"img\";s:29:\"themeplicity_offer/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"330\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:114;a:25:{s:2:\"id\";s:3:\"116\";s:5:\"title\";s:23:\"Themeplicity What We Do\";s:5:\"alias\";s:21:\"themeplicity_whatwedo\";s:3:\"zip\";s:31:\"packs/themeplicity_whatwedo.zip\";s:3:\"uid\";s:32:\"aa800a44b5a3eab30414dde1f32bfed7\";s:3:\"img\";s:32:\"themeplicity_whatwedo/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"813\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:115;a:25:{s:2:\"id\";s:3:\"117\";s:5:\"title\";s:21:\"Themeplicity Projects\";s:5:\"alias\";s:21:\"themeplicity_projects\";s:3:\"zip\";s:31:\"packs/themeplicity_projects.zip\";s:3:\"uid\";s:32:\"5f61b3a13033ba6a51a18270163e0a50\";s:3:\"img\";s:32:\"themeplicity_projects/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"813\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:116;a:25:{s:2:\"id\";s:3:\"118\";s:5:\"title\";s:24:\"Themeplicity Whats Great\";s:5:\"alias\";s:23:\"themeplicity_whatsgreat\";s:3:\"zip\";s:33:\"packs/themeplicity_whatsgreat.zip\";s:3:\"uid\";s:32:\"ce9faf8c55ed2e33e091b23667e7173b\";s:3:\"img\";s:34:\"themeplicity_whatsgreat/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:117;a:25:{s:2:\"id\";s:3:\"119\";s:5:\"title\";s:19:\"Themeplicity Tables\";s:5:\"alias\";s:19:\"themeplicity_tables\";s:3:\"zip\";s:29:\"packs/themeplicity_tables.zip\";s:3:\"uid\";s:32:\"f28bb4cd20ec1f29a1de7da5ad09c293\";s:3:\"img\";s:30:\"themeplicity_tables/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1059\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:118;a:25:{s:2:\"id\";s:3:\"120\";s:5:\"title\";s:24:\"Themeplicity Contactform\";s:5:\"alias\";s:24:\"themeplicity_contactform\";s:3:\"zip\";s:34:\"packs/themeplicity_contactform.zip\";s:3:\"uid\";s:32:\"3e59da970f534490774fa8e053f5b5ed\";s:3:\"img\";s:35:\"themeplicity_contactform/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1067\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:119;a:25:{s:2:\"id\";s:3:\"121\";s:5:\"title\";s:19:\"Themeplicity Footer\";s:5:\"alias\";s:19:\"themeplicity_footer\";s:3:\"zip\";s:29:\"packs/themeplicity_footer.zip\";s:3:\"uid\";s:32:\"89eeb0b4b852c5f743e1bd76e3e8f2ef\";s:3:\"img\";s:30:\"themeplicity_footer/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"780\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:120;a:25:{s:2:\"id\";s:3:\"122\";s:5:\"title\";s:20:\"Themeplicity Package\";s:5:\"alias\";s:20:\"themeplicity-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:20:\"themeplicity-package\";s:3:\"img\";s:38:\"packages/templatepack_themeplicity.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Themeplicity Website Template uses the new groups & rows feature introduced in 5.3 to its full potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:121;a:25:{s:2:\"id\";s:3:\"123\";s:5:\"title\";s:19:\"Nice And Clean Menu\";s:5:\"alias\";s:17:\"NiceAndClean_Menu\";s:3:\"zip\";s:27:\"packs/NiceAndClean_Menu.zip\";s:3:\"uid\";s:32:\"3f8c01e26c7446428e045c4b1180776d\";s:3:\"img\";s:28:\"NiceAndClean_Menu/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:2:\"90\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:122;a:25:{s:2:\"id\";s:3:\"124\";s:5:\"title\";s:21:\"Nice And Clean Header\";s:5:\"alias\";s:19:\"NiceAndClean_Header\";s:3:\"zip\";s:29:\"packs/NiceAndClean_Header.zip\";s:3:\"uid\";s:32:\"76931033addb20a62557c2845a4d6a11\";s:3:\"img\";s:30:\"NiceAndClean_Header/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:123;a:25:{s:2:\"id\";s:3:\"125\";s:5:\"title\";s:23:\"Nice And Clean Services\";s:5:\"alias\";s:21:\"NiceAndClean_Services\";s:3:\"zip\";s:31:\"packs/NiceAndClean_Services.zip\";s:3:\"uid\";s:32:\"02f72ec606800c8215bcadea09624e87\";s:3:\"img\";s:32:\"NiceAndClean_Services/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"360\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:124;a:25:{s:2:\"id\";s:3:\"126\";s:5:\"title\";s:20:\"Nice And Clean About\";s:5:\"alias\";s:18:\"NiceAndClean_About\";s:3:\"zip\";s:28:\"packs/NiceAndClean_About.zip\";s:3:\"uid\";s:32:\"9510f6fdbb8e9473e8c22f692a6bc89f\";s:3:\"img\";s:29:\"NiceAndClean_About/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:125;a:25:{s:2:\"id\";s:3:\"127\";s:5:\"title\";s:20:\"Nice And Clean Video\";s:5:\"alias\";s:18:\"niceandclean_video\";s:3:\"zip\";s:28:\"packs/niceandclean_video.zip\";s:3:\"uid\";s:32:\"2bb9e1ad329435cc500542d0c7025e15\";s:3:\"img\";s:29:\"niceandclean_video/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:126;a:25:{s:2:\"id\";s:3:\"128\";s:5:\"title\";s:25:\"Nice And Clean Highlights\";s:5:\"alias\";s:23:\"niceandclean_highlights\";s:3:\"zip\";s:33:\"packs/niceandclean_highlights.zip\";s:3:\"uid\";s:32:\"ff396af163a79d2d5b35db17c1ea7aa6\";s:3:\"img\";s:34:\"niceandclean_highlights/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:127;a:25:{s:2:\"id\";s:3:\"129\";s:5:\"title\";s:23:\"Nice And Clean Projects\";s:5:\"alias\";s:21:\"NiceAndClean_Projects\";s:3:\"zip\";s:31:\"packs/NiceAndClean_Projects.zip\";s:3:\"uid\";s:32:\"1e6695959ef83f8975b52289c08a4d44\";s:3:\"img\";s:32:\"NiceAndClean_Projects/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:128;a:25:{s:2:\"id\";s:3:\"130\";s:5:\"title\";s:25:\"Nice And Clean TextBlocks\";s:5:\"alias\";s:23:\"niceandclean_textblocks\";s:3:\"zip\";s:33:\"packs/niceandclean_textblocks.zip\";s:3:\"uid\";s:32:\"1f33eb839c96ea3225faff1c8d382b05\";s:3:\"img\";s:34:\"niceandclean_textblocks/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:129;a:25:{s:2:\"id\";s:3:\"131\";s:5:\"title\";s:22:\"Nice And Clean CallOut\";s:5:\"alias\";s:20:\"niceandclean_callout\";s:3:\"zip\";s:30:\"packs/niceandclean_callout.zip\";s:3:\"uid\";s:32:\"54d4d9bcf79d357de0e614700e909863\";s:3:\"img\";s:31:\"niceandclean_callout/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:130;a:25:{s:2:\"id\";s:3:\"132\";s:5:\"title\";s:21:\"Nice And Clean Footer\";s:5:\"alias\";s:19:\"niceandclean_footer\";s:3:\"zip\";s:29:\"packs/niceandclean_footer.zip\";s:3:\"uid\";s:32:\"5492d7f72b3771a4e754f91bda063b15\";s:3:\"img\";s:30:\"niceandclean_footer/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"400\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:542:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">For using the social sharing buttons, please install the social sharing add-on.<br><br></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"9\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:131;a:22:{s:2:\"id\";s:3:\"134\";s:5:\"title\";s:15:\"80s Style Intro\";s:5:\"alias\";s:3:\"80s\";s:3:\"zip\";s:7:\"80s.zip\";s:3:\"uid\";s:32:\"98881ab51f71b2fbdb220752d321b15a\";s:3:\"img\";s:14:\"80s/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/80s-style-intro/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:139:\"<span class=\"ttm_content\">This intro hero block takes you back to the 80\'s with some funky effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:317:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and text.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:132;a:22:{s:2:\"id\";s:3:\"135\";s:5:\"title\";s:18:\"Blur Effect Slider\";s:5:\"alias\";s:10:\"blurslider\";s:3:\"zip\";s:14:\"blurslider.zip\";s:3:\"uid\";s:32:\"83bd6e1ccef83f03c944fa05b0a2d879\";s:3:\"img\";s:21:\"blurslider/slide1.jpg\";s:7:\"preview\";s:53:\"https://revolution.themepunch.com/blur-effect-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:147:\"<span class=\"ttm_content\">This slider makes use of the brand new blur effects available with version 5.3.1.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:315:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change the background images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:133;a:22:{s:2:\"id\";s:3:\"136\";s:5:\"title\";s:18:\"Coming Soon Add-On\";s:5:\"alias\";s:15:\"ComingSoonAddon\";s:3:\"zip\";s:19:\"ComingSoonAddon.zip\";s:3:\"uid\";s:32:\"51258492055b940099eb96ba52901fa9\";s:3:\"img\";s:26:\"ComingSoonAddon/slide1.jpg\";s:7:\"preview\";s:53:\"https://revolution.themepunch.com/coming-soon-add-on/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:133:\"<span class=\"ttm_content\">This slider template makes use of the brand new Coming Soon Add-On.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:197:\"[{\"path\":\"revslider-maintenance-addon\\/revslider-maintenance-addon.php\",\"name\":\"Coming Soon & Maintenance AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/add-coming-soon-maintenance\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:134;a:25:{s:2:\"id\";s:3:\"137\";s:5:\"title\";s:22:\"Nice And Clean Package\";s:5:\"alias\";s:22:\"nice-and-clean-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:22:\"nice-and-clean-package\";s:3:\"img\";s:38:\"packages/templatepack_niceandclean.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:242:\"<span class=\"ttm_content\">The Nice & Clean Website Template uses groups & rows for a fully responsive website experience. Elegant blur effects available since version 5.3.1 make this template stand out!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:135;a:22:{s:2:\"id\";s:3:\"138\";s:5:\"title\";s:18:\"Snow Effect Add-On\";s:5:\"alias\";s:9:\"snowaddon\";s:3:\"zip\";s:13:\"snowaddon.zip\";s:3:\"uid\";s:32:\"7408d8567b8af5716eaabd390422e51b\";s:3:\"img\";s:20:\"snowaddon/slide1.jpg\";s:7:\"preview\";s:53:\"https://revolution.themepunch.com/snow-effect-add-on/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:183:\"<span class=\"ttm_content\">Add a pleasant Snow Effect to your website with this slider template. Make sure to install the \"Holiday Snow\" Add-On.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:153:\"[{\"path\":\"revslider-snow-addon\\/revslider-snow-addon.php\",\"name\":\"Snow AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:136;a:22:{s:2:\"id\";s:3:\"139\";s:5:\"title\";s:19:\"Particle Effect One\";s:5:\"alias\";s:19:\"particle-effect-one\";s:3:\"zip\";s:23:\"particle-effect-one.zip\";s:3:\"uid\";s:32:\"a4611c906e35ca60f617da86217b5299\";s:3:\"img\";s:30:\"particle-effect-one/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/particle-effect-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A unique particle effect that can serve as a stunning intro for your website.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:442:\"<span class=\"ttm_content\">The blend mode effect is achieved through a layer image with CSS blend mode. If you want to customize this effect, select the \"BLEND MODE IMAGE\" layer and go to \"advanced style -> filters -> blend mode\".</span>\r\n<span class=\"ttm_space\"></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:137;a:22:{s:2:\"id\";s:3:\"140\";s:5:\"title\";s:19:\"Particle Effect Two\";s:5:\"alias\";s:19:\"particle-effect-two\";s:3:\"zip\";s:23:\"particle-effect-two.zip\";s:3:\"uid\";s:32:\"b8ecbf43374a69e4ab329ea834862ef8\";s:3:\"img\";s:30:\"particle-effect-two/slide1.jpg\";s:7:\"preview\";s:56:\"https://revolution.themepunch.com/particle-effect-intro/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A unique particle effect that can serve as a stunning intro for your website.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:138;a:22:{s:2:\"id\";s:3:\"141\";s:5:\"title\";s:21:\"Particle Effect Three\";s:5:\"alias\";s:21:\"particle-effect-three\";s:3:\"zip\";s:25:\"particle-effect-three.zip\";s:3:\"uid\";s:32:\"b33bc2c5655d8d51cd17c3740f72e748\";s:3:\"img\";s:32:\"particle-effect-three/slide1.jpg\";s:7:\"preview\";s:61:\"https://revolution.themepunch.com/particle-background-effect/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A unique particle effect that can serve as a stunning intro for your website.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:437:\"<span class=\"ttm_content\">The blend mode effect is achieved through a layer image with CSS blend mode. If you want to customize this effect, select the \"BLEND IMAGE\" layer and go to \"advanced style -> filters -> blend mode\".</span>\r\n<span class=\"ttm_space\"></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:139;a:22:{s:2:\"id\";s:3:\"142\";s:5:\"title\";s:16:\"Portfolio Viewer\";s:5:\"alias\";s:15:\"portfolioviewer\";s:3:\"zip\";s:19:\"portfolioviewer.zip\";s:3:\"uid\";s:32:\"9ac7230ff5b880fb6c8f28fbbc123b3b\";s:3:\"img\";s:26:\"portfolioviewer/slide1.jpg\";s:7:\"preview\";s:61:\"https://revolution.themepunch.com/wordpress-portfolio-plugin/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:207:\"<span class=\"ttm_content\">This slider template can be used to display your portfolio highlights in a stunning way, utilising out free particles add-on and blend modes.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:387:\"<span class=\"ttm_content\">The navigation for the slides is found in the <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">Static Layers</a>.</span><span class=\"ttm_space\"></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:140;a:22:{s:2:\"id\";s:3:\"143\";s:5:\"title\";s:12:\"App Showcase\";s:5:\"alias\";s:11:\"appshowcase\";s:3:\"zip\";s:15:\"appshowcase.zip\";s:3:\"uid\";s:32:\"082aef931b0369080bc30c3a2a0c331f\";s:3:\"img\";s:22:\"appshowcase/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/app-showcase-wordpress-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:239:\"<span class=\"ttm_content\">This template shows off our new \"Polyfold Effects\" Add-On in form of an App product showcase module. Get started now and illustrate your Apps key features in a striking way!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:179:\"[{\"path\":\"revslider-polyfold-addon\\/revslider-polyfold-addon.php\",\"name\":\"Polyfold Scroll Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:141;a:22:{s:2:\"id\";s:3:\"144\";s:5:\"title\";s:19:\"Gravity Design Hero\";s:5:\"alias\";s:13:\"gravitydesign\";s:3:\"zip\";s:17:\"gravitydesign.zip\";s:3:\"uid\";s:32:\"7bdbe73a6e5bf290cb4412708ac4134d\";s:3:\"img\";s:24:\"gravitydesign/slide1.jpg\";s:7:\"preview\";s:68:\"https://revolution.themepunch.com/best-wordpress-slider-plugin-2017/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:205:\"<span class=\"ttm_content\">This hero template shows a striking mouse-parallax scene and cool particle effects. Requires our \"Particle Effects\" Add-on to be installed.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:142;a:22:{s:2:\"id\";s:3:\"145\";s:5:\"title\";s:14:\"404 Error Page\";s:5:\"alias\";s:12:\"404errorpage\";s:3:\"zip\";s:16:\"404errorpage.zip\";s:3:\"uid\";s:32:\"2dc62d802b42b73088651cac17d0c486\";s:3:\"img\";s:23:\"404errorpage/slide1.jpg\";s:7:\"preview\";s:58:\"https://revolution.themepunch.com/404-error-page-template/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:227:\"<span class=\"ttm_content\">This template can be used as a custom error page on your website with our new 404 page Add-On. Of course you can also use this template as a regular hero header.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:179:\"{\"1\":{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}}\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:143;a:22:{s:2:\"id\";s:3:\"146\";s:5:\"title\";s:16:\"Carousel Gallery\";s:5:\"alias\";s:15:\"carouselgallery\";s:3:\"zip\";s:19:\"carouselgallery.zip\";s:3:\"uid\";s:32:\"041838fd32923c40e15c998f0ea19526\";s:3:\"img\";s:26:\"carouselgallery/slide1.jpg\";s:7:\"preview\";s:61:\"https://revolution.themepunch.com/wordpress-carousel-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.4\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:159:\"<span class=\"ttm_content\">This carousel gallery features a subtle parallax effect, html5 video and a fullscreen button.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:144;a:22:{s:2:\"id\";s:3:\"147\";s:5:\"title\";s:16:\"Filmstrip Effect\";s:5:\"alias\";s:9:\"filmstrip\";s:3:\"zip\";s:13:\"filmstrip.zip\";s: